/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.context.orm;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.core.context.XmlContextNode;
import org.eclipse.jpt.eclipselink.core.context.ConversionValue;
import org.eclipse.jpt.eclipselink.core.context.ObjectTypeConverter;
import org.eclipse.jpt.eclipselink.core.internal.context.orm.EclipseLinkOrmConversionValue;
import org.eclipse.jpt.eclipselink.core.internal.context.orm.EclipseLinkOrmConverter;
import org.eclipse.jpt.eclipselink.core.resource.orm.EclipseLinkOrmFactory;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlConversionValue;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlConversionValueImpl;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlObjectTypeConverter;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneIterator;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationListIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkOrmObjectTypeConverter
extends EclipseLinkOrmConverter<XmlObjectTypeConverter>
implements ObjectTypeConverter {
    private String dataType;
    private String objectType;
    private final List<EclipseLinkOrmConversionValue> conversionValues = new ArrayList<EclipseLinkOrmConversionValue>();
    private String defaultObjectValue;

    public EclipseLinkOrmObjectTypeConverter(XmlContextNode parent) {
        super(parent);
    }

    @Override
    public String getType() {
        return "objectTypeConverter";
    }

    @Override
    public String getDataType() {
        return this.dataType;
    }

    @Override
    public void setDataType(String newDataType) {
        String oldDataType = this.dataType;
        this.dataType = newDataType;
        ((XmlObjectTypeConverter)this.getXmlResource()).setDataType(newDataType);
        this.firePropertyChanged("dataType", oldDataType, newDataType);
    }

    protected void setDataType_(String newDataType) {
        String oldDataType = this.dataType;
        this.dataType = newDataType;
        this.firePropertyChanged("dataType", oldDataType, newDataType);
    }

    @Override
    public String getObjectType() {
        return this.objectType;
    }

    @Override
    public void setObjectType(String newObjectType) {
        String oldObjectType = this.objectType;
        this.objectType = newObjectType;
        ((XmlObjectTypeConverter)this.getXmlResource()).setObjectType(newObjectType);
        this.firePropertyChanged("objectType", oldObjectType, newObjectType);
    }

    protected void setObjectType_(String newObjectType) {
        String oldObjectType = this.objectType;
        this.objectType = newObjectType;
        this.firePropertyChanged("objectType", oldObjectType, newObjectType);
    }

    public ListIterator<EclipseLinkOrmConversionValue> conversionValues() {
        return new CloneListIterator(this.conversionValues);
    }

    @Override
    public int conversionValuesSize() {
        return this.conversionValues.size();
    }

    @Override
    public EclipseLinkOrmConversionValue addConversionValue(int index) {
        XmlConversionValueImpl resourceConversionValue = EclipseLinkOrmFactory.eINSTANCE.createXmlConversionValueImpl();
        EclipseLinkOrmConversionValue contextConversionValue = this.buildConversionValue(resourceConversionValue);
        this.conversionValues.add(index, contextConversionValue);
        ((XmlObjectTypeConverter)this.getXmlResource()).getConversionValues().add(index, (Object)resourceConversionValue);
        this.fireItemAdded("conversionValues", index, contextConversionValue);
        return contextConversionValue;
    }

    @Override
    public EclipseLinkOrmConversionValue addConversionValue() {
        return this.addConversionValue(this.conversionValues.size());
    }

    protected void addConversionValue(int index, EclipseLinkOrmConversionValue conversionValue) {
        this.addItemToList(index, conversionValue, this.conversionValues, "conversionValues");
    }

    protected void addConversionValue(EclipseLinkOrmConversionValue conversionValue) {
        this.addConversionValue(this.conversionValues.size(), conversionValue);
    }

    @Override
    public void removeConversionValue(int index) {
        EclipseLinkOrmConversionValue removedJoinColumn = this.conversionValues.remove(index);
        ((XmlObjectTypeConverter)this.getXmlResource()).getConversionValues().remove(index);
        this.fireItemRemoved("conversionValues", index, removedJoinColumn);
    }

    @Override
    public void removeConversionValue(ConversionValue conversionValue) {
        this.removeConversionValue(this.conversionValues.indexOf(conversionValue));
    }

    protected void removeConversionValue_(ConversionValue conversionValue) {
        this.removeItemFromList(conversionValue, this.conversionValues, "conversionValues");
    }

    @Override
    public void moveConversionValue(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.conversionValues, (int)targetIndex, (int)sourceIndex);
        ((XmlObjectTypeConverter)this.getXmlResource()).getConversionValues().move(targetIndex, sourceIndex);
        this.fireItemMoved("conversionValues", targetIndex, sourceIndex);
    }

    @Override
    public ListIterator<String> dataValues() {
        return new TransformationListIterator<EclipseLinkOrmConversionValue, String>(this.conversionValues()){

            protected String transform(EclipseLinkOrmConversionValue next) {
                return next.getDataValue();
            }
        };
    }

    @Override
    public String getDefaultObjectValue() {
        return this.defaultObjectValue;
    }

    @Override
    public void setDefaultObjectValue(String newDefaultObjectValue) {
        String oldDefaultObjectValue = this.defaultObjectValue;
        this.defaultObjectValue = newDefaultObjectValue;
        ((XmlObjectTypeConverter)this.getXmlResource()).setDefaultObjectValue(newDefaultObjectValue);
        this.firePropertyChanged("defaultObjectValue", oldDefaultObjectValue, newDefaultObjectValue);
    }

    protected void setDefaultObjectValue_(String newDefaultObjectValue) {
        String oldDefaultObjectValue = this.defaultObjectValue;
        this.defaultObjectValue = newDefaultObjectValue;
        this.firePropertyChanged("defaultObjectValue", oldDefaultObjectValue, newDefaultObjectValue);
    }

    @Override
    protected void initialize(XmlObjectTypeConverter xmlResource) {
        super.initialize(xmlResource);
        this.dataType = this.getResourceDataType();
        this.objectType = this.getResourceObjectType();
        this.defaultObjectValue = this.getResourceDefaultObjectValue();
        this.initializeConversionValues();
    }

    protected void initializeConversionValues() {
        for (XmlConversionValue resourceConversionValue : ((XmlObjectTypeConverter)this.getXmlResource()).getConversionValues()) {
            this.conversionValues.add(this.buildConversionValue(resourceConversionValue));
        }
    }

    @Override
    public void update() {
        super.update();
        this.setDataType_(this.getResourceDataType());
        this.setObjectType_(this.getResourceObjectType());
        this.setDefaultObjectValue_(this.getResourceDefaultObjectValue());
        this.updateConversionValues();
    }

    protected void updateConversionValues() {
        CloneIterator xmlConversionValues = new CloneIterator(((XmlObjectTypeConverter)this.getXmlResource()).getConversionValues());
        ListIterator<EclipseLinkOrmConversionValue> contextConversionValues = this.conversionValues();
        while (contextConversionValues.hasNext()) {
            EclipseLinkOrmConversionValue contextConversionValue = (EclipseLinkOrmConversionValue)contextConversionValues.next();
            if (xmlConversionValues.hasNext()) {
                contextConversionValue.update((XmlConversionValue)xmlConversionValues.next());
                continue;
            }
            this.removeConversionValue_(contextConversionValue);
        }
        while (xmlConversionValues.hasNext()) {
            this.addConversionValue(this.buildConversionValue((XmlConversionValue)xmlConversionValues.next()));
        }
    }

    protected EclipseLinkOrmConversionValue buildConversionValue(XmlConversionValue resourceConversionValue) {
        EclipseLinkOrmConversionValue conversionValue = new EclipseLinkOrmConversionValue(this);
        conversionValue.initialize(resourceConversionValue);
        return conversionValue;
    }

    protected String getResourceDataType() {
        return ((XmlObjectTypeConverter)this.resourceConverter).getDataType();
    }

    protected String getResourceObjectType() {
        return ((XmlObjectTypeConverter)this.resourceConverter).getObjectType();
    }

    protected String getResourceDefaultObjectValue() {
        return ((XmlObjectTypeConverter)this.resourceConverter).getDefaultObjectValue();
    }

    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        ListIterator<EclipseLinkOrmConversionValue> stream = this.conversionValues();
        while (stream.hasNext()) {
            ((EclipseLinkOrmConversionValue)stream.next()).validate(messages, reporter);
        }
    }
}

