/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.context.orm;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jpt.core.context.JpaContextNode;
import org.eclipse.jpt.core.context.XmlContextNode;
import org.eclipse.jpt.core.internal.context.AbstractXmlContextNode;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.eclipselink.core.context.CustomConverter;
import org.eclipse.jpt.eclipselink.core.context.ObjectTypeConverter;
import org.eclipse.jpt.eclipselink.core.context.StructConverter;
import org.eclipse.jpt.eclipselink.core.context.TypeConverter;
import org.eclipse.jpt.eclipselink.core.internal.context.orm.ConverterHolder;
import org.eclipse.jpt.eclipselink.core.internal.context.orm.EclipseLinkOrmCustomConverter;
import org.eclipse.jpt.eclipselink.core.internal.context.orm.EclipseLinkOrmObjectTypeConverter;
import org.eclipse.jpt.eclipselink.core.internal.context.orm.EclipseLinkOrmStructConverter;
import org.eclipse.jpt.eclipselink.core.internal.context.orm.EclipseLinkOrmTypeConverter;
import org.eclipse.jpt.eclipselink.core.resource.orm.EclipseLinkOrmFactory;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlConverter;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlConverterImpl;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlConvertersHolder;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlObjectTypeConverter;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlObjectTypeConverterImpl;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlStructConverter;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlStructConverterImpl;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlTypeConverter;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlTypeConverterImpl;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.HashBag;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkOrmConverterHolder
extends AbstractXmlContextNode
implements ConverterHolder {
    private final XmlConvertersHolder resourceConvertersHolder;
    protected final List<EclipseLinkOrmCustomConverter> customConverters;
    protected final List<EclipseLinkOrmObjectTypeConverter> objectTypeConverters;
    protected final List<EclipseLinkOrmStructConverter> structConverters;
    protected final List<EclipseLinkOrmTypeConverter> typeConverters;

    public EclipseLinkOrmConverterHolder(XmlContextNode parent, XmlConvertersHolder resourceConvertersHolder) {
        super((JpaContextNode)parent);
        this.resourceConvertersHolder = resourceConvertersHolder;
        this.customConverters = new ArrayList<EclipseLinkOrmCustomConverter>();
        this.objectTypeConverters = new ArrayList<EclipseLinkOrmObjectTypeConverter>();
        this.structConverters = new ArrayList<EclipseLinkOrmStructConverter>();
        this.typeConverters = new ArrayList<EclipseLinkOrmTypeConverter>();
        this.initializeCustomConverters();
        this.initializeObjectTypeConverters();
        this.initializeStructConverters();
        this.initializeTypeConverters();
    }

    public ListIterator<EclipseLinkOrmCustomConverter> customConverters() {
        return this.customConverters.listIterator();
    }

    @Override
    public int customConvertersSize() {
        return this.customConverters.size();
    }

    @Override
    public CustomConverter addCustomConverter(int index) {
        XmlConverterImpl resourceConverter = EclipseLinkOrmFactory.eINSTANCE.createXmlConverterImpl();
        EclipseLinkOrmCustomConverter contextConverter = this.buildCustomConverter(resourceConverter);
        this.customConverters.add(index, contextConverter);
        this.resourceConvertersHolder.getConverters().add(index, (Object)resourceConverter);
        this.fireItemAdded("customConverters", index, contextConverter);
        return contextConverter;
    }

    protected void addCustomConverter(int index, EclipseLinkOrmCustomConverter converter) {
        this.addItemToList(index, converter, this.customConverters, "customConverters");
    }

    protected void addCustomConverter(EclipseLinkOrmCustomConverter converter) {
        this.addCustomConverter(this.customConverters.size(), converter);
    }

    @Override
    public void removeCustomConverter(int index) {
        EclipseLinkOrmCustomConverter removedConverter = this.customConverters.remove(index);
        this.resourceConvertersHolder.getConverters().remove(index);
        this.fireItemRemoved("customConverters", index, removedConverter);
    }

    @Override
    public void removeCustomConverter(CustomConverter converter) {
        this.removeCustomConverter(this.customConverters.indexOf(converter));
    }

    protected void removeConverter_(CustomConverter converter) {
        this.removeItemFromList(converter, this.customConverters, "customConverters");
    }

    @Override
    public void moveCustomConverter(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.customConverters, (int)targetIndex, (int)sourceIndex);
        this.resourceConvertersHolder.getConverters().move(targetIndex, sourceIndex);
        this.fireItemMoved("customConverters", targetIndex, sourceIndex);
    }

    protected void moveCustomConverter_(int index, EclipseLinkOrmCustomConverter converter) {
        this.moveItemInList(index, this.customConverters.indexOf(converter), this.customConverters, "customConverters");
    }

    public ListIterator<EclipseLinkOrmObjectTypeConverter> objectTypeConverters() {
        return this.objectTypeConverters.listIterator();
    }

    @Override
    public int objectTypeConvertersSize() {
        return this.objectTypeConverters.size();
    }

    @Override
    public ObjectTypeConverter addObjectTypeConverter(int index) {
        XmlObjectTypeConverterImpl resourceObjectTypeConverter = EclipseLinkOrmFactory.eINSTANCE.createXmlObjectTypeConverterImpl();
        EclipseLinkOrmObjectTypeConverter contextObjectTypeConverter = this.buildObjectTypeConverter(resourceObjectTypeConverter);
        this.objectTypeConverters.add(index, contextObjectTypeConverter);
        this.resourceConvertersHolder.getObjectTypeConverters().add(index, (Object)resourceObjectTypeConverter);
        this.fireItemAdded("objectTypeConverters", index, contextObjectTypeConverter);
        return contextObjectTypeConverter;
    }

    protected void addObjectTypeConverter(int index, EclipseLinkOrmObjectTypeConverter converter) {
        this.addItemToList(index, converter, this.objectTypeConverters, "objectTypeConverters");
    }

    protected void addObjectTypeConverter(EclipseLinkOrmObjectTypeConverter converter) {
        this.addObjectTypeConverter(this.objectTypeConverters.size(), converter);
    }

    @Override
    public void removeObjectTypeConverter(int index) {
        EclipseLinkOrmObjectTypeConverter removedObjectTypeConverter = this.objectTypeConverters.remove(index);
        this.resourceConvertersHolder.getObjectTypeConverters().remove(index);
        this.fireItemRemoved("objectTypeConverters", index, removedObjectTypeConverter);
    }

    @Override
    public void removeObjectTypeConverter(ObjectTypeConverter converter) {
        this.removeObjectTypeConverter(this.objectTypeConverters.indexOf(converter));
    }

    protected void removeObjectTypeConverter_(ObjectTypeConverter converter) {
        this.removeItemFromList(converter, this.objectTypeConverters, "objectTypeConverters");
    }

    @Override
    public void moveObjectTypeConverter(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.objectTypeConverters, (int)targetIndex, (int)sourceIndex);
        this.resourceConvertersHolder.getObjectTypeConverters().move(targetIndex, sourceIndex);
        this.fireItemMoved("objectTypeConverters", targetIndex, sourceIndex);
    }

    protected void moveObjectTypeConverter_(int index, EclipseLinkOrmObjectTypeConverter converter) {
        this.moveItemInList(index, this.objectTypeConverters.indexOf(converter), this.objectTypeConverters, "objectTypeConverters");
    }

    public ListIterator<EclipseLinkOrmStructConverter> structConverters() {
        return this.structConverters.listIterator();
    }

    @Override
    public int structConvertersSize() {
        return this.structConverters.size();
    }

    @Override
    public StructConverter addStructConverter(int index) {
        XmlStructConverterImpl resourceStructConverter = EclipseLinkOrmFactory.eINSTANCE.createXmlStructConverterImpl();
        EclipseLinkOrmStructConverter contextStructConverter = this.buildStructConverter(resourceStructConverter);
        this.structConverters.add(index, contextStructConverter);
        this.resourceConvertersHolder.getStructConverters().add(index, (Object)resourceStructConverter);
        this.fireItemAdded("structConverters", index, contextStructConverter);
        return contextStructConverter;
    }

    protected void addStructConverter(int index, EclipseLinkOrmStructConverter converter) {
        this.addItemToList(index, converter, this.structConverters, "structConverters");
    }

    protected void addStructConverter(EclipseLinkOrmStructConverter converter) {
        this.addStructConverter(this.structConverters.size(), converter);
    }

    @Override
    public void removeStructConverter(int index) {
        EclipseLinkOrmStructConverter removedStructConverter = this.structConverters.remove(index);
        this.resourceConvertersHolder.getStructConverters().remove(index);
        this.fireItemRemoved("structConverters", index, removedStructConverter);
    }

    @Override
    public void removeStructConverter(StructConverter converter) {
        this.removeStructConverter(this.structConverters.indexOf(converter));
    }

    protected void removeStructConverter_(StructConverter converter) {
        this.removeItemFromList(converter, this.structConverters, "structConverters");
    }

    @Override
    public void moveStructConverter(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.structConverters, (int)targetIndex, (int)sourceIndex);
        this.resourceConvertersHolder.getStructConverters().move(targetIndex, sourceIndex);
        this.fireItemMoved("structConverters", targetIndex, sourceIndex);
    }

    protected void moveStructConverter_(int index, EclipseLinkOrmStructConverter converter) {
        this.moveItemInList(index, this.structConverters.indexOf(converter), this.structConverters, "structConverters");
    }

    public ListIterator<EclipseLinkOrmTypeConverter> typeConverters() {
        return this.typeConverters.listIterator();
    }

    @Override
    public int typeConvertersSize() {
        return this.typeConverters.size();
    }

    @Override
    public TypeConverter addTypeConverter(int index) {
        XmlTypeConverterImpl resourceTypeConverter = EclipseLinkOrmFactory.eINSTANCE.createXmlTypeConverterImpl();
        EclipseLinkOrmTypeConverter contextTypeConverter = this.buildTypeConverter(resourceTypeConverter);
        this.typeConverters.add(index, contextTypeConverter);
        this.resourceConvertersHolder.getTypeConverters().add(index, (Object)resourceTypeConverter);
        this.fireItemAdded("typeConverters", index, contextTypeConverter);
        return contextTypeConverter;
    }

    protected void addTypeConverter(int index, EclipseLinkOrmTypeConverter converter) {
        this.addItemToList(index, converter, this.typeConverters, "typeConverters");
    }

    protected void addTypeConverter(EclipseLinkOrmTypeConverter converter) {
        this.addTypeConverter(this.typeConverters.size(), converter);
    }

    @Override
    public void removeTypeConverter(int index) {
        EclipseLinkOrmTypeConverter removedTypeConverter = this.typeConverters.remove(index);
        this.resourceConvertersHolder.getTypeConverters().remove(index);
        this.fireItemRemoved("typeConverters", index, removedTypeConverter);
    }

    @Override
    public void removeTypeConverter(TypeConverter converter) {
        this.removeTypeConverter(this.typeConverters.indexOf(converter));
    }

    protected void removeTypeConverter_(TypeConverter converter) {
        this.removeItemFromList(converter, this.typeConverters, "typeConverters");
    }

    @Override
    public void moveTypeConverter(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.typeConverters, (int)targetIndex, (int)sourceIndex);
        this.resourceConvertersHolder.getTypeConverters().move(targetIndex, sourceIndex);
        this.fireItemMoved("typeConverters", targetIndex, sourceIndex);
    }

    protected void moveTypeConverter_(int index, EclipseLinkOrmTypeConverter converter) {
        this.moveItemInList(index, this.typeConverters.indexOf(converter), this.typeConverters, "typeConverters");
    }

    protected void initializeCustomConverters() {
        for (XmlConverter resourceConverter : this.resourceConvertersHolder.getConverters()) {
            this.customConverters.add(this.buildCustomConverter(resourceConverter));
        }
    }

    protected void initializeObjectTypeConverters() {
        for (XmlObjectTypeConverter resourceConverter : this.resourceConvertersHolder.getObjectTypeConverters()) {
            this.objectTypeConverters.add(this.buildObjectTypeConverter(resourceConverter));
        }
    }

    protected void initializeStructConverters() {
        for (XmlStructConverter resourceConverter : this.resourceConvertersHolder.getStructConverters()) {
            this.structConverters.add(this.buildStructConverter(resourceConverter));
        }
    }

    protected void initializeTypeConverters() {
        for (XmlTypeConverter resourceConverter : this.resourceConvertersHolder.getTypeConverters()) {
            this.typeConverters.add(this.buildTypeConverter(resourceConverter));
        }
    }

    protected EclipseLinkOrmCustomConverter buildCustomConverter(XmlConverter resourceConverter) {
        EclipseLinkOrmCustomConverter contextConverter = new EclipseLinkOrmCustomConverter((XmlContextNode)this);
        contextConverter.initialize(resourceConverter);
        return contextConverter;
    }

    protected EclipseLinkOrmTypeConverter buildTypeConverter(XmlTypeConverter resourceConverter) {
        EclipseLinkOrmTypeConverter contextConverter = new EclipseLinkOrmTypeConverter((XmlContextNode)this);
        contextConverter.initialize(resourceConverter);
        return contextConverter;
    }

    protected EclipseLinkOrmObjectTypeConverter buildObjectTypeConverter(XmlObjectTypeConverter resourceConverter) {
        EclipseLinkOrmObjectTypeConverter contextConverter = new EclipseLinkOrmObjectTypeConverter((XmlContextNode)this);
        contextConverter.initialize(resourceConverter);
        return contextConverter;
    }

    protected EclipseLinkOrmStructConverter buildStructConverter(XmlStructConverter resourceConverter) {
        EclipseLinkOrmStructConverter contextConverter = new EclipseLinkOrmStructConverter((XmlContextNode)this);
        contextConverter.initialize(resourceConverter);
        return contextConverter;
    }

    public void update() {
        this.updateCustomConverters();
        this.updateObjectTypeConverters();
        this.updateStructConverters();
        this.updateTypeConverters();
    }

    protected void updateCustomConverters() {
        HashBag contextConvertersToRemove = CollectionTools.collection(this.customConverters());
        ArrayList<EclipseLinkOrmCustomConverter> contextConvertersToUpdate = new ArrayList<EclipseLinkOrmCustomConverter>();
        int resourceIndex = 0;
        EList<XmlConverter> xmlConverters = this.resourceConvertersHolder.getConverters();
        XmlConverter[] xmlConverterArray = xmlConverters.toArray((XmlConverter[])new XmlConverter[xmlConverters.size()]);
        int n = xmlConverterArray.length;
        int n2 = 0;
        while (n2 < n) {
            XmlConverter resourceConverter = xmlConverterArray[n2];
            boolean contextConverterFound = false;
            for (EclipseLinkOrmCustomConverter contextConverter : contextConvertersToRemove) {
                if (contextConverter.getXmlResource() != resourceConverter) continue;
                this.moveCustomConverter_(resourceIndex, contextConverter);
                contextConvertersToRemove.remove(contextConverter);
                contextConvertersToUpdate.add(contextConverter);
                contextConverterFound = true;
                break;
            }
            if (!contextConverterFound) {
                this.addCustomConverter(this.buildCustomConverter(resourceConverter));
            }
            ++resourceIndex;
            ++n2;
        }
        for (EclipseLinkOrmCustomConverter contextConverter : contextConvertersToRemove) {
            this.removeConverter_(contextConverter);
        }
        for (EclipseLinkOrmCustomConverter contextConverter : contextConvertersToUpdate) {
            contextConverter.update();
        }
    }

    protected void updateObjectTypeConverters() {
        HashBag contextConvertersToRemove = CollectionTools.collection(this.objectTypeConverters());
        ArrayList<EclipseLinkOrmObjectTypeConverter> contextConvertersToUpdate = new ArrayList<EclipseLinkOrmObjectTypeConverter>();
        int resourceIndex = 0;
        EList<XmlObjectTypeConverter> xmlConverters = this.resourceConvertersHolder.getObjectTypeConverters();
        XmlObjectTypeConverter[] xmlObjectTypeConverterArray = xmlConverters.toArray((XmlObjectTypeConverter[])new XmlObjectTypeConverter[xmlConverters.size()]);
        int n = xmlObjectTypeConverterArray.length;
        int n2 = 0;
        while (n2 < n) {
            XmlObjectTypeConverter xmlConverter = xmlObjectTypeConverterArray[n2];
            boolean contextConverterFound = false;
            for (EclipseLinkOrmObjectTypeConverter contextObjectTypeConverter : contextConvertersToRemove) {
                if (contextObjectTypeConverter.getXmlResource() != xmlConverter) continue;
                this.moveObjectTypeConverter_(resourceIndex, contextObjectTypeConverter);
                contextConvertersToRemove.remove(contextObjectTypeConverter);
                contextConvertersToUpdate.add(contextObjectTypeConverter);
                contextConverterFound = true;
                break;
            }
            if (!contextConverterFound) {
                this.addObjectTypeConverter(this.buildObjectTypeConverter(xmlConverter));
            }
            ++resourceIndex;
            ++n2;
        }
        for (EclipseLinkOrmObjectTypeConverter contextObjectTypeConverter : contextConvertersToRemove) {
            this.removeObjectTypeConverter_(contextObjectTypeConverter);
        }
        for (EclipseLinkOrmObjectTypeConverter contextObjectTypeConverter : contextConvertersToUpdate) {
            contextObjectTypeConverter.update();
        }
    }

    protected void updateTypeConverters() {
        HashBag contextConvertersToRemove = CollectionTools.collection(this.typeConverters());
        ArrayList<EclipseLinkOrmTypeConverter> contextConvertersToUpdate = new ArrayList<EclipseLinkOrmTypeConverter>();
        int resourceIndex = 0;
        EList<XmlTypeConverter> xmlConverters = this.resourceConvertersHolder.getTypeConverters();
        XmlTypeConverter[] xmlTypeConverterArray = xmlConverters.toArray((XmlTypeConverter[])new XmlTypeConverter[xmlConverters.size()]);
        int n = xmlTypeConverterArray.length;
        int n2 = 0;
        while (n2 < n) {
            XmlTypeConverter xmlConverter = xmlTypeConverterArray[n2];
            boolean contextTypeConverterFound = false;
            for (EclipseLinkOrmTypeConverter contextTypeConverter : contextConvertersToRemove) {
                if (contextTypeConverter.getXmlResource() != xmlConverter) continue;
                this.moveTypeConverter_(resourceIndex, contextTypeConverter);
                contextConvertersToRemove.remove(contextTypeConverter);
                contextConvertersToUpdate.add(contextTypeConverter);
                contextTypeConverterFound = true;
                break;
            }
            if (!contextTypeConverterFound) {
                this.addTypeConverter(this.buildTypeConverter(xmlConverter));
            }
            ++resourceIndex;
            ++n2;
        }
        for (EclipseLinkOrmTypeConverter contextTypeConverter : contextConvertersToRemove) {
            this.removeTypeConverter_(contextTypeConverter);
        }
        for (EclipseLinkOrmTypeConverter contextTypeConverter : contextConvertersToUpdate) {
            contextTypeConverter.update();
        }
    }

    protected void updateStructConverters() {
        HashBag contextConvertersToRemove = CollectionTools.collection(this.structConverters());
        ArrayList<EclipseLinkOrmStructConverter> contextConvertersToUpdate = new ArrayList<EclipseLinkOrmStructConverter>();
        int resourceIndex = 0;
        EList<XmlStructConverter> xmlConverters = this.resourceConvertersHolder.getStructConverters();
        XmlStructConverter[] xmlStructConverterArray = xmlConverters.toArray((XmlStructConverter[])new XmlStructConverter[xmlConverters.size()]);
        int n = xmlStructConverterArray.length;
        int n2 = 0;
        while (n2 < n) {
            XmlStructConverter resourceStructConverter = xmlStructConverterArray[n2];
            boolean contextStructConverterFound = false;
            for (EclipseLinkOrmStructConverter contextStructConverter : contextConvertersToRemove) {
                if (contextStructConverter.getXmlResource() != resourceStructConverter) continue;
                this.moveStructConverter_(resourceIndex, contextStructConverter);
                contextConvertersToRemove.remove(contextStructConverter);
                contextConvertersToUpdate.add(contextStructConverter);
                contextStructConverterFound = true;
                break;
            }
            if (!contextStructConverterFound) {
                this.addStructConverter(this.buildStructConverter(resourceStructConverter));
            }
            ++resourceIndex;
            ++n2;
        }
        for (EclipseLinkOrmStructConverter contextStructConverter : contextConvertersToRemove) {
            this.removeStructConverter_(contextStructConverter);
        }
        for (EclipseLinkOrmStructConverter contextStructConverter : contextConvertersToUpdate) {
            contextStructConverter.update();
        }
    }

    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
    }

    public TextRange getValidationTextRange() {
        return this.resourceConvertersHolder.getValidationTextRange();
    }
}

