/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.context.java;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.JpaContextNode;
import org.eclipse.jpt.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.core.context.java.JavaConverter;
import org.eclipse.jpt.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.eclipselink.core.context.Convert;
import org.eclipse.jpt.eclipselink.core.internal.context.java.EclipseLinkJavaConverter;
import org.eclipse.jpt.eclipselink.core.internal.context.java.EclipseLinkJavaCustomConverter;
import org.eclipse.jpt.eclipselink.core.internal.context.java.EclipseLinkJavaObjectTypeConverter;
import org.eclipse.jpt.eclipselink.core.internal.context.java.EclipseLinkJavaStructConverter;
import org.eclipse.jpt.eclipselink.core.internal.context.java.EclipseLinkJavaTypeConverter;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.EclipseLinkPersistenceUnit;
import org.eclipse.jpt.eclipselink.core.resource.java.ConvertAnnotation;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkJavaConvert
extends AbstractJavaJpaContextNode
implements Convert,
JavaConverter {
    private String specifiedConverterName;
    private JavaResourcePersistentAttribute resourcePersistentAttribute;
    private EclipseLinkJavaConverter converter;

    public EclipseLinkJavaConvert(JavaAttributeMapping parent, JavaResourcePersistentAttribute jrpa) {
        super((JpaContextNode)parent);
        this.initialize(jrpa);
    }

    public JavaAttributeMapping getParent() {
        return (JavaAttributeMapping)super.getParent();
    }

    public String getType() {
        return "eclipseLinkConverter";
    }

    protected String getAnnotationName() {
        return "org.eclipse.persistence.annotations.Convert";
    }

    public void addToResourceModel() {
        this.resourcePersistentAttribute.addSupportingAnnotation(this.getAnnotationName());
    }

    public void removeFromResourceModel() {
        this.resourcePersistentAttribute.removeSupportingAnnotation(this.getAnnotationName());
        if (this.getConverter() != null) {
            this.resourcePersistentAttribute.removeSupportingAnnotation(this.getConverter().getAnnotationName());
        }
    }

    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return this.getResourceConvert().getTextRange(astRoot);
    }

    protected ConvertAnnotation getResourceConvert() {
        return (ConvertAnnotation)this.resourcePersistentAttribute.getSupportingAnnotation(this.getAnnotationName());
    }

    @Override
    public String getConverterName() {
        return this.getSpecifiedConverterName() == null ? this.getDefaultConverterName() : this.getSpecifiedConverterName();
    }

    @Override
    public String getDefaultConverterName() {
        return "none";
    }

    @Override
    public String getSpecifiedConverterName() {
        return this.specifiedConverterName;
    }

    @Override
    public void setSpecifiedConverterName(String newSpecifiedConverterName) {
        String oldSpecifiedConverterName = this.specifiedConverterName;
        this.specifiedConverterName = newSpecifiedConverterName;
        this.getResourceConvert().setValue(newSpecifiedConverterName);
        this.firePropertyChanged("specifiedConverterName", oldSpecifiedConverterName, newSpecifiedConverterName);
    }

    protected void setSpecifiedConverterName_(String newSpecifiedConverterName) {
        String oldSpecifiedConverterName = this.specifiedConverterName;
        this.specifiedConverterName = newSpecifiedConverterName;
        this.firePropertyChanged("specifiedConverterName", oldSpecifiedConverterName, newSpecifiedConverterName);
    }

    @Override
    public EclipseLinkJavaConverter getConverter() {
        return this.converter;
    }

    protected String getConverterType() {
        if (this.converter == null) {
            return "noConverter";
        }
        return this.converter.getType();
    }

    @Override
    public void setConverter(String converterType) {
        if (this.getConverterType() == converterType) {
            return;
        }
        EclipseLinkJavaConverter oldConverter = this.converter;
        EclipseLinkJavaConverter newConverter = this.buildConverter(converterType);
        this.converter = null;
        if (oldConverter != null) {
            this.resourcePersistentAttribute.removeSupportingAnnotation(oldConverter.getAnnotationName());
        }
        this.converter = newConverter;
        if (newConverter != null) {
            this.resourcePersistentAttribute.addSupportingAnnotation(newConverter.getAnnotationName());
        }
        this.firePropertyChanged("converter", oldConverter, newConverter);
    }

    protected void setConverter(EclipseLinkJavaConverter newConverter) {
        EclipseLinkJavaConverter oldConverter = this.converter;
        this.converter = newConverter;
        this.firePropertyChanged("converter", oldConverter, newConverter);
    }

    protected void initialize(JavaResourcePersistentAttribute jrpa) {
        this.resourcePersistentAttribute = jrpa;
        this.specifiedConverterName = this.getResourceConverterName();
        this.converter = this.buildConverter(this.getResourceConverterType());
    }

    public void update(JavaResourcePersistentAttribute jrpa) {
        this.resourcePersistentAttribute = jrpa;
        this.setSpecifiedConverterName_(this.getResourceConverterName());
        if (this.getResourceConverterType() == this.getConverterType()) {
            this.getConverter().update((JavaResourcePersistentMember)this.resourcePersistentAttribute);
        } else {
            EclipseLinkJavaConverter javaConverter = this.buildConverter(this.getResourceConverterType());
            this.setConverter(javaConverter);
        }
    }

    protected String getResourceConverterName() {
        ConvertAnnotation resourceConvert = this.getResourceConvert();
        return resourceConvert == null ? null : resourceConvert.getValue();
    }

    protected EclipseLinkJavaConverter buildConverter(String converterType) {
        if (converterType == "noConverter") {
            return null;
        }
        if (converterType == "customConverter") {
            return this.buildCustomConverter();
        }
        if (converterType == "typeConverter") {
            return this.buildTypeConverter();
        }
        if (converterType == "objectTypeConverter") {
            return this.buildObjectTypeConverter();
        }
        if (converterType == "structConverter") {
            return this.buildStructConverter();
        }
        return null;
    }

    protected EclipseLinkJavaCustomConverter buildCustomConverter() {
        EclipseLinkJavaCustomConverter contextConverter = new EclipseLinkJavaCustomConverter((JavaJpaContextNode)this);
        contextConverter.initialize((JavaResourcePersistentMember)this.resourcePersistentAttribute);
        return contextConverter;
    }

    protected EclipseLinkJavaTypeConverter buildTypeConverter() {
        EclipseLinkJavaTypeConverter contextConverter = new EclipseLinkJavaTypeConverter((JavaJpaContextNode)this);
        contextConverter.initialize((JavaResourcePersistentMember)this.resourcePersistentAttribute);
        return contextConverter;
    }

    protected EclipseLinkJavaObjectTypeConverter buildObjectTypeConverter() {
        EclipseLinkJavaObjectTypeConverter contextConverter = new EclipseLinkJavaObjectTypeConverter((JavaJpaContextNode)this);
        contextConverter.initialize((JavaResourcePersistentMember)this.resourcePersistentAttribute);
        return contextConverter;
    }

    protected EclipseLinkJavaStructConverter buildStructConverter() {
        EclipseLinkJavaStructConverter contextConverter = new EclipseLinkJavaStructConverter((JavaJpaContextNode)this);
        contextConverter.initialize((JavaResourcePersistentMember)this.resourcePersistentAttribute);
        return contextConverter;
    }

    protected String getResourceConverterType() {
        if (this.resourcePersistentAttribute.getSupportingAnnotation("org.eclipse.persistence.annotations.Converter") != null) {
            return "customConverter";
        }
        if (this.resourcePersistentAttribute.getSupportingAnnotation("org.eclipse.persistence.annotations.TypeConverter") != null) {
            return "typeConverter";
        }
        if (this.resourcePersistentAttribute.getSupportingAnnotation("org.eclipse.persistence.annotations.ObjectTypeConverter") != null) {
            return "objectTypeConverter";
        }
        if (this.resourcePersistentAttribute.getSupportingAnnotation("org.eclipse.persistence.annotations.StructConverter") != null) {
            return "structConverter";
        }
        return null;
    }

    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator<String> result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        if (this.convertValueTouches(pos, astRoot) && (result = this.persistenceConvertersNames(filter)) != null) {
            return result;
        }
        return null;
    }

    protected boolean convertValueTouches(int pos, CompilationUnit astRoot) {
        if (this.getResourceConvert() != null) {
            return this.getResourceConvert().valueTouches(pos, astRoot);
        }
        return false;
    }

    protected Iterator<String> persistenceConvertersNames() {
        if (this.getEclipseLinkPersistenceUnit().convertersSize() == 0) {
            return EmptyIterator.instance();
        }
        return CollectionTools.iterator((Object[])this.getEclipseLinkPersistenceUnit().uniqueConverterNames());
    }

    private Iterator<String> convertersNames(Filter<String> filter) {
        return new FilteringIterator(this.persistenceConvertersNames(), filter);
    }

    protected Iterator<String> persistenceConvertersNames(Filter<String> filter) {
        return StringTools.convertToJavaStringLiterals(this.convertersNames(filter));
    }

    protected EclipseLinkPersistenceUnit getEclipseLinkPersistenceUnit() {
        return (EclipseLinkPersistenceUnit)this.getPersistenceUnit();
    }

    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        if (this.getConverter() != null) {
            this.getConverter().validate(messages, reporter, astRoot);
        }
    }
}

