/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.context.persistence.caching;

import org.eclipse.jpt.eclipselink.core.internal.context.persistence.PersistenceUnitProperties;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.caching.CacheType;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.caching.Caching;
import org.eclipse.jpt.eclipselink.core.tests.internal.context.persistence.PersistenceUnitTestCase;
import org.eclipse.jpt.utility.internal.model.AbstractModel;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingValueModelTests
extends PersistenceUnitTestCase {
    private Caching caching;
    private PropertyValueModel<Caching> cachingHolder;
    private WritablePropertyValueModel<CacheType> cacheTypeHolder;
    private PropertyChangeListener cacheTypeListener;
    private PropertyChangeEvent cacheTypeEvent;
    private WritablePropertyValueModel<Boolean> sharedCacheHolder;
    private PropertyChangeListener sharedCacheListener;
    private PropertyChangeEvent sharedCacheEvent;
    private WritablePropertyValueModel<CacheType> cacheTypeDefaultHolder;
    private PropertyChangeListener cacheTypeDefaultListener;
    private PropertyChangeEvent cacheTypeDefaultEvent;
    private WritablePropertyValueModel<Boolean> sharedCacheDefaultHolder;
    private PropertyChangeListener sharedCacheDefaultListener;
    private PropertyChangeEvent sharedCacheDefaultEvent;
    public static final String ENTITY_NAME_TEST_VALUE = "Employee";
    public static final CacheType CACHE_TYPE_TEST_VALUE = CacheType.hard_weak;
    public static final Boolean SHARED_CACHE_TEST_VALUE = Boolean.FALSE;
    public static final CacheType CACHE_TYPE_DEFAULT_TEST_VALUE = CacheType.weak;
    public static final Boolean SHARED_CACHE_DEFAULT_TEST_VALUE = Boolean.FALSE;

    public CachingValueModelTests(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.caching = this.subject.getCaching();
        this.cachingHolder = new SimplePropertyValueModel((Object)this.caching);
        this.cacheTypeHolder = this.buildCacheTypeAA(this.cachingHolder);
        this.cacheTypeListener = this.buildCacheTypeChangeListener();
        this.cacheTypeHolder.addPropertyChangeListener("value", this.cacheTypeListener);
        this.cacheTypeEvent = null;
        this.sharedCacheHolder = this.buildSharedCacheAA(this.cachingHolder);
        this.sharedCacheListener = this.buildSharedCacheChangeListener();
        this.sharedCacheHolder.addPropertyChangeListener("value", this.sharedCacheListener);
        this.sharedCacheEvent = null;
        this.cacheTypeDefaultHolder = this.buildCacheTypeDefaultAA(this.cachingHolder);
        this.cacheTypeDefaultListener = this.buildCacheTypeDefaultChangeListener();
        this.cacheTypeDefaultHolder.addPropertyChangeListener("value", this.cacheTypeDefaultListener);
        this.cacheTypeDefaultEvent = null;
        this.sharedCacheDefaultHolder = this.buildSharedCacheDefaultAA(this.cachingHolder);
        this.sharedCacheDefaultListener = this.buildSharedCacheDefaultChangeListener();
        this.sharedCacheDefaultHolder.addPropertyChangeListener("value", this.sharedCacheDefaultListener);
        this.sharedCacheDefaultEvent = null;
    }

    public void testHasListeners() {
        AbstractModel subjectCaching = (AbstractModel)this.caching;
        PropertyAspectAdapter cacheTypeAA = (PropertyAspectAdapter)this.cacheTypeHolder;
        CachingValueModelTests.assertTrue((boolean)cacheTypeAA.hasAnyPropertyChangeListeners("value"));
        CachingValueModelTests.assertTrue((boolean)subjectCaching.hasAnyPropertyChangeListeners("cacheType"));
        cacheTypeAA.removePropertyChangeListener("value", this.cacheTypeListener);
        CachingValueModelTests.assertFalse((boolean)subjectCaching.hasAnyPropertyChangeListeners("cacheType"));
        CachingValueModelTests.assertFalse((boolean)cacheTypeAA.hasAnyPropertyChangeListeners("value"));
        PropertyAspectAdapter sharedCacheAA = (PropertyAspectAdapter)this.sharedCacheHolder;
        CachingValueModelTests.assertTrue((boolean)sharedCacheAA.hasAnyPropertyChangeListeners("value"));
        CachingValueModelTests.assertTrue((boolean)subjectCaching.hasAnyPropertyChangeListeners("sharedCache"));
        sharedCacheAA.removePropertyChangeListener("value", this.sharedCacheListener);
        CachingValueModelTests.assertFalse((boolean)subjectCaching.hasAnyPropertyChangeListeners("sharedCache"));
        CachingValueModelTests.assertFalse((boolean)sharedCacheAA.hasAnyPropertyChangeListeners("value"));
        PropertyAspectAdapter cacheTypeDefaultAA = (PropertyAspectAdapter)this.cacheTypeDefaultHolder;
        CachingValueModelTests.assertTrue((boolean)cacheTypeDefaultAA.hasAnyPropertyChangeListeners("value"));
        CachingValueModelTests.assertTrue((boolean)subjectCaching.hasAnyPropertyChangeListeners("cacheTypeDefault"));
        cacheTypeDefaultAA.removePropertyChangeListener("value", this.cacheTypeDefaultListener);
        CachingValueModelTests.assertFalse((boolean)subjectCaching.hasAnyPropertyChangeListeners("cacheTypeDefault"));
        CachingValueModelTests.assertFalse((boolean)cacheTypeDefaultAA.hasAnyPropertyChangeListeners("value"));
        PropertyAspectAdapter sharedCacheDefaultAA = (PropertyAspectAdapter)this.sharedCacheDefaultHolder;
        CachingValueModelTests.assertTrue((boolean)sharedCacheDefaultAA.hasAnyPropertyChangeListeners("value"));
        CachingValueModelTests.assertTrue((boolean)subjectCaching.hasAnyPropertyChangeListeners("sharedCacheDefault"));
        sharedCacheDefaultAA.removePropertyChangeListener("value", this.sharedCacheDefaultListener);
        CachingValueModelTests.assertFalse((boolean)subjectCaching.hasAnyPropertyChangeListeners("sharedCacheDefault"));
        CachingValueModelTests.assertFalse((boolean)sharedCacheDefaultAA.hasAnyPropertyChangeListeners("value"));
    }

    @Override
    protected void populatePu() {
        this.persistenceUnitSetProperty("eclipselink.cache.type.Employee", CACHE_TYPE_TEST_VALUE);
        this.persistenceUnitSetProperty("eclipselink.cache.shared.Employee", SHARED_CACHE_TEST_VALUE);
        this.persistenceUnitSetProperty("eclipselink.cache.type.default", CACHE_TYPE_DEFAULT_TEST_VALUE);
        this.persistenceUnitSetProperty("eclipselink.cache.shared.default", SHARED_CACHE_DEFAULT_TEST_VALUE);
    }

    @Override
    protected PersistenceUnitProperties getModel() {
        return this.caching;
    }

    private WritablePropertyValueModel<CacheType> buildCacheTypeAA(PropertyValueModel<Caching> subjectHolder) {
        return new PropertyAspectAdapter<Caching, CacheType>(subjectHolder, new String[]{"cacheType"}){

            protected CacheType buildValue_() {
                return ((Caching)this.subject).getCacheType(CachingValueModelTests.ENTITY_NAME_TEST_VALUE);
            }

            protected void setValue_(CacheType enumValue) {
                ((Caching)this.subject).setCacheType(enumValue, CachingValueModelTests.ENTITY_NAME_TEST_VALUE);
            }
        };
    }

    private PropertyChangeListener buildCacheTypeChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                CachingValueModelTests.this.cacheTypeEvent = e;
            }
        };
    }

    private WritablePropertyValueModel<Boolean> buildSharedCacheAA(PropertyValueModel<Caching> subjectHolder) {
        return new PropertyAspectAdapter<Caching, Boolean>(subjectHolder, new String[]{"sharedCache"}){

            protected Boolean buildValue_() {
                return ((Caching)this.subject).getSharedCache(CachingValueModelTests.ENTITY_NAME_TEST_VALUE);
            }

            protected void setValue_(Boolean enumValue) {
                ((Caching)this.subject).setSharedCache(enumValue, CachingValueModelTests.ENTITY_NAME_TEST_VALUE);
            }
        };
    }

    private PropertyChangeListener buildSharedCacheChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                CachingValueModelTests.this.sharedCacheEvent = e;
            }
        };
    }

    private WritablePropertyValueModel<CacheType> buildCacheTypeDefaultAA(PropertyValueModel<Caching> subjectHolder) {
        return new PropertyAspectAdapter<Caching, CacheType>(subjectHolder, new String[]{"cacheTypeDefault"}){

            protected CacheType buildValue_() {
                return ((Caching)this.subject).getCacheTypeDefault();
            }

            protected void setValue_(CacheType enumValue) {
                ((Caching)this.subject).setCacheTypeDefault(enumValue);
            }
        };
    }

    private PropertyChangeListener buildCacheTypeDefaultChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                CachingValueModelTests.this.cacheTypeDefaultEvent = e;
            }
        };
    }

    private WritablePropertyValueModel<Boolean> buildSharedCacheDefaultAA(PropertyValueModel<Caching> subjectHolder) {
        return new PropertyAspectAdapter<Caching, Boolean>(subjectHolder, new String[]{"sharedCacheDefault"}){

            protected Boolean buildValue_() {
                return ((Caching)this.subject).getSharedCacheDefault();
            }

            protected void setValue_(Boolean enumValue) {
                ((Caching)this.subject).setSharedCacheDefault(enumValue);
            }
        };
    }

    private PropertyChangeListener buildSharedCacheDefaultChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                CachingValueModelTests.this.sharedCacheDefaultEvent = e;
            }
        };
    }

    public void testValue() {
        this.verifyCacheTypeAAValue(CACHE_TYPE_TEST_VALUE);
        CachingValueModelTests.assertEquals((Object)this.caching.getCacheTypeDefault(), (Object)this.caching.getDefaultCacheType());
        this.verifySharedCacheAAValue(SHARED_CACHE_TEST_VALUE);
        CachingValueModelTests.assertEquals((Object)this.caching.getSharedCacheDefault(), (Object)this.caching.getDefaultSharedCache());
        this.verifyCacheTypeDefaultAAValue(CACHE_TYPE_DEFAULT_TEST_VALUE);
        CachingValueModelTests.assertEquals((Object)Caching.DEFAULT_CACHE_TYPE_DEFAULT, (Object)this.caching.getDefaultCacheTypeDefault());
        this.verifySharedCacheDefaultAAValue(SHARED_CACHE_DEFAULT_TEST_VALUE);
        CachingValueModelTests.assertEquals((Object)Caching.DEFAULT_SHARED_CACHE_DEFAULT, (Object)this.caching.getDefaultSharedCacheDefault());
    }

    public void testSetValue() throws Exception {
        this.cacheTypeEvent = null;
        this.verifyHasListeners((PropertyValueModel<?>)this.cacheTypeHolder, "value");
        CacheType newCacheType = CacheType.full;
        this.cacheTypeHolder.setValue((Object)newCacheType);
        this.verifyCacheTypeAAValue(newCacheType);
        CachingValueModelTests.assertNotNull((Object)this.cacheTypeEvent);
        this.sharedCacheEvent = null;
        this.verifyHasListeners((PropertyValueModel<?>)this.sharedCacheHolder, "value");
        Boolean newSharedCache = SHARED_CACHE_TEST_VALUE == false;
        this.sharedCacheHolder.setValue((Object)newSharedCache);
        this.verifySharedCacheAAValue(newSharedCache);
        CachingValueModelTests.assertNotNull((Object)this.sharedCacheEvent);
        this.cacheTypeDefaultEvent = null;
        this.verifyHasListeners((PropertyValueModel<?>)this.cacheTypeDefaultHolder, "value");
        CacheType newCacheTypeDefault = CacheType.none;
        this.cacheTypeDefaultHolder.setValue((Object)newCacheTypeDefault);
        this.verifyCacheTypeDefaultAAValue(newCacheTypeDefault);
        CachingValueModelTests.assertNotNull((Object)this.cacheTypeDefaultEvent);
        this.sharedCacheDefaultEvent = null;
        this.verifyHasListeners((PropertyValueModel<?>)this.sharedCacheDefaultHolder, "value");
        Boolean newSharedCacheDefault = SHARED_CACHE_DEFAULT_TEST_VALUE == false;
        this.sharedCacheDefaultHolder.setValue((Object)newSharedCacheDefault);
        this.verifySharedCacheDefaultAAValue(newSharedCacheDefault);
        CachingValueModelTests.assertNotNull((Object)this.sharedCacheDefaultEvent);
    }

    public void testSetNullValue() {
        String notDeleted = "Property not deleted";
        this.cacheTypeEvent = null;
        this.cacheTypeHolder.setValue(null);
        this.verifyCacheTypeAAValue(null);
        CachingValueModelTests.assertNotNull((Object)this.cacheTypeEvent);
        this.verifyPuHasNotProperty("eclipselink.cache.type.Employee", notDeleted);
        this.sharedCacheEvent = null;
        this.sharedCacheHolder.setValue(null);
        this.verifySharedCacheAAValue(null);
        CachingValueModelTests.assertNotNull((Object)this.sharedCacheEvent);
        this.verifyPuHasNotProperty("eclipselink.cache.shared.Employee", notDeleted);
        this.cacheTypeDefaultEvent = null;
        this.cacheTypeDefaultHolder.setValue(null);
        this.verifyCacheTypeDefaultAAValue(null);
        CachingValueModelTests.assertNotNull((Object)this.cacheTypeDefaultEvent);
        this.verifyPuHasNotProperty("eclipselink.cache.type.default", notDeleted);
        this.sharedCacheDefaultEvent = null;
        this.sharedCacheDefaultHolder.setValue(null);
        this.verifySharedCacheDefaultAAValue(null);
        CachingValueModelTests.assertNotNull((Object)this.sharedCacheDefaultEvent);
        this.verifyPuHasNotProperty("eclipselink.cache.shared.default", notDeleted);
    }

    protected void verifyCacheTypeAAValue(CacheType testValue) {
        this.verifyAAValue(testValue, this.caching.getCacheType(ENTITY_NAME_TEST_VALUE), this.cacheTypeHolder, "eclipselink.cache.type.Employee");
    }

    protected void verifySharedCacheAAValue(Boolean testValue) {
        this.verifyAAValue(testValue, this.caching.getSharedCache(ENTITY_NAME_TEST_VALUE), this.sharedCacheHolder, "eclipselink.cache.shared.Employee");
    }

    protected void verifyCacheTypeDefaultAAValue(CacheType testValue) {
        this.verifyAAValue(testValue, this.caching.getCacheTypeDefault(), this.cacheTypeDefaultHolder, "eclipselink.cache.type.default");
    }

    protected void verifySharedCacheDefaultAAValue(Boolean testValue) {
        this.verifyAAValue(testValue, this.caching.getSharedCacheDefault(), this.sharedCacheDefaultHolder, "eclipselink.cache.shared.default");
    }

    @Override
    protected void setProperty(String propertyName, Object newValue) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Object getProperty(String propertyName) throws NoSuchFieldException {
        throw new UnsupportedOperationException();
    }
}

