/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.db.internal.vendor;

import java.util.Collections;
import java.util.List;
import org.eclipse.datatools.modelbase.sql.schema.Catalog;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jpt.db.internal.vendor.CatalogStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UnknownCatalogStrategy
implements CatalogStrategy {
    private static final CatalogStrategy INSTANCE = new UnknownCatalogStrategy();

    static CatalogStrategy instance() {
        return INSTANCE;
    }

    private UnknownCatalogStrategy() {
    }

    @Override
    public boolean supportsCatalogs(Database database) {
        EList catalogs = database.getCatalogs();
        if (catalogs == null || catalogs.isEmpty()) {
            return false;
        }
        return this.getFauxCatalog((List<Catalog>)catalogs) == null;
    }

    @Override
    public List<Catalog> getCatalogs(Database database) {
        EList catalogs = database.getCatalogs();
        if (catalogs == null || catalogs.isEmpty()) {
            return Collections.emptyList();
        }
        Catalog fauxCatalog = this.getFauxCatalog((List<Catalog>)catalogs);
        return fauxCatalog == null ? catalogs : Collections.emptyList();
    }

    @Override
    public List<Schema> getSchemas(Database database) {
        EList catalogs = database.getCatalogs();
        if (catalogs == null || catalogs.isEmpty()) {
            return database.getSchemas();
        }
        Catalog fauxCatalog = this.getFauxCatalog((List<Catalog>)catalogs);
        return fauxCatalog != null ? fauxCatalog.getSchemas() : Collections.emptyList();
    }

    private Catalog getFauxCatalog(List<Catalog> catalogs) {
        Catalog catalog;
        if (catalogs.size() == 1 && (catalog = catalogs.get(0)).getName().equals("")) {
            return catalog;
        }
        return null;
    }
}

