/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.utility.jdt.JDTMethodAttribute;
import org.eclipse.jpt.core.internal.utility.jdt.JDTType;
import org.eclipse.jpt.core.tests.internal.resource.java.JavaResourceModelTestCase;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.core.utility.jdt.FieldAttribute;
import org.eclipse.jpt.core.utility.jdt.MethodAttribute;
import org.eclipse.jpt.core.utility.jdt.Type;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class JPTToolsTests
extends JavaResourceModelTestCase {
    public JPTToolsTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestTypeFieldWithModifier(final String modifier) throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    " + modifier + " String foo;").append(CR);
                sb.append(CR);
            }
        });
    }

    protected FieldAttribute fooField(ICompilationUnit cu) {
        return this.buildField("foo", cu);
    }

    private ICompilationUnit createTestTypeGetMethodWithModifier(final String modifier) throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    " + modifier + " int getFoo() {").append(CR);
                sb.append("        return this.id;").append(CR);
                sb.append("    }").append(CR);
                sb.append(CR);
                sb.append("    public void setFoo(int id) {").append(CR);
                sb.append("        this.id = id;").append(CR);
                sb.append("    }").append(CR);
                sb.append(CR);
            }
        });
    }

    private ICompilationUnit createTestTypeInvalidMethodName() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    public int foo() {").append(CR);
                sb.append("        return this.id;").append(CR);
                sb.append("    }").append(CR);
                sb.append(CR);
                sb.append("    public void setFoo(int id) {").append(CR);
                sb.append("        this.id = id;").append(CR);
                sb.append("    }").append(CR);
                sb.append(CR);
            }
        });
    }

    private ICompilationUnit createTestTypeConstructor() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    public AnnotationTestType() {").append(CR);
                sb.append("        super();").append(CR);
                sb.append("    }").append(CR);
                sb.append(CR);
            }
        });
    }

    private ICompilationUnit createTestTypeVoidMethodReturnType() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    public void getFoo() {").append(CR);
                sb.append("        return this.id;").append(CR);
                sb.append("    }").append(CR);
                sb.append(CR);
                sb.append("    public void setFoo(int id) {").append(CR);
                sb.append("        this.id = id;").append(CR);
                sb.append("    }").append(CR);
                sb.append(CR);
            }
        });
    }

    private ICompilationUnit createTestTypeInvalidMethodReturnType() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"com.foo.Foo"});
            }

            @Override
            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    public Foo getFoo() {").append(CR);
                sb.append("        return null;").append(CR);
                sb.append("    }").append(CR);
                sb.append(CR);
                sb.append("    public void setFoo(Foo id) {").append(CR);
                sb.append("        this.id = id;").append(CR);
                sb.append("    }").append(CR);
                sb.append(CR);
            }
        });
    }

    private ICompilationUnit createTestTypeIsMethod() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    public boolean isFoo() {").append(CR);
                sb.append("        return this.id;").append(CR);
                sb.append("    }").append(CR);
                sb.append(CR);
                sb.append("    public void setFoo(boolean id) {").append(CR);
                sb.append("        this.id = id;").append(CR);
                sb.append("    }").append(CR);
                sb.append(CR);
            }
        });
    }

    private ICompilationUnit createTestTypeIsMethodReturnInt() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    public int isFoo() {").append(CR);
                sb.append("        return this.id;").append(CR);
                sb.append("    }").append(CR);
                sb.append(CR);
                sb.append("    public void setFoo(int id) {").append(CR);
                sb.append("        this.id = id;").append(CR);
                sb.append("    }").append(CR);
                sb.append(CR);
            }
        });
    }

    private ICompilationUnit createTestTypeIsAndGetMethodWithModifier(final String modifier) throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    " + modifier + " boolean isFoo() {").append(CR);
                sb.append("        return this.id;").append(CR);
                sb.append("    }").append(CR);
                sb.append(CR);
                sb.append("    " + modifier + " boolean getFoo() {").append(CR);
                sb.append("        return this.id;").append(CR);
                sb.append("    }").append(CR);
                sb.append(CR);
                sb.append("    public void setFoo(boolean id) {").append(CR);
                sb.append("        this.id = id;").append(CR);
                sb.append("    }").append(CR);
                sb.append(CR);
            }
        });
    }

    private ICompilationUnit createTestTypeSetMethodWithModifier(final String modifier) throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    public int getFoo() {").append(CR);
                sb.append("        return this.id;").append(CR);
                sb.append("    }").append(CR);
                sb.append(CR);
                sb.append("    " + modifier + " void setFoo(int id) {").append(CR);
                sb.append("        this.id = id;").append(CR);
                sb.append("    }").append(CR);
                sb.append(CR);
            }
        });
    }

    private ICompilationUnit createTestTypeWithMemberTypes() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            public void appendMemberTypeTo(StringBuilder sb) {
                sb.append("     public static class FooStatic {}").append(CR);
                sb.append(CR);
                sb.append("     public class FooNotStatic {}").append(CR);
                sb.append(CR);
                sb.append("     public @interface MyAnnotation {}").append(CR);
                sb.append(CR);
                sb.append("     public enum MyEnum {}").append(CR);
            }
        });
    }

    protected MethodAttribute fooMethod(ICompilationUnit cu) {
        return this.buildMethod("getFoo", cu);
    }

    public void testFieldIsPersistable1() throws Exception {
        ICompilationUnit cu = this.createTestTypeFieldWithModifier("private");
        FieldAttribute fieldAttribute = this.fooField(cu);
        JPTToolsTests.assertTrue((boolean)fieldAttribute.isPersistable(this.buildASTRoot(cu)));
    }

    public void testFieldIsPersistable2() throws Exception {
        ICompilationUnit cu = this.createTestTypeFieldWithModifier("private static");
        FieldAttribute fieldAttribute = this.fooField(cu);
        JPTToolsTests.assertFalse((boolean)fieldAttribute.isPersistable(this.buildASTRoot(cu)));
    }

    public void testFieldIsPersistable3() throws Exception {
        ICompilationUnit cu = this.createTestTypeFieldWithModifier("private transient");
        FieldAttribute fieldAttribute = this.fooField(cu);
        JPTToolsTests.assertFalse((boolean)fieldAttribute.isPersistable(this.buildASTRoot(cu)));
    }

    public void testFieldIsPersistable4() throws Exception {
        ICompilationUnit cu = this.createTestTypeFieldWithModifier("private final");
        FieldAttribute fieldAttribute = this.fooField(cu);
        JPTToolsTests.assertTrue((boolean)fieldAttribute.isPersistable(this.buildASTRoot(cu)));
    }

    public void testFieldIsPersistable5() throws Exception {
        ICompilationUnit cu = this.createTestTypeFieldWithModifier("public");
        FieldAttribute fieldAttribute = this.fooField(cu);
        JPTToolsTests.assertTrue((boolean)fieldAttribute.isPersistable(this.buildASTRoot(cu)));
    }

    public void testMethodIsPersistablePropertyGetter01() throws Exception {
        ICompilationUnit cu = this.createTestTypeGetMethodWithModifier("public");
        MethodAttribute methodAttribute = this.fooMethod(cu);
        JPTToolsTests.assertTrue((boolean)methodAttribute.isPersistable(this.buildASTRoot(cu)));
    }

    public void testMethodIsPersistablePropertyGetter02() throws Exception {
        ICompilationUnit cu = this.createTestTypeGetMethodWithModifier("protected");
        MethodAttribute methodAttribute = this.fooMethod(cu);
        JPTToolsTests.assertTrue((boolean)methodAttribute.isPersistable(this.buildASTRoot(cu)));
    }

    public void testMethodIsPersistablePropertyGetter03() throws Exception {
        ICompilationUnit cu = this.createTestTypeGetMethodWithModifier("");
        MethodAttribute methodAttribute = this.fooMethod(cu);
        JPTToolsTests.assertFalse((boolean)methodAttribute.isPersistable(this.buildASTRoot(cu)));
    }

    public void testMethodIsPersistablePropertyGetter04() throws Exception {
        ICompilationUnit cu = this.createTestTypeGetMethodWithModifier("private");
        MethodAttribute methodAttribute = this.fooMethod(cu);
        JPTToolsTests.assertFalse((boolean)methodAttribute.isPersistable(this.buildASTRoot(cu)));
    }

    public void testMethodIsPersistablePropertyGetter05() throws Exception {
        ICompilationUnit cu = this.createTestTypeGetMethodWithModifier("public static");
        MethodAttribute methodAttribute = this.fooMethod(cu);
        JPTToolsTests.assertFalse((boolean)methodAttribute.isPersistable(this.buildASTRoot(cu)));
    }

    public void testMethodIsPersistablePropertyGetter06() throws Exception {
        ICompilationUnit cu = this.createTestTypeGetMethodWithModifier("public final");
        MethodAttribute methodAttribute = this.fooMethod(cu);
        JPTToolsTests.assertFalse((boolean)methodAttribute.isPersistable(this.buildASTRoot(cu)));
    }

    public void testMethodIsPersistablePropertyGetter07() throws Exception {
        ICompilationUnit cu = this.createTestTypeSetMethodWithModifier("public");
        MethodAttribute methodAttribute = this.fooMethod(cu);
        JPTToolsTests.assertTrue((boolean)methodAttribute.isPersistable(this.buildASTRoot(cu)));
    }

    public void testMethodIsPersistablePropertyGetter08() throws Exception {
        ICompilationUnit cu = this.createTestTypeSetMethodWithModifier("protected");
        MethodAttribute methodAttribute = this.fooMethod(cu);
        JPTToolsTests.assertTrue((boolean)methodAttribute.isPersistable(this.buildASTRoot(cu)));
    }

    public void testMethodIsPersistablePropertyGetter09() throws Exception {
        ICompilationUnit cu = this.createTestTypeSetMethodWithModifier("");
        MethodAttribute methodAttribute = this.fooMethod(cu);
        JPTToolsTests.assertFalse((boolean)methodAttribute.isPersistable(this.buildASTRoot(cu)));
    }

    public void testMethodIsPersistablePropertyGetter10() throws Exception {
        ICompilationUnit cu = this.createTestTypeSetMethodWithModifier("private");
        MethodAttribute methodAttribute = this.fooMethod(cu);
        JPTToolsTests.assertFalse((boolean)methodAttribute.isPersistable(this.buildASTRoot(cu)));
    }

    public void testMethodIsPersistablePropertyGetter11() throws Exception {
        ICompilationUnit cu = this.createTestTypeSetMethodWithModifier("public static");
        MethodAttribute methodAttribute = this.fooMethod(cu);
        JPTToolsTests.assertFalse((boolean)methodAttribute.isPersistable(this.buildASTRoot(cu)));
    }

    public void testMethodIsPersistablePropertyGetter12() throws Exception {
        ICompilationUnit cu = this.createTestTypeSetMethodWithModifier("public final");
        MethodAttribute methodAttribute = this.fooMethod(cu);
        JPTToolsTests.assertFalse((boolean)methodAttribute.isPersistable(this.buildASTRoot(cu)));
    }

    public void testMethodIsPersistablePropertyGetter13() throws Exception {
        ICompilationUnit cu = this.createTestTypeIsMethod();
        JDTMethodAttribute methodAttribute = this.buildMethod("isFoo", cu);
        JPTToolsTests.assertTrue((boolean)methodAttribute.isPersistable(this.buildASTRoot(cu)));
    }

    public void testMethodIsPersistablePropertyGetter14() throws Exception {
        ICompilationUnit cu = this.createTestTypeIsMethodReturnInt();
        JDTMethodAttribute methodAttribute = this.buildMethod("isFoo", cu);
        JPTToolsTests.assertFalse((boolean)methodAttribute.isPersistable(this.buildASTRoot(cu)));
    }

    public void testMethodIsPersistablePropertyGetter15() throws Exception {
        ICompilationUnit cu = this.createTestTypeIsAndGetMethodWithModifier("public");
        JDTMethodAttribute isFooMethod = this.buildMethod("isFoo", cu);
        JDTMethodAttribute getFooMethod = this.buildMethod("getFoo", cu);
        CompilationUnit astRoot = this.buildASTRoot(cu);
        JPTToolsTests.assertTrue((boolean)isFooMethod.isPersistable(astRoot));
        JPTToolsTests.assertFalse((boolean)getFooMethod.isPersistable(astRoot));
    }

    public void testMethodIsPersistablePropertyGetter16() throws Exception {
        ICompilationUnit cu = this.createTestTypeInvalidMethodName();
        JDTMethodAttribute fooMethod = this.buildMethod("foo", cu);
        JPTToolsTests.assertFalse((boolean)fooMethod.isPersistable(this.buildASTRoot(cu)));
    }

    public void testMethodIsPersistablePropertyGetter17() throws Exception {
        ICompilationUnit cu = this.createTestTypeVoidMethodReturnType();
        JDTMethodAttribute fooMethod = this.buildMethod("getFoo", cu);
        JPTToolsTests.assertFalse((boolean)fooMethod.isPersistable(this.buildASTRoot(cu)));
    }

    public void testMethodIsPersistablePropertyGetter18() throws Exception {
        ICompilationUnit cu = this.createTestTypeInvalidMethodReturnType();
        JDTMethodAttribute getFooMethod = this.buildMethod("getFoo", cu);
        JPTToolsTests.assertTrue((boolean)getFooMethod.isPersistable(this.buildASTRoot(cu)));
    }

    public void testMethodIsPersistablePropertyGetter19() throws Exception {
        ICompilationUnit cu = this.createTestType();
        JDTMethodAttribute setIdMethod = this.idSetMethod(cu);
        JPTToolsTests.assertFalse((boolean)setIdMethod.isPersistable(this.buildASTRoot(cu)));
    }

    public void testMethodIsPersistablePropertyGetter20() throws Exception {
        ICompilationUnit cu = this.createTestTypeConstructor();
        JDTMethodAttribute constructor = this.buildMethod("AnnotationTestType", cu);
        JPTToolsTests.assertFalse((boolean)constructor.isPersistable(this.buildASTRoot(cu)));
    }

    public void testMethodIsPersistablePropertyGetter21() throws Exception {
        ICompilationUnit cu = this.createTestType();
        JDTMethodAttribute getNameMethod = this.nameGetMethod(cu);
        JPTToolsTests.assertFalse((boolean)getNameMethod.isPersistable(this.buildASTRoot(cu)));
    }

    public void testTypeIsPersistable1() throws Exception {
        ICompilationUnit cu = this.createTestType();
        JDTType type = this.testType(cu);
        CompilationUnit astRoot = this.buildASTRoot(cu);
        JPTToolsTests.assertTrue((boolean)type.isPersistable(astRoot));
    }

    public void testTypeIsPersistable2() throws Exception {
        ICompilationUnit cu = this.javaProject.createCompilationUnit("finals", "MyFinal.java", "public final class MyFinal { }");
        JDTType type = this.buildType("MyFinal", cu);
        CompilationUnit astRoot = this.buildASTRoot(cu);
        JPTToolsTests.assertFalse((boolean)type.isPersistable(astRoot));
    }

    public void testTypeIsPersistable3() throws Exception {
        ICompilationUnit cu = this.javaProject.createCompilationUnit("interfaces", "MyInterface.java", "public interface MyInterface { }");
        JDTType type = this.buildType("MyInterface", cu);
        CompilationUnit astRoot = this.buildASTRoot(cu);
        JPTToolsTests.assertFalse((boolean)type.isPersistable(astRoot));
    }

    public void testTypeIsPersistable4() throws Exception {
        ICompilationUnit cu = this.createEnumAndMembers("TestEnum", "FOO, BAR, BAZ");
        JDTType type = this.buildType("TestEnum", cu);
        CompilationUnit astRoot = this.buildASTRoot(cu);
        JPTToolsTests.assertFalse((boolean)type.isPersistable(astRoot));
    }

    public void testTypeIsPersistable5() throws Exception {
        ICompilationUnit cu = this.createAnnotationAndMembers("TestAnnotation", "TestEnum foo();");
        JDTType type = this.buildType("TestAnnotation", cu);
        CompilationUnit astRoot = this.buildASTRoot(cu);
        JPTToolsTests.assertFalse((boolean)type.isPersistable(astRoot));
    }

    public void testTypeIsPersistable6() throws Exception {
        ICompilationUnit cu = this.createTestTypeWithMemberTypes();
        JDTType testType = this.testType(cu);
        JDTType memberType = this.buildType((Type)testType, "FooStatic", 1, cu);
        CompilationUnit astRoot = this.buildASTRoot(cu);
        JPTToolsTests.assertTrue((boolean)memberType.isPersistable(astRoot));
    }

    public void testTypeIsPersistable7() throws Exception {
        ICompilationUnit cu = this.createTestTypeWithMemberTypes();
        JDTType testType = this.testType(cu);
        JDTType memberType = this.buildType((Type)testType, "FooNotStatic", 1, cu);
        CompilationUnit astRoot = this.buildASTRoot(cu);
        JPTToolsTests.assertFalse((boolean)memberType.isPersistable(astRoot));
    }
}

