/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.persistence;

import org.eclipse.jpt.core.context.persistence.PersistenceXml;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.xml.JpaXmlResource;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;

public class PersistenceXmlTests
extends ContextModelTestCase {
    public PersistenceXmlTests(String name) {
        super(name);
    }

    protected PersistenceXml getPersistenceXml() {
        return this.getRootContextNode().getPersistenceXml();
    }

    public void testUpdateAddPersistence() throws Exception {
        PersistenceXmlTests.assertEquals((int)2, (int)this.getJpaProject().jpaFilesSize());
        JpaXmlResource prm = this.getPersistenceXmlResource();
        prm.getContents().clear();
        prm.save(null);
        PersistenceXmlTests.assertNull((Object)this.getPersistenceXml());
        PersistenceXmlTests.assertEquals((int)1, (int)this.getJpaProject().jpaFilesSize());
        prm.getContents().add((Object)PersistenceFactory.eINSTANCE.createXmlPersistence());
        prm.save(null);
        PersistenceXmlTests.assertNotNull((Object)this.getPersistenceXml().getPersistence());
        PersistenceXmlTests.assertEquals((int)2, (int)this.getJpaProject().jpaFilesSize());
    }

    public void testModifyAddPersistence() {
        JpaXmlResource prm = this.getPersistenceXmlResource();
        prm.getContents().remove((Object)this.getXmlPersistence());
        PersistenceXmlTests.assertNull((Object)this.getXmlPersistence());
        PersistenceXml persistenceXml = this.getPersistenceXml();
        persistenceXml.addPersistence();
        PersistenceXmlTests.assertNotNull((Object)persistenceXml.getPersistence());
        boolean exceptionThrown = false;
        try {
            persistenceXml.addPersistence();
        }
        catch (IllegalStateException illegalStateException) {
            exceptionThrown = true;
        }
        PersistenceXmlTests.assertTrue((boolean)exceptionThrown);
    }

    public void testUpdateRemovePersistence() throws Exception {
        JpaXmlResource prm = this.getPersistenceXmlResource();
        PersistenceXmlTests.assertNotNull((Object)this.getPersistenceXml().getPersistence());
        prm.getContents().clear();
        PersistenceXmlTests.assertNull((Object)this.getPersistenceXml().getPersistence());
    }

    public void testModifyRemovePersistence() {
        PersistenceXml persistenceXml = this.getPersistenceXml();
        PersistenceXmlTests.assertNotNull((Object)persistenceXml.getPersistence());
        persistenceXml.removePersistence();
        PersistenceXmlTests.assertNull((Object)persistenceXml.getPersistence());
        boolean exceptionThrown = false;
        try {
            persistenceXml.removePersistence();
        }
        catch (IllegalStateException illegalStateException) {
            exceptionThrown = true;
        }
        PersistenceXmlTests.assertTrue((boolean)exceptionThrown);
    }
}

