/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.orm;

import java.util.ListIterator;
import org.eclipse.jpt.core.context.orm.OrmEntity;
import org.eclipse.jpt.core.context.orm.OrmNamedNativeQuery;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.context.orm.OrmQueryHint;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlEntity;
import org.eclipse.jpt.core.resource.orm.XmlNamedNativeQuery;
import org.eclipse.jpt.core.resource.orm.XmlQueryHint;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;

public class OrmNamedNativeQueryTests
extends ContextModelTestCase {
    public OrmNamedNativeQueryTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.getXmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.getPersistenceXmlResource().save(null);
    }

    public void testUpdateName() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmNamedNativeQuery ormNamedNativeQuery = ormEntity.addNamedNativeQuery(0);
        XmlNamedNativeQuery namedNativeQueryResource = (XmlNamedNativeQuery)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getNamedNativeQueries().get(0);
        OrmNamedNativeQueryTests.assertNull((Object)ormNamedNativeQuery.getName());
        OrmNamedNativeQueryTests.assertNull((Object)namedNativeQueryResource.getName());
        namedNativeQueryResource.setName("newName");
        OrmNamedNativeQueryTests.assertEquals((String)"newName", (String)ormNamedNativeQuery.getName());
        OrmNamedNativeQueryTests.assertEquals((String)"newName", (String)namedNativeQueryResource.getName());
        namedNativeQueryResource.setName(null);
        OrmNamedNativeQueryTests.assertNull((Object)ormNamedNativeQuery.getName());
        OrmNamedNativeQueryTests.assertNull((Object)namedNativeQueryResource.getName());
    }

    public void testModifyName() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmNamedNativeQuery ormNamedNativeQuery = ormEntity.addNamedNativeQuery(0);
        XmlNamedNativeQuery namedNativeQueryResource = (XmlNamedNativeQuery)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getNamedNativeQueries().get(0);
        OrmNamedNativeQueryTests.assertNull((Object)ormNamedNativeQuery.getName());
        OrmNamedNativeQueryTests.assertNull((Object)namedNativeQueryResource.getName());
        ormNamedNativeQuery.setName("newName");
        OrmNamedNativeQueryTests.assertEquals((String)"newName", (String)ormNamedNativeQuery.getName());
        OrmNamedNativeQueryTests.assertEquals((String)"newName", (String)namedNativeQueryResource.getName());
        ormNamedNativeQuery.setName(null);
        OrmNamedNativeQueryTests.assertNull((Object)ormNamedNativeQuery.getName());
        OrmNamedNativeQueryTests.assertNull((Object)namedNativeQueryResource.getName());
    }

    public void testUpdateQuery() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmNamedNativeQuery ormNamedNativeQuery = ormEntity.addNamedNativeQuery(0);
        XmlNamedNativeQuery namedNativeQueryResource = (XmlNamedNativeQuery)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getNamedNativeQueries().get(0);
        OrmNamedNativeQueryTests.assertNull((Object)ormNamedNativeQuery.getQuery());
        OrmNamedNativeQueryTests.assertNull((Object)namedNativeQueryResource.getQuery());
        namedNativeQueryResource.setQuery("newName");
        OrmNamedNativeQueryTests.assertEquals((String)"newName", (String)ormNamedNativeQuery.getQuery());
        OrmNamedNativeQueryTests.assertEquals((String)"newName", (String)namedNativeQueryResource.getQuery());
        namedNativeQueryResource.setQuery(null);
        OrmNamedNativeQueryTests.assertNull((Object)ormNamedNativeQuery.getQuery());
        OrmNamedNativeQueryTests.assertNull((Object)namedNativeQueryResource.getQuery());
    }

    public void testModifyQuery() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmNamedNativeQuery ormNamedNativeQuery = ormEntity.addNamedNativeQuery(0);
        XmlNamedNativeQuery namedNativeQueryResource = (XmlNamedNativeQuery)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getNamedNativeQueries().get(0);
        OrmNamedNativeQueryTests.assertNull((Object)ormNamedNativeQuery.getQuery());
        OrmNamedNativeQueryTests.assertNull((Object)namedNativeQueryResource.getQuery());
        ormNamedNativeQuery.setQuery("newName");
        OrmNamedNativeQueryTests.assertEquals((String)"newName", (String)ormNamedNativeQuery.getQuery());
        OrmNamedNativeQueryTests.assertEquals((String)"newName", (String)namedNativeQueryResource.getQuery());
        ormNamedNativeQuery.setQuery(null);
        OrmNamedNativeQueryTests.assertNull((Object)ormNamedNativeQuery.getQuery());
        OrmNamedNativeQueryTests.assertNull((Object)namedNativeQueryResource.getQuery());
    }

    public void testAddHint() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmNamedNativeQuery ormNamedNativeQuery = ormEntity.addNamedNativeQuery(0);
        XmlNamedNativeQuery namedNativeQueryResource = (XmlNamedNativeQuery)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getNamedNativeQueries().get(0);
        OrmQueryHint queryHint = ormNamedNativeQuery.addHint(0);
        queryHint.setName("FOO");
        OrmNamedNativeQueryTests.assertEquals((String)"FOO", (String)((XmlQueryHint)namedNativeQueryResource.getHints().get(0)).getName());
        OrmQueryHint queryHint2 = ormNamedNativeQuery.addHint(0);
        queryHint2.setName("BAR");
        OrmNamedNativeQueryTests.assertEquals((String)"BAR", (String)((XmlQueryHint)namedNativeQueryResource.getHints().get(0)).getName());
        OrmNamedNativeQueryTests.assertEquals((String)"FOO", (String)((XmlQueryHint)namedNativeQueryResource.getHints().get(1)).getName());
        OrmQueryHint queryHint3 = ormNamedNativeQuery.addHint(1);
        queryHint3.setName("BAZ");
        OrmNamedNativeQueryTests.assertEquals((String)"BAR", (String)((XmlQueryHint)namedNativeQueryResource.getHints().get(0)).getName());
        OrmNamedNativeQueryTests.assertEquals((String)"BAZ", (String)((XmlQueryHint)namedNativeQueryResource.getHints().get(1)).getName());
        OrmNamedNativeQueryTests.assertEquals((String)"FOO", (String)((XmlQueryHint)namedNativeQueryResource.getHints().get(2)).getName());
        ListIterator queryHints = ormNamedNativeQuery.hints();
        OrmNamedNativeQueryTests.assertEquals((Object)queryHint2, queryHints.next());
        OrmNamedNativeQueryTests.assertEquals((Object)queryHint3, queryHints.next());
        OrmNamedNativeQueryTests.assertEquals((Object)queryHint, queryHints.next());
        queryHints = ormNamedNativeQuery.hints();
        OrmNamedNativeQueryTests.assertEquals((String)"BAR", (String)((OrmQueryHint)queryHints.next()).getName());
        OrmNamedNativeQueryTests.assertEquals((String)"BAZ", (String)((OrmQueryHint)queryHints.next()).getName());
        OrmNamedNativeQueryTests.assertEquals((String)"FOO", (String)((OrmQueryHint)queryHints.next()).getName());
    }

    public void testRemoveHint() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmNamedNativeQuery ormNamedNativeQuery = ormEntity.addNamedNativeQuery(0);
        XmlNamedNativeQuery namedNativeQueryResource = (XmlNamedNativeQuery)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getNamedNativeQueries().get(0);
        ormNamedNativeQuery.addHint(0).setName("FOO");
        ormNamedNativeQuery.addHint(1).setName("BAR");
        ormNamedNativeQuery.addHint(2).setName("BAZ");
        OrmNamedNativeQueryTests.assertEquals((int)3, (int)namedNativeQueryResource.getHints().size());
        ormNamedNativeQuery.removeHint(0);
        OrmNamedNativeQueryTests.assertEquals((int)2, (int)namedNativeQueryResource.getHints().size());
        OrmNamedNativeQueryTests.assertEquals((String)"BAR", (String)((XmlQueryHint)namedNativeQueryResource.getHints().get(0)).getName());
        OrmNamedNativeQueryTests.assertEquals((String)"BAZ", (String)((XmlQueryHint)namedNativeQueryResource.getHints().get(1)).getName());
        ormNamedNativeQuery.removeHint(0);
        OrmNamedNativeQueryTests.assertEquals((int)1, (int)namedNativeQueryResource.getHints().size());
        OrmNamedNativeQueryTests.assertEquals((String)"BAZ", (String)((XmlQueryHint)namedNativeQueryResource.getHints().get(0)).getName());
        ormNamedNativeQuery.removeHint(0);
        OrmNamedNativeQueryTests.assertEquals((int)0, (int)namedNativeQueryResource.getHints().size());
    }

    public void testMoveHint() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmNamedNativeQuery ormNamedNativeQuery = ormEntity.addNamedNativeQuery(0);
        XmlNamedNativeQuery namedNativeQueryResource = (XmlNamedNativeQuery)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getNamedNativeQueries().get(0);
        ormNamedNativeQuery.addHint(0).setName("FOO");
        ormNamedNativeQuery.addHint(1).setName("BAR");
        ormNamedNativeQuery.addHint(2).setName("BAZ");
        OrmNamedNativeQueryTests.assertEquals((int)3, (int)namedNativeQueryResource.getHints().size());
        ormNamedNativeQuery.moveHint(2, 0);
        ListIterator hints = ormNamedNativeQuery.hints();
        OrmNamedNativeQueryTests.assertEquals((String)"BAR", (String)((OrmQueryHint)hints.next()).getName());
        OrmNamedNativeQueryTests.assertEquals((String)"BAZ", (String)((OrmQueryHint)hints.next()).getName());
        OrmNamedNativeQueryTests.assertEquals((String)"FOO", (String)((OrmQueryHint)hints.next()).getName());
        OrmNamedNativeQueryTests.assertEquals((String)"BAR", (String)((XmlQueryHint)namedNativeQueryResource.getHints().get(0)).getName());
        OrmNamedNativeQueryTests.assertEquals((String)"BAZ", (String)((XmlQueryHint)namedNativeQueryResource.getHints().get(1)).getName());
        OrmNamedNativeQueryTests.assertEquals((String)"FOO", (String)((XmlQueryHint)namedNativeQueryResource.getHints().get(2)).getName());
        ormNamedNativeQuery.moveHint(0, 1);
        hints = ormNamedNativeQuery.hints();
        OrmNamedNativeQueryTests.assertEquals((String)"BAZ", (String)((OrmQueryHint)hints.next()).getName());
        OrmNamedNativeQueryTests.assertEquals((String)"BAR", (String)((OrmQueryHint)hints.next()).getName());
        OrmNamedNativeQueryTests.assertEquals((String)"FOO", (String)((OrmQueryHint)hints.next()).getName());
        OrmNamedNativeQueryTests.assertEquals((String)"BAZ", (String)((XmlQueryHint)namedNativeQueryResource.getHints().get(0)).getName());
        OrmNamedNativeQueryTests.assertEquals((String)"BAR", (String)((XmlQueryHint)namedNativeQueryResource.getHints().get(1)).getName());
        OrmNamedNativeQueryTests.assertEquals((String)"FOO", (String)((XmlQueryHint)namedNativeQueryResource.getHints().get(2)).getName());
    }

    public void testUpdateHints() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmNamedNativeQuery ormNamedNativeQuery = ormEntity.addNamedNativeQuery(0);
        XmlNamedNativeQuery namedNativeQueryResource = (XmlNamedNativeQuery)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getNamedNativeQueries().get(0);
        namedNativeQueryResource.getHints().add((Object)OrmFactory.eINSTANCE.createXmlQueryHint());
        namedNativeQueryResource.getHints().add((Object)OrmFactory.eINSTANCE.createXmlQueryHint());
        namedNativeQueryResource.getHints().add((Object)OrmFactory.eINSTANCE.createXmlQueryHint());
        ((XmlQueryHint)namedNativeQueryResource.getHints().get(0)).setName("FOO");
        ((XmlQueryHint)namedNativeQueryResource.getHints().get(1)).setName("BAR");
        ((XmlQueryHint)namedNativeQueryResource.getHints().get(2)).setName("BAZ");
        ListIterator hints = ormNamedNativeQuery.hints();
        OrmNamedNativeQueryTests.assertEquals((String)"FOO", (String)((OrmQueryHint)hints.next()).getName());
        OrmNamedNativeQueryTests.assertEquals((String)"BAR", (String)((OrmQueryHint)hints.next()).getName());
        OrmNamedNativeQueryTests.assertEquals((String)"BAZ", (String)((OrmQueryHint)hints.next()).getName());
        OrmNamedNativeQueryTests.assertFalse((boolean)hints.hasNext());
        namedNativeQueryResource.getHints().move(2, 0);
        hints = ormNamedNativeQuery.hints();
        OrmNamedNativeQueryTests.assertEquals((String)"BAR", (String)((OrmQueryHint)hints.next()).getName());
        OrmNamedNativeQueryTests.assertEquals((String)"BAZ", (String)((OrmQueryHint)hints.next()).getName());
        OrmNamedNativeQueryTests.assertEquals((String)"FOO", (String)((OrmQueryHint)hints.next()).getName());
        OrmNamedNativeQueryTests.assertFalse((boolean)hints.hasNext());
        namedNativeQueryResource.getHints().move(0, 1);
        hints = ormNamedNativeQuery.hints();
        OrmNamedNativeQueryTests.assertEquals((String)"BAZ", (String)((OrmQueryHint)hints.next()).getName());
        OrmNamedNativeQueryTests.assertEquals((String)"BAR", (String)((OrmQueryHint)hints.next()).getName());
        OrmNamedNativeQueryTests.assertEquals((String)"FOO", (String)((OrmQueryHint)hints.next()).getName());
        OrmNamedNativeQueryTests.assertFalse((boolean)hints.hasNext());
        namedNativeQueryResource.getHints().remove(1);
        hints = ormNamedNativeQuery.hints();
        OrmNamedNativeQueryTests.assertEquals((String)"BAZ", (String)((OrmQueryHint)hints.next()).getName());
        OrmNamedNativeQueryTests.assertEquals((String)"FOO", (String)((OrmQueryHint)hints.next()).getName());
        OrmNamedNativeQueryTests.assertFalse((boolean)hints.hasNext());
        namedNativeQueryResource.getHints().remove(1);
        hints = ormNamedNativeQuery.hints();
        OrmNamedNativeQueryTests.assertEquals((String)"BAZ", (String)((OrmQueryHint)hints.next()).getName());
        OrmNamedNativeQueryTests.assertFalse((boolean)hints.hasNext());
        namedNativeQueryResource.getHints().remove(0);
        OrmNamedNativeQueryTests.assertFalse((boolean)ormNamedNativeQuery.hints().hasNext());
    }

    public void testUpdateResultSetMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmNamedNativeQuery ormNamedNativeQuery = ormEntity.addNamedNativeQuery(0);
        XmlNamedNativeQuery namedNativeQueryResource = (XmlNamedNativeQuery)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getNamedNativeQueries().get(0);
        OrmNamedNativeQueryTests.assertEquals(null, (String)namedNativeQueryResource.getResultSetMapping());
        OrmNamedNativeQueryTests.assertEquals(null, (String)ormNamedNativeQuery.getResultSetMapping());
        namedNativeQueryResource.setResultSetMapping("foo");
        OrmNamedNativeQueryTests.assertEquals((String)"foo", (String)namedNativeQueryResource.getResultSetMapping());
        OrmNamedNativeQueryTests.assertEquals((String)"foo", (String)ormNamedNativeQuery.getResultSetMapping());
        namedNativeQueryResource.setResultSetMapping(null);
        OrmNamedNativeQueryTests.assertNull((Object)namedNativeQueryResource.getResultSetMapping());
        OrmNamedNativeQueryTests.assertNull((Object)ormNamedNativeQuery.getResultSetMapping());
    }

    public void testModifyResultSetMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmNamedNativeQuery ormNamedNativeQuery = ormEntity.addNamedNativeQuery(0);
        XmlNamedNativeQuery namedNativeQueryResource = (XmlNamedNativeQuery)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getNamedNativeQueries().get(0);
        OrmNamedNativeQueryTests.assertEquals(null, (String)namedNativeQueryResource.getResultSetMapping());
        OrmNamedNativeQueryTests.assertEquals(null, (String)ormNamedNativeQuery.getResultSetMapping());
        ormNamedNativeQuery.setResultSetMapping("foo");
        OrmNamedNativeQueryTests.assertEquals((String)"foo", (String)namedNativeQueryResource.getResultSetMapping());
        OrmNamedNativeQueryTests.assertEquals((String)"foo", (String)ormNamedNativeQuery.getResultSetMapping());
        ormNamedNativeQuery.setResultSetMapping(null);
        OrmNamedNativeQueryTests.assertNull((Object)namedNativeQueryResource.getResultSetMapping());
        OrmNamedNativeQueryTests.assertNull((Object)ormNamedNativeQuery.getResultSetMapping());
    }

    public void testUpdateResultClass() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmNamedNativeQuery ormNamedNativeQuery = ormEntity.addNamedNativeQuery(0);
        XmlNamedNativeQuery namedNativeQueryResource = (XmlNamedNativeQuery)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getNamedNativeQueries().get(0);
        OrmNamedNativeQueryTests.assertEquals(null, (String)namedNativeQueryResource.getResultClass());
        OrmNamedNativeQueryTests.assertEquals(null, (String)ormNamedNativeQuery.getResultClass());
        namedNativeQueryResource.setResultClass("foo");
        OrmNamedNativeQueryTests.assertEquals((String)"foo", (String)namedNativeQueryResource.getResultClass());
        OrmNamedNativeQueryTests.assertEquals((String)"foo", (String)ormNamedNativeQuery.getResultClass());
        namedNativeQueryResource.setResultClass(null);
        OrmNamedNativeQueryTests.assertNull((Object)namedNativeQueryResource.getResultClass());
        OrmNamedNativeQueryTests.assertNull((Object)ormNamedNativeQuery.getResultClass());
    }

    public void testModifyResultClass() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmNamedNativeQuery ormNamedNativeQuery = ormEntity.addNamedNativeQuery(0);
        XmlNamedNativeQuery namedNativeQueryResource = (XmlNamedNativeQuery)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getNamedNativeQueries().get(0);
        OrmNamedNativeQueryTests.assertEquals(null, (String)namedNativeQueryResource.getResultClass());
        OrmNamedNativeQueryTests.assertEquals(null, (String)ormNamedNativeQuery.getResultClass());
        ormNamedNativeQuery.setResultClass("foo");
        OrmNamedNativeQueryTests.assertEquals((String)"foo", (String)namedNativeQueryResource.getResultClass());
        OrmNamedNativeQueryTests.assertEquals((String)"foo", (String)ormNamedNativeQuery.getResultClass());
        ormNamedNativeQuery.setResultClass(null);
        OrmNamedNativeQueryTests.assertNull((Object)namedNativeQueryResource.getResultClass());
        OrmNamedNativeQueryTests.assertNull((Object)ormNamedNativeQuery.getResultClass());
    }
}

