/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.context.IdMapping;
import org.eclipse.jpt.core.context.TableGenerator;
import org.eclipse.jpt.core.context.UniqueConstraint;
import org.eclipse.jpt.core.context.java.JavaUniqueConstraint;
import org.eclipse.jpt.core.context.orm.OrmEntity;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.TableGeneratorAnnotation;
import org.eclipse.jpt.core.resource.java.UniqueConstraintAnnotation;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class JavaTableGeneratorTests
extends ContextModelTestCase {
    private static final String TABLE_GENERATOR_NAME = "MY_TABLE_GENERATOR";

    private ICompilationUnit createTestEntityWithTableGenerator() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.TableGenerator", "javax.persistence.Id"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id").append(CR);
                sb.append("@TableGenerator(name=\"MY_TABLE_GENERATOR\")");
            }
        });
    }

    public JavaTableGeneratorTests(String name) {
        super(name);
    }

    public void testGetName() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        JavaTableGeneratorTests.assertEquals((String)TABLE_GENERATOR_NAME, (String)idMapping.getTableGenerator().getName());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.TableGenerator");
        tableGenerator.setName("foo");
        JavaTableGeneratorTests.assertEquals((String)"foo", (String)idMapping.getTableGenerator().getName());
    }

    public void testSetName() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        JavaTableGeneratorTests.assertEquals((String)TABLE_GENERATOR_NAME, (String)idMapping.getTableGenerator().getName());
        idMapping.getTableGenerator().setName("foo");
        JavaTableGeneratorTests.assertEquals((String)"foo", (String)idMapping.getTableGenerator().getName());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.TableGenerator");
        JavaTableGeneratorTests.assertEquals((String)"foo", (String)tableGenerator.getName());
    }

    public void testSetSpecifiedNameNull() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        JavaTableGeneratorTests.assertEquals((String)TABLE_GENERATOR_NAME, (String)idMapping.getTableGenerator().getName());
        idMapping.getTableGenerator().setName(null);
        JavaTableGeneratorTests.assertNull((Object)idMapping.getTableGenerator());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.TableGenerator");
        JavaTableGeneratorTests.assertNull((Object)tableGenerator);
    }

    public void testGetCatalog() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        JavaTableGeneratorTests.assertNull((Object)idMapping.getTableGenerator().getCatalog());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.TableGenerator");
        tableGenerator.setCatalog("myCatalog");
        JavaTableGeneratorTests.assertEquals((String)"myCatalog", (String)idMapping.getTableGenerator().getCatalog());
        JavaTableGeneratorTests.assertEquals((String)"myCatalog", (String)idMapping.getTableGenerator().getSpecifiedCatalog());
    }

    public void testGetDefaultCatalog() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        JavaTableGeneratorTests.assertNull((Object)idMapping.getTableGenerator().getDefaultCatalog());
        idMapping.getTableGenerator().setSpecifiedCatalog("myCatalog");
        JavaTableGeneratorTests.assertNull((Object)idMapping.getTableGenerator().getDefaultCatalog());
        JavaTableGeneratorTests.assertEquals((String)"myCatalog", (String)idMapping.getTableGenerator().getSpecifiedCatalog());
    }

    public void testSetSpecifiedCatalog() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        idMapping.getTableGenerator().setSpecifiedCatalog("myCatalog");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.TableGenerator");
        JavaTableGeneratorTests.assertEquals((String)"myCatalog", (String)tableGenerator.getCatalog());
        idMapping.getTableGenerator().setName(null);
        idMapping.getTableGenerator().setSpecifiedCatalog(null);
        JavaTableGeneratorTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.TableGenerator"));
    }

    public void testGetSchema() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        JavaTableGeneratorTests.assertNull((Object)idMapping.getTableGenerator().getSchema());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.TableGenerator");
        tableGenerator.setSchema("mySchema");
        JavaTableGeneratorTests.assertEquals((String)"mySchema", (String)idMapping.getTableGenerator().getSchema());
        JavaTableGeneratorTests.assertEquals((String)"mySchema", (String)idMapping.getTableGenerator().getSpecifiedSchema());
    }

    public void testGetDefaultSchema() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        JavaTableGeneratorTests.assertNull((Object)idMapping.getTableGenerator().getDefaultSchema());
        idMapping.getTableGenerator().setSpecifiedSchema("mySchema");
        JavaTableGeneratorTests.assertNull((Object)idMapping.getTableGenerator().getDefaultSchema());
        JavaTableGeneratorTests.assertEquals((String)"mySchema", (String)idMapping.getTableGenerator().getSpecifiedSchema());
    }

    public void testUpdateDefaultSchemaFromPersistenceUnitDefaults() throws Exception {
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.getXmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.createTestEntityWithTableGenerator();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        IdMapping idMapping = (IdMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("id").getMapping();
        JavaTableGeneratorTests.assertNull((Object)idMapping.getTableGenerator().getDefaultSchema());
        this.getEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setSpecifiedSchema("FOO");
        JavaTableGeneratorTests.assertEquals((String)"FOO", (String)idMapping.getTableGenerator().getDefaultSchema());
        this.getEntityMappings().setSpecifiedSchema("BAR");
        JavaTableGeneratorTests.assertEquals((String)"BAR", (String)idMapping.getTableGenerator().getDefaultSchema());
        ormEntity.getTable().setSpecifiedSchema("XML_SCHEMA");
        JavaTableGeneratorTests.assertEquals((String)"BAR", (String)idMapping.getTableGenerator().getDefaultSchema());
        this.getEntityMappings().removePersistentType(0);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaTableGeneratorTests.assertEquals((String)"FOO", (String)((IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping()).getTableGenerator().getDefaultSchema());
    }

    public void testSetSpecifiedSchema() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        idMapping.getTableGenerator().setSpecifiedSchema("mySchema");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.TableGenerator");
        JavaTableGeneratorTests.assertEquals((String)"mySchema", (String)tableGenerator.getSchema());
        idMapping.getTableGenerator().setName(null);
        idMapping.getTableGenerator().setSpecifiedSchema(null);
        JavaTableGeneratorTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.TableGenerator"));
    }

    public void testGetPkColumnName() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        JavaTableGeneratorTests.assertNull((Object)idMapping.getTableGenerator().getPkColumnName());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.TableGenerator");
        tableGenerator.setPkColumnName("myPkColumnName");
        JavaTableGeneratorTests.assertEquals((String)"myPkColumnName", (String)idMapping.getTableGenerator().getPkColumnName());
        JavaTableGeneratorTests.assertEquals((String)"myPkColumnName", (String)idMapping.getTableGenerator().getSpecifiedPkColumnName());
    }

    public void testGetDefaultPkColumnName() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        JavaTableGeneratorTests.assertNull((Object)idMapping.getTableGenerator().getDefaultPkColumnName());
        idMapping.getTableGenerator().setSpecifiedPkColumnName("myPkColumnName");
        JavaTableGeneratorTests.assertNull((Object)idMapping.getTableGenerator().getDefaultPkColumnName());
        JavaTableGeneratorTests.assertEquals((String)"myPkColumnName", (String)idMapping.getTableGenerator().getSpecifiedPkColumnName());
    }

    public void testSetSpecifiedPkColumnName() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        idMapping.getTableGenerator().setSpecifiedPkColumnName("myPkColumnName");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.TableGenerator");
        JavaTableGeneratorTests.assertEquals((String)"myPkColumnName", (String)tableGenerator.getPkColumnName());
        idMapping.getTableGenerator().setName(null);
        idMapping.getTableGenerator().setSpecifiedPkColumnName(null);
        JavaTableGeneratorTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.TableGenerator"));
    }

    public void testGetValueColumnName() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        JavaTableGeneratorTests.assertNull((Object)idMapping.getTableGenerator().getValueColumnName());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.TableGenerator");
        tableGenerator.setValueColumnName("myValueColumnName");
        JavaTableGeneratorTests.assertEquals((String)"myValueColumnName", (String)idMapping.getTableGenerator().getValueColumnName());
        JavaTableGeneratorTests.assertEquals((String)"myValueColumnName", (String)idMapping.getTableGenerator().getSpecifiedValueColumnName());
    }

    public void testGetDefaultValueColumnName() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        JavaTableGeneratorTests.assertNull((Object)idMapping.getTableGenerator().getDefaultValueColumnName());
        idMapping.getTableGenerator().setSpecifiedValueColumnName("myValueColumnName");
        JavaTableGeneratorTests.assertNull((Object)idMapping.getTableGenerator().getDefaultValueColumnName());
        JavaTableGeneratorTests.assertEquals((String)"myValueColumnName", (String)idMapping.getTableGenerator().getSpecifiedValueColumnName());
    }

    public void testSetSpecifiedValueColumnName() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        idMapping.getTableGenerator().setSpecifiedValueColumnName("myValueColumnName");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.TableGenerator");
        JavaTableGeneratorTests.assertEquals((String)"myValueColumnName", (String)tableGenerator.getValueColumnName());
        idMapping.getTableGenerator().setName(null);
        idMapping.getTableGenerator().setSpecifiedValueColumnName(null);
        JavaTableGeneratorTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.TableGenerator"));
    }

    public void testGetPkColumnValue() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        JavaTableGeneratorTests.assertNull((Object)idMapping.getTableGenerator().getPkColumnValue());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.TableGenerator");
        tableGenerator.setPkColumnValue("myPkColumnValue");
        JavaTableGeneratorTests.assertEquals((String)"myPkColumnValue", (String)idMapping.getTableGenerator().getPkColumnValue());
        JavaTableGeneratorTests.assertEquals((String)"myPkColumnValue", (String)idMapping.getTableGenerator().getSpecifiedPkColumnValue());
    }

    public void testGetDefaultPkColumnValue() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        JavaTableGeneratorTests.assertNull((Object)idMapping.getTableGenerator().getDefaultPkColumnValue());
        idMapping.getTableGenerator().setSpecifiedPkColumnValue("myPkColumnValue");
        JavaTableGeneratorTests.assertNull((Object)idMapping.getTableGenerator().getDefaultPkColumnValue());
        JavaTableGeneratorTests.assertEquals((String)"myPkColumnValue", (String)idMapping.getTableGenerator().getSpecifiedPkColumnValue());
    }

    public void testSetSpecifiedPkColumnValue() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        idMapping.getTableGenerator().setSpecifiedPkColumnValue("myPkColumnValue");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.TableGenerator");
        JavaTableGeneratorTests.assertEquals((String)"myPkColumnValue", (String)tableGenerator.getPkColumnValue());
        idMapping.getTableGenerator().setName(null);
        idMapping.getTableGenerator().setSpecifiedPkColumnValue(null);
        JavaTableGeneratorTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.TableGenerator"));
    }

    public void testGetInitialValue() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        JavaTableGeneratorTests.assertEquals((int)0, (int)idMapping.getTableGenerator().getInitialValue());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.TableGenerator");
        tableGenerator.setInitialValue(Integer.valueOf(82));
        JavaTableGeneratorTests.assertEquals((int)82, (int)idMapping.getTableGenerator().getInitialValue());
        JavaTableGeneratorTests.assertEquals((Object)82, (Object)idMapping.getTableGenerator().getSpecifiedInitialValue());
    }

    public void testGetDefaultInitialValue() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        JavaTableGeneratorTests.assertEquals((int)0, (int)idMapping.getTableGenerator().getDefaultInitialValue());
        idMapping.getTableGenerator().setSpecifiedInitialValue(Integer.valueOf(82));
        JavaTableGeneratorTests.assertEquals((int)0, (int)idMapping.getTableGenerator().getDefaultInitialValue());
        JavaTableGeneratorTests.assertEquals((Object)82, (Object)idMapping.getTableGenerator().getSpecifiedInitialValue());
    }

    public void testSetSpecifiedInitialValue() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        idMapping.getTableGenerator().setSpecifiedInitialValue(Integer.valueOf(20));
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.TableGenerator");
        JavaTableGeneratorTests.assertEquals((Object)20, (Object)tableGenerator.getInitialValue());
        idMapping.getTableGenerator().setName(null);
        idMapping.getTableGenerator().setSpecifiedInitialValue(null);
        JavaTableGeneratorTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.TableGenerator"));
    }

    public void testGetAllocationSize() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        JavaTableGeneratorTests.assertEquals((int)50, (int)idMapping.getTableGenerator().getAllocationSize());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.TableGenerator");
        tableGenerator.setAllocationSize(Integer.valueOf(20));
        JavaTableGeneratorTests.assertEquals((int)20, (int)idMapping.getTableGenerator().getAllocationSize());
        JavaTableGeneratorTests.assertEquals((Object)20, (Object)idMapping.getTableGenerator().getSpecifiedAllocationSize());
    }

    public void testGetDefaultAllocationSize() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        JavaTableGeneratorTests.assertEquals((int)50, (int)idMapping.getTableGenerator().getDefaultAllocationSize());
        idMapping.getTableGenerator().setSpecifiedAllocationSize(Integer.valueOf(20));
        JavaTableGeneratorTests.assertEquals((int)50, (int)idMapping.getTableGenerator().getDefaultAllocationSize());
        JavaTableGeneratorTests.assertEquals((Object)20, (Object)idMapping.getTableGenerator().getSpecifiedAllocationSize());
    }

    public void testSetSpecifiedAllocationSize() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        idMapping.getTableGenerator().setSpecifiedAllocationSize(Integer.valueOf(25));
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.TableGenerator");
        JavaTableGeneratorTests.assertEquals((Object)25, (Object)tableGenerator.getAllocationSize());
        idMapping.getTableGenerator().setName(null);
        idMapping.getTableGenerator().setSpecifiedAllocationSize(null);
        JavaTableGeneratorTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.TableGenerator"));
    }

    public void testUniqueConstraints() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        TableGenerator tableGenerator = ((IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping()).getTableGenerator();
        ListIterator uniqueConstraints = tableGenerator.uniqueConstraints();
        JavaTableGeneratorTests.assertFalse((boolean)uniqueConstraints.hasNext());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TableGeneratorAnnotation tableGeneratorAnnotation = (TableGeneratorAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.TableGenerator");
        tableGeneratorAnnotation.addUniqueConstraint(0).addColumnName(0, "foo");
        tableGeneratorAnnotation.addUniqueConstraint(0).addColumnName(0, "bar");
        uniqueConstraints = tableGenerator.uniqueConstraints();
        JavaTableGeneratorTests.assertTrue((boolean)uniqueConstraints.hasNext());
        JavaTableGeneratorTests.assertEquals((String)"bar", (String)((String)((JavaUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaTableGeneratorTests.assertEquals((String)"foo", (String)((String)((JavaUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaTableGeneratorTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testUniqueConstraintsSize() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        TableGenerator tableGenerator = ((IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping()).getTableGenerator();
        JavaTableGeneratorTests.assertEquals((int)0, (int)tableGenerator.uniqueConstraintsSize());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TableGeneratorAnnotation tableGeneratorAnnotation = (TableGeneratorAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.TableGenerator");
        tableGeneratorAnnotation.addUniqueConstraint(0).addColumnName(0, "foo");
        tableGeneratorAnnotation.addUniqueConstraint(1).addColumnName(0, "bar");
        JavaTableGeneratorTests.assertEquals((int)2, (int)tableGenerator.uniqueConstraintsSize());
    }

    public void testAddUniqueConstraint() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        TableGenerator tableGenerator = ((IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping()).getTableGenerator();
        tableGenerator.addUniqueConstraint(0).addColumnName(0, "FOO");
        tableGenerator.addUniqueConstraint(0).addColumnName(0, "BAR");
        tableGenerator.addUniqueConstraint(0).addColumnName(0, "BAZ");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TableGeneratorAnnotation tableGeneratorAnnotation = (TableGeneratorAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.TableGenerator");
        ListIterator uniqueConstraints = tableGeneratorAnnotation.uniqueConstraints();
        JavaTableGeneratorTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNames().next()));
        JavaTableGeneratorTests.assertEquals((String)"BAR", (String)((String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNames().next()));
        JavaTableGeneratorTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNames().next()));
        JavaTableGeneratorTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testAddUniqueConstraint2() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        TableGenerator tableGenerator = ((IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping()).getTableGenerator();
        tableGenerator.addUniqueConstraint(0).addColumnName(0, "FOO");
        tableGenerator.addUniqueConstraint(1).addColumnName(0, "BAR");
        tableGenerator.addUniqueConstraint(0).addColumnName(0, "BAZ");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TableGeneratorAnnotation tableGeneratorAnnotation = (TableGeneratorAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.TableGenerator");
        ListIterator uniqueConstraints = tableGeneratorAnnotation.uniqueConstraints();
        JavaTableGeneratorTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNames().next()));
        JavaTableGeneratorTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNames().next()));
        JavaTableGeneratorTests.assertEquals((String)"BAR", (String)((String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNames().next()));
        JavaTableGeneratorTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testRemoveUniqueConstraint() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        TableGenerator tableGenerator = ((IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping()).getTableGenerator();
        tableGenerator.addUniqueConstraint(0).addColumnName(0, "FOO");
        tableGenerator.addUniqueConstraint(1).addColumnName(0, "BAR");
        tableGenerator.addUniqueConstraint(2).addColumnName(0, "BAZ");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TableGeneratorAnnotation tableGeneratorAnnotation = (TableGeneratorAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.TableGenerator");
        JavaTableGeneratorTests.assertEquals((int)3, (int)tableGeneratorAnnotation.uniqueConstraintsSize());
        tableGenerator.removeUniqueConstraint(1);
        ListIterator uniqueConstraintAnnotations = tableGeneratorAnnotation.uniqueConstraints();
        JavaTableGeneratorTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNames().next()));
        JavaTableGeneratorTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNames().next()));
        JavaTableGeneratorTests.assertFalse((boolean)uniqueConstraintAnnotations.hasNext());
        ListIterator uniqueConstraints = tableGenerator.uniqueConstraints();
        JavaTableGeneratorTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaTableGeneratorTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaTableGeneratorTests.assertFalse((boolean)uniqueConstraints.hasNext());
        tableGenerator.removeUniqueConstraint(1);
        uniqueConstraintAnnotations = tableGeneratorAnnotation.uniqueConstraints();
        JavaTableGeneratorTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNames().next()));
        JavaTableGeneratorTests.assertFalse((boolean)uniqueConstraintAnnotations.hasNext());
        uniqueConstraints = tableGenerator.uniqueConstraints();
        JavaTableGeneratorTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaTableGeneratorTests.assertFalse((boolean)uniqueConstraints.hasNext());
        tableGenerator.removeUniqueConstraint(0);
        uniqueConstraintAnnotations = tableGeneratorAnnotation.uniqueConstraints();
        JavaTableGeneratorTests.assertFalse((boolean)uniqueConstraintAnnotations.hasNext());
        uniqueConstraints = tableGenerator.uniqueConstraints();
        JavaTableGeneratorTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testMoveUniqueConstraint() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        TableGenerator tableGenerator = ((IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping()).getTableGenerator();
        tableGenerator.addUniqueConstraint(0).addColumnName(0, "FOO");
        tableGenerator.addUniqueConstraint(1).addColumnName(0, "BAR");
        tableGenerator.addUniqueConstraint(2).addColumnName(0, "BAZ");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TableGeneratorAnnotation tableGeneratorAnnotation = (TableGeneratorAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.TableGenerator");
        JavaTableGeneratorTests.assertEquals((int)3, (int)tableGeneratorAnnotation.uniqueConstraintsSize());
        tableGenerator.moveUniqueConstraint(2, 0);
        ListIterator uniqueConstraints = tableGenerator.uniqueConstraints();
        JavaTableGeneratorTests.assertEquals((String)"BAR", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaTableGeneratorTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaTableGeneratorTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        ListIterator uniqueConstraintAnnotations = tableGeneratorAnnotation.uniqueConstraints();
        JavaTableGeneratorTests.assertEquals((String)"BAR", (String)((String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNames().next()));
        JavaTableGeneratorTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNames().next()));
        JavaTableGeneratorTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNames().next()));
        tableGenerator.moveUniqueConstraint(0, 1);
        uniqueConstraints = tableGenerator.uniqueConstraints();
        JavaTableGeneratorTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaTableGeneratorTests.assertEquals((String)"BAR", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaTableGeneratorTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        uniqueConstraintAnnotations = tableGeneratorAnnotation.uniqueConstraints();
        JavaTableGeneratorTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNames().next()));
        JavaTableGeneratorTests.assertEquals((String)"BAR", (String)((String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNames().next()));
        JavaTableGeneratorTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNames().next()));
    }

    public void testUpdateUniqueConstraints() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        TableGenerator tableGenerator = ((IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping()).getTableGenerator();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TableGeneratorAnnotation tableGeneratorAnnotation = (TableGeneratorAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.TableGenerator");
        tableGeneratorAnnotation.addUniqueConstraint(0).addColumnName("FOO");
        tableGeneratorAnnotation.addUniqueConstraint(1).addColumnName("BAR");
        tableGeneratorAnnotation.addUniqueConstraint(2).addColumnName("BAZ");
        ListIterator uniqueConstraints = tableGenerator.uniqueConstraints();
        JavaTableGeneratorTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaTableGeneratorTests.assertEquals((String)"BAR", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaTableGeneratorTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaTableGeneratorTests.assertFalse((boolean)uniqueConstraints.hasNext());
        tableGeneratorAnnotation.moveUniqueConstraint(2, 0);
        uniqueConstraints = tableGenerator.uniqueConstraints();
        JavaTableGeneratorTests.assertEquals((String)"BAR", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaTableGeneratorTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaTableGeneratorTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaTableGeneratorTests.assertFalse((boolean)uniqueConstraints.hasNext());
        tableGeneratorAnnotation.moveUniqueConstraint(0, 1);
        uniqueConstraints = tableGenerator.uniqueConstraints();
        JavaTableGeneratorTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaTableGeneratorTests.assertEquals((String)"BAR", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaTableGeneratorTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaTableGeneratorTests.assertFalse((boolean)uniqueConstraints.hasNext());
        tableGeneratorAnnotation.removeUniqueConstraint(1);
        uniqueConstraints = tableGenerator.uniqueConstraints();
        JavaTableGeneratorTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaTableGeneratorTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaTableGeneratorTests.assertFalse((boolean)uniqueConstraints.hasNext());
        tableGeneratorAnnotation.removeUniqueConstraint(1);
        uniqueConstraints = tableGenerator.uniqueConstraints();
        JavaTableGeneratorTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        JavaTableGeneratorTests.assertFalse((boolean)uniqueConstraints.hasNext());
        tableGeneratorAnnotation.removeUniqueConstraint(0);
        uniqueConstraints = tableGenerator.uniqueConstraints();
        JavaTableGeneratorTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }
}

