/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context;

import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.internal.resource.orm.OrmXmlResourceProvider;
import org.eclipse.jpt.core.internal.resource.persistence.PersistenceXmlResourceProvider;
import org.eclipse.jpt.core.resource.xml.JpaXmlResource;
import org.eclipse.jpt.core.tests.internal.projects.TestJpaProject;

public class JpaProjectTests
extends TestCase {
    static final String BASE_PROJECT_NAME = JpaProjectTests.class.getSimpleName();
    TestJpaProject jpaProject;

    public JpaProjectTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.jpaProject = TestJpaProject.buildJpaProject(BASE_PROJECT_NAME, false);
    }

    protected void tearDown() throws Exception {
        this.jpaProject.getProject().delete(true, true, null);
        this.jpaProject = null;
        super.tearDown();
    }

    protected JpaProject getJpaProject() {
        return this.jpaProject.getJpaProject();
    }

    public void testGetPersistenceXmlResource() throws Exception {
        JpaXmlResource resource = this.getJpaProject().getPersistenceXmlResource();
        JpaProjectTests.assertNotNull((Object)resource);
        JpaProjectTests.assertEquals((Object)JptCorePlugin.PERSISTENCE_XML_CONTENT_TYPE, (Object)resource.getContentType());
        JpaProjectTests.assertEquals((String)"src/META-INF/persistence.xml", (String)resource.getFile().getProjectRelativePath().toString());
        resource.delete(null);
        resource = this.getJpaProject().getPersistenceXmlResource();
        JpaProjectTests.assertNull((Object)resource);
        this.createPersistenceXmlFile();
        resource = this.getJpaProject().getPersistenceXmlResource();
        JpaProjectTests.assertNotNull((Object)resource);
        JpaProjectTests.assertEquals((Object)JptCorePlugin.PERSISTENCE_XML_CONTENT_TYPE, (Object)resource.getContentType());
        JpaProjectTests.assertEquals((String)"src/META-INF/persistence.xml", (String)resource.getFile().getProjectRelativePath().toString());
    }

    private void createPersistenceXmlFile() throws Exception {
        PersistenceXmlResourceProvider resourceProvider = PersistenceXmlResourceProvider.getDefaultXmlResourceProvider((IProject)this.jpaProject.getProject());
        resourceProvider.createFileAndResource();
    }

    public void testGetDefaultOrmXmlResource() throws Exception {
        JpaXmlResource resource = this.getJpaProject().getDefaultOrmXmlResource();
        JpaProjectTests.assertNotNull((Object)resource);
        JpaProjectTests.assertEquals((Object)JptCorePlugin.ORM_XML_CONTENT_TYPE, (Object)resource.getContentType());
        JpaProjectTests.assertEquals((String)"src/META-INF/orm.xml", (String)resource.getFile().getProjectRelativePath().toString());
        resource.delete(null);
        resource = this.getJpaProject().getDefaultOrmXmlResource();
        JpaProjectTests.assertNull((Object)resource);
        this.createDefaultOrmXmlFile();
        resource = this.getJpaProject().getDefaultOrmXmlResource();
        JpaProjectTests.assertNotNull((Object)resource);
        JpaProjectTests.assertEquals((Object)JptCorePlugin.ORM_XML_CONTENT_TYPE, (Object)resource.getContentType());
        JpaProjectTests.assertEquals((String)"src/META-INF/orm.xml", (String)resource.getFile().getProjectRelativePath().toString());
    }

    private void createDefaultOrmXmlFile() throws Exception {
        OrmXmlResourceProvider resourceProvider = OrmXmlResourceProvider.getDefaultXmlResourceProvider((IProject)this.jpaProject.getProject());
        resourceProvider.createFileAndResource();
    }

    private void createOrmXmlFile(String filePath) throws Exception {
        OrmXmlResourceProvider resourceProvider = OrmXmlResourceProvider.getXmlResourceProvider((IProject)this.jpaProject.getProject(), (String)filePath);
        resourceProvider.createFileAndResource();
    }

    public void testGetMappingFileResource() throws Exception {
        JpaXmlResource resource = this.getJpaProject().getMappingFileXmlResource("META-INF/orm.xml");
        JpaProjectTests.assertNotNull((Object)resource);
        JpaProjectTests.assertEquals((Object)JptCorePlugin.ORM_XML_CONTENT_TYPE, (Object)resource.getContentType());
        JpaProjectTests.assertEquals((String)"src/META-INF/orm.xml", (String)resource.getFile().getProjectRelativePath().toString());
        resource.delete(null);
        resource = this.getJpaProject().getMappingFileXmlResource("META-INF/orm.xml");
        JpaProjectTests.assertNull((Object)resource);
        this.createDefaultOrmXmlFile();
        resource = this.getJpaProject().getMappingFileXmlResource("META-INF/orm.xml");
        JpaProjectTests.assertNotNull((Object)resource);
        JpaProjectTests.assertEquals((Object)JptCorePlugin.ORM_XML_CONTENT_TYPE, (Object)resource.getContentType());
        JpaProjectTests.assertEquals((String)"src/META-INF/orm.xml", (String)resource.getFile().getProjectRelativePath().toString());
    }

    public void testGetMappingFileResourceDifferentlyName() throws Exception {
        JpaXmlResource resource = this.getJpaProject().getMappingFileXmlResource("META-INF/orm2.xml");
        JpaProjectTests.assertNull((Object)resource);
        this.createOrmXmlFile("META-INF/orm2.xml");
        resource = this.getJpaProject().getMappingFileXmlResource("META-INF/orm2.xml");
        JpaProjectTests.assertNotNull((Object)resource);
        JpaProjectTests.assertEquals((Object)JptCorePlugin.ORM_XML_CONTENT_TYPE, (Object)resource.getContentType());
        JpaProjectTests.assertEquals((String)"src/META-INF/orm2.xml", (String)resource.getFile().getProjectRelativePath().toString());
        resource.delete(null);
        resource = this.getJpaProject().getMappingFileXmlResource("META-INF/orm2.xml");
        JpaProjectTests.assertNull((Object)resource);
        this.createOrmXmlFile("META-INF/orm2.xml");
        resource = this.getJpaProject().getMappingFileXmlResource("META-INF/orm2.xml");
        JpaProjectTests.assertNotNull((Object)resource);
        JpaProjectTests.assertEquals((Object)JptCorePlugin.ORM_XML_CONTENT_TYPE, (Object)resource.getContentType());
        JpaProjectTests.assertEquals((String)"src/META-INF/orm2.xml", (String)resource.getFile().getProjectRelativePath().toString());
    }
}

