/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.initParser;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.jem.internal.proxy.initParser.EvaluationException;
import org.eclipse.jem.internal.proxy.initParser.Expression;
import org.eclipse.jem.internal.proxy.initParser.IParserConstants;
import org.eclipse.jem.internal.proxy.initParser.InitializationStringEvaluationException;
import org.eclipse.jem.internal.proxy.initParser.Statement;

public class InitializationStringParser
implements IParserConstants {
    protected ClassLoader fClassLoader;
    protected boolean isComplete = false;
    protected String fInitString;
    protected int fSourceLength;
    protected char[] fSource;
    protected int fSourcePosition = -1;
    private char[] fCurrentToken;
    private char fCurrentTokenDelimiter = '\u0000';
    protected ArrayList fExpressionStack = new ArrayList(4);
    protected Expression fExpression;

    public InitializationStringParser(String initString) {
        this.fInitString = initString;
        this.fSource = initString.toCharArray();
        this.fSourceLength = this.fSource.length;
    }

    protected void createNextToken() {
        this.fCurrentTokenDelimiter = '\u0000';
        if (this.fSourcePosition >= this.fSourceLength - 1) {
            this.isComplete = true;
            return;
        }
        ++this.fSourcePosition;
        char[] fCurrentTokenSource = new char[this.fSourceLength];
        int i = 0;
        block20: while (this.fSourcePosition < this.fSourceLength) {
            switch (this.fSource[this.fSourcePosition]) {
                case '.': {
                    this.fCurrentTokenDelimiter = (char)46;
                    break block20;
                }
                case '(': {
                    this.fCurrentTokenDelimiter = (char)40;
                    break block20;
                }
                case ')': {
                    this.fCurrentTokenDelimiter = (char)41;
                    break block20;
                }
                case ',': {
                    this.fCurrentTokenDelimiter = (char)44;
                    break block20;
                }
                case ' ': {
                    this.fCurrentTokenDelimiter = (char)32;
                    break block20;
                }
                case '\"': {
                    this.fCurrentTokenDelimiter = (char)34;
                    break block20;
                }
                case '\'': {
                    this.fCurrentTokenDelimiter = (char)39;
                    break block20;
                }
                case '\\': {
                    this.fCurrentTokenDelimiter = (char)92;
                    break block20;
                }
                case '{': {
                    this.fCurrentTokenDelimiter = (char)123;
                    break block20;
                }
                case '[': {
                    this.fCurrentTokenDelimiter = (char)91;
                    break block20;
                }
                case ']': {
                    this.fCurrentTokenDelimiter = (char)93;
                    break block20;
                }
                case '}': {
                    this.fCurrentTokenDelimiter = (char)125;
                    break block20;
                }
                case '+': {
                    this.fCurrentTokenDelimiter = (char)43;
                    break block20;
                }
                case '-': {
                    this.fCurrentTokenDelimiter = (char)45;
                    break block20;
                }
                case '*': {
                    this.fCurrentTokenDelimiter = (char)42;
                    break block20;
                }
                case '/': {
                    this.fCurrentTokenDelimiter = (char)47;
                    break block20;
                }
                case '|': {
                    this.fCurrentTokenDelimiter = (char)124;
                    break block20;
                }
                case '&': {
                    this.fCurrentTokenDelimiter = (char)38;
                    break block20;
                }
                default: {
                    fCurrentTokenSource[i] = this.fSource[this.fSourcePosition];
                    ++this.fSourcePosition;
                    ++i;
                }
            }
        }
        if (i >= 1) {
            this.fCurrentToken = new char[i];
            System.arraycopy(fCurrentTokenSource, 0, this.fCurrentToken, 0, i);
        } else {
            this.fCurrentToken = new char[0];
        }
    }

    public Object evaluate() throws InitializationStringEvaluationException {
        try {
            return this.fExpression.evaluate();
        }
        catch (InvocationTargetException e) {
            throw new EvaluationException(e);
        }
        catch (EvaluationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InitializationStringEvaluationException(e);
        }
    }

    public static Object evaluate(String initString) throws InitializationStringEvaluationException {
        return InitializationStringParser.evaluate(initString, null);
    }

    public static Object evaluate(String initString, ClassLoader aClassLoader) throws InitializationStringEvaluationException {
        InitializationStringParser parser = null;
        try {
            parser = new InitializationStringParser(initString);
            parser.setClassLoader(aClassLoader);
            parser.parse();
        }
        catch (Throwable exc) {
            throw new InitializationStringEvaluationException(exc);
        }
        return parser.evaluate();
    }

    public static InitializationStringParser createParser(String initString) throws InitializationStringEvaluationException {
        return InitializationStringParser.createParser(initString, null);
    }

    public static InitializationStringParser createParser(String initString, ClassLoader classLoader) throws InitializationStringEvaluationException {
        try {
            InitializationStringParser parser = new InitializationStringParser(initString);
            parser.setClassLoader(classLoader);
            parser.parse();
            return parser;
        }
        catch (Throwable exc) {
            throw new InitializationStringEvaluationException(exc);
        }
    }

    public void parse() {
        this.createFirstExpression();
        int i = 1;
        while (true) {
            this.createNextToken();
            if (this.isComplete) {
                return;
            }
            ++i;
            Expression result = this.fExpression.push(this.fCurrentToken, this.fCurrentTokenDelimiter);
            if (result.isComplete()) {
                this.popExpressionStack();
                continue;
            }
            if (result == this.fExpression) continue;
            this.pushExpressionStack(result);
        }
    }

    public boolean isPrimitive() throws InitializationStringEvaluationException {
        try {
            return this.fExpression.isPrimitive();
        }
        catch (Exception e) {
            throw new InitializationStringEvaluationException(e);
        }
    }

    public Class getExpectedType() throws InitializationStringEvaluationException {
        try {
            return this.fExpression.getTypeClass();
        }
        catch (Exception e) {
            throw new InitializationStringEvaluationException(e);
        }
    }

    protected void popExpressionStack() {
        if (this.fExpressionStack.size() > 0) {
            this.fExpression = (Expression)this.fExpressionStack.remove(this.fExpressionStack.size() - 1);
        }
    }

    protected void pushExpressionStack(Expression anExpression) {
        this.fExpressionStack.add(this.fExpression);
        this.fExpression = anExpression;
    }

    protected void createFirstExpression() {
        if (this.fExpression == null) {
            this.fExpression = new Statement(this.fClassLoader);
        }
    }

    public void setClassLoader(ClassLoader aClassLoader) {
        this.fClassLoader = aClassLoader;
    }

    public String toString() {
        StringBuffer writer = new StringBuffer();
        writer.append("Parser. token=\"");
        if (this.fCurrentToken != null) {
            writer.append(this.fCurrentToken);
        }
        writer.append("\", delim=\"");
        writer.append(this.fCurrentTokenDelimiter);
        writer.append("\", initString=\"");
        writer.append(this.fInitString);
        return writer.toString();
    }
}

