/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.editor.datatype.internal.validation;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.eclipse.vorto.core.api.model.datatype.Constraint;
import org.eclipse.vorto.core.api.model.datatype.PrimitiveType;
import org.eclipse.vorto.editor.datatype.internal.validation.ConstraintValueValidator;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class AccordinglyValueValidator
extends ConstraintValueValidator {
    @Override
    public boolean evaluateValueType(PrimitiveType type, Constraint constraint) {
        boolean _xblockexpression;
        block50: {
            _xblockexpression = false;
            String rawValue = constraint.getConstraintValues();
            String typeStr = type.getLiteral();
            if (typeStr == null) break block50;
            switch (typeStr) {
                case "int": {
                    try {
                        Integer.parseInt(rawValue);
                        break;
                    }
                    catch (Throwable _t) {
                        if (_t instanceof NumberFormatException) {
                            this.setErrorMessage("This constraint value must be of an Integer");
                            return false;
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                }
                case "long": {
                    try {
                        Long.parseLong(rawValue);
                        break;
                    }
                    catch (Throwable _t_1) {
                        if (_t_1 instanceof NumberFormatException) {
                            this.setErrorMessage("This constraint value must be of a Long");
                            return false;
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t_1);
                    }
                }
                case "boolean": {
                    if (rawValue.equalsIgnoreCase("\"true\"") || rawValue.equalsIgnoreCase("\"false\"")) {
                        return true;
                    }
                    this.setErrorMessage("This constraint value must be of a Short");
                    return false;
                }
                case "short": {
                    try {
                        Short.parseShort(rawValue);
                        break;
                    }
                    catch (Throwable _t_2) {
                        if (_t_2 instanceof NumberFormatException) {
                            this.setErrorMessage("This constraint value must be of a Short");
                            return false;
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t_2);
                    }
                }
                case "double": {
                    try {
                        Double.parseDouble(rawValue);
                        break;
                    }
                    catch (Throwable _t_3) {
                        if (_t_3 instanceof NumberFormatException) {
                            this.setErrorMessage("This constraint value must be of a Double");
                            return false;
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t_3);
                    }
                }
                case "float": {
                    try {
                        Float.parseFloat(rawValue);
                        break;
                    }
                    catch (Throwable _t_4) {
                        if (_t_4 instanceof NumberFormatException) {
                            this.setErrorMessage("This constraint value must be of a Float");
                            return false;
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t_4);
                    }
                }
                case "dateTime": {
                    try {
                        new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX").parse(rawValue);
                        break;
                    }
                    catch (Throwable _t_5) {
                        if (_t_5 instanceof ParseException) {
                            this.setErrorMessage("Value expected should be in ISO 8196 Date Format e.g: 2002-05-30T09:30:10+06:00");
                            return false;
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t_5);
                    }
                }
                case "byte": {
                    try {
                        Byte.parseByte(rawValue);
                        break;
                    }
                    catch (Throwable _t_6) {
                        if (_t_6 instanceof NumberFormatException) {
                            this.setErrorMessage("This constraint value must be of a Byte");
                            return false;
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t_6);
                    }
                }
            }
        }
        _xblockexpression = true;
        return _xblockexpression;
    }
}

