/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.shell.internal;

import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintStream;
import org.eclipse.virgo.medic.log.DelegatingPrintStream;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public final class LocalInputOutputManager {
    private static final String SERVICE_FILTER_SYSERR_DELEGATE = "(org.eclipse.virgo.medic.log.printStream=delegating.System.err)";
    private static final String SERVICE_FILTER_SYSOUT_DELEGATE = "(org.eclipse.virgo.medic.log.printStream=delegating.System.out)";
    private final InputStream in = new FileInputStream(FileDescriptor.in);
    private final PrintStream out;
    private final PrintStream err;
    private final DelegatingPrintStream delegatingSysOut;
    private final DelegatingPrintStream delegatingSysErr;

    public LocalInputOutputManager(BundleContext bundleContext) {
        this.out = LocalInputOutputManager.getPrintStreamFromServiceRegistry(bundleContext, "(org.eclipse.virgo.medic.log.printStream=System.out)");
        this.err = LocalInputOutputManager.getPrintStreamFromServiceRegistry(bundleContext, "(org.eclipse.virgo.medic.log.printStream=System.err)");
        this.delegatingSysOut = LocalInputOutputManager.getDelegatingPrintStreamFromServiceRegistry(bundleContext, SERVICE_FILTER_SYSOUT_DELEGATE);
        this.delegatingSysErr = LocalInputOutputManager.getDelegatingPrintStreamFromServiceRegistry(bundleContext, SERVICE_FILTER_SYSERR_DELEGATE);
    }

    public void grabSystemIO() {
        this.delegatingSysOut.setDelegate(null);
        this.delegatingSysErr.setDelegate(null);
    }

    public void releaseSystemIO() {
        this.delegatingSysOut.setDelegate(this.out);
        this.delegatingSysErr.setDelegate(this.err);
    }

    public PrintStream getErr() {
        return this.err;
    }

    public PrintStream getOut() {
        return this.out;
    }

    public InputStream getIn() {
        return this.in;
    }

    private static PrintStream getPrintStreamFromServiceRegistry(BundleContext bundleContext, String filter) {
        return (PrintStream)LocalInputOutputManager.getService(PrintStream.class, bundleContext, filter);
    }

    private static DelegatingPrintStream getDelegatingPrintStreamFromServiceRegistry(BundleContext bundleContext, String filter) {
        return (DelegatingPrintStream)LocalInputOutputManager.getService(DelegatingPrintStream.class, bundleContext, filter);
    }

    private static Object getService(Class<?> clazz, BundleContext bundleContext, String filter) {
        ServiceReference[] serviceReferences;
        try {
            serviceReferences = bundleContext.getServiceReferences(clazz.getName(), filter);
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException("Unexpected InvalidSyntaxException", e);
        }
        if (serviceReferences != null && serviceReferences.length > 0) {
            return bundleContext.getService(serviceReferences[0]);
        }
        return null;
    }
}

