/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.model.internal.configurationadmin;

import java.io.IOException;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.eclipse.equinox.region.Region;
import org.eclipse.virgo.kernel.model.RuntimeArtifactRepository;
import org.eclipse.virgo.kernel.model.internal.configurationadmin.ConfigurationArtifact;
import org.eclipse.virgo.kernel.model.internal.configurationadmin.ModelConfigurationListener;
import org.eclipse.virgo.nano.serviceability.NonNull;
import org.eclipse.virgo.nano.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.nano.serviceability.enforcement.NonNullAssertionEnforcer;
import org.eclipse.virgo.util.osgi.ServiceRegistrationTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ModelConfigurationListenerInitializer {
    private final Logger logger;
    private final ServiceRegistrationTracker registrationTracker;
    private final RuntimeArtifactRepository artifactRepository;
    private final BundleContext bundleContext;
    private final ConfigurationAdmin configurationAdmin;
    private final Region globalRegion;

    public ModelConfigurationListenerInitializer(@NonNull RuntimeArtifactRepository artifactRepository, @NonNull BundleContext bundleContext, @NonNull ConfigurationAdmin configurationAdmin, @NonNull Region globalRegion) {
        Region region = globalRegion;
        ConfigurationAdmin configurationAdmin2 = configurationAdmin;
        BundleContext bundleContext2 = bundleContext;
        RuntimeArtifactRepository runtimeArtifactRepository = artifactRepository;
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$1$7118cd8((Object)runtimeArtifactRepository);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$2$ea5bfc82((Object)bundleContext2);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$3$438bd8c1((Object)configurationAdmin2);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$4$c122b91c((Object)region);
        try {
            this.logger = LoggerFactory.getLogger(this.getClass());
            this.registrationTracker = new ServiceRegistrationTracker();
            this.artifactRepository = artifactRepository;
            this.bundleContext = bundleContext;
            this.configurationAdmin = configurationAdmin;
            this.globalRegion = globalRegion;
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @PostConstruct
    public void initialize() throws IOException, InvalidSyntaxException {
        try {
            ModelConfigurationListener configurationListener = new ModelConfigurationListener(this.artifactRepository, this.bundleContext, this.configurationAdmin, this.globalRegion);
            this.registrationTracker.track(this.bundleContext.registerService(ConfigurationListener.class.getCanonicalName(), (Object)configurationListener, null));
            Configuration[] configurations = this.configurationAdmin.listConfigurations(null);
            if (configurations != null) {
                Configuration[] configurationArray = configurations;
                int n = configurations.length;
                int n2 = 0;
                while (n2 < n) {
                    Configuration configuration = configurationArray[n2];
                    try {
                        this.artifactRepository.add(new ConfigurationArtifact(this.bundleContext, this.configurationAdmin, configuration.getPid(), this.globalRegion));
                    }
                    catch (Exception e) {
                        this.logger.error(String.format("Exception adding configuration '%s' to the repository", configuration.getPid()), (Throwable)e);
                    }
                    ++n2;
                }
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @PreDestroy
    public void destroy() {
        try {
            this.registrationTracker.unregisterAll();
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }
}

