/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.shell.internal;

import java.io.IOException;
import java.util.List;
import org.eclipse.virgo.shell.CommandExecutor;
import org.eclipse.virgo.shell.LinePrinter;
import org.eclipse.virgo.shell.internal.CommandSession;

public class SessionCommandExecutor
implements CommandExecutor {
    private static final String EXIT_COMMAND = "exit";
    private final CommandSession commandSession;

    SessionCommandExecutor(CommandSession commandSession) {
        this.commandSession = commandSession;
    }

    @Override
    public boolean execute(String commandLine, LinePrinter linePrinter) throws IOException {
        if (commandLine != null && (commandLine = commandLine.trim()).length() > 0) {
            if (EXIT_COMMAND.equalsIgnoreCase(commandLine)) {
                return false;
            }
            try {
                List<String> executionResult = this.commandSession.execute(commandLine);
                if (executionResult == null) {
                    linePrinter.println(String.format("Null result returned for '%s'", commandLine));
                } else {
                    SessionCommandExecutor.printList(linePrinter, executionResult);
                }
            }
            catch (Exception e) {
                linePrinter.println(String.format("%s while executing command '%s': '%s'", e.getClass().getName(), commandLine, e.getMessage()));
            }
        }
        return true;
    }

    private static void printList(LinePrinter linePrinter, List<String> executionResult) throws IOException {
        linePrinter.println();
        for (String line : executionResult) {
            linePrinter.println(line);
        }
    }
}

