/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.install.artifact.internal.bundle;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.virgo.kernel.artifact.fs.ArtifactFSEntry;
import org.eclipse.virgo.kernel.deployer.core.internal.BlockingAbortableSignal;
import org.eclipse.virgo.kernel.install.artifact.ArtifactIdentity;
import org.eclipse.virgo.kernel.install.artifact.ArtifactIdentityDeterminer;
import org.eclipse.virgo.kernel.install.artifact.ArtifactStorage;
import org.eclipse.virgo.kernel.install.artifact.BundleInstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.PlanInstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.internal.AbstractInstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.internal.ArtifactStateMonitor;
import org.eclipse.virgo.kernel.install.artifact.internal.InstallArtifactRefreshHandler;
import org.eclipse.virgo.kernel.install.artifact.internal.bundle.BundleDriver;
import org.eclipse.virgo.kernel.install.artifact.internal.scoping.ArtifactIdentityScoper;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiBundle;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.nano.core.AbortableSignal;
import org.eclipse.virgo.nano.deployer.api.core.DeployerLogEvents;
import org.eclipse.virgo.nano.deployer.api.core.DeploymentException;
import org.eclipse.virgo.nano.serviceability.NonNull;
import org.eclipse.virgo.util.common.GraphNode;
import org.eclipse.virgo.util.io.FileCopyUtils;
import org.eclipse.virgo.util.io.IOUtils;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;
import org.eclipse.virgo.util.osgi.manifest.BundleManifestFactory;
import org.eclipse.virgo.util.osgi.manifest.BundleSymbolicName;
import org.eclipse.virgo.util.osgi.manifest.ExportedPackage;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class StandardBundleInstallArtifact
extends AbstractInstallArtifact
implements BundleInstallArtifact {
    private static final String DEFAULTED_BSN = "org-eclipse-virgo-kernel-DefaultedBSN";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String MANIFEST_ENTRY_NAME = "META-INF/MANIFEST.MF";
    private static final String EQUINOX_SYSTEM_BUNDLE_NAME = "org.eclipse.osgi";
    private static final String RESERVED_SYSTEM_BUNDLE_NAME = "system.bundle";
    private static final long REFRESH_RESTART_WAIT_PERIOD = 60L;
    private final Object monitor = new Object();
    private final ArtifactStorage artifactStorage;
    private final BundleDriver bundleDriver;
    private final InstallArtifactRefreshHandler refreshHandler;
    private final ArtifactIdentityDeterminer identityDeterminer;
    private BundleManifest bundleManifest;
    private QuasiBundle quasiBundle;
    private Bundle cachedBundle;
    private File cachedBundleFile;

    public StandardBundleInstallArtifact(@NonNull ArtifactIdentity artifactIdentifier, @NonNull BundleManifest bundleManifest, @NonNull ArtifactStorage artifactStorage, @NonNull BundleDriver bundleDriver, @NonNull ArtifactStateMonitor artifactStateMonitor, @NonNull InstallArtifactRefreshHandler refreshHandler, String repositoryName, EventLogger eventLogger, ArtifactIdentityDeterminer identityDeterminer) {
        super(artifactIdentifier, artifactStorage, artifactStateMonitor, repositoryName, eventLogger);
        this.artifactStorage = artifactStorage;
        this.bundleManifest = bundleManifest;
        this.bundleDriver = bundleDriver;
        this.refreshHandler = refreshHandler;
        this.identityDeterminer = identityDeterminer;
        this.synchronizeBundleSymbolicNameWithIdentity();
    }

    private void synchronizeBundleSymbolicNameWithIdentity() {
        BundleManifest bundleManifest = this.bundleManifest;
        BundleSymbolicName bundleSymbolicName = bundleManifest.getBundleSymbolicName();
        if (!this.getName().equals(bundleSymbolicName.getSymbolicName())) {
            bundleSymbolicName.setSymbolicName(this.getName());
            bundleManifest.setHeader(DEFAULTED_BSN, "true");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BundleManifest getBundleManifest() throws IOException {
        Object object = this.monitor;
        synchronized (object) {
            if (this.bundleManifest == null) {
                this.bundleManifest = this.getManifestFromArtifactFS();
            }
            return this.bundleManifest;
        }
    }

    private BundleManifest getManifestFromArtifactFS() throws IOException {
        ArtifactFSEntry manifestEntry = this.artifactStorage.getArtifactFS().getEntry(MANIFEST_ENTRY_NAME);
        if (manifestEntry != null && manifestEntry.exists()) {
            Throwable throwable = null;
            Object var3_4 = null;
            try (InputStreamReader manifestReader = new InputStreamReader(manifestEntry.getInputStream(), StandardCharsets.UTF_8);){
                return BundleManifestFactory.createBundleManifest((Reader)manifestReader);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return BundleManifestFactory.createBundleManifest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QuasiBundle getQuasiBundle() {
        Object object = this.monitor;
        synchronized (object) {
            return this.quasiBundle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setQuasiBundle(QuasiBundle quasiBundle) {
        Object object = this.monitor;
        synchronized (object) {
            this.quasiBundle = quasiBundle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bundle getBundle() {
        Object object = this.monitor;
        synchronized (object) {
            return this.quasiBundle == null ? this.cachedBundle : this.quasiBundle.getBundle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getBundleFile() {
        Object object = this.monitor;
        synchronized (object) {
            return this.quasiBundle == null ? this.cachedBundleFile : this.quasiBundle.getBundleFile();
        }
    }

    @Override
    public InstallArtifact.State getState() {
        this.monitorBundle();
        InstallArtifact.State state = super.getState();
        return this.isFragment() && (state == InstallArtifact.State.STARTING || state == InstallArtifact.State.ACTIVE || state == InstallArtifact.State.STOPPING) ? InstallArtifact.State.RESOLVED : state;
    }

    @Override
    public void endInstall() throws DeploymentException {
        this.monitorBundle();
        super.endInstall();
        this.cacheAndDelete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void monitorBundle() {
        Object object = this.monitor;
        synchronized (object) {
            Bundle bundle = this.getBundle();
            if (bundle != null) {
                this.bundleDriver.setBundle(bundle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheAndDelete() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.quasiBundle == null) {
                return;
            }
            this.cachedBundle = this.quasiBundle.getBundle();
            this.cachedBundleFile = this.quasiBundle.getBundleFile();
            this.quasiBundle = null;
        }
    }

    @Override
    public void pushThreadContext() {
        this.bundleDriver.pushThreadContext();
    }

    @Override
    public void popThreadContext() {
        this.bundleDriver.popThreadContext();
    }

    void trackStart() {
        AbortableSignal signal = this.createStateMonitorSignal(null);
        this.bundleDriver.trackStart(signal);
    }

    @Override
    public void beginInstall() throws DeploymentException {
        if (this.isFragmentOnSystemBundle()) {
            throw new DeploymentException("Deploying fragments of the system bundle is not supported");
        }
        super.beginInstall();
    }

    private boolean isFragment() {
        return this.bundleManifest.getFragmentHost().getBundleSymbolicName() != null;
    }

    private boolean isFragmentOnSystemBundle() {
        String fragmentHost = this.bundleManifest.getFragmentHost().getBundleSymbolicName();
        if (fragmentHost != null) {
            return fragmentHost.equals(EQUINOX_SYSTEM_BUNDLE_NAME) || fragmentHost.equals(RESERVED_SYSTEM_BUNDLE_NAME);
        }
        return false;
    }

    @Override
    public void start(AbortableSignal signal) throws DeploymentException {
        if (!this.hasStartingParent()) {
            this.topLevelStart();
        }
        this.pushThreadContext();
        try {
            this.driveDoStart(signal);
        }
        finally {
            this.popThreadContext();
        }
    }

    @Override
    protected void doStart(AbortableSignal signal) throws DeploymentException {
        this.bundleDriver.start(signal);
    }

    @Override
    public void stop() throws DeploymentException {
        if (this.getBundle().getState() == 32 && this.shouldStop()) {
            this.pushThreadContext();
            try {
                try {
                    this.doStop();
                }
                catch (DeploymentException e) {
                    this.getStateMonitor().onStopFailed(this, e);
                    this.popThreadContext();
                }
            }
            finally {
                this.popThreadContext();
            }
        }
    }

    @Override
    protected void doStop() throws DeploymentException {
        this.bundleDriver.stop();
    }

    @Override
    public void uninstall() throws DeploymentException {
        super.uninstall();
    }

    @Override
    protected void doUninstall() throws DeploymentException {
        this.bundleDriver.uninstall();
    }

    private boolean isScoped() {
        return this.getScopeName() != null;
    }

    private boolean stopBundleIfNecessary() throws DeploymentException {
        boolean stopBundle;
        int bundleState = this.getBundle().getState();
        boolean bl = stopBundle = bundleState == 8 || bundleState == 32;
        if (stopBundle) {
            this.stop();
            return true;
        }
        return false;
    }

    private boolean completeUpdateAndRefresh(boolean startRequired) {
        try {
            boolean refreshed = this.bundleDriver.update(this.bundleManifest, this.artifactStorage.getArtifactFS().getFile());
            if (refreshed && startRequired) {
                BlockingAbortableSignal blockingSignal = new BlockingAbortableSignal(true);
                this.start(blockingSignal);
                try {
                    refreshed = blockingSignal.checkComplete();
                }
                catch (DeploymentException deploymentException) {
                    refreshed = false;
                }
            }
            return refreshed;
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doRefresh() throws DeploymentException {
        BundleManifest newBundleManifest;
        BundleManifest currentBundleManifest;
        Object object = this.monitor;
        synchronized (object) {
            currentBundleManifest = this.bundleManifest;
        }
        try {
            newBundleManifest = this.getManifestFromArtifactFS();
        }
        catch (IOException ioe) {
            throw new DeploymentException("Failed to read new bundle manifest during refresh", (Throwable)ioe);
        }
        ArtifactIdentity newIdentity = this.identityDeterminer.determineIdentity(this.artifactStorage.getArtifactFS().getFile(), this.getScopeName());
        if (newIdentity == null) {
            throw new DeploymentException("Failed to determine new identity during refresh");
        }
        if (!this.isNameAndVersionUnchanged(newIdentity = ArtifactIdentityScoper.scopeArtifactIdentity(newIdentity))) {
            return false;
        }
        boolean bundleStopped = this.stopBundleIfNecessary();
        Object object2 = this.monitor;
        synchronized (object2) {
            this.bundleManifest = newBundleManifest;
        }
        this.synchronizeBundleSymbolicNameWithIdentity();
        if (!this.refreshScope()) {
            object2 = this.monitor;
            synchronized (object2) {
                this.bundleManifest = currentBundleManifest;
            }
            this.startIfNecessary(bundleStopped);
            return false;
        }
        if (this.isScoped() && !this.isExportPackageUnchanged(currentBundleManifest, newBundleManifest)) {
            this.eventLogger.log((LogEvent)DeployerLogEvents.CANNOT_REFRESH_BUNDLE_AS_SCOPED_AND_EXPORTS_CHANGED, new Object[]{this.getName(), this.getVersion()});
            object2 = this.monitor;
            synchronized (object2) {
                this.bundleManifest = currentBundleManifest;
            }
            this.startIfNecessary(bundleStopped);
            return false;
        }
        boolean refreshSuccessful = this.completeUpdateAndRefresh(bundleStopped);
        if (!refreshSuccessful) {
            Object object3 = this.monitor;
            synchronized (object3) {
                this.bundleManifest = currentBundleManifest;
            }
            this.startIfNecessary(bundleStopped);
        }
        return refreshSuccessful;
    }

    private void startIfNecessary(boolean bundleStopped) throws DeploymentException {
        if (bundleStopped) {
            BlockingAbortableSignal signal = new BlockingAbortableSignal(true);
            this.start(signal);
            signal.awaitCompletion(60L);
        }
    }

    private boolean isExportPackageUnchanged(BundleManifest currentBundleManifest, BundleManifest newBundleManifest) {
        Set<ExportedPackage> previousExportedPackageSet = this.getExportedPackageSet(currentBundleManifest.getExportPackage().getExportedPackages());
        Set<ExportedPackage> newExportedPackageSet = this.getExportedPackageSet(newBundleManifest.getExportPackage().getExportedPackages());
        return newExportedPackageSet.equals(previousExportedPackageSet);
    }

    private boolean isNameAndVersionUnchanged(ArtifactIdentity newIdentity) {
        if (newIdentity.getName().equals(this.getName()) && newIdentity.getVersion().equals((Object)this.getVersion())) {
            return true;
        }
        this.eventLogger.log((LogEvent)DeployerLogEvents.CANNOT_REFRESH_BUNDLE_IDENTITY_CHANGED, new Object[]{this.getName(), this.getVersion(), newIdentity.getName(), newIdentity.getVersion()});
        return false;
    }

    private boolean refreshScope() {
        PlanInstallArtifact scopedAncestor = this.getScopedAncestor();
        boolean refreshed = scopedAncestor != null ? scopedAncestor.refreshScope() : this.refreshHandler.refresh(this);
        return refreshed;
    }

    PlanInstallArtifact getScopedAncestor() {
        List ancestors = this.getGraph().getParents();
        while (!ancestors.isEmpty()) {
            GraphNode ancestor = (GraphNode)ancestors.get(0);
            InstallArtifact ancestorArtifact = (InstallArtifact)ancestor.getValue();
            PlanInstallArtifact planAncestor = (PlanInstallArtifact)ancestorArtifact;
            if (planAncestor.isScoped()) {
                return planAncestor;
            }
            ancestor = (GraphNode)ancestors.get(0);
            ancestors = ancestor.getParents();
        }
        return null;
    }

    private Set<ExportedPackage> getExportedPackageSet(List<ExportedPackage> exportedPackages) {
        HashSet<ExportedPackage> packageExports = new HashSet<ExportedPackage>();
        for (ExportedPackage exportPackage : exportedPackages) {
            packageExports.add(exportPackage);
        }
        return packageExports;
    }

    @Override
    public void deleteEntry(String targetPath) {
        this.deleteEntry(this.getBundleFile(), targetPath);
        this.getArtifactFS().getEntry(targetPath).delete();
    }

    private void deleteEntry(File root, String path) {
        if (root.isDirectory()) {
            File f = new File(root, path);
            if (f.exists() && !f.delete()) {
                this.logger.warn("Unable to delete resource at {}", (Object)path);
            }
        } else {
            this.logger.warn("Unable to delete resource in non-directory location at {}", (Object)root.getAbsolutePath());
        }
    }

    @Override
    public void updateEntry(URI inputPath, String targetPath) {
        this.updateEntry(this.getBundleFile(), inputPath, targetPath);
        this.updateEntry(this.getArtifactFS().getEntry(targetPath), inputPath);
    }

    private void updateEntry(ArtifactFSEntry entry, URI inputPath) {
        this.doUpdate(inputPath, entry.getOutputStream(), String.valueOf(entry.getArtifactFS().getFile().getAbsolutePath()) + File.separatorChar + entry.getPath());
    }

    private void updateEntry(File root, URI inputPath, String targetPath) {
        block5: {
            try {
                if (root.isDirectory()) {
                    FileOutputStream out = null;
                    try {
                        out = new FileOutputStream(new File(root, targetPath));
                        this.doUpdate(inputPath, out, targetPath);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(out);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((Closeable)out);
                    break block5;
                }
                this.logger.warn("Unable to update resource in non-directory location at {}", (Object)root.getAbsolutePath());
            }
            catch (Exception exception) {
                this.logger.warn("Unable to update resource at {} with resource at {}", (Object)targetPath, (Object)inputPath.toASCIIString());
            }
        }
    }

    private void doUpdate(URI input, OutputStream output, String targetPath) {
        try {
            InputStream in = input.toURL().openStream();
            FileCopyUtils.copy((InputStream)in, (OutputStream)output);
        }
        catch (Exception exception) {
            this.logger.warn("Unable to update resource at {} with resource at {}", (Object)targetPath, (Object)input.toASCIIString());
        }
    }
}

