/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.install.artifact.internal;

import java.io.File;
import java.util.Set;
import org.eclipse.virgo.kernel.install.artifact.ArtifactIdentity;
import org.eclipse.virgo.kernel.install.artifact.ArtifactIdentityDeterminer;
import org.eclipse.virgo.repository.ArtifactBridge;
import org.eclipse.virgo.repository.ArtifactDescriptor;
import org.eclipse.virgo.repository.ArtifactGenerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class StandardArtifactIdentityDeterminer
implements ArtifactIdentityDeterminer {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandardArtifactIdentityDeterminer.class);
    private final Set<ArtifactBridge> bridges;

    public StandardArtifactIdentityDeterminer(Set<ArtifactBridge> bridges) {
        this.bridges = bridges;
    }

    @Override
    public ArtifactIdentity determineIdentity(File file, String scopeName) {
        ArtifactDescriptor artifactDescriptor = null;
        for (ArtifactBridge artifactBridge : this.bridges) {
            try {
                artifactDescriptor = artifactBridge.generateArtifactDescriptor(file);
            }
            catch (ArtifactGenerationException e) {
                LOGGER.error(String.format("Error occurred while determining the identity of an Artifact '%s' with the bridge '%s'.", file, artifactBridge.getClass().getSimpleName()), (Throwable)e);
                return null;
            }
            if (artifactDescriptor != null) break;
        }
        if (artifactDescriptor == null) {
            return null;
        }
        return new ArtifactIdentity(artifactDescriptor.getType(), artifactDescriptor.getName(), artifactDescriptor.getVersion(), scopeName);
    }
}

