/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.osgi.security;

import java.util.StringTokenizer;
import org.jolokia.util.Base64Util;

public final class AuthorizationHeaderParser {
    private AuthorizationHeaderParser() {
    }

    public static Result parse(String pAuthInfo) {
        boolean valid;
        String password;
        String user;
        StringTokenizer stok = new StringTokenizer(pAuthInfo);
        String method = stok.nextToken();
        if (!"BASIC".equalsIgnoreCase(method)) {
            throw new IllegalArgumentException("Only BasicAuthentication is supported");
        }
        String b64Auth = stok.nextToken();
        String auth = new String(Base64Util.decode(b64Auth));
        int p = auth.indexOf(58);
        if (p != -1) {
            user = auth.substring(0, p);
            password = auth.substring(p + 1);
            valid = true;
        } else {
            valid = false;
            user = null;
            password = null;
        }
        return new Result(method, user, password, valid);
    }

    public static class Result {
        private final String method;
        private final String user;
        private final String password;
        private final boolean valid;

        public Result(String pMethod, String pUser, String pPassword, boolean pValid) {
            this.method = pMethod;
            this.user = pUser;
            this.password = pPassword;
            this.valid = pValid;
        }

        public String getUser() {
            return this.user;
        }

        public String getPassword() {
            return this.password;
        }

        public boolean isValid() {
            return this.valid;
        }
    }
}

