/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.tomcat.internal.bundleresources;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import org.apache.catalina.Host;
import org.apache.catalina.WebResource;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.WebResourceSet;
import org.apache.catalina.webresources.StandardRoot;
import org.eclipse.gemini.web.tomcat.internal.bundleresources.BundleJarResourceSet;
import org.eclipse.gemini.web.tomcat.internal.bundleresources.BundleWebResource;
import org.eclipse.gemini.web.tomcat.internal.bundleresources.BundleWebResourceSet;
import org.osgi.framework.Bundle;
import org.osgi.util.tracker.ServiceTracker;

public class BundleWebResourceRoot
extends StandardRoot {
    private final Bundle bundle;
    private final WebResource main;
    private final ServiceTracker<?, ?> urlConverterTracker;
    private Path docBase;

    public BundleWebResourceRoot(Bundle bundle, ServiceTracker<?, ?> urlConverterTracker) {
        this.bundle = bundle;
        this.urlConverterTracker = urlConverterTracker;
        this.main = new BundleWebResource(this.bundle, (WebResourceRoot)this);
    }

    public void createWebResourceSet(WebResourceRoot.ResourceSetType type, String webAppMount, URL url, String internalPath) {
        BaseLocation baseLocation = new BaseLocation(url);
        this.createWebResourceSet(type, webAppMount, baseLocation.getBasePath(), baseLocation.getArchivePath(), internalPath);
    }

    public void createWebResourceSet(WebResourceRoot.ResourceSetType type, String webAppMount, String base, String archivePath, String internalPath) {
        Object resourceSet = null;
        if (archivePath != null) {
            if (archivePath.toLowerCase(Locale.ENGLISH).endsWith(".jar")) {
                resourceSet = new BundleJarResourceSet((WebResourceRoot)this, webAppMount, String.valueOf(base) + archivePath, internalPath);
            } else {
                WebResource entry = (WebResource)((BundleWebResource)this.main).getNamedEntry(archivePath).getKey();
                if (entry != null) {
                    resourceSet = new BundleWebResourceSet(entry, (WebResourceRoot)this, webAppMount, String.valueOf(base) + archivePath, internalPath);
                }
            }
            if (type.equals((Object)WebResourceRoot.ResourceSetType.CLASSES_JAR) && resourceSet != null) {
                resourceSet.setClassLoaderOnly(true);
            }
        }
        if (resourceSet != null) {
            switch (type) {
                case PRE: {
                    this.addPreResources((WebResourceSet)resourceSet);
                    break;
                }
                case CLASSES_JAR: {
                    this.addClassResources((WebResourceSet)resourceSet);
                    break;
                }
                case RESOURCE_JAR: {
                    this.addJarResources((WebResourceSet)resourceSet);
                    break;
                }
                case POST: {
                    this.addPostResources((WebResourceSet)resourceSet);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unable to create WebResourceSet of unknown type [" + type + "].");
                }
            }
        }
    }

    protected String getObjectNameKeyProperties() {
        StringBuilder keyProperties = new StringBuilder("type=BundleWebResourceRoot");
        keyProperties.append(this.getContext().getMBeanKeyProperties());
        return keyProperties.toString();
    }

    ServiceTracker<?, ?> getUrlConverterTracker() {
        return this.urlConverterTracker;
    }

    protected void registerURLStreamHandlerFactory() {
    }

    protected WebResourceSet createMainResourceSet() {
        String docBaseStr = this.getContext().getDocBase();
        if (docBaseStr != null) {
            this.docBase = Paths.get(docBaseStr, new String[0]);
            if (!this.docBase.isAbsolute()) {
                this.docBase = Paths.get(((Host)this.getContext().getParent()).getAppBaseFile().getPath(), new String[0]).resolve(this.docBase);
            }
        }
        return new BundleWebResourceSet(this.main, (WebResourceRoot)this, "/", this.docBase != null ? this.docBase.toAbsolutePath().toString() : null, "/");
    }

    private static class BaseLocation {
        private String basePath = "";
        private String archivePath = "";

        BaseLocation(URL url) {
            String protocol = url.getProtocol();
            if ("jar".equals(protocol)) {
                int endOfFileUrl;
                String jarUrl = url.toString();
                String fileUrl = jarUrl.substring(4, endOfFileUrl = jarUrl.indexOf("!/"));
                if (fileUrl.startsWith("bundle")) {
                    URL file = null;
                    try {
                        file = new URL(fileUrl);
                    }
                    catch (MalformedURLException e) {
                        throw new IllegalArgumentException(e);
                    }
                    this.archivePath = file.getFile();
                    this.basePath = fileUrl.substring(0, fileUrl.indexOf(this.archivePath));
                }
            } else if (protocol != null && protocol.startsWith("bundle")) {
                this.archivePath = url.getFile();
                String fileUrl = url.toString();
                this.basePath = fileUrl.substring(0, fileUrl.indexOf(this.archivePath));
            } else {
                throw new IllegalArgumentException("The URL protocol [" + protocol + "] is not supported by this web resources implementation");
            }
        }

        String getBasePath() {
            return this.basePath;
        }

        String getArchivePath() {
            return this.archivePath;
        }
    }
}

