/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.userregion.internal.equinox;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.virgo.kernel.osgi.framework.ManifestTransformer;
import org.eclipse.virgo.kernel.osgi.framework.OsgiFrameworkUtils;
import org.eclipse.virgo.kernel.osgi.framework.OsgiServiceHolder;
import org.eclipse.virgo.kernel.osgi.framework.support.AbstractOsgiFramework;
import org.eclipse.virgo.kernel.userregion.internal.equinox.EquinoxBootDelegationHelper;
import org.eclipse.virgo.kernel.userregion.internal.equinox.EquinoxUtils;
import org.eclipse.virgo.kernel.userregion.internal.equinox.KernelBundleClassLoader;
import org.eclipse.virgo.kernel.userregion.internal.equinox.TransformedManifestProvidingBundleFileWrapper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public class EquinoxOsgiFramework
extends AbstractOsgiFramework {
    private static final String FILE_SCHEME = "file:";
    private static final String REFERENCE_SCHEME = "reference:";
    private final OsgiServiceHolder<PlatformAdmin> platformAdmin;
    private final EquinoxBootDelegationHelper bootDelegationHelper = new EquinoxBootDelegationHelper(FrameworkProperties.getProperty((String)"org.osgi.framework.bootdelegation"));
    private final TransformedManifestProvidingBundleFileWrapper bundleTransformationHandler;

    public EquinoxOsgiFramework(BundleContext context, PackageAdmin packageAdmin, TransformedManifestProvidingBundleFileWrapper bundleTransformationHandler) {
        super(context, packageAdmin);
        this.platformAdmin = OsgiFrameworkUtils.getService((BundleContext)context, PlatformAdmin.class);
        this.bundleTransformationHandler = bundleTransformationHandler;
    }

    public void refresh(Bundle bundle) throws BundleException {
        KernelBundleClassLoader pbcl;
        ClassLoader cl = this.getBundleClassLoader(bundle);
        ArrayList<Bundle> refreshBundles = new ArrayList<Bundle>();
        if (cl instanceof KernelBundleClassLoader && (pbcl = (KernelBundleClassLoader)((Object)cl)).isInstrumented()) {
            Bundle[] dependencies;
            Bundle[] bundleArray = dependencies = this.getDirectDependencies(bundle);
            int n = dependencies.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle dependency = bundleArray[n2];
                if (OsgiFrameworkUtils.sameScope((Bundle)bundle, (Bundle)dependency)) {
                    dependency.update();
                    refreshBundles.add(dependency);
                }
                ++n2;
            }
        }
        bundle.update();
        refreshBundles.add(bundle);
        Bundle[] toRefresh = refreshBundles.toArray(new Bundle[refreshBundles.size()]);
        this.getPackageAdmin().refreshPackages(toRefresh);
    }

    final void stop() {
        if (this.platformAdmin != null) {
            this.getBundleContext().ungetService(this.platformAdmin.getServiceReference());
        }
    }

    public ClassLoader getBundleClassLoader(Bundle bundle) {
        return EquinoxUtils.getBundleClassLoader(bundle);
    }

    public boolean isBootDelegated(String className) {
        if (this.bootDelegationHelper != null) {
            return this.bootDelegationHelper.isBootDelegated(className);
        }
        throw new IllegalStateException("OsgiFramework must have been started prior to querying its boot delegation");
    }

    public Bundle[] getDirectDependencies(Bundle bundle, boolean includeFragments) {
        BundleContext bundleContext = this.getBundleContext();
        ServiceReference serviceRef = bundleContext.getServiceReference(PlatformAdmin.class);
        try {
            PlatformAdmin serverAdmin = (PlatformAdmin)bundleContext.getService(serviceRef);
            Bundle[] bundleArray = EquinoxUtils.getDirectDependencies(bundle, bundleContext, serverAdmin, includeFragments);
            return bundleArray;
        }
        finally {
            bundleContext.ungetService(serviceRef);
        }
    }

    public Bundle[] getDirectDependencies(Bundle bundle) {
        return this.getDirectDependencies(bundle, false);
    }

    public void update(Bundle bundle, ManifestTransformer manifestTransformer, File location) throws BundleException {
        this.bundleTransformationHandler.pushManifestTransformer(manifestTransformer);
        try {
            bundle.update(this.openBundleStream(location));
        }
        finally {
            this.bundleTransformationHandler.popManifestTransformer();
        }
    }

    private InputStream openBundleStream(File location) throws BundleException {
        String absoluteBundleUriString = this.getAbsoluteUriString(location);
        try {
            return new URL(REFERENCE_SCHEME + absoluteBundleUriString).openStream();
        }
        catch (MalformedURLException e) {
            throw new BundleException("Invalid bundle URI '" + absoluteBundleUriString + "'", (Throwable)e);
        }
        catch (IOException e) {
            throw new BundleException("Invalid bundle at URI '" + absoluteBundleUriString + "'", (Throwable)e);
        }
    }

    private String getAbsoluteUriString(File location) throws BundleException {
        return FILE_SCHEME + location.getAbsolutePath();
    }
}

