/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.config.annotation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.ServletContext;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.web.accept.ContentNegotiationManager;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistration;
import org.springframework.web.servlet.handler.AbstractHandlerMapping;
import org.springframework.web.servlet.handler.SimpleUrlHandlerMapping;
import org.springframework.web.servlet.resource.ResourceHttpRequestHandler;

public class ResourceHandlerRegistry {
    private final ServletContext servletContext;
    private final ApplicationContext applicationContext;
    private final ContentNegotiationManager contentNegotiationManager;
    private final List<ResourceHandlerRegistration> registrations = new ArrayList<ResourceHandlerRegistration>();
    private int order = 0x7FFFFFFE;

    public ResourceHandlerRegistry(ApplicationContext applicationContext, ServletContext servletContext) {
        this(applicationContext, servletContext, null);
    }

    public ResourceHandlerRegistry(ApplicationContext applicationContext, ServletContext servletContext, ContentNegotiationManager contentNegotiationManager) {
        Assert.notNull((Object)applicationContext, (String)"ApplicationContext is required");
        this.applicationContext = applicationContext;
        this.servletContext = servletContext;
        this.contentNegotiationManager = contentNegotiationManager;
    }

    public ResourceHandlerRegistration addResourceHandler(String ... pathPatterns) {
        ResourceHandlerRegistration registration = new ResourceHandlerRegistration((ResourceLoader)this.applicationContext, pathPatterns);
        this.registrations.add(registration);
        return registration;
    }

    public boolean hasMappingForPattern(String pathPattern) {
        for (ResourceHandlerRegistration registration : this.registrations) {
            if (!Arrays.asList(registration.getPathPatterns()).contains(pathPattern)) continue;
            return true;
        }
        return false;
    }

    public ResourceHandlerRegistry setOrder(int order) {
        this.order = order;
        return this;
    }

    protected AbstractHandlerMapping getHandlerMapping() {
        if (this.registrations.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, ResourceHttpRequestHandler> urlMap = new LinkedHashMap<String, ResourceHttpRequestHandler>();
        for (ResourceHandlerRegistration registration : this.registrations) {
            for (String pathPattern : registration.getPathPatterns()) {
                ResourceHttpRequestHandler handler = registration.getRequestHandler();
                handler.setServletContext(this.servletContext);
                handler.setApplicationContext(this.applicationContext);
                handler.setContentNegotiationManager(this.contentNegotiationManager);
                try {
                    handler.afterPropertiesSet();
                }
                catch (Throwable ex) {
                    throw new BeanInitializationException("Failed to init ResourceHttpRequestHandler", ex);
                }
                urlMap.put(pathPattern, handler);
            }
        }
        SimpleUrlHandlerMapping handlerMapping = new SimpleUrlHandlerMapping();
        handlerMapping.setOrder(this.order);
        handlerMapping.setUrlMap(urlMap);
        return handlerMapping;
    }
}

