/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.install.pipeline.stage.resolve.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.virgo.kernel.install.artifact.BundleInstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifact;
import org.eclipse.virgo.kernel.install.environment.InstallEnvironment;
import org.eclipse.virgo.kernel.install.pipeline.stage.PipelineStage;
import org.eclipse.virgo.kernel.osgi.framework.UnableToSatisfyBundleDependenciesException;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiFramework;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiFrameworkFactory;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiResolutionFailure;
import org.eclipse.virgo.nano.deployer.api.core.DeploymentException;
import org.eclipse.virgo.nano.serviceability.NonNull;
import org.eclipse.virgo.util.common.GraphNode;
import org.osgi.framework.Bundle;
import org.osgi.service.packageadmin.PackageAdmin;

public final class ResolveStage
implements PipelineStage {
    private final PackageAdmin packageAdmin;
    private final QuasiFrameworkFactory quasiFrameworkFactory;

    public ResolveStage(@NonNull PackageAdmin packageAdmin, @NonNull QuasiFrameworkFactory quasiFrameworkFactory) {
        this.packageAdmin = packageAdmin;
        this.quasiFrameworkFactory = quasiFrameworkFactory;
    }

    @Override
    public void process(GraphNode<InstallArtifact> installGraph, InstallEnvironment installEnvironment) throws DeploymentException, UnableToSatisfyBundleDependenciesException {
        BundleFinderVisitor visitor = new BundleFinderVisitor();
        installGraph.visit((GraphNode.DirectedAcyclicGraphVisitor)visitor);
        Bundle[] bundles = visitor.getBundles();
        boolean resolved = this.packageAdmin.resolveBundles(bundles);
        if (!resolved) {
            this.diagnoseResolutionFailure(bundles);
        }
    }

    private void diagnoseResolutionFailure(Bundle[] bundles) throws UnableToSatisfyBundleDependenciesException {
        QuasiFramework quasiFramework = this.quasiFrameworkFactory.create();
        Bundle[] bundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            List resolutionFailures;
            Bundle bundle = bundleArray[n2];
            if (bundle.getState() == 2 && !(resolutionFailures = quasiFramework.diagnose(bundle.getBundleId())).isEmpty()) {
                QuasiResolutionFailure failure = (QuasiResolutionFailure)resolutionFailures.get(0);
                throw new UnableToSatisfyBundleDependenciesException(failure.getUnresolvedQuasiBundle().getSymbolicName(), failure.getUnresolvedQuasiBundle().getVersion(), failure.getDescription());
            }
            ++n2;
        }
    }

    private static class BundleFinderVisitor
    implements GraphNode.DirectedAcyclicGraphVisitor<InstallArtifact> {
        private final List<Bundle> bundles = new ArrayList<Bundle>();

        private BundleFinderVisitor() {
        }

        public boolean visit(GraphNode<InstallArtifact> graph) {
            InstallArtifact installArtifact = (InstallArtifact)graph.getValue();
            if (installArtifact instanceof BundleInstallArtifact) {
                BundleInstallArtifact bundleInstallArtifact = (BundleInstallArtifact)installArtifact;
                Bundle bundle = bundleInstallArtifact.getBundle();
                this.bundles.add(bundle);
            }
            return true;
        }

        public Bundle[] getBundles() {
            return this.bundles.toArray(new Bundle[0]);
        }
    }
}

