/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.install.artifact.internal;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.virgo.kernel.artifact.fs.ArtifactFS;
import org.eclipse.virgo.kernel.artifact.fs.ArtifactFSEntry;
import org.eclipse.virgo.kernel.install.artifact.ScopeServiceRepository;
import org.eclipse.virgo.kernel.install.artifact.internal.SpringConfigServiceModelScanner;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.nano.deployer.api.core.DeploymentException;
import org.eclipse.virgo.util.io.IOUtils;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;
import org.eclipse.virgo.util.osgi.manifest.BundleManifestFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.xml.XmlValidationModeDetector;

final class ServiceScoper {
    private static final String SPRING_CONFIG_DIR = "META-INF/spring/";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final XmlValidationModeDetector xmlValidationModeDetector = new XmlValidationModeDetector();
    private final String scopeName;
    private final ScopeServiceRepository repository;
    private final EventLogger eventLogger;

    public ServiceScoper(String scopeName, ScopeServiceRepository scopeServiceRepository, EventLogger eventLogger) {
        this.scopeName = scopeName;
        this.repository = scopeServiceRepository;
        this.eventLogger = eventLogger;
    }

    public void scope(Set<ArtifactFS> modules) throws DeploymentException {
        HashMap<ArtifactFS, List<ArtifactFSEntry>> configFiles = new HashMap<ArtifactFS, List<ArtifactFSEntry>>();
        for (ArtifactFS moduleData : modules) {
            configFiles.put(moduleData, this.findConfigFiles(moduleData));
        }
        this.doScope(configFiles);
    }

    private List<ArtifactFSEntry> findConfigFiles(ArtifactFS bundleData) throws DeploymentException {
        ArrayList<ArtifactFSEntry> configFiles = new ArrayList<ArtifactFSEntry>();
        ArtifactFSEntry entry = bundleData.getEntry(SPRING_CONFIG_DIR);
        if (entry.exists()) {
            try {
                configFiles.addAll(this.findConfigFiles(bundleData, entry));
            }
            catch (IOException e) {
                throw new DeploymentException("Unable to read Spring config files.", (Throwable)e);
            }
        }
        return configFiles;
    }

    private List<ArtifactFSEntry> findConfigFiles(ArtifactFS bundleData, ArtifactFSEntry entry) throws IOException {
        ArtifactFSEntry[] children = entry.getChildren();
        ArrayList<ArtifactFSEntry> configFiles = new ArrayList<ArtifactFSEntry>();
        ArtifactFSEntry[] artifactFSEntryArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            ArtifactFSEntry e = artifactFSEntryArray[n2];
            if (e.isDirectory()) {
                configFiles.addAll(this.findConfigFiles(bundleData, e));
            } else if (e.getPath().endsWith(".xml")) {
                try {
                    int validationMode;
                    InputStream is = e.getInputStream();
                    try {
                        validationMode = this.xmlValidationModeDetector.detectValidationMode(is);
                    }
                    finally {
                        IOUtils.closeQuietly((Closeable)is);
                    }
                    if (validationMode != 2) {
                        configFiles.add(e);
                    } else {
                        this.logger.debug("Skipping entry '{}' as it uses a DTD.", (Object)e);
                    }
                }
                catch (IOException ioe) {
                    this.logger.debug("Unexpected error detecting validation mode of entry '{}'", (Object)ioe, (Object)e);
                    configFiles.add(e);
                }
            }
            ++n2;
        }
        return configFiles;
    }

    public void rescope(ArtifactFS bundleData) throws DeploymentException {
        HashMap<ArtifactFS, List<ArtifactFSEntry>> configFiles = new HashMap<ArtifactFS, List<ArtifactFSEntry>>();
        configFiles.put(bundleData, this.findConfigFiles(bundleData));
        this.doScope(configFiles);
    }

    private void doScope(Map<ArtifactFS, List<ArtifactFSEntry>> configFiles) throws DeploymentException {
        SpringConfigServiceModelScanner scanner = new SpringConfigServiceModelScanner(this.scopeName, this.repository, this.eventLogger);
        Map<ArtifactFS, BundleManifest> manifests = this.loadBundleManifests(configFiles.keySet());
        for (Map.Entry<ArtifactFS, List<ArtifactFSEntry>> entry : configFiles.entrySet()) {
            BundleManifest bundleManifest = manifests.get(entry.getKey());
            for (ArtifactFSEntry configFile : entry.getValue()) {
                InputStream is = configFile.getInputStream();
                try {
                    scanner.scanConfigFile(bundleManifest.getBundleSymbolicName().getSymbolicName(), bundleManifest.getBundleVersion(), configFile.getPath(), is);
                }
                finally {
                    IOUtils.closeQuietly((Closeable)is);
                }
            }
        }
    }

    private Map<ArtifactFS, BundleManifest> loadBundleManifests(Collection<ArtifactFS> modules) throws DeploymentException {
        HashMap<ArtifactFS, BundleManifest> result = new HashMap<ArtifactFS, BundleManifest>();
        for (ArtifactFS module : modules) {
            if (result.containsKey(module)) continue;
            BundleManifest manifest = this.loadManifest(module);
            result.put(module, manifest);
        }
        return result;
    }

    private BundleManifest loadManifest(ArtifactFS compositeArtifactFS) throws DeploymentException {
        BundleManifest bundleManifest;
        ArtifactFSEntry entry = compositeArtifactFS.getEntry("META-INF/MANIFEST.MF");
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(entry.getInputStream(), StandardCharsets.UTF_8);
            bundleManifest = BundleManifestFactory.createBundleManifest((Reader)reader);
        }
        catch (IOException ex) {
            try {
                throw new DeploymentException("Error reading MANIFEST.MF from '" + compositeArtifactFS + "'", (Throwable)ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)reader);
        return bundleManifest;
    }
}

