/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.install.artifact.internal;

import java.util.Map;
import org.eclipse.virgo.kernel.install.artifact.ArtifactIdentity;
import org.eclipse.virgo.kernel.install.artifact.ArtifactStorage;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.internal.AbstractArtifactGraphFactory;
import org.eclipse.virgo.kernel.install.artifact.internal.ConfigLifecycleEngine;
import org.eclipse.virgo.kernel.install.artifact.internal.StandardArtifactStateMonitor;
import org.eclipse.virgo.kernel.install.artifact.internal.StandardConfigInstallArtifact;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.nano.deployer.api.config.ConfigurationDeployer;
import org.eclipse.virgo.nano.deployer.api.core.DeploymentException;
import org.eclipse.virgo.nano.serviceability.NonNull;
import org.eclipse.virgo.util.common.DirectedAcyclicGraph;
import org.eclipse.virgo.util.common.GraphNode;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

final class ConfigInstallArtifactGraphFactory
extends AbstractArtifactGraphFactory {
    private static final String PROPERTIES_TYPE = "configuration";
    private final BundleContext bundleContext;
    private final ConfigLifecycleEngine lifecycleEngine;
    private final EventLogger eventLogger;
    private final Object monitor = new Object();
    private ConfigurationDeployer configurationDeployer;

    ConfigInstallArtifactGraphFactory(BundleContext bundleContext, EventLogger eventLogger, @NonNull DirectedAcyclicGraph<InstallArtifact> dag) {
        super(dag);
        this.bundleContext = bundleContext;
        this.lifecycleEngine = new ConfigLifecycleEngine(bundleContext);
        this.eventLogger = eventLogger;
    }

    @Override
    public GraphNode<InstallArtifact> constructInstallArtifactGraph(ArtifactIdentity artifactIdentity, ArtifactStorage artifactStorage, Map<String, String> deploymentProperties, String repositoryName) throws DeploymentException {
        if (PROPERTIES_TYPE.equalsIgnoreCase(artifactIdentity.getType())) {
            ConfigurationDeployer configDeployer = this.obtainConfigurationDeployer();
            if (configDeployer == null) {
                throw new DeploymentException(String.format("Unable to locate a '%s' service to deploy '%s'", ConfigurationDeployer.class.getName(), artifactIdentity.getName()));
            }
            StandardArtifactStateMonitor artifactStateMonitor = new StandardArtifactStateMonitor(this.bundleContext);
            StandardConfigInstallArtifact configInstallArtifact = new StandardConfigInstallArtifact(artifactIdentity, artifactStorage, this.lifecycleEngine, this.lifecycleEngine, this.lifecycleEngine, artifactStateMonitor, repositoryName, this.eventLogger, configDeployer);
            return this.constructAssociatedGraphNode(configInstallArtifact);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigurationDeployer obtainConfigurationDeployer() throws DeploymentException {
        Object object = this.monitor;
        synchronized (object) {
            if (this.configurationDeployer == null) {
                ServiceReference serviceReference = this.bundleContext.getServiceReference(ConfigurationDeployer.class);
                this.configurationDeployer = (ConfigurationDeployer)this.bundleContext.getService(serviceReference);
            }
            return this.configurationDeployer;
        }
    }
}

