/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.shell.internal.commands;

import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.eclipse.virgo.shell.Command;
import org.eclipse.virgo.shell.internal.LocalInputOutputManager;

@Command(value="shutdown")
final class ShutdownCommand {
    private static final String DEFAULT_KERNEL_DOMAIN = "org.eclipse.virgo.kernel";
    private static final String MBEAN_VALUE_SHUTDOWN = "Shutdown";
    private static final String MBEAN_KEY_TYPE = "type";
    private final LocalInputOutputManager ioManager;

    ShutdownCommand(LocalInputOutputManager ioManager) {
        this.ioManager = ioManager;
    }

    @Command(value="")
    public List<String> shutdown() {
        this.ioManager.releaseSystemIO();
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName shutdownName = ObjectName.getInstance(DEFAULT_KERNEL_DOMAIN, MBEAN_KEY_TYPE, MBEAN_VALUE_SHUTDOWN);
            server.invoke(shutdownName, "shutdown", new Object[0], new String[0]);
        }
        catch (Exception e) {
            this.ioManager.grabSystemIO();
            return Arrays.asList(String.format("Error occurred '%s'", e.getMessage()));
        }
        return Collections.emptyList();
    }
}

