/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.nano.serviceability.dump.internal;

import java.io.File;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.virgo.medic.dump.Dump;
import org.eclipse.virgo.medic.dump.DumpContributionFailedException;
import org.eclipse.virgo.medic.dump.DumpContributor;
import org.eclipse.virgo.nano.serviceability.dump.internal.ResolutionStateDumper;
import org.eclipse.virgo.nano.serviceability.dump.internal.StandardStateWriter;
import org.eclipse.virgo.nano.serviceability.dump.internal.StandardSystemStateAccessor;
import org.osgi.framework.BundleContext;

public class ResolutionDumpContributor
implements DumpContributor {
    public static final String RESOLUTION_STATE_KEY = "resolution.state";
    private final ResolutionStateDumper resolutionStateDumper;

    public ResolutionDumpContributor(BundleContext bundleContext) {
        PlatformAdmin platformAdmin = (PlatformAdmin)bundleContext.getService(bundleContext.getServiceReference(PlatformAdmin.class));
        this.resolutionStateDumper = new ResolutionStateDumper(new StandardSystemStateAccessor(platformAdmin), new StandardStateWriter(platformAdmin.getFactory()));
    }

    public void contribute(Dump dump) throws DumpContributionFailedException {
        File outputFile = dump.createFile("osgi.zip");
        if (dump.getContext().containsKey(RESOLUTION_STATE_KEY)) {
            this.resolutionStateDumper.dump(outputFile, (State)dump.getContext().get(RESOLUTION_STATE_KEY));
        } else {
            this.resolutionStateDumper.dump(outputFile);
        }
    }

    public String getName() {
        return "resolution";
    }
}

