/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.management.fragment;

import java.util.Hashtable;
import javax.management.ObjectName;
import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.RegionDigraph;
import org.eclipse.gemini.management.ObjectNameTranslator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class VirgoObjectNameTranslator
implements ObjectNameTranslator {
    private static final String REGION_KEY = "region";
    private final String regionName;

    public VirgoObjectNameTranslator(BundleContext context) {
        ServiceReference serviceReference = context.getServiceReference(RegionDigraph.class);
        RegionDigraph service = (RegionDigraph)context.getService(serviceReference);
        Region region = service.getRegion(context.getBundle().getBundleId());
        this.regionName = region.getName();
    }

    public ObjectName translate(ObjectName originalName) {
        Hashtable<String, String> keyPropertyList = originalName.getKeyPropertyList();
        keyPropertyList.put(REGION_KEY, this.regionName);
        try {
            return new ObjectName(originalName.getDomain(), keyPropertyList);
        }
        catch (Exception e) {
            throw new RuntimeException("Error modifying ObjectName for '" + originalName.getCanonicalName() + "'", e);
        }
    }
}

