/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.nano.deployer.hot;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.nano.deployer.api.core.ApplicationDeployer;
import org.eclipse.virgo.nano.deployer.api.core.DeploymentException;
import org.eclipse.virgo.nano.deployer.api.core.DeploymentIdentity;
import org.eclipse.virgo.nano.deployer.api.core.DeploymentOptions;
import org.eclipse.virgo.nano.deployer.api.core.FatalDeploymentException;
import org.eclipse.virgo.nano.deployer.hot.HotDeployerLogEvents;
import org.eclipse.virgo.nano.serviceability.NonNull;
import org.eclipse.virgo.util.io.FileSystemEvent;
import org.eclipse.virgo.util.io.FileSystemListener;
import org.eclipse.virgo.util.io.PathReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HotDeploymentFileSystemListener
implements FileSystemListener {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final EventLogger eventLogger;
    private final ApplicationDeployer deployer;

    public HotDeploymentFileSystemListener(@NonNull ApplicationDeployer deployer, EventLogger eventLogger) {
        this.deployer = deployer;
        this.eventLogger = eventLogger;
    }

    public void onChange(String path, FileSystemEvent event) {
        String fileName = new PathReference(path).getName();
        this.eventLogger.log((LogEvent)HotDeployerLogEvents.HOT_DEPLOY_PROCESSING_FILE, new Object[]{event, fileName});
        try {
            if (event == FileSystemEvent.CREATED) {
                this.logger.info("ApplicationDeploying path '{}'.", (Object)path);
                this.deploy(path);
            } else if (event == FileSystemEvent.MODIFIED) {
                this.logger.info("Redeploying path '{}'.", (Object)path);
                this.deploy(path);
            } else if (event == FileSystemEvent.DELETED) {
                this.logger.info("ApplicationUndeploying path '{}'.", (Object)path);
                this.undeploy(path);
            } else if (event == FileSystemEvent.INITIAL) {
                this.logger.info("ApplicationConditionallyDeploying path '{}'.", (Object)path);
                this.deployIfNotDeployed(path, fileName);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
            this.determineFailureAndLogMessage(event, fileName, ex);
        }
    }

    public void onInitialEvent(List<String> paths) {
        this.eventLogger.log((LogEvent)HotDeployerLogEvents.HOT_DEPLOY_PROCESSING_FILE, new Object[]{FileSystemEvent.INITIAL, this.getConcatenatedPaths(paths)});
        try {
            this.bulkDeployIfNotDeployed(paths);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
            this.determineFailureAndLogMessage(FileSystemEvent.INITIAL, this.getConcatenatedPaths(paths), ex);
        }
    }

    private String getConcatenatedPaths(List<String> paths) {
        StringBuilder sb = new StringBuilder("");
        for (String path : paths) {
            sb.append(new PathReference(path).getName()).append("; ");
        }
        return new String(sb);
    }

    private List<URI> getUrisToDeploy(List<String> sourceArtefacts) {
        ArrayList<URI> resultUris = new ArrayList<URI>();
        for (String sourceArtefact : sourceArtefacts) {
            if (!this.isDeployed(sourceArtefact)) {
                resultUris.add(this.getDefinitiveUri(sourceArtefact));
                this.logger.info("ApplicationConditionallyDeploying path '{}'.", (Object)sourceArtefact);
                continue;
            }
            this.eventLogger.log((LogEvent)HotDeployerLogEvents.HOT_DEPLOY_SKIPPED, new Object[]{sourceArtefact});
        }
        return resultUris;
    }

    private void bulkDeployIfNotDeployed(List<String> sourceArtefacts) throws DeploymentException {
        this.deployer.bulkDeploy(this.getUrisToDeploy(sourceArtefacts), new DeploymentOptions(true, true, false));
    }

    private void determineFailureAndLogMessage(FileSystemEvent event, String fileName, Exception ex) {
        switch (event) {
            case INITIAL: 
            case CREATED: {
                this.eventLogger.log((LogEvent)HotDeployerLogEvents.HOT_DEPLOY_FAILED, (Throwable)ex, new Object[]{fileName});
                break;
            }
            case MODIFIED: {
                this.eventLogger.log((LogEvent)HotDeployerLogEvents.HOT_REDEPLOY_FAILED, (Throwable)ex, new Object[]{fileName});
                break;
            }
            case DELETED: {
                this.eventLogger.log((LogEvent)HotDeployerLogEvents.HOT_UNDEPLOY_FAILED, (Throwable)ex, new Object[]{fileName});
            }
        }
    }

    private void undeploy(String sourceArtefact) throws DeploymentException {
        DeploymentIdentity deploymentIdentity = this.getDeploymentIdentity(sourceArtefact);
        if (deploymentIdentity != null) {
            this.deployer.undeploy(deploymentIdentity);
        }
    }

    private DeploymentIdentity getDeploymentIdentity(String sourceArtefact) {
        return this.deployer.getDeploymentIdentity(this.getDefinitiveUri(sourceArtefact));
    }

    private boolean isDeployed(String sourceArtefact) {
        return this.deployer.isDeployed(this.getDefinitiveUri(sourceArtefact));
    }

    private URI getDefinitiveUri(String sourceArtefact) {
        URI baseUri = new File(sourceArtefact).toURI();
        if (sourceArtefact.endsWith(File.separator) && !baseUri.toString().endsWith("/")) {
            try {
                baseUri = new URI(String.valueOf(baseUri.toString()) + "/");
            }
            catch (URISyntaxException e) {
                throw new FatalDeploymentException("Unexpected URI syntax problem.", (Throwable)e);
            }
        }
        return baseUri;
    }

    private void deploy(String sourceArtefact) throws DeploymentException {
        this.deployer.deploy(this.getDefinitiveUri(sourceArtefact), new DeploymentOptions(true, true, false));
    }

    private void deployIfNotDeployed(String sourceArtefact, String fileName) throws DeploymentException {
        if (!this.isDeployed(sourceArtefact)) {
            this.deploy(sourceArtefact);
        } else {
            this.eventLogger.log((LogEvent)HotDeployerLogEvents.HOT_DEPLOY_SKIPPED, new Object[]{fileName});
        }
    }

    public String toString() {
        return "Hot Deploy Listener";
    }
}

