/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.bval.jsr303.util.SecureActions;
import org.apache.commons.lang.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassHelper {
    private ClassHelper() {
    }

    public static void fillFullClassHierarchyAsList(List<Class<?>> allClasses, Class<?> clazz) {
        if (clazz == null || clazz == Object.class) {
            return;
        }
        if (allClasses.contains(clazz)) {
            return;
        }
        allClasses.add(clazz);
        ArrayList subClasses = new ArrayList(Arrays.asList(clazz.getInterfaces()));
        subClasses.add(0, clazz.getSuperclass());
        for (Class clazz2 : subClasses) {
            ClassHelper.fillFullClassHierarchyAsList(allClasses, clazz2);
        }
    }

    public static Class<?> getClass(String className) throws ClassNotFoundException {
        return ClassHelper.getClass(className, true);
    }

    public static Class<?> getClass(String className, boolean initialize) throws ClassNotFoundException {
        ClassLoader ctxtCldr = SecureActions.getContextClassLoader(Thread.currentThread());
        ClassLoader loader = ctxtCldr != null ? ctxtCldr : SecureActions.getClassLoader(ClassHelper.class);
        return ClassUtils.getClass((ClassLoader)loader, (String)className, (boolean)initialize);
    }
}

