/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.tomcat.internal.loading;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Loader;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.mbeans.MBeanUtils;
import org.apache.catalina.util.LifecycleMBeanBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

abstract class BaseWebappLoader
extends LifecycleMBeanBase
implements Loader,
PropertyChangeListener {
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.loader");
    protected final Log log = LogFactory.getLog(this.getClass());
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private boolean delegate = false;
    private Container container = null;
    private boolean reloadable = false;

    BaseWebappLoader() {
    }

    protected String getCatalinaContextPath(Context context) {
        String contextName = context.getName();
        if (!contextName.startsWith("/")) {
            contextName = "/";
        }
        return contextName;
    }

    protected String getObjectNameKeyProperties() {
        StringBuilder name = new StringBuilder("type=Loader");
        if (this.container instanceof Context) {
            name.append(",context=");
            Context context = (Context)this.container;
            name.append(this.getCatalinaContextPath(context));
            name.append(",host=");
            name.append(context.getParent().getName());
        }
        return name.toString();
    }

    protected String getDomainInternal() {
        return MBeanUtils.getDomain((Container)this.container);
    }

    public void backgroundProcess() {
        if (this.reloadable && this.modified()) {
            try {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                if (this.getContainer() instanceof StandardContext) {
                    ((StandardContext)this.getContainer()).reload();
                }
            }
            finally {
                if (this.getContainer().getLoader() != null) {
                    Thread.currentThread().setContextClassLoader(this.getContainer().getLoader().getClassLoader());
                }
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void setContainer(Container container) {
        if (this.container != null && this.container instanceof Context) {
            ((Context)this.container).removePropertyChangeListener((PropertyChangeListener)this);
        }
        Container oldContainer = this.container;
        this.container = container;
        this.support.firePropertyChange("container", oldContainer, this.container);
        if (this.container != null && this.container instanceof Context) {
            this.setReloadable(((Context)this.container).getReloadable());
            ((Context)this.container).addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public final Container getContainer() {
        return this.container;
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public boolean getReloadable() {
        return this.reloadable;
    }

    public void setReloadable(boolean reloadable) {
        boolean oldReloadable = this.reloadable;
        this.reloadable = reloadable;
        this.support.firePropertyChange("reloadable", (Object)oldReloadable, (Object)this.reloadable);
    }

    public boolean getDelegate() {
        return this.delegate;
    }

    public void setDelegate(boolean delegate) {
        boolean oldDelegate = this.delegate;
        this.delegate = delegate;
        this.support.firePropertyChange("delegate", (Object)oldDelegate, (Object)this.delegate);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (!(event.getSource() instanceof Context)) {
            return;
        }
        if (event.getPropertyName().equals("reloadable")) {
            try {
                this.setReloadable((Boolean)event.getNewValue());
            }
            catch (Exception exception) {
                this.log.error((Object)sm.getString("webappLoader.reloadable", new Object[]{event.getNewValue().toString()}));
            }
        }
    }
}

