/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.core.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.core.AbortableSignal;
import org.eclipse.virgo.kernel.core.BundleUtils;
import org.eclipse.virgo.kernel.core.internal.SpringUtils;
import org.eclipse.virgo.kernel.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BundleStartTracker
implements EventHandler {
    private static final String TOPIC_BLUEPRINT_EVENTS = "org/osgi/service/blueprint/container/";
    private static final String EVENT_REGION_STARTING = "org/eclipse/virgo/kernel/region/STARTING";
    private static final String EVENT_CREATED = "org/osgi/service/blueprint/container/CREATED";
    private static final String EVENT_FAILURE = "org/osgi/service/blueprint/container/FAILURE";
    private static final Logger LOGGER;
    private final Object monitor;
    private final List<Bundle> bundlesWithCreatedApplicationContexts;
    private final Map<Bundle, Throwable> failureMap;
    private final Map<Bundle, List<AbortableSignal>> signalMap;
    private final BundleListener bundleListener;
    private final ExecutorService signalExecutor;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;

    static {
        Factory factory = new Factory("BundleStartTracker.java", Class.forName("org.eclipse.virgo.kernel.core.internal.BundleStartTracker"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "initialize", "org.eclipse.virgo.kernel.core.internal.BundleStartTracker", "org.osgi.framework.BundleContext:", "bundleContext:", "", "void"), 79);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "recordApplicationContextCreation", "org.eclipse.virgo.kernel.core.internal.BundleStartTracker", "org.osgi.framework.Bundle:", "bundle:", "", "void"), 83);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1008", "access$0", "org.eclipse.virgo.kernel.core.internal.BundleStartTracker", "org.osgi.framework.Bundle:", "arg0:", "", "boolean"), 219);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1008", "access$1", "org.eclipse.virgo.kernel.core.internal.BundleStartTracker", "org.eclipse.virgo.kernel.core.internal.BundleStartTracker:", "arg0:", "", "java.lang.Object"), 63);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1008", "access$2", "org.eclipse.virgo.kernel.core.internal.BundleStartTracker", "org.eclipse.virgo.kernel.core.internal.BundleStartTracker:", "arg0:", "", "java.util.Map"), 69);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1008", "access$3", "org.eclipse.virgo.kernel.core.internal.BundleStartTracker", "", "", "", "org.slf4j.Logger"), 61);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1008", "access$4", "org.eclipse.virgo.kernel.core.internal.BundleStartTracker", "org.eclipse.virgo.kernel.core.internal.BundleStartTracker:java.util.List:boolean:java.lang.Throwable:", "arg0:arg1:arg2:arg3:", "", "void"), 132);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "driveSignalsIfStartCompleted", "org.eclipse.virgo.kernel.core.internal.BundleStartTracker", "org.osgi.framework.Bundle:boolean:", "bundle:springDmPowered:", "", "void"), 91);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "driveSignals", "org.eclipse.virgo.kernel.core.internal.BundleStartTracker", "java.util.List:boolean:java.lang.Throwable:", "signals:aborted:cause:", "", "void"), 132);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "handleEvent", "org.eclipse.virgo.kernel.core.internal.BundleStartTracker", "org.osgi.service.event.Event:", "event:", "", "void"), 152);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "trackStart", "org.eclipse.virgo.kernel.core.internal.BundleStartTracker", "org.osgi.framework.Bundle:org.eclipse.virgo.kernel.core.AbortableSignal:", "bundle:signal:", "", "void"), 183);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "isBundleActive", "org.eclipse.virgo.kernel.core.internal.BundleStartTracker", "org.osgi.framework.Bundle:", "bundle:", "", "boolean"), 212);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "isSpringDmPoweredBundle", "org.eclipse.virgo.kernel.core.internal.BundleStartTracker", "org.osgi.framework.Bundle:", "bundle:", "", "boolean"), 219);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "cleanup", "org.eclipse.virgo.kernel.core.internal.BundleStartTracker", "org.osgi.framework.Bundle:boolean:java.lang.Throwable:", "bundle:aborted:cause:", "", "void"), 260);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "stop", "org.eclipse.virgo.kernel.core.internal.BundleStartTracker", "", "", "", "void"), 277);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.core.internal.BundleStartTracker");
        LOGGER = LoggerFactory.getLogger(BundleStartTracker.class);
    }

    BundleStartTracker(ExecutorService signalExecutor) {
        try {
            try {
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            this.monitor = new Object();
            this.bundlesWithCreatedApplicationContexts = new ArrayList<Bundle>();
            this.failureMap = new HashMap<Bundle, Throwable>();
            this.signalMap = new HashMap<Bundle, List<AbortableSignal>>();
            this.bundleListener = new StartupTrackerBundleListener(this, null);
            this.signalExecutor = signalExecutor;
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    void initialize(BundleContext bundleContext) {
        try {
            BundleStartTracker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_0);
            try {
                bundleContext.addBundleListener(this.bundleListener);
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            BundleStartTracker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_0);
            return;
        }
        catch (Throwable throwable) {
            BundleStartTracker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordApplicationContextCreation(Bundle bundle) {
        try {
            BundleStartTracker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_1);
            try {
                LOGGER.info("Recording created application context for bundle '{}'", (Object)bundle);
                Object object = this.monitor;
                synchronized (object) {
                    this.bundlesWithCreatedApplicationContexts.add(bundle);
                }
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            BundleStartTracker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_1);
            return;
        }
        catch (Throwable throwable) {
            BundleStartTracker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_1);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void driveSignalsIfStartCompleted(Bundle bundle, boolean springDmPowered) {
        try {
            BundleStartTracker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_2);
            try {
                List<AbortableSignal> signals = null;
                Throwable failure = null;
                boolean isActive = BundleStartTracker.isBundleActive(bundle);
                Object object = this.monitor;
                synchronized (object) {
                    if (springDmPowered) {
                        boolean created = this.bundlesWithCreatedApplicationContexts.contains(bundle);
                        failure = this.failureMap.get(bundle);
                        if (created && failure != null) {
                            throw new IllegalStateException("Spring DM has notified an application context both successfully constructed and failed: " + failure);
                        }
                        if (created) {
                            LOGGER.info("Bundle '{}' has started and its application context is available", (Object)bundle);
                            signals = this.signalMap.remove(bundle);
                        } else if (failure != null) {
                            LOGGER.info("Bundle '{}' failed to start, the failure was '{}'", (Object)bundle, (Object)failure);
                            signals = this.signalMap.remove(bundle);
                        }
                    } else if (isActive) {
                        signals = this.signalMap.remove(bundle);
                    }
                }
                if (signals != null) {
                    if (!springDmPowered && isActive) {
                        LOGGER.info("Non-Spring DM powered bundle '{}' has started. Driving signals '{}'.", (Object)bundle, signals);
                        this.driveSignals(signals, false, null);
                    } else {
                        this.driveSignals(signals, false, failure);
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            BundleStartTracker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_2);
            return;
        }
        catch (Throwable throwable) {
            BundleStartTracker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_2);
            throw throwable;
        }
    }

    private void driveSignals(final List<AbortableSignal> signals, final boolean aborted, final Throwable cause) {
        try {
            BundleStartTracker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_3);
            try {
                this.signalExecutor.execute(new Runnable(){
                    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
                    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
                    {
                        try {
                            try {
                            }
                            catch (RuntimeException runtimeException) {
                                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                                throw runtimeException;
                            }
                            return;
                        }
                        catch (RuntimeException runtimeException) {
                            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                            throw runtimeException;
                        }
                    }

                    @Override
                    public void run() {
                        try {
                            1.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
                            try {
                                for (AbortableSignal signal : signals) {
                                    BundleStartTracker.access$3().info("Driving signal '{}'", (Object)signal);
                                    if (aborted) {
                                        signal.signalAborted();
                                        continue;
                                    }
                                    if (cause == null) {
                                        signal.signalSuccessfulCompletion();
                                        continue;
                                    }
                                    signal.signalFailure(cause);
                                }
                            }
                            catch (RuntimeException runtimeException) {
                                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                                throw runtimeException;
                            }
                            1.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
                            return;
                        }
                        catch (Throwable throwable) {
                            1.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
                            throw throwable;
                        }
                    }

                    static {
                        Factory factory = new Factory("BundleStartTracker.java", Class.forName("org.eclipse.virgo.kernel.core.internal.BundleStartTracker$1"));
                        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "run", "org.eclipse.virgo.kernel.core.internal.BundleStartTracker$1", "", "", "", "void"), 134);
                        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.core.internal.BundleStartTracker$1");
                    }
                });
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            BundleStartTracker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_3);
            return;
        }
        catch (Throwable throwable) {
            BundleStartTracker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_3);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(Event event) {
        try {
            BundleStartTracker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_4);
            try {
                LOGGER.info("Handling event '{}'", (Object)event);
                Throwable cause = null;
                List<AbortableSignal> signals = null;
                Bundle bundle = (Bundle)event.getProperty("bundle");
                if (EVENT_FAILURE.equals(event.getTopic())) {
                    cause = (Throwable)event.getProperty("exception");
                    if (cause != null) {
                        Object object = this.monitor;
                        synchronized (object) {
                            LOGGER.error("Recording application context construction failure '{}' for bundle '{}'", (Object)cause, (Object)bundle);
                            this.failureMap.put(bundle, cause);
                            signals = this.signalMap.remove(bundle);
                        }
                    }
                } else if (EVENT_CREATED.equals(event.getTopic())) {
                    Object object = this.monitor;
                    synchronized (object) {
                        this.recordApplicationContextCreation(bundle);
                        signals = this.signalMap.remove(bundle);
                    }
                } else if (EVENT_REGION_STARTING.equals(event.getTopic())) {
                    this.initialize((BundleContext)event.getProperty("region.bundleContext"));
                }
                if (signals != null) {
                    this.driveSignals(signals, false, cause);
                }
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            BundleStartTracker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_4);
            return;
        }
        catch (Throwable throwable) {
            BundleStartTracker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_4);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trackStart(Bundle bundle, AbortableSignal signal) {
        try {
            BundleStartTracker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_5);
            try {
                if (BundleUtils.isFragmentBundle(bundle)) {
                    throw new IllegalArgumentException("Cannot track the start of a fragment bundle.");
                }
                boolean springDmPowered = BundleStartTracker.isSpringDmPoweredBundle(bundle);
                boolean bundleActive = BundleStartTracker.isBundleActive(bundle);
                if (signal != null) {
                    if (springDmPowered || !bundleActive) {
                        Object object = this.monitor;
                        synchronized (object) {
                            List<AbortableSignal> queue = this.signalMap.get(bundle);
                            if (queue == null) {
                                queue = new ArrayList<AbortableSignal>();
                                this.signalMap.put(bundle, queue);
                            }
                            LOGGER.info("Adding signal '{}' for bundle '{}'", (Object)signal, (Object)bundle);
                            queue.add(signal);
                        }
                    } else {
                        this.driveSignals(Arrays.asList(signal), false, null);
                    }
                }
                this.driveSignalsIfStartCompleted(bundle, springDmPowered);
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            BundleStartTracker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_5);
            return;
        }
        catch (Throwable throwable) {
            BundleStartTracker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_5);
            throw throwable;
        }
    }

    private static boolean isBundleActive(Bundle bundle) {
        try {
            boolean bl;
            BundleStartTracker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_6);
            try {
                bl = bundle != null ? bundle.getState() == 32 : false;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            BundleStartTracker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_6);
            return bl;
        }
        catch (Throwable throwable) {
            BundleStartTracker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_6);
            throw throwable;
        }
    }

    private static boolean isSpringDmPoweredBundle(Bundle bundle) {
        try {
            boolean bl;
            BundleStartTracker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_7);
            try {
                bl = SpringUtils.isSpringDMPoweredBundle(bundle);
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            BundleStartTracker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_7);
            return bl;
        }
        catch (Throwable throwable) {
            BundleStartTracker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_7);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup(Bundle bundle, boolean aborted, Throwable cause) {
        try {
            BundleStartTracker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_8);
            try {
                List<AbortableSignal> danglingSignals = null;
                Object object = this.monitor;
                synchronized (object) {
                    if (bundle != null) {
                        this.bundlesWithCreatedApplicationContexts.remove(bundle);
                        this.failureMap.remove(bundle);
                        danglingSignals = this.signalMap.remove(bundle);
                    }
                }
                if (danglingSignals != null) {
                    this.driveSignals(danglingSignals, aborted, cause);
                }
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            BundleStartTracker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_8);
            return;
        }
        catch (Throwable throwable) {
            BundleStartTracker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_8);
            throw throwable;
        }
    }

    public void stop() {
        try {
            BundleStartTracker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_9);
            try {
                this.signalExecutor.shutdownNow();
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            BundleStartTracker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_9);
            return;
        }
        catch (Throwable throwable) {
            BundleStartTracker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_9);
            throw throwable;
        }
    }

    static /* synthetic */ boolean access$0(Bundle arg0) {
        try {
            boolean bl;
            BundleStartTracker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_10);
            try {
                bl = BundleStartTracker.isSpringDmPoweredBundle(arg0);
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            BundleStartTracker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_10);
            return bl;
        }
        catch (Throwable throwable) {
            BundleStartTracker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_10);
            throw throwable;
        }
    }

    static /* synthetic */ Object access$1(BundleStartTracker arg0) {
        try {
            Object object;
            BundleStartTracker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_11);
            try {
                object = arg0.monitor;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            BundleStartTracker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_11);
            return object;
        }
        catch (Throwable throwable) {
            BundleStartTracker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_11);
            throw throwable;
        }
    }

    static /* synthetic */ Map access$2(BundleStartTracker arg0) {
        try {
            Map<Bundle, List<AbortableSignal>> map;
            BundleStartTracker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_12);
            try {
                map = arg0.signalMap;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            BundleStartTracker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_12);
            return map;
        }
        catch (Throwable throwable) {
            BundleStartTracker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_12);
            throw throwable;
        }
    }

    static /* synthetic */ Logger access$3() {
        try {
            Logger logger;
            BundleStartTracker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_13);
            try {
                logger = LOGGER;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            BundleStartTracker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_13);
            return logger;
        }
        catch (Throwable throwable) {
            BundleStartTracker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_13);
            throw throwable;
        }
    }

    static /* synthetic */ void access$4(BundleStartTracker arg0, List arg1, boolean arg2, Throwable arg3) {
        try {
            BundleStartTracker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_14);
            try {
                arg0.driveSignals(arg1, arg2, arg3);
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            BundleStartTracker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_14);
            return;
        }
        catch (Throwable throwable) {
            BundleStartTracker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_14);
            throw throwable;
        }
    }

    private final class StartupTrackerBundleListener
    implements SynchronousBundleListener {
        private Boolean isLazyBundle;
        final /* synthetic */ BundleStartTracker this$0;
        private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        private StartupTrackerBundleListener(BundleStartTracker bundleStartTracker) {
            this.this$0 = bundleStartTracker;
            try {
                try {
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
                try {
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
                try {
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
                this.isLazyBundle = false;
                return;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void bundleChanged(BundleEvent event) {
            try {
                StartupTrackerBundleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
                try {
                    Bundle bundle = event.getBundle();
                    if (event.getType() == 2) {
                        List signals = null;
                        if (!BundleStartTracker.access$0(bundle)) {
                            Object object = BundleStartTracker.access$1(this.this$0);
                            synchronized (object) {
                                signals = (List)BundleStartTracker.access$2(this.this$0).remove(bundle);
                            }
                            if (signals != null) {
                                BundleStartTracker.access$3().info("Non-Spring DM powered bundle '{}' has started. Driving signals '{}'.", (Object)bundle, (Object)signals);
                                BundleStartTracker.access$4(this.this$0, signals, false, null);
                            }
                        }
                    }
                    if (event.getType() == 512) {
                        this.isLazyBundle = true;
                        BundleStartTracker.access$3().info("Bundle '{}' has lazy activation and is in the starting state.", (Object)bundle);
                    }
                    if (event.getType() == 4) {
                        BundleStartTracker.access$3().info("Bundle '{}' has stopped. Removing its related tracking state.", (Object)bundle);
                        this.this$0.cleanup(bundle, this.isLazyBundle, this.isLazyBundle != false ? null : new RuntimeException("Bundle '" + bundle + "' stopped"));
                    }
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
                StartupTrackerBundleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
                return;
            }
            catch (Throwable throwable) {
                StartupTrackerBundleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
                throw throwable;
            }
        }

        /* synthetic */ StartupTrackerBundleListener(BundleStartTracker bundleStartTracker, StartupTrackerBundleListener startupTrackerBundleListener) {
            BundleStartTracker bundleStartTracker2 = bundleStartTracker;
            StartupTrackerBundleListener ajc$aspectInstance = this;
            ajc$aspectInstance.this$0 = bundleStartTracker2;
            try {
                try {
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
                try {
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
                try {
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
                ajc$aspectInstance.isLazyBundle = false;
                return;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        static {
            Factory factory = new Factory("BundleStartTracker.java", Class.forName("org.eclipse.virgo.kernel.core.internal.BundleStartTracker$StartupTrackerBundleListener"));
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "bundleChanged", "org.eclipse.virgo.kernel.core.internal.BundleStartTracker$StartupTrackerBundleListener", "org.osgi.framework.BundleEvent:", "event:", "", "void"), 230);
            ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.core.internal.BundleStartTracker$StartupTrackerBundleListener");
        }
    }
}

