/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.util.osgi.manifest.internal;

import org.eclipse.virgo.util.osgi.VersionRange;
import org.eclipse.virgo.util.osgi.manifest.FragmentHost;
import org.eclipse.virgo.util.osgi.manifest.internal.BaseParameterised;
import org.eclipse.virgo.util.osgi.manifest.parse.HeaderDeclaration;
import org.eclipse.virgo.util.osgi.manifest.parse.HeaderParser;

class StandardFragmentHost
extends BaseParameterised
implements FragmentHost {
    StandardFragmentHost(HeaderParser parser) {
        super(parser);
    }

    HeaderDeclaration parse(HeaderParser parser, String parseString) {
        return parser.parseFragmentHostHeader(parseString);
    }

    public String getBundleSymbolicName() {
        return this.name;
    }

    public FragmentHost.Extension getExtension() {
        String value = this.getDirectives().get("extension");
        if ("bootclasspath".equals(value)) {
            return FragmentHost.Extension.BOOTCLASSPATH;
        }
        if ("framework".equals(value)) {
            return FragmentHost.Extension.FRAMEWORK;
        }
        return null;
    }

    public void setBundleSymbolicName(String hostName) {
        this.name = hostName;
    }

    public void setExtension(FragmentHost.Extension extension) {
        if (extension == null) {
            this.getDirectives().remove("extension");
            return;
        }
        switch (extension) {
            case BOOTCLASSPATH: {
                this.getDirectives().put("extension", "bootclasspath");
                break;
            }
            case FRAMEWORK: {
                this.getDirectives().put("extension", "framework");
            }
        }
    }

    public VersionRange getBundleVersion() {
        return new VersionRange(this.getAttributes().get("bundle-version"));
    }

    public void setBundleVersion(VersionRange versionRange) {
        if (versionRange == null) {
            this.getAttributes().remove("bundle-version");
        } else {
            this.getAttributes().put("bundle-version", versionRange.toParseString());
        }
    }
}

