/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.service.exporter.support.internal.support;

import java.util.Dictionary;
import java.util.Map;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.springframework.osgi.service.exporter.OsgiServiceRegistrationListener;
import org.springframework.osgi.util.OsgiServiceReferenceUtils;
import org.springframework.util.Assert;

public class ServiceRegistrationDecorator
implements ServiceRegistration {
    private final ServiceRegistration delegate;
    private final OsgiServiceRegistrationListener[] listeners;
    private final Object service;

    public ServiceRegistrationDecorator(Object service, ServiceRegistration registration, OsgiServiceRegistrationListener[] listeners) {
        Assert.notNull((Object)registration);
        this.delegate = registration;
        this.listeners = listeners == null ? new OsgiServiceRegistrationListener[]{} : listeners;
        this.service = service;
    }

    public ServiceReference getReference() {
        return this.delegate.getReference();
    }

    public void setProperties(Dictionary properties) {
        this.delegate.setProperties(properties);
    }

    public void unregister() {
        Map properties = (Map)((Object)OsgiServiceReferenceUtils.getServicePropertiesSnapshot(this.delegate.getReference()));
        this.delegate.unregister();
        for (int i = 0; i < this.listeners.length; ++i) {
            if (this.listeners[i] == null) continue;
            try {
                this.listeners[i].unregistered(this.service, properties);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String toString() {
        return "ServiceRegistrationWrapper for " + this.delegate.toString();
    }
}

