/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.dse.api.strategy.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.PriorityQueue;
import org.apache.log4j.Logger;
import org.eclipse.viatra.dse.api.strategy.interfaces.IStrategy;
import org.eclipse.viatra.dse.base.ThreadContext;
import org.eclipse.viatra.dse.objectives.Fitness;
import org.eclipse.viatra.dse.objectives.ObjectiveComparatorHelper;
import org.eclipse.viatra.dse.solutionstore.SolutionStore;

public class BestFirstStrategy
implements IStrategy {
    private ThreadContext context;
    private SolutionStore solutionStore;
    private int maxDepth;
    private boolean isInterrupted = false;
    private boolean backTrackIfSolution = true;
    private boolean onlyBetterFirst = false;
    private PriorityQueue<TrajectoryWithFitness> trajectoiresToExplore;
    private Logger logger = Logger.getLogger(IStrategy.class);

    public BestFirstStrategy() {
        this(-1);
    }

    public BestFirstStrategy(int maxDepth) {
        this.maxDepth = maxDepth < 0 ? Integer.MAX_VALUE : maxDepth;
    }

    public BestFirstStrategy continueIfHardObjectivesFulfilled() {
        this.backTrackIfSolution = false;
        return this;
    }

    public BestFirstStrategy goOnOnlyIfFitnessIsBetter() {
        this.onlyBetterFirst = true;
        return this;
    }

    @Override
    public void initStrategy(ThreadContext context) {
        this.context = context;
        this.solutionStore = context.getGlobalContext().getSolutionStore();
        ObjectiveComparatorHelper objectiveComparatorHelper = context.getObjectiveComparatorHelper();
        this.trajectoiresToExplore = new PriorityQueue(11, (o1, o2) -> objectiveComparatorHelper.compare(o2.fitness, o1.fitness));
    }

    @Override
    public void explore() {
        ObjectiveComparatorHelper objectiveComparatorHelper = this.context.getObjectiveComparatorHelper();
        boolean globalConstraintsAreSatisfied = this.context.checkGlobalConstraints();
        if (!globalConstraintsAreSatisfied) {
            this.logger.info((Object)"Global contraint is not satisifed in the first state. Terminate.");
            return;
        }
        Fitness firstFittness = this.context.calculateFitness();
        if (firstFittness.isSatisifiesHardObjectives()) {
            this.context.newSolution();
            this.logger.info((Object)"First state is a solution. Terminate.");
            return;
        }
        if (this.maxDepth == 0) {
            return;
        }
        Object[] firstTrajectory = this.context.getTrajectory().toArray(new Object[0]);
        TrajectoryWithFitness currentTrajectoryWithFittness = new TrajectoryWithFitness(firstTrajectory, firstFittness);
        this.trajectoiresToExplore.add(currentTrajectoryWithFittness);
        block0: while (!this.isInterrupted) {
            if (currentTrajectoryWithFittness == null) {
                if (this.trajectoiresToExplore.isEmpty()) {
                    this.logger.debug((Object)"State space is fully traversed.");
                    return;
                }
                currentTrajectoryWithFittness = (TrajectoryWithFitness)this.trajectoiresToExplore.element();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("New trajectory is chosen: " + String.valueOf(currentTrajectoryWithFittness)));
                }
                this.context.getDesignSpaceManager().executeTrajectoryWithMinimalBacktrackWithoutStateCoding(currentTrajectoryWithFittness.trajectory);
            }
            Collection<Object> activationIds = this.context.getUntraversedActivationIds();
            Iterator<Object> iterator = activationIds.iterator();
            while (!this.isInterrupted && iterator.hasNext()) {
                Object nextActivation = iterator.next();
                if (!iterator.hasNext()) {
                    this.logger.debug((Object)"Last untraversed activation of the state.");
                    this.trajectoiresToExplore.remove(currentTrajectoryWithFittness);
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Executing new activation: " + String.valueOf(nextActivation)));
                }
                this.context.executeAcitvationId(nextActivation);
                if (this.context.isCurrentStateAlreadyTraversed()) {
                    this.logger.info((Object)"The new state is already visited.");
                    this.context.backtrack();
                    continue;
                }
                if (!this.context.checkGlobalConstraints()) {
                    this.logger.debug((Object)"Global contraint is not satisifed.");
                    this.context.backtrack();
                    continue;
                }
                Fitness nextFitness = this.context.calculateFitness();
                if (nextFitness.isSatisifiesHardObjectives()) {
                    this.solutionStore.newSolution(this.context);
                    this.logger.debug((Object)"Found a solution.");
                    if (this.backTrackIfSolution) {
                        this.context.backtrack();
                        continue;
                    }
                }
                if (this.context.getDepth() >= this.maxDepth) {
                    this.logger.debug((Object)"Reached max depth.");
                    this.context.backtrack();
                    continue;
                }
                TrajectoryWithFitness nextTrajectoryWithFittness = new TrajectoryWithFitness(this.context.getTrajectory().toArray(), nextFitness);
                this.trajectoiresToExplore.add(nextTrajectoryWithFittness);
                int compare = objectiveComparatorHelper.compare(currentTrajectoryWithFittness.fitness, nextTrajectoryWithFittness.fitness);
                if (compare < 0) {
                    this.logger.debug((Object)("Better fitness, moving on: " + String.valueOf(nextFitness)));
                    currentTrajectoryWithFittness = nextTrajectoryWithFittness;
                    continue block0;
                }
                if (compare == 0) {
                    if (this.onlyBetterFirst) {
                        this.logger.debug((Object)("Equally good fitness, backtrack: " + String.valueOf(nextFitness)));
                        this.context.backtrack();
                        continue;
                    }
                    this.logger.debug((Object)("Equally good fitness, moving on: " + String.valueOf(nextFitness)));
                    currentTrajectoryWithFittness = nextTrajectoryWithFittness;
                    continue block0;
                }
                this.logger.debug((Object)"Worse fitness.");
                currentTrajectoryWithFittness = null;
                continue block0;
            }
            this.logger.debug((Object)"State is fully traversed.");
            this.trajectoiresToExplore.remove(currentTrajectoryWithFittness);
            currentTrajectoryWithFittness = null;
        }
        this.logger.info((Object)"Interrupted.");
    }

    @Override
    public void interruptStrategy() {
        this.isInterrupted = true;
    }

    private static class TrajectoryWithFitness {
        public Object[] trajectory;
        public Fitness fitness;

        public TrajectoryWithFitness(Object[] trajectory, Fitness fitness) {
            this.trajectory = trajectory;
            this.fitness = fitness;
        }

        public String toString() {
            return Arrays.toString(this.trajectory) + this.fitness.toString();
        }
    }
}

