/**
 * Copyright (c) 2010-2015, Balázs Grill, Istvan Rath and Daniel Varro
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-v20.html.
 * 
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.viatra.query.testing.core;

import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;

/**
 * @author Grill Balázs
 */
@SuppressWarnings("all")
public class TestingSeverityAggregatorLogAppender extends AppenderSkeleton {
  private Level severity = Level.INFO;

  private final Level minReportSeverity = Level.ERROR;

  private LoggingEvent event;

  @Override
  public void close() {
  }

  public void clear() {
    this.severity = Level.INFO;
  }

  @Override
  public boolean requiresLayout() {
    return false;
  }

  @Override
  protected void append(final LoggingEvent event) {
    final Level eventLevel = event.getLevel();
    int _int = this.severity.toInt();
    int _int_1 = eventLevel.toInt();
    boolean _lessThan = (_int < _int_1);
    if (_lessThan) {
      this.severity = eventLevel;
      this.event = event;
    }
  }

  public LoggingEvent getEvent() {
    return this.event;
  }

  /**
   * @since 2.0
   */
  public String getOutput() {
    String _xifexpression = null;
    boolean _isGreaterOrEqual = this.event.getLevel().isGreaterOrEqual(this.minReportSeverity);
    if (_isGreaterOrEqual) {
      _xifexpression = "";
    } else {
      _xifexpression = this.layout.format(this.event);
    }
    return _xifexpression;
  }

  public Level getSeverity() {
    return this.severity;
  }
}
