/**
 * Copyright (c) 2010-2012, Zoltan Ujhelyi, Istvan Rath and Daniel Varro
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-v20.html.
 * 
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.viatra.query.tooling.core.generator;

import org.eclipse.viatra.query.tooling.core.project.XmlDocumentHelper;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions.Function0;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@SuppressWarnings("all")
public class ExtensionGenerator {
  private Document document = new Function0<Document>() {
    @Override
    public Document apply() {
      try {
        Document _emptyXmlDocument = XmlDocumentHelper.getEmptyXmlDocument();
        return _emptyXmlDocument;
      } catch (Throwable _e) {
        throw Exceptions.sneakyThrow(_e);
      }
    }
  }.apply();

  public ExtensionData contribExtension(final String id, final String point, final Procedure1<? super Element> initializer) {
    ExtensionData _xblockexpression = null;
    {
      final Element ex = this.document.createElement("extension");
      ex.setAttribute("id", id);
      ex.setAttribute("point", point);
      this.<Element>init(ex, initializer);
      ex.normalize();
      _xblockexpression = new ExtensionData(ex);
    }
    return _xblockexpression;
  }

  public Element contribElement(final Element parent, final String name, final Procedure1<? super Element> initializer) {
    Element _xblockexpression = null;
    {
      final Element el = this.document.createElement(name);
      parent.appendChild(el);
      _xblockexpression = this.<Element>init(el, initializer);
    }
    return _xblockexpression;
  }

  public void contribAttribute(final Element element, final String name, final String value) {
    element.setAttribute(name, value);
  }

  private <T extends Object> T init(final T obj, final Procedure1<? super T> init) {
    init.apply(obj);
    return obj;
  }
}
