/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.psystem.rewriters;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.viatra.query.runtime.matchers.psystem.IExpressionEvaluator;
import org.eclipse.viatra.query.runtime.matchers.psystem.IValueProvider;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;

class VariableMappingExpressionEvaluatorWrapper
implements IExpressionEvaluator {
    private final IExpressionEvaluator wrapped;
    private final Map<String, String> variableMapping;

    public VariableMappingExpressionEvaluatorWrapper(IExpressionEvaluator wrapped, Map<PVariable, PVariable> variableMapping) {
        boolean rewrap = wrapped instanceof VariableMappingExpressionEvaluatorWrapper;
        this.wrapped = rewrap ? ((VariableMappingExpressionEvaluatorWrapper)wrapped).wrapped : wrapped;
        this.variableMapping = new LinkedHashMap<String, String>();
        HashMap<String, PVariable> names = new HashMap<String, PVariable>();
        for (PVariable originalVar : variableMapping.keySet()) {
            names.put(originalVar.getName(), originalVar);
        }
        Map<String, String> previousMapping = null;
        if (rewrap) {
            previousMapping = ((VariableMappingExpressionEvaluatorWrapper)wrapped).variableMapping;
        }
        for (String inputParameterName : this.wrapped.getInputParameterNames()) {
            String parameterName = rewrap ? previousMapping.get(inputParameterName) : inputParameterName;
            Preconditions.checkArgument(parameterName != null);
            PVariable original = (PVariable)names.get(parameterName);
            Preconditions.checkArgument(original != null);
            PVariable mapped = variableMapping.get(original);
            if (mapped == null) continue;
            this.variableMapping.put(inputParameterName, mapped.getName());
        }
    }

    @Override
    public String getShortDescription() {
        return this.wrapped.getShortDescription();
    }

    @Override
    public Iterable<String> getInputParameterNames() {
        return this.variableMapping.values();
    }

    @Override
    public Object evaluateExpression(IValueProvider provider) throws Exception {
        return this.wrapped.evaluateExpression(variableName -> {
            String mappedVariableName = this.variableMapping.get(variableName);
            Preconditions.checkArgument(mappedVariableName != null, "Could not find variable %s", variableName);
            return provider.getValue(mappedVariableName);
        });
    }
}

