/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.util;

import java.util.Collections;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.util.Clearable;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.matchers.util.Direction;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;
import org.eclipse.viatra.query.runtime.matchers.util.Signed;
import org.eclipse.viatra.query.runtime.matchers.util.resumable.UnmaskedResumable;
import org.eclipse.viatra.query.runtime.matchers.util.timeline.Diff;
import org.eclipse.viatra.query.runtime.matchers.util.timeline.Timeline;
import org.eclipse.viatra.query.runtime.matchers.util.timeline.Timelines;

public class TimelyMemory<Timestamp extends Comparable<Timestamp>>
implements Clearable,
UnmaskedResumable<Timestamp> {
    protected final Map<Tuple, TreeMap<Timestamp, CumulativeCounter>> counters;
    protected final Map<Tuple, Timeline<Timestamp>> timelines;
    public final TreeMap<Timestamp, Map<Tuple, FoldingState>> foldingState;
    protected final Set<Tuple> presentAtInfinity;
    protected final boolean isLazy;
    protected final Diff<Timestamp> EMPTY_DIFF = new Diff();

    public TimelyMemory() {
        this(false);
    }

    public TimelyMemory(boolean isLazy) {
        this.counters = CollectionsFactory.createMap();
        this.timelines = CollectionsFactory.createMap();
        this.presentAtInfinity = CollectionsFactory.createSet();
        this.isLazy = isLazy;
        this.foldingState = isLazy ? CollectionsFactory.createTreeMap() : null;
    }

    public Set<Tuple> getResumableTuples() {
        if (this.foldingState == null || this.foldingState.isEmpty()) {
            return Collections.emptySet();
        }
        return this.foldingState.firstEntry().getValue().keySet();
    }

    @Override
    public Timestamp getResumableTimestamp() {
        if (this.foldingState == null || this.foldingState.isEmpty()) {
            return null;
        }
        return (Timestamp)((Comparable)this.foldingState.firstKey());
    }

    protected void addFoldingState(Tuple tuple, FoldingState state, Timestamp timestamp) {
        assert (state.diff != 0);
        Map tupleMap = this.foldingState.computeIfAbsent(timestamp, k -> CollectionsFactory.createMap());
        tupleMap.compute(tuple, (k, v) -> v == null ? state : v.merge(state));
    }

    @Override
    public Map<Tuple, Diff<Timestamp>> resumeAt(Timestamp timestamp) {
        Timestamp current = this.getResumableTimestamp();
        if (current == null) {
            throw new IllegalStateException("There is othing to fold!");
        }
        if (current.compareTo(timestamp) != 0) {
            while (current != null && current.compareTo(timestamp) < 0) {
                Map<Tuple, FoldingState> tupleMap = this.foldingState.remove(current);
                for (Map.Entry<Tuple, FoldingState> entry : tupleMap.entrySet()) {
                    Tuple key = entry.getKey();
                    FoldingState value = entry.getValue();
                    if (value.diff != 0) {
                        throw new IllegalStateException("Expected zero diff during garbage collection at " + current + ", but the diff was " + value.diff + "!");
                    }
                    this.doFoldingStep(key, value, current);
                }
                current = this.getResumableTimestamp();
            }
            if (current == null || current.compareTo(timestamp) != 0) {
                throw new IllegalStateException("Expected to continue folding at " + timestamp + "!");
            }
        }
        Map<Tuple, Diff<Timestamp>> diffMap = CollectionsFactory.createMap();
        Map<Tuple, FoldingState> tupleMap = this.foldingState.remove(timestamp);
        for (Map.Entry<Tuple, FoldingState> entry : tupleMap.entrySet()) {
            Tuple key = entry.getKey();
            FoldingState value = entry.getValue();
            diffMap.put(key, this.doFoldingStep(key, value, timestamp));
        }
        if (this.foldingState.get(timestamp) != null) {
            throw new IllegalStateException("Folding at " + timestamp + " produced more folding work at the same timestamp!");
        }
        return diffMap;
    }

    protected Diff<Timestamp> doFoldingStep(Tuple tuple, FoldingState state, Timestamp timestamp) {
        CumulativeCounter counter = this.getCounter(tuple, timestamp);
        if (state.diff == 0) {
            this.gcCounters(counter, tuple, timestamp);
            return this.EMPTY_DIFF;
        }
        Diff resultDiff = new Diff();
        Comparable nextTimestamp = (Comparable)this.counters.get(tuple).higherKey(timestamp);
        int oldCumulative = counter.cumulative;
        counter.cumulative += state.diff;
        this.computeDiffsLazy(state.diff < 0 ? Direction.DELETE : Direction.INSERT, oldCumulative, counter.cumulative, timestamp, nextTimestamp, resultDiff);
        this.gcCounters(counter, tuple, timestamp);
        this.updateTimeline(tuple, resultDiff);
        if (nextTimestamp != null) {
            this.addFoldingState(tuple, new FoldingState(state.diff), nextTimestamp);
        }
        return resultDiff;
    }

    protected CumulativeCounter getCounter(Tuple tuple, Timestamp timestamp) {
        TreeMap counterTimeline = this.counters.computeIfAbsent(tuple, k -> CollectionsFactory.createTreeMap());
        CumulativeCounter counter = counterTimeline.computeIfAbsent(timestamp, k -> {
            Map.Entry previousCounter = counterTimeline.lowerEntry(k);
            int previousCumulative = previousCounter == null ? 0 : ((CumulativeCounter)previousCounter.getValue()).cumulative;
            return new CumulativeCounter(0, previousCumulative);
        });
        return counter;
    }

    protected void gcCounters(CumulativeCounter counter, Tuple tuple, Timestamp timestamp) {
        if (counter.diff == 0) {
            TreeMap<Timestamp, CumulativeCounter> counterMap = this.counters.get(tuple);
            counterMap.remove(timestamp);
            if (counterMap.isEmpty()) {
                this.counters.remove(tuple);
            }
        }
    }

    protected void computeDiffsLazy(Direction direction, int oldCumulative, int newCumulative, Timestamp timestamp, Timestamp nextTimestamp, Diff<Timestamp> diffs) {
        if (direction == Direction.INSERT) {
            if (newCumulative == 0) {
                throw new IllegalStateException("Cumulative count can never be negative!");
            }
            if (oldCumulative == 0) {
                diffs.add(new Signed<Timestamp>(Direction.INSERT, timestamp));
                if (nextTimestamp != null) {
                    diffs.add(new Signed<Timestamp>(Direction.DELETE, nextTimestamp));
                }
            }
        } else {
            if (newCumulative < 0) {
                throw new IllegalStateException("Cumulative count can never be negative!");
            }
            if (newCumulative == 0) {
                diffs.add(new Signed<Timestamp>(Direction.DELETE, timestamp));
                if (nextTimestamp != null) {
                    diffs.add(new Signed<Timestamp>(Direction.INSERT, nextTimestamp));
                }
            }
        }
    }

    protected SignChange computeDiffsEager(Direction direction, CumulativeCounter counter, SignChange signChangeAtPrevious, Timestamp timestamp, Diff<Timestamp> diffs) {
        if (direction == Direction.INSERT) {
            if (counter.cumulative == 0) {
                throw new IllegalStateException("Cumulative count can never be negative!");
            }
            if (counter.cumulative == 1) {
                if (signChangeAtPrevious == SignChange.BECAME_POSITIVE) {
                    throw new IllegalStateException("This would mean that the diff at current is 0 " + counter.diff);
                }
                diffs.add(new Signed<Timestamp>(Direction.INSERT, timestamp));
                return SignChange.BECAME_POSITIVE;
            }
            if (signChangeAtPrevious == SignChange.BECAME_POSITIVE) {
                diffs.add(new Signed<Timestamp>(Direction.DELETE, timestamp));
            }
            return SignChange.IRRELEVANT;
        }
        if (counter.cumulative < 0) {
            throw new IllegalStateException("Cumulative count can never be negative!");
        }
        if (counter.cumulative == 0) {
            if (signChangeAtPrevious == SignChange.BECAME_ZERO) {
                throw new IllegalStateException("This would mean that the diff at current is 0 " + counter.diff);
            }
            diffs.add(new Signed<Timestamp>(Direction.DELETE, timestamp));
            return SignChange.BECAME_ZERO;
        }
        if (signChangeAtPrevious == SignChange.BECAME_ZERO) {
            diffs.add(new Signed<Timestamp>(Direction.INSERT, timestamp));
        }
        return SignChange.IRRELEVANT;
    }

    public Diff<Timestamp> put(Tuple tuple, Timestamp timestamp) {
        if (this.isLazy) {
            return this.putLazy(tuple, timestamp);
        }
        return this.putEager(tuple, timestamp);
    }

    public Diff<Timestamp> remove(Tuple tuple, Timestamp timestamp) {
        if (this.isLazy) {
            return this.removeLazy(tuple, timestamp);
        }
        return this.removeEager(tuple, timestamp);
    }

    protected Diff<Timestamp> putEager(Tuple tuple, Timestamp timestamp) {
        Diff resultDiff = new Diff();
        CumulativeCounter counter = this.getCounter(tuple, timestamp);
        ++counter.diff;
        SignChange signChangeAtPrevious = SignChange.IRRELEVANT;
        NavigableMap<Timestamp, CumulativeCounter> nextCounters = this.counters.get(tuple).tailMap(timestamp, true);
        for (Map.Entry currentEntry : nextCounters.entrySet()) {
            Comparable currentTimestamp = (Comparable)currentEntry.getKey();
            CumulativeCounter currentCounter = (CumulativeCounter)currentEntry.getValue();
            ++currentCounter.cumulative;
            signChangeAtPrevious = this.computeDiffsEager(Direction.INSERT, currentCounter, signChangeAtPrevious, currentTimestamp, resultDiff);
        }
        this.gcCounters(counter, tuple, timestamp);
        this.updateTimeline(tuple, resultDiff);
        return resultDiff;
    }

    protected Diff<Timestamp> putLazy(Tuple tuple, Timestamp timestamp) {
        CumulativeCounter counter = this.getCounter(tuple, timestamp);
        ++counter.diff;
        this.addFoldingState(tuple, new FoldingState(1), timestamp);
        return this.EMPTY_DIFF;
    }

    protected Diff<Timestamp> removeEager(Tuple tuple, Timestamp timestamp) {
        Diff resultDiff = new Diff();
        CumulativeCounter counter = this.getCounter(tuple, timestamp);
        --counter.diff;
        SignChange signChangeAtPrevious = SignChange.IRRELEVANT;
        NavigableMap<Timestamp, CumulativeCounter> nextCounters = this.counters.get(tuple).tailMap(timestamp, true);
        for (Map.Entry currentEntry : nextCounters.entrySet()) {
            Comparable currentTimestamp = (Comparable)currentEntry.getKey();
            CumulativeCounter currentCounter = (CumulativeCounter)currentEntry.getValue();
            --currentCounter.cumulative;
            signChangeAtPrevious = this.computeDiffsEager(Direction.DELETE, currentCounter, signChangeAtPrevious, currentTimestamp, resultDiff);
        }
        this.gcCounters(counter, tuple, timestamp);
        this.updateTimeline(tuple, resultDiff);
        return resultDiff;
    }

    protected Diff<Timestamp> removeLazy(Tuple tuple, Timestamp timestamp) {
        CumulativeCounter counter = this.getCounter(tuple, timestamp);
        --counter.diff;
        this.addFoldingState(tuple, new FoldingState(-1), timestamp);
        return this.EMPTY_DIFF;
    }

    protected void updateTimeline(Tuple tuple, Diff<Timestamp> diff) {
        if (!diff.isEmpty()) {
            this.timelines.compute(tuple, (k, oldTimeline) -> {
                Timeline timeline;
                this.presentAtInfinity.remove(tuple);
                Timeline timeline2 = timeline = oldTimeline == null ? Timelines.createFrom(diff) : oldTimeline.mergeAdditive(diff);
                if (timeline.isPresentAtInfinity()) {
                    this.presentAtInfinity.add(tuple);
                }
                if (timeline.isEmpty()) {
                    return null;
                }
                return timeline;
            });
        }
    }

    public Set<Tuple> getTuplesAtInfinity() {
        return this.presentAtInfinity;
    }

    public int getCountAtInfinity() {
        return this.presentAtInfinity.size();
    }

    public boolean isPresentAtInfinity(Tuple tuple) {
        Timeline<Timestamp> timeline = this.timelines.get(tuple);
        if (timeline == null) {
            return false;
        }
        return timeline.isPresentAtInfinity();
    }

    public boolean isEmpty() {
        return this.counters.isEmpty();
    }

    public int size() {
        return this.counters.size();
    }

    public Set<Tuple> keySet() {
        return this.counters.keySet();
    }

    public Map<Tuple, Timeline<Timestamp>> asMap() {
        return this.timelines;
    }

    public Timeline<Timestamp> get(ITuple tuple) {
        return this.timelines.get(tuple);
    }

    @Override
    public void clear() {
        this.counters.clear();
        this.timelines.clear();
        if (this.foldingState != null) {
            this.foldingState.clear();
        }
    }

    public boolean containsKey(ITuple tuple) {
        return this.counters.containsKey(tuple);
    }

    public String toString() {
        return this.counters + "\n" + this.timelines + "\n" + this.foldingState + "\n";
    }

    protected static final class CumulativeCounter {
        protected int diff;
        protected int cumulative;

        protected CumulativeCounter(int diff, int cumulative) {
            this.diff = diff;
            this.cumulative = cumulative;
        }

        public String toString() {
            return "{diff=" + this.diff + ", cumulative=" + this.cumulative + "}";
        }
    }

    protected static final class FoldingState {
        protected final int diff;

        protected FoldingState(int diff) {
            this.diff = diff;
        }

        public String toString() {
            return "{diff=" + this.diff + "}";
        }

        public FoldingState merge(FoldingState that) {
            Preconditions.checkArgument(that != null);
            return new FoldingState(this.diff + that.diff);
        }
    }

    protected static enum SignChange {
        BECAME_POSITIVE,
        BECAME_ZERO,
        IRRELEVANT;

    }
}

