/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.patternlanguage.emf.sirius.util;

import com.google.inject.Injector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditor;
import org.eclipse.sirius.diagram.ui.tools.api.part.IDiagramDialectGraphicalViewer;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.viatra.query.patternlanguage.emf.scoping.IMetamodelProvider;
import org.eclipse.viatra.query.patternlanguage.emf.sirius.SiriusVQLGraphicalEditorPlugin;
import org.eclipse.viatra.query.patternlanguage.emf.sirius.util.XtextEmbeddedEditor;
import org.eclipse.viatra.query.patternlanguage.emf.ui.EMFPatternLanguageUIPlugin;
import org.eclipse.viatra.query.patternlanguage.metamodel.vgql.BooleanLiteral;
import org.eclipse.viatra.query.patternlanguage.metamodel.vgql.CompareConstraint;
import org.eclipse.viatra.query.patternlanguage.metamodel.vgql.EClassifierReference;
import org.eclipse.viatra.query.patternlanguage.metamodel.vgql.EnumValue;
import org.eclipse.viatra.query.patternlanguage.metamodel.vgql.Expression;
import org.eclipse.viatra.query.patternlanguage.metamodel.vgql.InterpretableExpression;
import org.eclipse.viatra.query.patternlanguage.metamodel.vgql.JavaClassReference;
import org.eclipse.viatra.query.patternlanguage.metamodel.vgql.Literal;
import org.eclipse.viatra.query.patternlanguage.metamodel.vgql.LocalVariable;
import org.eclipse.viatra.query.patternlanguage.metamodel.vgql.NamedElement;
import org.eclipse.viatra.query.patternlanguage.metamodel.vgql.NumberLiteral;
import org.eclipse.viatra.query.patternlanguage.metamodel.vgql.Parameter;
import org.eclipse.viatra.query.patternlanguage.metamodel.vgql.ParameterRef;
import org.eclipse.viatra.query.patternlanguage.metamodel.vgql.PathExpressionConstraint;
import org.eclipse.viatra.query.patternlanguage.metamodel.vgql.PatternPackage;
import org.eclipse.viatra.query.patternlanguage.metamodel.vgql.Reference;
import org.eclipse.viatra.query.patternlanguage.metamodel.vgql.ReferenceType;
import org.eclipse.viatra.query.patternlanguage.metamodel.vgql.StringLiteral;
import org.eclipse.viatra.query.patternlanguage.metamodel.vgql.Type;
import org.eclipse.viatra.query.patternlanguage.metamodel.vgql.VgqlFactory;
import org.eclipse.viatra.query.patternlanguage.metamodel.vgql.VgqlPackage;
import org.eclipse.viatra.query.tooling.core.project.ProjectGenerationHelper;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;

public class VGQLEditorUtil {
    private static final String UNDEFINED_TYPE_LITERAL = "\u00abUNDEFINED\u00bb";

    private VGQLEditorUtil() {
    }

    public static Reference createReference(Expression ex) {
        Reference result = VgqlFactory.eINSTANCE.createReference();
        result.setExpression(ex);
        result.setAggregator(false);
        return result;
    }

    public static void removeParameter(Parameter parameter, DDiagramElement containerView) {
        ListIterator iterator = parameter.getParameterReferences().listIterator();
        while (iterator.hasNext()) {
            ParameterRef pr = (ParameterRef)iterator.next();
            LocalVariable lv = VgqlFactory.eINSTANCE.createLocalVariable();
            lv.setName(pr.getName());
            pr.getTypes().stream().map(EcoreUtil::copy).forEach(t -> {
                boolean bl = pr.getTypes().add(t);
            });
            pr.getBody().getNodes().add((Object)lv);
            for (Reference vr : new ArrayList(pr.getReferences())) {
                vr.setExpression((Expression)lv);
                lv.getReferences().add((Object)vr);
            }
            Set<DDiagramElement> diagramElements = VGQLEditorUtil.findViewsByTarget(containerView, (EObject)pr);
            if (diagramElements.size() == 1) {
                VGQLEditorUtil.handleTargetSemanticElementChange(diagramElements.iterator().next(), (EObject)lv);
            } else {
                SiriusVQLGraphicalEditorPlugin.logError(new IllegalStateException("Not exactly one view exists for the examined parameter reference on the diagram!"));
            }
            iterator.remove();
            EcoreUtil.delete((EObject)pr);
        }
        EcoreUtil.delete((EObject)parameter);
    }

    public static void removeExpression(Expression exp) {
        ListIterator iterator = exp.getReferences().listIterator();
        while (iterator.hasNext()) {
            Reference ref = (Reference)iterator.next();
            EObject container = ref.eContainer();
            if (container instanceof PathExpressionConstraint) {
                iterator.remove();
                EcoreUtil.delete((EObject)container);
                continue;
            }
            if (!(container instanceof CompareConstraint)) continue;
            iterator.remove();
            EcoreUtil.delete((EObject)container);
        }
        EcoreUtil.delete((EObject)exp);
    }

    public static String getFirstUnusedName(String name, List<NamedElement> list) {
        int i = 0;
        boolean occupied = true;
        while (occupied) {
            occupied = VGQLEditorUtil.isNameUsed(String.valueOf(name) + ++i, list);
        }
        String nameWithIndex = String.valueOf(name) + i;
        return nameWithIndex;
    }

    private static boolean isNameUsed(String name, List<NamedElement> list) {
        return list.stream().anyMatch(el -> Objects.equals(el.getName(), name));
    }

    public static String getLiteralValueReferenceLabel(Literal lvr) {
        if (lvr instanceof NumberLiteral) {
            return ((NumberLiteral)lvr).getValue();
        }
        if (lvr instanceof StringLiteral) {
            return "\"" + ((StringLiteral)lvr).getValue() + "\"";
        }
        if (lvr instanceof BooleanLiteral) {
            return Boolean.toString(((BooleanLiteral)lvr).isValue());
        }
        if (lvr instanceof EnumValue) {
            return ((EnumValue)lvr).getLiteral().getName();
        }
        return "";
    }

    public static String getTypeLabel(Type type) {
        if (type instanceof EClassifierReference) {
            EClassifier classifier = ((EClassifierReference)type).getClassifier();
            return classifier == null ? UNDEFINED_TYPE_LITERAL : classifier.getName();
        }
        if (type instanceof ReferenceType) {
            EClassifier eType = ((ReferenceType)type).getRefname().getEType();
            return eType == null ? UNDEFINED_TYPE_LITERAL : eType.getName();
        }
        if (type instanceof JavaClassReference) {
            String fqn = ((JavaClassReference)type).getClassName();
            return fqn == null ? UNDEFINED_TYPE_LITERAL : fqn.substring(fqn.lastIndexOf(46) + 1);
        }
        return "Unknown type";
    }

    public static void openXtextEmbeddedEditor(InterpretableExpression target, EObject targetViewEObject) {
        IEditorPart editor;
        if (!(targetViewEObject instanceof DDiagramElement)) {
            SiriusVQLGraphicalEditorPlugin.logError(new IllegalArgumentException("The 'targetView' parameter must be a DDiagramElement instance!"));
        }
        if (!((editor = Optional.ofNullable(PlatformUI.getWorkbench()).map(IWorkbench::getActiveWorkbenchWindow).map(IWorkbenchWindow::getActivePage).map(IWorkbenchPage::getActiveEditor).orElseThrow(null)) instanceof SiriusDiagramEditor)) {
            SiriusVQLGraphicalEditorPlugin.logError(new IllegalStateException("The currently active editor is not a SiriusDiagramEditor instance!"));
            return;
        }
        DDiagramElement targetView = (DDiagramElement)targetViewEObject;
        SiriusDiagramEditor siriusDiagramEditor = (SiriusDiagramEditor)editor;
        DiagramEditPart diagramEditPart = siriusDiagramEditor.getDiagramEditPart();
        EditPart editPart = null;
        editPart = targetView instanceof DEdge ? diagramEditPart.findEditPart((EditPart)diagramEditPart, (EObject)((DEdge)targetView).getSourceNode()) : diagramEditPart.findEditPart((EditPart)diagramEditPart, (EObject)targetView);
        if (!(editPart instanceof IGraphicalEditPart)) {
            SiriusVQLGraphicalEditorPlugin.logError(new IllegalStateException("Can not find appropriate edit part for the target element (" + target + ")"));
            return;
        }
        XtextEmbeddedEditor embeddedEditor = new XtextEmbeddedEditor((IGraphicalEditPart)editPart, target, targetView, VGQLEditorUtil.getEMFPatternLanguageInjector(), editor);
        embeddedEditor.showEditor();
    }

    private static Set<DDiagramElement> findViewsByTarget(DDiagramElement containerView, EObject target) {
        HashSet<DDiagramElement> result = new HashSet<DDiagramElement>();
        EObject element = null;
        TreeIterator it = containerView.eAllContents();
        while (it.hasNext()) {
            element = (EObject)it.next();
            if (!(element instanceof DDiagramElement) || !VGQLEditorUtil.isDiagramElementForTarget((DDiagramElement)element, target)) continue;
            result.add((DDiagramElement)element);
        }
        return result;
    }

    public static IDiagramDialectGraphicalViewer getViewer(DDiagramElement diagramElement) {
        DDiagram representation = diagramElement.getParentDiagram();
        Session session = SessionManager.INSTANCE.getSession(((DSemanticDiagram)representation).getTarget());
        IEditingSession editingSession = SessionUIManager.INSTANCE.getUISession(session);
        SiriusDiagramEditor editor = (SiriusDiagramEditor)editingSession.getEditor((DRepresentation)representation);
        return (IDiagramDialectGraphicalViewer)editor.getDiagramGraphicalViewer();
    }

    private static void handleTargetSemanticElementChange(DDiagramElement diagramElement, EObject newValue) {
        EObject oldValue = diagramElement.getTarget();
        IDiagramDialectGraphicalViewer viewer = VGQLEditorUtil.getViewer(diagramElement);
        List editParts = viewer.findEditPartsForElement(diagramElement.getTarget(), IGraphicalEditPart.class);
        for (IGraphicalEditPart editPart : editParts) {
            viewer.unregisterEditPartForSemanticElement(oldValue, (EditPart)editPart);
        }
        diagramElement.setTarget(newValue);
        for (IGraphicalEditPart editPart : editParts) {
            viewer.registerEditPartForSemanticElement(newValue, (EditPart)editPart);
        }
    }

    private static boolean isDiagramElementForTarget(DDiagramElement diagramElement, EObject target) {
        if (diagramElement instanceof AbstractDNode) {
            return diagramElement.getTarget() != null && diagramElement.getTarget().equals(target);
        }
        if (diagramElement instanceof DEdge) {
            DEdge edge = (DEdge)diagramElement;
            return VGQLEditorUtil.isDiagramElementForTarget((DDiagramElement)edge.getSourceNode(), target) || VGQLEditorUtil.isDiagramElementForTarget((DDiagramElement)edge.getTargetNode(), target) || edge.getTarget() != null && edge.getTarget().equals(target);
        }
        return false;
    }

    private static Injector getEMFPatternLanguageInjector() {
        return EMFPatternLanguageUIPlugin.getInstance().getInjector("org.eclipse.viatra.query.patternlanguage.emf.EMFPatternLanguage");
    }

    public static Set<IEObjectDescription> getAllKnownMetamodels(EObject context) {
        IMetamodelProvider metamodelProvider = (IMetamodelProvider)VGQLEditorUtil.getEMFPatternLanguageInjector().getInstance(IMetamodelProvider.class);
        IScope metamodelScope = metamodelProvider.getAllMetamodelObjects(IScope.NULLSCOPE, context);
        TreeSet<IEObjectDescription> result = new TreeSet<IEObjectDescription>(Comparator.comparing(IEObjectDescription::getName));
        metamodelScope.getAllElements().forEach(result::add);
        return result;
    }

    public static EPackage loadEPackageDeclaration(IEObjectDescription description, EObject context) {
        IMetamodelProvider metamodelProvider = (IMetamodelProvider)VGQLEditorUtil.getEMFPatternLanguageInjector().getInstance(IMetamodelProvider.class);
        IWorkspace workspace = (IWorkspace)VGQLEditorUtil.getEMFPatternLanguageInjector().getInstance(IWorkspace.class);
        EPackage ePackage = (EPackage)description.getEObjectOrProxy();
        try {
            URI resourceUri = context.eResource().getURI();
            if (resourceUri.isPlatformResource()) {
                IFile file = workspace.getRoot().getFile((IPath)new Path(resourceUri.toPlatformString(true)));
                ResourceSet set = context.eResource().getResourceSet();
                String requiredPluginId = metamodelProvider.getModelPluginId(ePackage, set);
                if (file.exists() && !file.isReadOnly() && requiredPluginId != null) {
                    ProjectGenerationHelper.ensureBundleDependencies((IProject)file.getProject(), Arrays.asList(requiredPluginId));
                }
            }
        }
        catch (Exception e) {
            SiriusVQLGraphicalEditorPlugin.logError(e);
        }
        return ePackage;
    }

    public static String getPackageName(IEObjectDescription description) {
        return description.getName().toString();
    }

    public static void removePackageImport(PatternPackage pkg, EObject declaration, Session session) {
        TransactionalEditingDomain ed = session.getTransactionalEditingDomain();
        Command command = RemoveCommand.create((EditingDomain)ed, (Object)pkg, (Object)VgqlPackage.Literals.PATTERN_PACKAGE__PACKAGE_IMPORTS, (Object)declaration);
        ed.getCommandStack().execute(command);
    }

    public static void removePackageImport(PatternPackage pkg, Collection<EPackage> declarations, Session session) {
        TransactionalEditingDomain ed = session.getTransactionalEditingDomain();
        Command command = RemoveCommand.create((EditingDomain)ed, (Object)pkg, (Object)VgqlPackage.Literals.PATTERN_PACKAGE__PACKAGE_IMPORTS, declarations);
        ed.getCommandStack().execute(command);
    }
}

