/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.runtime.emf.modelmanipulation.tabular;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.viatra.query.runtime.matchers.scopes.tables.ITableWriterBinary;
import org.eclipse.viatra.query.runtime.matchers.scopes.tables.ITableWriterUnary;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuples;
import org.eclipse.viatra.query.runtime.matchers.util.Direction;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;
import org.eclipse.viatra.query.runtime.tabular.EcoreIndexHost;
import org.eclipse.viatra.transformation.runtime.emf.modelmanipulation.AbstractEcoreManipulations;
import org.eclipse.viatra.transformation.runtime.emf.modelmanipulation.IEcoreReadOperations;
import org.eclipse.viatra.transformation.runtime.emf.modelmanipulation.ModelManipulationException;

public abstract class IndexHostManipulations<ModelObject>
extends AbstractEcoreManipulations<Void, ModelObject>
implements IEcoreReadOperations<Void, ModelObject> {
    private static final String UNDEFINED_ESTRUCTURAL_FEATURE_FOR_CONTAINER_MESSAGE = "The type of container %s does neither define or inherit an EStructuralFeature %s.";
    private static final String FEATURE_TYPE_MISMATCH = "The type of EStructuralFeature %s is incompatible with %s.";
    EcoreIndexHost host;
    protected static final TupleMask BIND_SOURCE = TupleMask.selectSingle((int)0, (int)2);
    protected static final TupleMask BIND_TARGET = TupleMask.selectSingle((int)1, (int)2);
    private List<EClass> allClassTypes = null;
    private Map<EClass, List<EClass>> allSubtypes = new HashMap<EClass, List<EClass>>();
    private Map<EClass, List<Map.Entry<EStructuralFeature, ITableWriterBinary.Table<Object, Object>>>> allPossibleContainers = new HashMap<EClass, List<Map.Entry<EStructuralFeature, ITableWriterBinary.Table<Object, Object>>>>();
    private Map<EClass, List<Map.Entry<EStructuralFeature, ITableWriterBinary.Table<Object, Object>>>> allPossibleCrossRefs = new HashMap<EClass, List<Map.Entry<EStructuralFeature, ITableWriterBinary.Table<Object, Object>>>>();
    protected Map<EClass, Initializer<ModelObject>> initializerActions = new HashMap<EClass, Initializer<ModelObject>>();

    public IndexHostManipulations(EcoreIndexHost host) {
        this.host = host;
    }

    @Override
    public EClass eClass(ModelObject element) throws ModelManipulationException {
        return this.findExactType(element);
    }

    protected EClass findExactType(ModelObject element) throws ModelManipulationException {
        Tuple boundElement = Tuples.staticArityFlatTupleOf(element);
        for (EClass eClass : this.getAllClassTypes()) {
            boolean found = this.host.getTableDirectInstances((EClassifier)eClass).containsTuple((ITuple)boundElement);
            if (!found) continue;
            return eClass;
        }
        throw new ModelManipulationException("Model object not found as direct instance of any known type + " + element);
    }

    protected boolean isAssignableFrom(EClass superClass, ModelObject element) {
        if (this.isEObjectClass(superClass)) {
            return true;
        }
        Tuple boundElement = Tuples.staticArityFlatTupleOf(element);
        for (EClass eClass : this.getAllClassTypesThatExtend(superClass)) {
            boolean found = this.host.getTableDirectInstances((EClassifier)eClass).containsTuple((ITuple)boundElement);
            if (!found) continue;
            return true;
        }
        return false;
    }

    protected boolean isAssignableFrom(EClassifier classifier, Object element) {
        if (classifier instanceof EDataType) {
            EDataType dataType = (EDataType)classifier;
            return dataType.isInstance(element);
        }
        if (classifier instanceof EClass) {
            return this.isAssignableFrom((EClass)classifier, element);
        }
        throw new IllegalArgumentException(classifier.toString());
    }

    protected Iterable<EClass> getAllClassTypes() {
        if (this.allClassTypes == null) {
            this.allClassTypes = this.host.getAllCurrentTablesDirectInstances().stream().filter(entry -> entry.getKey() instanceof EClass).map(entry -> (EClass)entry.getKey()).collect(Collectors.toList());
        }
        return this.allClassTypes;
    }

    protected List<EClass> getAllClassTypesThatExtend(EClass superClass) {
        return this.allSubtypes.computeIfAbsent(superClass, this::computeSubtypes);
    }

    protected List<EClass> computeSubtypes(EClass superClass) {
        ArrayList<EClass> result = new ArrayList<EClass>();
        for (EClass eClass : this.getAllClassTypes()) {
            if (!superClass.isSuperTypeOf(eClass)) continue;
            result.add(eClass);
        }
        return result;
    }

    @Override
    public int count(ModelObject container, EStructuralFeature feature) throws ModelManipulationException {
        Preconditions.checkArgument((boolean)this.isAssignableFrom(feature.getEContainingClass(), container), (String)UNDEFINED_ESTRUCTURAL_FEATURE_FOR_CONTAINER_MESSAGE, (Object[])new Object[]{container, feature.getName()});
        ITableWriterBinary.Table table = this.host.getTableFeatureSlots(feature);
        return table.countTuples(BIND_SOURCE, (ITuple)Tuples.staticArityFlatTupleOf(container));
    }

    @Override
    public Stream<? extends Object> stream(ModelObject container, EStructuralFeature feature) throws ModelManipulationException {
        Preconditions.checkArgument((boolean)this.isAssignableFrom(feature.getEContainingClass(), container), (String)UNDEFINED_ESTRUCTURAL_FEATURE_FOR_CONTAINER_MESSAGE, (Object[])new Object[]{container, feature.getName()});
        ITableWriterBinary.Table table = this.host.getTableFeatureSlots(feature);
        return table.streamValues(BIND_SOURCE, (ITuple)Tuples.staticArityFlatTupleOf(container));
    }

    @Override
    public boolean isSetTo(ModelObject container, EStructuralFeature feature, Object value) throws ModelManipulationException {
        Preconditions.checkArgument((boolean)this.isAssignableFrom(feature.getEContainingClass(), container), (String)UNDEFINED_ESTRUCTURAL_FEATURE_FOR_CONTAINER_MESSAGE, (Object[])new Object[]{container, feature.getName()});
        Preconditions.checkArgument((boolean)this.isAssignableFrom(feature.getEType(), value), (String)FEATURE_TYPE_MISMATCH, (Object[])new Object[]{feature.getName(), value});
        ITableWriterBinary.Table table = this.host.getTableFeatureSlots(feature);
        return table.containsTuple((ITuple)Tuples.staticArityFlatTupleOf(container, (Object)value));
    }

    @Override
    public ModelObject create(Void res, EClass clazz) throws ModelManipulationException {
        return this.doCreate(res, clazz);
    }

    protected abstract ModelObject doCreate(Void var1, EClass var2) throws ModelManipulationException;

    @Override
    public ModelObject createChild(ModelObject container, EReference reference, EClass clazz) throws ModelManipulationException {
        Preconditions.checkArgument((boolean)this.isAssignableFrom(reference.getEContainingClass(), container), (String)UNDEFINED_ESTRUCTURAL_FEATURE_FOR_CONTAINER_MESSAGE, (Object[])new Object[]{container, reference.getName()});
        Preconditions.checkArgument((reference.getEReferenceType().isSuperTypeOf(clazz) || this.isEObjectClass(reference.getEReferenceType()) ? 1 : 0) != 0, (String)FEATURE_TYPE_MISMATCH, (Object[])new Object[]{reference.getName(), clazz.getName()});
        Preconditions.checkArgument((boolean)reference.isContainment(), (String)"Created elements must be inserted directly into the containment hierarchy.");
        Preconditions.checkArgument((!clazz.isAbstract() ? 1 : 0) != 0, (String)"Cannot instantiate abstract EClass %s.", (Object[])new Object[]{clazz.getName()});
        return this.doCreate(container, reference, clazz);
    }

    protected abstract ModelObject doCreate(ModelObject var1, EReference var2, EClass var3) throws ModelManipulationException;

    protected void deleteWithOutgoing(ModelObject element) throws ModelManipulationException {
        EClass eClass = this.findExactType(element);
        this.deleteWithOutgoingInternal(element, eClass);
    }

    protected void deleteWithOutgoingInternal(ModelObject element, EClass eClass) throws ModelManipulationException {
        for (EStructuralFeature candidate : this.getAllPossibleFeatures(eClass)) {
            this.removeAllOfInternal(element, candidate);
        }
        this.unregisterInstance((EClassifier)eClass, element, null);
    }

    protected void deleteWithAllDangling(ModelObject element) throws ModelManipulationException {
        EClass eClass = this.findExactType(element);
        for (Map.Entry<EStructuralFeature, ITableWriterBinary.Table<Object, Object>> candidate : this.getAllCrossrefsPossiblyIncoming(eClass)) {
            Tuple targetBinding = Tuples.staticArityFlatTupleOf(element);
            int oldSourceCount = candidate.getValue().countTuples(BIND_TARGET, (ITuple)targetBinding);
            if (oldSourceCount <= 0) continue;
            ArrayList oldSourcesCopy = new ArrayList(oldSourceCount);
            Iterable oldSources = candidate.getValue().enumerateValues(BIND_TARGET, (ITuple)targetBinding);
            for (Object oldSource : oldSources) {
                oldSourcesCopy.add(oldSource);
            }
            for (Object oldSource : oldSourcesCopy) {
                this.removeInternal(oldSource, candidate.getKey(), element, candidate.getValue(), null);
            }
        }
        this.removeFromCurrentContainer(element, eClass);
        this.deleteWithOutgoingInternal(element, eClass);
    }

    protected void removeFromCurrentContainer(ModelObject value) throws ModelManipulationException {
        EClass eClass = this.findExactType(value);
        this.removeFromCurrentContainer(value, eClass);
    }

    protected void removeFromCurrentContainer(ModelObject value, EClass eClass) {
        for (Map.Entry<EStructuralFeature, ITableWriterBinary.Table<Object, Object>> candidate : this.getAllRefsPossiblyContaining(eClass)) {
            Tuple targetBinding = Tuples.staticArityFlatTupleOf(value);
            Iterable oldContainers = candidate.getValue().enumerateValues(BIND_TARGET, (ITuple)targetBinding);
            Iterator iterator = oldContainers.iterator();
            if (!iterator.hasNext()) continue;
            Object oldContainer = iterator.next();
            candidate.getValue().write(Direction.DELETE, oldContainer, value);
            return;
        }
    }

    protected Iterable<Map.Entry<EStructuralFeature, ITableWriterBinary.Table<Object, Object>>> getAllRefsPossiblyContaining(EClass eClass) {
        return this.allPossibleContainers.computeIfAbsent(eClass, type -> this.host.getAllCurrentTablesFeatures().stream().filter(entry -> FeatureKind.CONTAINMENT_REF == FeatureKind.of((EStructuralFeature)entry.getKey()) && ((EReference)entry.getKey()).getEReferenceType().isSuperTypeOf(eClass)).collect(Collectors.toList()));
    }

    protected Iterable<Map.Entry<EStructuralFeature, ITableWriterBinary.Table<Object, Object>>> getAllCrossrefsPossiblyIncoming(EClass eClass) {
        return this.allPossibleCrossRefs.computeIfAbsent(eClass, type -> this.host.getAllCurrentTablesFeatures().stream().filter(entry -> FeatureKind.CROSS_REF == FeatureKind.of((EStructuralFeature)entry.getKey()) && ((EReference)entry.getKey()).getEReferenceType().isSuperTypeOf(eClass)).collect(Collectors.toList()));
    }

    protected Iterable<EStructuralFeature> getAllPossibleFeatures(EClass exactType) {
        return exactType.getEAllStructuralFeatures();
    }

    protected void unregisterInstance(EClassifier type, Object oldValue, ITableWriterUnary.Table<Object> instanceTableOptional) {
        if (instanceTableOptional == null) {
            instanceTableOptional = this.host.getTableDirectInstances(type);
        }
        instanceTableOptional.write(Direction.DELETE, oldValue);
    }

    protected void registerInstance(EClassifier type, Object newValue, ITableWriterUnary.Table<Object> instanceTableOptional) {
        if (instanceTableOptional == null) {
            instanceTableOptional = this.host.getTableDirectInstances(type);
        }
        instanceTableOptional.write(Direction.INSERT, newValue);
    }

    protected void initializeNewlyCreatedObject(ModelObject instance, EClass clazz) throws ModelManipulationException {
        Initializer initializer = this.initializerActions.computeIfAbsent(clazz, this::determineInitializationSequence);
        if (initializer != null) {
            initializer.initialize(instance);
        }
    }

    protected Initializer<ModelObject> determineInitializationSequence(EClass clazz) {
        Map<EAttribute, Object> defaultValues = this.determineDefaultValues(clazz);
        return this.makeInitializer(defaultValues);
    }

    protected Map<EAttribute, Object> determineDefaultValues(EClass clazz) {
        HashMap<EAttribute, Object> defaultValues = new HashMap<EAttribute, Object>();
        Optional<EObject> templateInstance = this.createTemplateInstance(clazz);
        for (EAttribute attribute : clazz.getEAllAttributes()) {
            Object defaultValue;
            if (attribute.isDerived()) continue;
            Object object = defaultValue = templateInstance.isPresent() ? templateInstance.get().eGet((EStructuralFeature)attribute) : attribute.getEType().getDefaultValue();
            if (defaultValue == null) continue;
            defaultValues.put(attribute, defaultValue);
        }
        return defaultValues;
    }

    protected Optional<EObject> createTemplateInstance(EClass clazz) {
        try {
            return Optional.of(clazz.getEPackage().getEFactoryInstance().create(clazz));
        }
        catch (Throwable t) {
            return Optional.empty();
        }
    }

    protected Initializer<ModelObject> makeInitializer(Map<EAttribute, Object> defaultValues) {
        return modelObject -> {
            for (Map.Entry entry : defaultValues.entrySet()) {
                this.setInternal(modelObject, (EStructuralFeature)entry.getKey(), entry.getValue());
            }
        };
    }

    protected void removeInternal(ModelObject container, EStructuralFeature feature, Object oldValue, ITableWriterBinary.Table<Object, Object> featureTable, ITableWriterUnary.Table<Object> instanceTable) throws ModelManipulationException {
        if (featureTable == null) {
            featureTable = this.host.getTableFeatureSlots(feature);
        }
        featureTable.write(Direction.DELETE, container, oldValue);
        switch (FeatureKind.of(feature)) {
            case CONTAINMENT_REF: {
                this.deleteWithOutgoing(oldValue);
                break;
            }
            case ATTRIBUTE: {
                this.unregisterInstance(feature.getEType(), oldValue, instanceTable);
            }
        }
    }

    protected void addInternal(ModelObject container, EStructuralFeature feature, Object newValue, ITableWriterBinary.Table<Object, Object> featureTable, ITableWriterUnary.Table<Object> instanceTable) {
        if (featureTable == null) {
            featureTable = this.host.getTableFeatureSlots(feature);
        }
        featureTable.write(Direction.INSERT, container, newValue);
        if (feature instanceof EAttribute) {
            this.registerInstance(feature.getEType(), newValue, instanceTable);
        }
    }

    @Override
    public void addTo(ModelObject container, EStructuralFeature feature, Object element) throws ModelManipulationException {
        Preconditions.checkArgument((boolean)this.isAssignableFrom(feature.getEContainingClass(), container), (String)UNDEFINED_ESTRUCTURAL_FEATURE_FOR_CONTAINER_MESSAGE, (Object[])new Object[]{container, feature.getName()});
        Preconditions.checkArgument((boolean)this.isAssignableFrom(feature.getEType(), element), (String)FEATURE_TYPE_MISMATCH, (Object[])new Object[]{feature.getName(), element});
        Preconditions.checkArgument((boolean)feature.isMany(), (String)"The EStructuralFeature %s must have an upper bound larger than 1.", (Object[])new Object[]{feature.getName()});
        Preconditions.checkArgument((!(feature instanceof EReference) || !((EReference)feature).isContainment() ? 1 : 0) != 0, (String)"Adding existing elements into the containment reference %s is not supported.", (Object[])new Object[]{feature.getName()});
        this.addInternal(container, feature, element, null, null);
    }

    @Override
    public void addTo(ModelObject container, EStructuralFeature feature, Object element, int index) throws ModelManipulationException {
        this.addTo(container, feature, element);
    }

    @Override
    public void addAllTo(ModelObject container, EStructuralFeature feature, Collection<? extends Object> elements) throws ModelManipulationException {
        Preconditions.checkArgument((boolean)this.isAssignableFrom(feature.getEContainingClass(), container), (String)UNDEFINED_ESTRUCTURAL_FEATURE_FOR_CONTAINER_MESSAGE, (Object[])new Object[]{container, feature.getName()});
        for (Object object : elements) {
            Preconditions.checkArgument((boolean)this.isAssignableFrom(feature.getEType(), object), (String)FEATURE_TYPE_MISMATCH, (Object[])new Object[]{feature.getName(), object});
        }
        Preconditions.checkArgument((boolean)feature.isMany(), (String)"The EStructuralFeature %s must have an upper bound larger than 1.", (Object[])new Object[]{feature.getName()});
        Preconditions.checkArgument((!(feature instanceof EReference) || !((EReference)feature).isContainment() ? 1 : 0) != 0, (String)"Adding existing elements into the containment reference %s is not supported.", (Object[])new Object[]{feature.getName()});
        ITableWriterBinary.Table table = this.host.getTableFeatureSlots(feature);
        for (Object object : elements) {
            this.addInternal(container, feature, object, (ITableWriterBinary.Table<Object, Object>)table, null);
        }
    }

    @Override
    public void set(ModelObject container, EStructuralFeature feature, Object value) throws ModelManipulationException {
        Preconditions.checkArgument((boolean)this.isAssignableFrom(feature.getEContainingClass(), container), (String)UNDEFINED_ESTRUCTURAL_FEATURE_FOR_CONTAINER_MESSAGE, (Object[])new Object[]{container, feature.getName()});
        Preconditions.checkArgument((value == null || this.isAssignableFrom(feature.getEType(), value) ? 1 : 0) != 0, (String)FEATURE_TYPE_MISMATCH, (Object[])new Object[]{feature.getName(), value});
        Preconditions.checkArgument((!feature.isMany() ? 1 : 0) != 0, (String)"The EStructuralFeature %s must have an upper bound of 1.", (Object[])new Object[]{feature.getName()});
        this.setInternal(container, feature, value);
    }

    protected void setInternal(ModelObject container, EStructuralFeature feature, Object value) throws ModelManipulationException {
        ITableWriterBinary.Table table = this.host.getTableFeatureSlots(feature);
        Tuple sourceBinding = Tuples.staticArityFlatTupleOf(container);
        Iterable oldValues = table.enumerateValues(BIND_SOURCE, (ITuple)sourceBinding);
        Object removed = null;
        for (Object oldValue : oldValues) {
            if (removed == null) {
                this.removeInternal(container, feature, oldValue, (ITableWriterBinary.Table<Object, Object>)table, null);
                removed = oldValue;
                continue;
            }
            throw new ModelManipulationException(String.format("Found multiple values (%s, %s) of feature (%s) on object (%s) when trying to SET to new value (%s)", removed, oldValue, feature.getName(), container, value));
        }
        if (value != null) {
            if (feature instanceof EReference && ((EReference)feature).isContainer()) {
                this.removeFromCurrentContainer(value);
            }
            this.addInternal(container, feature, value, (ITableWriterBinary.Table<Object, Object>)table, null);
        }
    }

    @Override
    public void remove(ModelObject container, EStructuralFeature feature, Object element) throws ModelManipulationException {
        Preconditions.checkArgument((boolean)this.isAssignableFrom(feature.getEContainingClass(), container), (String)UNDEFINED_ESTRUCTURAL_FEATURE_FOR_CONTAINER_MESSAGE, (Object[])new Object[]{container, feature.getName()});
        Preconditions.checkArgument((boolean)this.isAssignableFrom(feature.getEType(), element), (String)FEATURE_TYPE_MISMATCH, (Object[])new Object[]{feature.getName(), element});
        Preconditions.checkArgument((boolean)feature.isMany(), (String)"Remove only works on EStructuralFeatures with 'many' multiplicity.");
        this.removeInternal(container, feature, element, null, null);
    }

    @Override
    public void remove(ModelObject container, EStructuralFeature feature, int index) throws ModelManipulationException {
        throw new UnsupportedOperationException("Position-based removal unsupported.");
    }

    @Override
    public void remove(ModelObject container, EStructuralFeature feature) throws ModelManipulationException {
        Preconditions.checkArgument((boolean)this.isAssignableFrom(feature.getEContainingClass(), container), (String)UNDEFINED_ESTRUCTURAL_FEATURE_FOR_CONTAINER_MESSAGE, (Object[])new Object[]{container, feature.getName()});
        Preconditions.checkArgument((boolean)feature.isMany(), (String)"Remove only works on references with 'many' multiplicity.");
        this.removeAllOfInternal(container, feature);
    }

    protected void removeAllOfInternal(ModelObject container, EStructuralFeature feature) throws ModelManipulationException {
        ITableWriterBinary.Table table = this.host.getTableFeatureSlots(feature);
        ITableWriterUnary.Table tableDirectInstances = feature instanceof EAttribute ? this.host.getTableDirectInstances(feature.getEType()) : null;
        Tuple sourceBinding = Tuples.staticArityFlatTupleOf(container);
        int oldValueCount = table.countTuples(BIND_SOURCE, (ITuple)sourceBinding);
        if (oldValueCount > 0) {
            ArrayList oldValuesCopy = new ArrayList(oldValueCount);
            Iterable oldValues = table.enumerateValues(BIND_SOURCE, (ITuple)sourceBinding);
            for (Object oldValue : oldValues) {
                oldValuesCopy.add(oldValue);
            }
            for (Object oldValue : oldValuesCopy) {
                this.removeInternal(container, feature, oldValue, (ITableWriterBinary.Table<Object, Object>)table, (ITableWriterUnary.Table<Object>)tableDirectInstances);
            }
        }
    }

    @Override
    public void remove(ModelObject object) throws ModelManipulationException {
        this.deleteWithAllDangling(object);
    }

    @Override
    public void moveTo(ModelObject what, Void newContainer) throws ModelManipulationException {
        this.removeFromCurrentContainer(what);
    }

    @Override
    public void moveTo(ModelObject what, Void newContainer, int index) throws ModelManipulationException {
        this.removeFromCurrentContainer(what);
    }

    @Override
    public void moveTo(ModelObject what, ModelObject newContainer, EReference reference) throws ModelManipulationException {
        Preconditions.checkArgument((boolean)this.isAssignableFrom(reference.getEContainingClass(), newContainer), (String)UNDEFINED_ESTRUCTURAL_FEATURE_FOR_CONTAINER_MESSAGE, (Object[])new Object[]{newContainer, reference.getName()});
        Preconditions.checkArgument((boolean)this.isAssignableFrom(reference.getEReferenceType(), what), (String)FEATURE_TYPE_MISMATCH, (Object[])new Object[]{reference.getName(), what});
        Preconditions.checkArgument((boolean)reference.isContainment(), (String)"Elements must be moved into the containment hierarchy.");
        this.moveInternal(what, newContainer, reference);
    }

    protected void moveInternal(ModelObject what, ModelObject newContainer, EReference reference) throws ModelManipulationException {
        this.removeFromCurrentContainer(what);
        this.addInternal(newContainer, (EStructuralFeature)reference, what, null, null);
    }

    @Override
    public void moveTo(ModelObject what, ModelObject newContainer, EReference reference, int index) throws ModelManipulationException {
        this.moveTo(what, newContainer, reference);
    }

    @Override
    public void moveAllTo(Collection<ModelObject> what, ModelObject newContainer, EReference reference) throws ModelManipulationException {
        Preconditions.checkArgument((boolean)this.isAssignableFrom(reference.getEContainingClass(), newContainer), (String)UNDEFINED_ESTRUCTURAL_FEATURE_FOR_CONTAINER_MESSAGE, (Object[])new Object[]{newContainer, reference.getName()});
        Preconditions.checkArgument((boolean)reference.isContainment(), (String)"Elements must be moved into the containment hierarchy.");
        for (ModelObject element : what) {
            Preconditions.checkArgument((boolean)this.isAssignableFrom((EClassifier)reference.getEReferenceType(), element), (String)FEATURE_TYPE_MISMATCH, (Object[])new Object[]{reference.getName(), element});
        }
        this.moveAllInternal(what, newContainer, reference);
    }

    protected void moveAllInternal(Collection<ModelObject> what, ModelObject newContainer, EReference reference) throws ModelManipulationException {
        ITableWriterBinary.Table table = this.host.getTableFeatureSlots((EStructuralFeature)reference);
        for (ModelObject element : what) {
            this.removeFromCurrentContainer(element);
            this.addInternal(newContainer, (EStructuralFeature)reference, element, (ITableWriterBinary.Table<Object, Object>)table, null);
        }
    }

    @Override
    public void changeIndex(ModelObject container, EStructuralFeature feature, int oldIndex, int newIndex) throws ModelManipulationException {
    }

    protected static enum FeatureKind {
        CROSS_REF,
        CONTAINMENT_REF,
        ATTRIBUTE;


        static FeatureKind of(EStructuralFeature feature) {
            if (feature instanceof EReference) {
                return ((EReference)feature).isContainment() ? CONTAINMENT_REF : CROSS_REF;
            }
            return ATTRIBUTE;
        }
    }

    @FunctionalInterface
    protected static interface Initializer<ModelObject> {
        public void initialize(ModelObject var1) throws ModelManipulationException;
    }
}

