/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.evm.api.resolver;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.viatra.transformation.evm.api.Activation;
import org.eclipse.viatra.transformation.evm.api.RuleBase;
import org.eclipse.viatra.transformation.evm.api.RuleInstance;
import org.eclipse.viatra.transformation.evm.api.RuleSpecification;
import org.eclipse.viatra.transformation.evm.api.event.EventFilter;
import org.eclipse.viatra.transformation.evm.api.resolver.ChangeableConflictSet;
import org.eclipse.viatra.transformation.evm.api.resolver.ConflictResolver;
import org.eclipse.viatra.transformation.evm.api.resolver.ConflictSet;
import org.eclipse.viatra.transformation.evm.api.resolver.ConflictSetUpdater;
import org.eclipse.viatra.transformation.evm.notification.IActivationNotificationListener;

public class ScopedConflictSet
implements ConflictSet {
    private final ChangeableConflictSet changeableConflictSet;
    private final RuleBase ruleBase;
    private final Map<RuleSpecification<?>, Set<EventFilter<?>>> specificationFilters;
    public IActivationNotificationListener listener;

    public ScopedConflictSet(RuleBase ruleBase, ConflictResolver conflictResolver, Map<RuleSpecification<?>, Set<EventFilter<?>>> specificationFilters) {
        this.ruleBase = ruleBase;
        this.changeableConflictSet = conflictResolver.createConflictSet();
        this.specificationFilters = Collections.unmodifiableMap(specificationFilters.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new HashSet((Collection)entry.getValue()))));
        this.listener = new ConflictSetUpdater(this.changeableConflictSet);
        for (Map.Entry<RuleSpecification<?>, Set<EventFilter<?>>> entry2 : specificationFilters.entrySet()) {
            RuleSpecification<?> ruleSpecification = entry2.getKey();
            entry2.getValue().forEach(value -> this.registerListenerFromInstance(ruleSpecification, (EventFilter<?>)value));
        }
    }

    public Map<RuleSpecification<?>, Set<EventFilter<?>>> getSpecificationFilters() {
        return this.specificationFilters;
    }

    protected IActivationNotificationListener getListener() {
        return this.listener;
    }

    public void dispose() {
        for (Map.Entry<RuleSpecification<?>, Set<EventFilter<?>>> entry : this.specificationFilters.entrySet()) {
            RuleSpecification<?> ruleSpecification = entry.getKey();
            entry.getValue().forEach(value -> this.unregisterListenerFromInstance(ruleSpecification, (EventFilter<?>)value));
        }
    }

    private <EventAtom> void unregisterListenerFromInstance(RuleSpecification<EventAtom> ruleSpecification, EventFilter<?> eventFilter) {
        RuleInstance<EventAtom> instance = this.ruleBase.getInstance(ruleSpecification, this.toTypedFilter(ruleSpecification, eventFilter));
        if (instance != null) {
            instance.removeActivationNotificationListener(this.listener);
        }
    }

    private <EventAtom> void registerListenerFromInstance(RuleSpecification<EventAtom> ruleSpecification, EventFilter<?> eventFilter) {
        RuleInstance<EventAtom> instance = this.ruleBase.getInstance(ruleSpecification, this.toTypedFilter(ruleSpecification, eventFilter));
        if (instance != null) {
            instance.addActivationNotificationListener(this.listener, true);
        }
    }

    private <EventAtom> EventFilter<? super EventAtom> toTypedFilter(RuleSpecification<EventAtom> ruleSpecification, EventFilter<?> eventFilter) {
        return eventFilter;
    }

    @Override
    public Activation<?> getNextActivation() {
        return this.changeableConflictSet.getNextActivation();
    }

    @Override
    public Set<Activation<?>> getNextActivations() {
        return this.changeableConflictSet.getNextActivations();
    }

    @Override
    public Set<Activation<?>> getConflictingActivations() {
        return this.changeableConflictSet.getConflictingActivations();
    }

    @Override
    public ConflictResolver getConflictResolver() {
        return this.changeableConflictSet.getConflictResolver();
    }
}

