/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.patternlanguage.emf.ui;

import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.LoggingEvent;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.viatra.query.patternlanguage.emf.ui.internal.EmfActivator;
import org.osgi.framework.Bundle;

public class EclipseLogAppender
extends AppenderSkeleton {
    private static final String LOG_PATTERN = "%m%n";
    private static final String BUNDLE_NAME = EmfActivator.getInstance().getBundle().getSymbolicName();
    private boolean initialized;
    private ILog log;

    public EclipseLogAppender() {
        this.layout = new PatternLayout(LOG_PATTERN);
    }

    public EclipseLogAppender(boolean isActive) {
        super(isActive);
        this.layout = new PatternLayout(LOG_PATTERN);
    }

    private synchronized void ensureInitialized() {
        if (!this.initialized) {
            this.log = Platform.getLog((Bundle)Platform.getBundle((String)BUNDLE_NAME));
            this.initialized = true;
        }
    }

    private ILog getLog() {
        this.ensureInitialized();
        return this.log;
    }

    protected void append(LoggingEvent event) {
        if (this.isDoLog(event.getLevel())) {
            String logString = this.layout.format(event);
            ILog myLog = this.getLog();
            if (myLog != null) {
                int severity = this.mapLevel(event.getLevel());
                Throwable throwable = event.getThrowableInformation() != null ? event.getThrowableInformation().getThrowable() : null;
                IStatus status = this.createStatus(severity, logString, throwable);
                this.getLog().log(status);
            }
        }
    }

    private boolean isDoLog(Level level) {
        return level.toInt() >= 30000;
    }

    private int mapLevel(Level level) {
        switch (level.toInt()) {
            case 10000: 
            case 20000: {
                return 1;
            }
            case 30000: {
                return 2;
            }
            case 40000: 
            case 50000: {
                return 4;
            }
        }
        return 1;
    }

    private IStatus createStatus(int severity, String message, Throwable throwable) {
        return new Status(severity, BUNDLE_NAME, message, throwable);
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return true;
    }
}

