/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.scopes;

import java.util.Map;
import java.util.Optional;
import org.eclipse.viatra.query.runtime.matchers.context.AbstractQueryRuntimeContext;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryRuntimeContextListener;
import org.eclipse.viatra.query.runtime.matchers.scopes.tables.IIndexTable;
import org.eclipse.viatra.query.runtime.matchers.scopes.tables.ITableContext;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.util.Accuracy;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;

public abstract class TabularRuntimeContext
extends AbstractQueryRuntimeContext
implements ITableContext {
    private Map<IInputKey, IIndexTable> instanceTables = CollectionsFactory.createMap();

    public void registerIndexTable(IIndexTable table) {
        IInputKey inputKey = table.getInputKey();
        this.instanceTables.put(inputKey, table);
    }

    public IIndexTable peekIndexTable(IInputKey key) {
        return this.instanceTables.get(key);
    }

    public IIndexTable getIndexTable(IInputKey key) {
        IIndexTable table = this.instanceTables.get(key);
        if (table != null) {
            return table;
        }
        return this.handleUnregisteredTableRequest(key);
    }

    protected IIndexTable handleUnregisteredTableRequest(IInputKey key) {
        throw new IllegalArgumentException(key.getPrettyPrintableName());
    }

    @Override
    public int countTuples(IInputKey key, TupleMask seedMask, ITuple seed) {
        return this.getIndexTable(key).countTuples(seedMask, seed);
    }

    @Override
    public Optional<Long> estimateCardinality(IInputKey key, TupleMask groupMask, Accuracy requiredAccuracy) {
        return this.getIndexTable(key).estimateProjectionSize(groupMask, requiredAccuracy);
    }

    @Override
    public Iterable<Tuple> enumerateTuples(IInputKey key, TupleMask seedMask, ITuple seed) {
        return this.getIndexTable(key).enumerateTuples(seedMask, seed);
    }

    @Override
    public Iterable<? extends Object> enumerateValues(IInputKey key, TupleMask seedMask, ITuple seed) {
        return this.getIndexTable(key).enumerateValues(seedMask, seed);
    }

    @Override
    public boolean containsTuple(IInputKey key, ITuple seed) {
        if (key.isEnumerable()) {
            return this.getIndexTable(key).containsTuple(seed);
        }
        return this.isContainedInStatelessKey(key, seed);
    }

    @Override
    public void addUpdateListener(IInputKey key, Tuple seed, IQueryRuntimeContextListener listener) {
        this.getIndexTable(key).addUpdateListener(seed, listener);
    }

    @Override
    public void removeUpdateListener(IInputKey key, Tuple seed, IQueryRuntimeContextListener listener) {
        this.getIndexTable(key).removeUpdateListener(seed, listener);
    }

    protected abstract boolean isContainedInStatelessKey(IInputKey var1, ITuple var2);
}

