/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.dse.solutionstore;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.viatra.dse.api.DSEException;
import org.eclipse.viatra.dse.api.Solution;
import org.eclipse.viatra.dse.api.SolutionTrajectory;
import org.eclipse.viatra.dse.base.DesignSpaceManager;
import org.eclipse.viatra.dse.base.ThreadContext;
import org.eclipse.viatra.dse.objectives.Fitness;
import org.eclipse.viatra.dse.objectives.ObjectiveComparatorHelper;
import org.eclipse.viatra.dse.solutionstore.ISolutionFoundHandler;
import org.eclipse.viatra.dse.solutionstore.ISolutionNameProvider;
import org.eclipse.viatra.dse.solutionstore.LogSolutionHandler;
import org.eclipse.viatra.dse.solutionstore.ModelSaverSolutionFoundHandler;
import org.eclipse.viatra.dse.statecode.IStateCoderFactory;
import org.eclipse.viatra.dse.util.EMFHelper;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;

public class SolutionStore {
    protected boolean acceptOnlyGoalSolutions = true;
    protected final Map<Object, Solution> solutions = new HashMap<Object, Solution>();
    protected ISolutionSaver solutionSaver = new SimpleSolutionSaver();
    protected List<ISolutionFoundHandler> solutionFoundHandlers = new ArrayList<ISolutionFoundHandler>(1);
    protected final IEnoughSolutions enoughSolutions;

    public SolutionStore() {
        this(new IEnoughSolutions(){

            @Override
            public void solutionFound(ThreadContext context, SolutionTrajectory trajectory) {
            }

            @Override
            public boolean enoughSolutions() {
                return false;
            }

            @Override
            public void solutionTriedToSave(ThreadContext context, SolutionTrajectory trajectory) {
            }
        });
    }

    public SolutionStore(int numOfSolutionsToFind) {
        this(new ANumberOfEnoughSolutions(numOfSolutionsToFind));
    }

    public SolutionStore(IEnoughSolutions enoughSolutionsImpl) {
        this.enoughSolutions = enoughSolutionsImpl;
    }

    public synchronized void newSolution(ThreadContext context) {
        this.solutionSaver.setSolutionsCollection(this.solutions);
        Fitness fitness = context.getLastFitness();
        DesignSpaceManager dsm = context.getDesignSpaceManager();
        Object id = dsm.getCurrentState();
        IStateCoderFactory stateCoderFactory = context.getGlobalContext().getStateCoderFactory();
        SolutionTrajectory solutionTrajectory = dsm.getTrajectoryInfo().createSolutionTrajectory(stateCoderFactory);
        solutionTrajectory.setFitness(fitness);
        if (this.acceptOnlyGoalSolutions && !fitness.isSatisifiesHardObjectives()) {
            this.unsavedSolutionCallbacks(context, solutionTrajectory);
            return;
        }
        boolean solutionSaved = this.solutionSaver.saveSolution(context, id, solutionTrajectory);
        if (solutionSaved) {
            this.enoughSolutions.solutionFound(context, solutionTrajectory);
            this.savedSolutionCallbacks(context, solutionTrajectory);
            if (this.enoughSolutions.enoughSolutions()) {
                context.getGlobalContext().stopAllThreads();
            }
        } else {
            this.unsavedSolutionCallbacks(context, solutionTrajectory);
        }
    }

    private void unsavedSolutionCallbacks(ThreadContext context, SolutionTrajectory solutionTrajectory) {
        for (ISolutionFoundHandler handler : this.solutionFoundHandlers) {
            handler.solutionTriedToSave(context, solutionTrajectory);
        }
    }

    private void savedSolutionCallbacks(ThreadContext context, SolutionTrajectory solutionTrajectory) {
        for (ISolutionFoundHandler handler : this.solutionFoundHandlers) {
            handler.solutionFound(context, solutionTrajectory);
        }
    }

    public synchronized Collection<Solution> getSolutions() {
        return this.solutions.values();
    }

    public synchronized void registerSolutionFoundHandler(ISolutionFoundHandler handler) {
        if (this.solutionFoundHandlers == null) {
            this.solutionFoundHandlers = new ArrayList<ISolutionFoundHandler>(1);
        }
        this.solutionFoundHandlers.add(handler);
    }

    public SolutionStore logSolutionsWhenFound() {
        this.registerSolutionFoundHandler(new LogSolutionHandler());
        Logger.getLogger(LogSolutionHandler.class).setLevel(Level.INFO);
        return this;
    }

    public SolutionStore saveModelWhenFound() {
        this.registerSolutionFoundHandler(new ModelSaverSolutionFoundHandler());
        return this;
    }

    public SolutionStore saveModelWhenFound(String extension) {
        this.registerSolutionFoundHandler(new ModelSaverSolutionFoundHandler(extension));
        return this;
    }

    public SolutionStore saveModelWhenFound(String prefix, String extension) {
        this.registerSolutionFoundHandler(new ModelSaverSolutionFoundHandler(prefix, extension));
        return this;
    }

    public SolutionStore saveModelWhenFound(ISolutionNameProvider solutionNameProvider) {
        this.registerSolutionFoundHandler(new ModelSaverSolutionFoundHandler(solutionNameProvider));
        return this;
    }

    public SolutionStore acceptGoalSolutionsOnly() {
        this.acceptOnlyGoalSolutions = true;
        return this;
    }

    public SolutionStore acceptAnySolutions() {
        this.acceptOnlyGoalSolutions = false;
        return this;
    }

    public SolutionStore withSolutionSaver(ISolutionSaver solutionSaver) {
        this.solutionSaver = solutionSaver;
        return this;
    }

    public SolutionStore storeBestSolutionsOnly() {
        this.solutionSaver = new BestSolutionSaver();
        return this;
    }

    public void saveModels(Notifier model, ISolutionNameProvider solutionNameProvider) {
        try {
            for (Solution solution : this.solutions.values()) {
                SolutionTrajectory trajectory = solution.getArbitraryTrajectory();
                trajectory.doTransformationUndoable(model);
                EMFHelper.saveModel(model, solutionNameProvider.getName());
                trajectory.undoTransformation();
            }
        }
        catch (ViatraQueryException e) {
            Logger.getLogger(SolutionStore.class).error((Object)"Exception happened during model saving.", (Throwable)e);
        }
    }

    public static class ANumberOfEnoughSolutions
    implements IEnoughSolutions {
        private final AtomicInteger foundSolutions;
        private final AtomicBoolean foundEnoughSolutions;

        public ANumberOfEnoughSolutions(int number) {
            this.foundSolutions = new AtomicInteger(number);
            this.foundEnoughSolutions = new AtomicBoolean(false);
        }

        @Override
        public boolean enoughSolutions() {
            return this.foundEnoughSolutions.get();
        }

        @Override
        public void solutionFound(ThreadContext context, SolutionTrajectory trajectory) {
            int solutionsToFind = this.foundSolutions.decrementAndGet();
            if (solutionsToFind == 0) {
                this.foundEnoughSolutions.set(true);
            }
        }

        @Override
        public void solutionTriedToSave(ThreadContext context, SolutionTrajectory trajectory) {
        }
    }

    public static class BestSolutionSaver
    implements ISolutionSaver {
        private Map<Object, Solution> solutions;
        private Map<SolutionTrajectory, Fitness> trajectories = new HashMap<SolutionTrajectory, Fitness>();

        @Override
        public void setSolutionsCollection(Map<Object, Solution> solutions) {
            this.solutions = solutions;
        }

        @Override
        public boolean saveSolution(ThreadContext context, Object id, SolutionTrajectory solutionTrajectory) {
            Fitness lastFitness = context.getLastFitness();
            ObjectiveComparatorHelper comparatorHelper = context.getObjectiveComparatorHelper();
            ArrayList<SolutionTrajectory> dominatedTrajectories = new ArrayList<SolutionTrajectory>();
            for (Map.Entry<SolutionTrajectory, Fitness> entry : this.trajectories.entrySet()) {
                int isLastFitnessBetter = comparatorHelper.compare(lastFitness, entry.getValue());
                if (isLastFitnessBetter < 0) {
                    return false;
                }
                if (isLastFitnessBetter <= 0) continue;
                dominatedTrajectories.add(entry.getKey());
            }
            boolean solutionSaved = false;
            Solution solution = this.solutions.get(id);
            if (solution != null) {
                if (!solution.getTrajectories().contains(solutionTrajectory)) {
                    solution.addTrajectory(solutionTrajectory);
                    solutionTrajectory.setSolution(solution);
                    solutionSaved = true;
                    this.trajectories.put(solutionTrajectory, lastFitness);
                }
            } else {
                solution = new Solution(id, solutionTrajectory);
                this.solutions.put(id, solution);
                solutionTrajectory.setSolution(solution);
                solutionSaved = true;
                this.trajectories.put(solutionTrajectory, lastFitness);
            }
            for (SolutionTrajectory st : dominatedTrajectories) {
                this.trajectories.remove(st);
                Solution s = st.getSolution();
                if (!s.getTrajectories().remove(st)) {
                    throw new DSEException("Should not happen.");
                }
                if (!s.getTrajectories().isEmpty()) continue;
                Object stateCode = s.getStateCode();
                this.solutions.remove(stateCode);
            }
            return solutionSaved;
        }
    }

    public static interface IEnoughSolutions
    extends ISolutionFoundHandler {
        public boolean enoughSolutions();
    }

    public static interface ISolutionSaver {
        public void setSolutionsCollection(Map<Object, Solution> var1);

        public boolean saveSolution(ThreadContext var1, Object var2, SolutionTrajectory var3);
    }

    public static class SimpleSolutionSaver
    implements ISolutionSaver {
        private Map<Object, Solution> solutions;

        @Override
        public void setSolutionsCollection(Map<Object, Solution> solutions) {
            this.solutions = solutions;
        }

        @Override
        public boolean saveSolution(ThreadContext context, Object id, SolutionTrajectory solutionTrajectory) {
            Solution solution = this.solutions.get(id);
            if (solution != null) {
                if (solution.getTrajectories().contains(solutionTrajectory)) {
                    return false;
                }
                solution.addTrajectory(solutionTrajectory);
                solutionTrajectory.setSolution(solution);
            } else {
                solution = new Solution(id, solutionTrajectory);
                this.solutions.put(id, solution);
                solutionTrajectory.setSolution(solution);
            }
            return true;
        }
    }
}

