/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.examples.cps.xform.m2m.batch.optimized;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.ApplicationInstance;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.ApplicationType;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.CyberPhysicalSystem;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.HostInstance;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.Identifiable;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.State;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.StateMachine;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.Transition;
import org.eclipse.viatra.examples.cps.deployment.BehaviorState;
import org.eclipse.viatra.examples.cps.deployment.BehaviorTransition;
import org.eclipse.viatra.examples.cps.deployment.Deployment;
import org.eclipse.viatra.examples.cps.deployment.DeploymentApplication;
import org.eclipse.viatra.examples.cps.deployment.DeploymentBehavior;
import org.eclipse.viatra.examples.cps.deployment.DeploymentElement;
import org.eclipse.viatra.examples.cps.deployment.DeploymentFactory;
import org.eclipse.viatra.examples.cps.deployment.DeploymentHost;
import org.eclipse.viatra.examples.cps.traceability.CPS2DeploymentTrace;
import org.eclipse.viatra.examples.cps.traceability.CPSToDeployment;
import org.eclipse.viatra.examples.cps.traceability.TraceabilityFactory;
import org.eclipse.viatra.examples.cps.xform.m2m.util.NamingUtil;
import org.eclipse.viatra.examples.cps.xform.m2m.util.SignalUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class CPS2DeploymentBatchTransformationOptimized {
    @Extension
    private Logger logger = Logger.getLogger((String)"cps.xform.m2m.batch.optimized");
    private Stopwatch clearModelPerformance;
    private Stopwatch hostTransformationPerformance;
    private Stopwatch appTransformationPerformance;
    private Stopwatch stateMachineTransformationPerformance;
    private Stopwatch stateTransformationPerformance;
    private Stopwatch transitionTransformationPerformance;
    private Stopwatch triggerTransformationPerformance;
    private Stopwatch transitionMappingCachingPerformance;
    private Stopwatch otherTimer;
    private CPSToDeployment mapping;
    private HashMultimap<Identifiable, DeploymentElement> mappingCache;
    private Map<DeploymentElement, Identifiable> reverseMappingCache;
    private final HashMap<Object, Object> transitionToAppId = Maps.newHashMap();
    private final HashMap<Object, Object> transitionToActionId = Maps.newHashMap();
    private Map<BehaviorTransition, HostInstance> transitionToHost = Maps.newHashMap();

    private void traceBegin(String method) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Executing ");
        _builder.append(method);
        _builder.append(" BEGIN");
        this.logger.trace((Object)_builder);
    }

    private void traceEnd(String method) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Executing ");
        _builder.append(method);
        _builder.append(" END");
        this.logger.trace((Object)_builder);
    }

    private Stopwatch initPerformanceTimers() {
        Stopwatch _xblockexpression = null;
        this.clearModelPerformance = Stopwatch.createUnstarted();
        this.hostTransformationPerformance = Stopwatch.createUnstarted();
        this.appTransformationPerformance = Stopwatch.createUnstarted();
        this.stateMachineTransformationPerformance = Stopwatch.createUnstarted();
        this.stateTransformationPerformance = Stopwatch.createUnstarted();
        this.transitionTransformationPerformance = Stopwatch.createUnstarted();
        this.triggerTransformationPerformance = Stopwatch.createUnstarted();
        this.transitionMappingCachingPerformance = Stopwatch.createUnstarted();
        _xblockexpression = this.otherTimer = Stopwatch.createUnstarted();
        return _xblockexpression;
    }

    public CPS2DeploymentBatchTransformationOptimized(CPSToDeployment mapping) {
        this.traceBegin("constructor");
        Preconditions.checkNotNull((Object)(mapping != null ? 1 : 0), (Object)"Mapping cannot be null!");
        CyberPhysicalSystem _cps = mapping.getCps();
        boolean _tripleNotEquals = _cps != null;
        Preconditions.checkArgument((boolean)_tripleNotEquals, (Object)"CPS not defined in mapping!");
        Deployment _deployment = mapping.getDeployment();
        boolean _tripleNotEquals_1 = _deployment != null;
        Preconditions.checkArgument((boolean)_tripleNotEquals_1, (Object)"Deployment not defined in mapping!");
        this.mapping = mapping;
        this.mappingCache = HashMultimap.create();
        this.reverseMappingCache = Maps.newHashMap();
        this.traceEnd("constructor");
    }

    private void reportPerformance() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(">>>Cleared model in: ");
        long _elapsed = this.clearModelPerformance.elapsed(TimeUnit.MILLISECONDS);
        _builder.append((Object)_elapsed);
        _builder.append(" ms");
        _builder.newLineIfNotEmpty();
        _builder.append(">>>Host transformation: ");
        long _elapsed_1 = this.hostTransformationPerformance.elapsed(TimeUnit.MILLISECONDS);
        _builder.append((Object)_elapsed_1);
        _builder.append(" ms");
        _builder.newLineIfNotEmpty();
        _builder.append(">>>Application Instance transformation: ");
        long _elapsed_2 = this.appTransformationPerformance.elapsed(TimeUnit.MILLISECONDS);
        _builder.append((Object)_elapsed_2);
        _builder.append(" ms");
        _builder.newLineIfNotEmpty();
        _builder.append(">>>State Machine transformation: ");
        long _elapsed_3 = this.stateMachineTransformationPerformance.elapsed(TimeUnit.MILLISECONDS);
        _builder.append((Object)_elapsed_3);
        _builder.append(" ms");
        _builder.newLineIfNotEmpty();
        _builder.append(">>>State transformation: ");
        long _elapsed_4 = this.stateTransformationPerformance.elapsed(TimeUnit.MILLISECONDS);
        _builder.append((Object)_elapsed_4);
        _builder.append(" ms");
        _builder.newLineIfNotEmpty();
        _builder.append(">>>Transition transformation: ");
        long _elapsed_5 = this.transitionTransformationPerformance.elapsed(TimeUnit.MILLISECONDS);
        _builder.append((Object)_elapsed_5);
        _builder.append(" ms");
        _builder.newLineIfNotEmpty();
        _builder.append(">>>Trigger transformation: ");
        long _elapsed_6 = this.triggerTransformationPerformance.elapsed(TimeUnit.MILLISECONDS);
        _builder.append((Object)_elapsed_6);
        _builder.append(" ms");
        _builder.newLineIfNotEmpty();
        _builder.append(">>>Other perf: ");
        long _elapsed_7 = this.otherTimer.elapsed(TimeUnit.MILLISECONDS);
        _builder.append((Object)_elapsed_7);
        _builder.append(" ms");
        this.logger.debug((Object)_builder);
    }

    public void execute() {
        this.traceBegin("execute()");
        this.initPerformanceTimers();
        this.otherTimer.start();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Executing transformation on:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("Cyber-physical system: ");
        String _identifier = this.mapping.getCps().getIdentifier();
        _builder.append(_identifier, "\t");
        this.logger.info((Object)_builder);
        this.clearModelPerformance.start();
        this.mapping.getTraces().clear();
        this.mapping.getDeployment().getHosts().clear();
        this.mappingCache.clear();
        this.reverseMappingCache.clear();
        this.clearModelPerformance.stop();
        Functions.Function1 _function = it -> it.getInstances();
        Iterable hosts = Iterables.concat((Iterable)ListExtensions.map((List)this.mapping.getCps().getHostTypes(), (Functions.Function1)_function));
        Functions.Function1 _function_1 = it -> this.transform((HostInstance)it);
        Iterable deploymentHosts = IterableExtensions.map((Iterable)hosts, (Functions.Function1)_function_1);
        EList _hosts = this.mapping.getDeployment().getHosts();
        Iterables.addAll((Collection)_hosts, (Iterable)deploymentHosts);
        Functions.Function1 _function_2 = it -> {
            Identifiable _head = (Identifiable)IterableExtensions.head((Iterable)it.getCpsElements());
            return _head instanceof Transition;
        };
        Consumer<CPS2DeploymentTrace> _function_3 = it -> this.createTransitionCache((CPS2DeploymentTrace)it);
        IterableExtensions.filter((Iterable)this.mapping.getTraces(), (Functions.Function1)_function_2).forEach(_function_3);
        this.assignTriggers();
        this.otherTimer.stop();
        this.traceEnd("execute()");
        this.reportPerformance();
    }

    private void assignTriggers() {
        this.traceBegin("assignTriggers()");
        this.triggerTransformationPerformance.start();
        Functions.Function1 _function = it -> {
            DeploymentElement _head = (DeploymentElement)IterableExtensions.head((Iterable)it.getDeploymentElements());
            return _head instanceof BehaviorTransition;
        };
        Iterable transitionMappings = IterableExtensions.filter((Iterable)this.mapping.getTraces(), (Functions.Function1)_function);
        Functions.Function1 _function_1 = it -> this.isTraceForSender((CPS2DeploymentTrace)it);
        Iterable senderTransitionMappings = IterableExtensions.filter((Iterable)transitionMappings, (Functions.Function1)_function_1);
        Consumer<CPS2DeploymentTrace> _function_2 = it -> this.findAndAssignReceivers((CPS2DeploymentTrace)it);
        senderTransitionMappings.forEach(_function_2);
        this.triggerTransformationPerformance.stop();
        this.traceEnd("assignTriggers()");
    }

    private void findAndAssignReceivers(CPS2DeploymentTrace senderTrace) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("findReceivers(");
        String _name = NamingUtil.name((EObject)senderTrace);
        _builder.append(_name);
        _builder.append(")");
        this.traceBegin(_builder.toString());
        Functions.Function1 _function = it -> {
            DeploymentElement _head = (DeploymentElement)IterableExtensions.head((Iterable)it.getDeploymentElements());
            return _head instanceof BehaviorTransition;
        };
        Iterable receiverTraces = IterableExtensions.filter((Iterable)this.mapping.getTraces(), (Functions.Function1)_function);
        Consumer<CPS2DeploymentTrace> _function_1 = it -> this.setTriggerIfConnected((CPS2DeploymentTrace)it, senderTrace);
        receiverTraces.forEach(_function_1);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("findReceivers(");
        String _name_1 = NamingUtil.name((EObject)senderTrace);
        _builder_1.append(_name_1);
        _builder_1.append(")");
        this.traceEnd(_builder_1.toString());
    }

    private void createTransitionCache(CPS2DeploymentTrace transitionTrace) {
        boolean _tripleEquals;
        this.transitionMappingCachingPerformance.start();
        Identifiable _head = (Identifiable)IterableExtensions.head((Iterable)transitionTrace.getCpsElements());
        Transition transition = (Transition)_head;
        String _action = transition.getAction();
        boolean bl = _tripleEquals = _action == null;
        if (_tripleEquals) {
            this.transitionMappingCachingPerformance.stop();
            return;
        }
        String actionId = SignalUtil.getSignalId((String)transition.getAction());
        EList _deploymentElements = transitionTrace.getDeploymentElements();
        for (DeploymentElement i : _deploymentElements) {
            BehaviorTransition behaviorTransition = (BehaviorTransition)i;
            EObject _eContainer = behaviorTransition.eContainer().eContainer();
            DeploymentApplication deploymentApp = (DeploymentApplication)_eContainer;
            EObject _eContainer_1 = deploymentApp.eContainer();
            DeploymentHost deploymentHost = (DeploymentHost)_eContainer_1;
            Identifiable _get = this.reverseMappingCache.get(deploymentHost);
            HostInstance hostInstance = (HostInstance)_get;
            Identifiable _get_1 = this.reverseMappingCache.get(deploymentApp);
            ApplicationInstance appInstance = (ApplicationInstance)_get_1;
            String appTypeId = appInstance.getType().getIdentifier();
            this.transitionToAppId.put(behaviorTransition, appTypeId);
            this.transitionToActionId.put(behaviorTransition, actionId);
            this.transitionToHost.put(behaviorTransition, hostInstance);
        }
        this.transitionMappingCachingPerformance.stop();
    }

    private void setTriggerIfConnected(CPS2DeploymentTrace receiverTrace, CPS2DeploymentTrace senderTrace) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("setTriggerIfConnected(");
        String _name = NamingUtil.name((EObject)receiverTrace);
        _builder.append(_name);
        _builder.append(",");
        String _name_1 = NamingUtil.name((EObject)senderTrace);
        _builder.append(_name_1);
        _builder.append(")");
        this.traceBegin(_builder.toString());
        boolean _isTraceForReceiver = this.isTraceForReceiver(receiverTrace);
        boolean bl = _not = !_isTraceForReceiver;
        if (_not) {
            return;
        }
        HashMap senderReceiverMappings = Maps.newHashMap();
        EList _deploymentElements = receiverTrace.getDeploymentElements();
        for (DeploymentElement sender : _deploymentElements) {
            senderReceiverMappings.put((BehaviorTransition)sender, receiverTrace.getDeploymentElements());
        }
        EList _deploymentElements_1 = receiverTrace.getDeploymentElements();
        for (DeploymentElement i : _deploymentElements_1) {
            BehaviorTransition receiverBehaviorTransition = (BehaviorTransition)i;
            Object appTypeId = this.transitionToAppId.get(receiverBehaviorTransition);
            Identifiable _head = (Identifiable)IterableExtensions.head((Iterable)senderTrace.getCpsElements());
            Transition senderTransition = (Transition)_head;
            String targetAppId = SignalUtil.getAppId((String)senderTransition.getAction());
            HostInstance receiverHostInstance = this.transitionToHost.get(receiverBehaviorTransition);
            this.transitionToActionId.get(receiverBehaviorTransition);
            Object receiverSignalId = this.transitionToActionId.get(receiverBehaviorTransition);
            EList _deploymentElements_2 = senderTrace.getDeploymentElements();
            for (DeploymentElement j : _deploymentElements_2) {
                boolean _isConnectedTo;
                BehaviorTransition senderBehaviorTransition = (BehaviorTransition)j;
                Object senderSignalId = this.transitionToActionId.get(senderBehaviorTransition);
                HostInstance senderHostInstance = this.transitionToHost.get(senderBehaviorTransition);
                if (!Objects.equal((Object)appTypeId, (Object)targetAppId) || !Objects.equal((Object)receiverSignalId, (Object)senderSignalId) || !(_isConnectedTo = this.isConnectedTo(senderHostInstance, receiverHostInstance))) continue;
                BehaviorTransition sender_1 = senderBehaviorTransition;
                BehaviorTransition receiver = receiverBehaviorTransition;
                EList _trigger = sender_1.getTrigger();
                _trigger.add((Object)receiver);
            }
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("setTriggerIfConnected(");
        String _name_2 = NamingUtil.name((EObject)receiverTrace);
        _builder_1.append(_name_2);
        _builder_1.append(",");
        String _name_3 = NamingUtil.name((EObject)senderTrace);
        _builder_1.append(_name_3);
        _builder_1.append(")");
        this.traceEnd(_builder_1.toString());
    }

    private boolean isTraceForSender(CPS2DeploymentTrace trace) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("isTraceForSender");
        String _name = NamingUtil.name((EObject)trace);
        _builder.append(_name);
        this.traceBegin(_builder.toString());
        boolean isSender = false;
        EList elements = trace.getCpsElements();
        for (Identifiable t : elements) {
            boolean bl = isSender = isSender || this.isTransitionSender((Transition)t);
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("isTraceForSender");
        String _name_1 = NamingUtil.name((EObject)trace);
        _builder_1.append(_name_1);
        this.traceEnd(_builder_1.toString());
        return isSender;
    }

    private boolean isTransitionSender(Transition transition) {
        boolean _tripleEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("isTransitionSender(");
        String _name = NamingUtil.name((EObject)transition);
        _builder.append(_name);
        _builder.append(")");
        this.traceBegin(_builder.toString());
        String _action = transition.getAction();
        boolean bl = _tripleEquals = _action == null;
        if (_tripleEquals) {
            return false;
        }
        boolean _isSend = SignalUtil.isSend((String)transition.getAction());
        if (_isSend) {
            return true;
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("isTransitionSender(");
        String _name_1 = NamingUtil.name((EObject)transition);
        _builder_1.append(_name_1);
        _builder_1.append(")");
        this.traceEnd(_builder_1.toString());
        return false;
    }

    private boolean isTraceForReceiver(CPS2DeploymentTrace trace) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("isTraceForReceiver(");
        String _name = NamingUtil.name((EObject)trace);
        _builder.append(_name);
        _builder.append(")");
        this.traceBegin(_builder.toString());
        boolean isReceiver = false;
        EList elements = trace.getCpsElements();
        for (Identifiable t : elements) {
            boolean bl = isReceiver = isReceiver || this.isTransitionReceiver((Transition)t);
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("isTraceForReceiver(");
        String _name_1 = NamingUtil.name((EObject)trace);
        _builder_1.append(_name_1);
        _builder_1.append(")");
        this.traceEnd(_builder_1.toString());
        return isReceiver;
    }

    private boolean isTransitionReceiver(Transition transition) {
        boolean _tripleEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("isTransitionReceiver(");
        String _name = NamingUtil.name((EObject)transition);
        _builder.append(_name);
        _builder.append(")");
        this.traceBegin(_builder.toString());
        String _action = transition.getAction();
        boolean bl = _tripleEquals = _action == null;
        if (_tripleEquals) {
            return false;
        }
        boolean _isWait = SignalUtil.isWait((String)transition.getAction());
        if (_isWait) {
            return true;
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("isTransitionReceiver(");
        String _name_1 = NamingUtil.name((EObject)transition);
        _builder_1.append(_name_1);
        _builder_1.append(")");
        this.traceEnd(_builder_1.toString());
        return false;
    }

    private boolean isConnectedTo(HostInstance src, HostInstance dst) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("isConnectedTo(");
        String _name = NamingUtil.name((EObject)src);
        _builder.append(_name);
        _builder.append(", ");
        String _name_1 = NamingUtil.name((EObject)dst);
        _builder.append(_name_1);
        _builder.append(")");
        this.traceBegin(_builder.toString());
        boolean communicates = Objects.equal((Object)src, (Object)dst) || src.getCommunicateWith().contains((Object)dst);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("isConnectedTo(");
        String _name_2 = NamingUtil.name((EObject)src);
        _builder_1.append(_name_2);
        _builder_1.append(", ");
        String _name_3 = NamingUtil.name((EObject)dst);
        _builder_1.append(_name_3);
        _builder_1.append(")");
        this.traceEnd(_builder_1.toString());
        return communicates;
    }

    private DeploymentHost transform(HostInstance hostInstance) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("transform(");
        String _name = NamingUtil.name((EObject)hostInstance);
        _builder.append(_name);
        _builder.append(")");
        this.traceBegin(_builder.toString());
        this.hostTransformationPerformance.start();
        DeploymentHost deploymentHost = DeploymentFactory.eINSTANCE.createDeploymentHost();
        deploymentHost.setIp(hostInstance.getNodeIp());
        this.createOrAddTrace((Identifiable)hostInstance, (DeploymentElement)deploymentHost);
        this.hostTransformationPerformance.stop();
        Functions.Function1 _function = it -> {
            ApplicationType _type = it.getType();
            CyberPhysicalSystem _cps = null;
            if (_type != null) {
                _cps = _type.getCps();
            }
            CyberPhysicalSystem _cps_1 = this.mapping.getCps();
            return Objects.equal((Object)_cps, (Object)_cps_1);
        };
        Iterable liveApplications = IterableExtensions.filter((Iterable)hostInstance.getApplications(), (Functions.Function1)_function);
        Functions.Function1 _function_1 = it -> this.transform((ApplicationInstance)it);
        Iterable deploymentApps = IterableExtensions.map((Iterable)liveApplications, (Functions.Function1)_function_1);
        EList _applications = deploymentHost.getApplications();
        Iterables.addAll((Collection)_applications, (Iterable)deploymentApps);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("transform(");
        String _name_1 = NamingUtil.name((EObject)hostInstance);
        _builder_1.append(_name_1);
        _builder_1.append(")");
        this.traceEnd(_builder_1.toString());
        return deploymentHost;
    }

    private DeploymentApplication transform(ApplicationInstance appInstance) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("transform(");
        String _name = NamingUtil.name((EObject)appInstance);
        _builder.append(_name);
        _builder.append(")");
        this.traceBegin(_builder.toString());
        this.appTransformationPerformance.start();
        DeploymentApplication deploymentApp = DeploymentFactory.eINSTANCE.createDeploymentApplication();
        deploymentApp.setId(appInstance.getIdentifier());
        this.createOrAddTrace((Identifiable)appInstance, (DeploymentElement)deploymentApp);
        this.appTransformationPerformance.stop();
        StateMachine _behavior = appInstance.getType().getBehavior();
        boolean bl = _tripleNotEquals = _behavior != null;
        if (_tripleNotEquals) {
            deploymentApp.setBehavior(this.transform(appInstance.getType().getBehavior()));
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("transform(");
        String _name_1 = NamingUtil.name((EObject)appInstance);
        _builder_1.append(_name_1);
        _builder_1.append(")");
        this.traceEnd(_builder_1.toString());
        return deploymentApp;
    }

    private DeploymentBehavior transform(StateMachine stateMachine) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("transform(");
        String _name = NamingUtil.name((EObject)stateMachine);
        _builder.append(_name);
        _builder.append(")");
        this.traceBegin(_builder.toString());
        this.stateMachineTransformationPerformance.start();
        DeploymentBehavior behavior = DeploymentFactory.eINSTANCE.createDeploymentBehavior();
        behavior.setDescription(stateMachine.getIdentifier());
        this.createOrAddTrace((Identifiable)stateMachine, (DeploymentElement)behavior);
        this.stateMachineTransformationPerformance.stop();
        Functions.Function1 _function = it -> this.transform((State)it);
        List behaviorStates = ListExtensions.map((List)stateMachine.getStates(), (Functions.Function1)_function);
        EList _states = behavior.getStates();
        Iterables.addAll((Collection)_states, (Iterable)behaviorStates);
        ArrayList behaviorTransitions = new ArrayList();
        EList _states_1 = stateMachine.getStates();
        for (State state : _states_1) {
            Functions.Function1 _function_1 = it -> behavior.getStates().contains(it);
            DeploymentElement _findFirst = (DeploymentElement)IterableExtensions.findFirst((Iterable)this.mappingCache.get((Object)state), (Functions.Function1)_function_1);
            BehaviorState parentBehaviorState = (BehaviorState)_findFirst;
            Functions.Function1 _function_2 = it -> {
                State _targetState = it.getTargetState();
                return _targetState != null;
            };
            Functions.Function1 _function_3 = transition -> this.mappingCache.get((Object)transition.getTargetState()) != null && transition.getTargetState().eContainer() != null;
            Functions.Function1 _function_4 = it -> this.transform((Transition)it, parentBehaviorState);
            Iterables.addAll(behaviorTransitions, (Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.filter((Iterable)state.getOutgoingTransitions(), (Functions.Function1)_function_2), (Functions.Function1)_function_3), (Functions.Function1)_function_4));
        }
        this.stateMachineTransformationPerformance.start();
        EList _transitions = behavior.getTransitions();
        Iterables.addAll((Collection)_transitions, behaviorTransitions);
        this.setCurrentState(stateMachine, behavior);
        this.stateMachineTransformationPerformance.stop();
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("transform(");
        String _name_1 = NamingUtil.name((EObject)stateMachine);
        _builder_1.append(_name_1);
        _builder_1.append(")");
        this.traceEnd(_builder_1.toString());
        return behavior;
    }

    private BehaviorState transform(State state) {
        BehaviorState _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("transform(");
        String _name = NamingUtil.name((EObject)state);
        _builder.append(_name);
        _builder.append(")");
        this.traceBegin(_builder.toString());
        this.stateTransformationPerformance.start();
        BehaviorState behaviorState = DeploymentFactory.eINSTANCE.createBehaviorState();
        behaviorState.setDescription(state.getIdentifier());
        this.createOrAddTrace((Identifiable)state, (DeploymentElement)behaviorState);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("transform(");
        String _name_1 = NamingUtil.name((EObject)state);
        _builder_1.append(_name_1);
        _builder_1.append(")");
        this.traceEnd(_builder_1.toString());
        this.stateTransformationPerformance.stop();
        _xblockexpression = behaviorState;
        return _xblockexpression;
    }

    private BehaviorTransition transform(Transition transition, BehaviorState behaviorState) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("transform(");
        String _name = NamingUtil.name((EObject)transition);
        _builder.append(_name);
        _builder.append(", ");
        String _name_1 = NamingUtil.name((EObject)behaviorState);
        _builder.append(_name_1);
        _builder.append(")");
        this.traceBegin(_builder.toString());
        this.transitionTransformationPerformance.start();
        BehaviorTransition behaviorTransition = DeploymentFactory.eINSTANCE.createBehaviorTransition();
        Set dep = this.mappingCache.get((Object)transition.getTargetState());
        Functions.Function1 _function = it -> it.eContainer().equals(behaviorState.eContainer());
        BehaviorState targetBehaviorState = (BehaviorState)IterableExtensions.findFirst((Iterable)Iterables.filter((Iterable)dep, BehaviorState.class), (Functions.Function1)_function);
        behaviorTransition.setTo(targetBehaviorState);
        EList _outgoing = behaviorState.getOutgoing();
        _outgoing.add((Object)behaviorTransition);
        behaviorTransition.setDescription(transition.getIdentifier());
        this.createOrAddTrace((Identifiable)transition, (DeploymentElement)behaviorTransition);
        this.transitionTransformationPerformance.stop();
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("transform(");
        String _name_2 = NamingUtil.name((EObject)transition);
        _builder_1.append(_name_2);
        _builder_1.append(", ");
        String _name_3 = NamingUtil.name((EObject)behaviorState);
        _builder_1.append(_name_3);
        _builder_1.append(")");
        this.traceEnd(_builder_1.toString());
        return behaviorTransition;
    }

    private void setCurrentState(StateMachine stateMachine, DeploymentBehavior behavior) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("transform(");
        String _name = NamingUtil.name((EObject)stateMachine);
        _builder.append(_name);
        _builder.append(", ");
        String _name_1 = NamingUtil.name((EObject)behavior);
        _builder.append(_name_1);
        _builder.append(")");
        this.traceBegin(_builder.toString());
        State initial = stateMachine.getInitial();
        if (initial != null) {
            Functions.Function1 _function = it -> behavior.getStates().contains(it);
            DeploymentElement initialBehaviorState = (DeploymentElement)IterableExtensions.findFirst((Iterable)this.mappingCache.get((Object)initial), (Functions.Function1)_function);
            behavior.setCurrent((BehaviorState)initialBehaviorState);
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("transform(");
        String _name_2 = NamingUtil.name((EObject)stateMachine);
        _builder_1.append(_name_2);
        _builder_1.append(", ");
        String _name_3 = NamingUtil.name((EObject)behavior);
        _builder_1.append(_name_3);
        _builder_1.append(")");
        this.traceEnd(_builder_1.toString());
    }

    private CPS2DeploymentTrace createOrAddTrace(Identifiable identifiable, DeploymentElement deploymentElement) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("createOrAddTrace(");
        String _name = NamingUtil.name((EObject)identifiable);
        _builder.append(_name);
        _builder.append(", ");
        String _name_1 = NamingUtil.name((EObject)deploymentElement);
        _builder.append(_name_1);
        _builder.append(")");
        this.traceBegin(_builder.toString());
        Functions.Function1 _function = it -> it.getCpsElements().contains((Object)identifiable);
        Iterable trace = IterableExtensions.filter((Iterable)this.mapping.getTraces(), (Functions.Function1)_function);
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)trace);
        if (_isEmpty) {
            return this.createTrace(identifiable, deploymentElement);
        }
        EList _deploymentElements = ((CPS2DeploymentTrace)IterableExtensions.head((Iterable)trace)).getDeploymentElements();
        _deploymentElements.add((Object)deploymentElement);
        this.mappingCache.put((Object)identifiable, (Object)deploymentElement);
        this.reverseMappingCache.put(deploymentElement, identifiable);
        boolean _isEmpty_1 = IterableExtensions.isEmpty((Iterable)IterableExtensions.tail((Iterable)trace));
        boolean bl = _not = !_isEmpty_1;
        if (_not) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("More than one mapping was created to state machine with Id '");
            String _identifier = identifiable.getIdentifier();
            _builder_1.append(_identifier);
            _builder_1.append("'.");
            throw new IllegalStateException(_builder_1.toString());
        }
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append("createOrAddTrace(");
        String _name_2 = NamingUtil.name((EObject)identifiable);
        _builder_2.append(_name_2);
        _builder_2.append(", ");
        String _name_3 = NamingUtil.name((EObject)deploymentElement);
        _builder_2.append(_name_3);
        _builder_2.append(")");
        this.traceEnd(_builder_2.toString());
        return (CPS2DeploymentTrace)IterableExtensions.head((Iterable)trace);
    }

    private CPS2DeploymentTrace createTrace(Identifiable identifiable, DeploymentElement deploymentElement) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("createTrace(");
        String _name = NamingUtil.name((EObject)identifiable);
        _builder.append(_name);
        _builder.append(", ");
        String _name_1 = NamingUtil.name((EObject)deploymentElement);
        _builder.append(_name_1);
        _builder.append(")");
        this.traceBegin(_builder.toString());
        CPS2DeploymentTrace trace = TraceabilityFactory.eINSTANCE.createCPS2DeploymentTrace();
        EList _cpsElements = trace.getCpsElements();
        _cpsElements.add((Object)identifiable);
        EList _deploymentElements = trace.getDeploymentElements();
        _deploymentElements.add((Object)deploymentElement);
        EList _traces = this.mapping.getTraces();
        _traces.add((Object)trace);
        this.mappingCache.put((Object)identifiable, (Object)deploymentElement);
        this.reverseMappingCache.put(deploymentElement, identifiable);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("createTrace(");
        String _name_2 = NamingUtil.name((EObject)identifiable);
        _builder_1.append(_name_2);
        _builder_1.append(", ");
        String _name_3 = NamingUtil.name((EObject)deploymentElement);
        _builder_1.append(_name_3);
        _builder_1.append(")");
        this.traceBegin(_builder_1.toString());
        return trace;
    }

    public void dispose() {
        this.traceBegin("dispose()");
        this.traceEnd("dispose()");
    }
}

