/*
 * Copyright (c) 2015 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;

import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.LazyLongIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableLongBag;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.LongPredicate;
import org.eclipse.collections.api.block.predicate.primitive.ObjectLongPredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectLongProcedure;
import org.eclipse.collections.api.map.primitive.ObjectLongMap;
import org.eclipse.collections.api.collection.ImmutableCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableLongCollection;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.map.primitive.ImmutableObjectLongMap;
import org.eclipse.collections.api.map.primitive.MutableObjectLongMap;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.api.tuple.primitive.ObjectLongPair;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableLongCollection;
import org.eclipse.collections.impl.iterator.UnmodifiableLongIterator;
import org.eclipse.collections.impl.map.mutable.primitive.ObjectLongHashMap;
import org.eclipse.collections.impl.set.mutable.UnmodifiableMutableSet;

/**
 * ImmutableObjectLongHashMap is the non-modifiable equivalent of {@link ObjectLongHashMap}.
 * This file was automatically generated from template file immutableObjectPrimitiveHashMap.stg.
 *
 * @since 4.0.
 */
final class ImmutableObjectLongHashMap<K> extends AbstractImmutableObjectLongMap<K> implements Serializable
{
    private static final long serialVersionUID = 1L;
    private final MutableObjectLongMap<K> delegate;

    ImmutableObjectLongHashMap(ObjectLongMap<? extends K> delegate)
    {
        this.delegate = new ObjectLongHashMap<K>(delegate);
    }

    public LongIterator longIterator()
    {
        return new UnmodifiableLongIterator(this.delegate.longIterator());
    }

    public void forEach(LongProcedure procedure)
    {
        this.each(procedure);
    }

    /**
     * @since 7.0.
     */
    public void each(LongProcedure procedure)
    {
        this.delegate.forEach(procedure);
    }

    public int count(LongPredicate predicate)
    {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(LongPredicate predicate)
    {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean allSatisfy(LongPredicate predicate)
    {
        return this.delegate.allSatisfy(predicate);
    }

    public boolean noneSatisfy(LongPredicate predicate)
    {
        return this.delegate.noneSatisfy(predicate);
    }

    public ImmutableLongCollection select(LongPredicate predicate)
    {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableLongCollection reject(LongPredicate predicate)
    {
        return this.delegate.reject(predicate).toImmutable();
    }

    public long detectIfNone(LongPredicate predicate, long ifNone)
    {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function)
    {
        return this.delegate.injectInto(injectedValue, function);
    }

    public <V> ImmutableCollection<V> collect(LongToObjectFunction<? extends V> function)
    {
        return this.delegate.collect(function).toImmutable();
    }

    public long sum()
    {
        return this.delegate.sum();
    }

    public long max()
    {
        return this.delegate.max();
    }

    public long maxIfEmpty(long defaultValue)
    {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    public long min()
    {
        return this.delegate.min();
    }

    public long minIfEmpty(long defaultValue)
    {
        return this.delegate.minIfEmpty(defaultValue);
    }

    public double average()
    {
        return this.delegate.average();
    }

    public double median()
    {
        return this.delegate.median();
    }

    public long[] toSortedArray()
    {
        return this.delegate.toSortedArray();
    }

    public MutableLongList toSortedList()
    {
        return this.delegate.toSortedList();
    }

    public long[] toArray()
    {
        return this.delegate.toArray();
    }

    public boolean contains(long value)
    {
        return this.delegate.contains(value);
    }

    public boolean containsAll(long... source)
    {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(LongIterable source)
    {
        return this.delegate.containsAll(source);
    }

    public MutableLongList toList()
    {
        return this.delegate.toList();
    }

    public MutableLongSet toSet()
    {
        return this.delegate.toSet();
    }

    public MutableLongBag toBag()
    {
        return this.delegate.toBag();
    }

    public LazyLongIterable asLazy()
    {
        return this.delegate.asLazy();
    }

    public ImmutableObjectLongMap<K> newWithKeyValue(K key, long value)
    {
        ObjectLongHashMap<K> map = ObjectLongHashMap.newMap();
        map.putAll(this);
        map.put(key, value);
        return map.toImmutable();
    }

    public ImmutableObjectLongMap<K> newWithoutKey(K key)
    {
        ObjectLongHashMap<K> map = ObjectLongHashMap.newMap();
        map.putAll(this);
        map.removeKey(key);
        return map.toImmutable();
    }

    public ImmutableObjectLongMap<K> newWithoutAllKeys(Iterable<? extends K> keys)
    {
        ObjectLongHashMap<K> map = ObjectLongHashMap.newMap();
        map.putAll(this);
        Iterator<? extends K> iterator = keys.iterator();
        while (iterator.hasNext())
        {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    public long get(Object key)
    {
        return this.delegate.get(key);
    }

    public long getOrThrow(Object key)
    {
        return this.delegate.getOrThrow(key);
    }

    public long getIfAbsent(Object key, long ifAbsent)
    {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    public boolean containsKey(Object key)
    {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(long value)
    {
        return this.delegate.containsValue(value);
    }

    public void forEachValue(LongProcedure procedure)
    {
        this.delegate.forEachValue(procedure);
    }

    public void forEachKey(Procedure<? super K> procedure)
    {
        this.delegate.forEachKey(procedure);
    }

    public void forEachKeyValue(ObjectLongProcedure<? super K> objectLongProcedure)
    {
        this.delegate.forEachKeyValue(objectLongProcedure);
    }

    public ImmutableObjectLongMap<K> select(ObjectLongPredicate<? super K> objectLongPredicate)
    {
        return this.delegate.select(objectLongPredicate).toImmutable();
    }

    public ImmutableObjectLongMap<K> reject(ObjectLongPredicate<? super K> objectLongPredicate)
    {
        return this.delegate.reject(objectLongPredicate).toImmutable();
    }

    public ImmutableObjectLongMap<K> toImmutable()
    {
        return this;
    }

    public int size()
    {
        return this.delegate.size();
    }

    public boolean isEmpty()
    {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty()
    {
        return this.delegate.notEmpty();
    }

    public Set<K> keySet()
    {
        return UnmodifiableMutableSet.of(this.delegate.keySet());
    }

    public MutableLongCollection values()
    {
        return UnmodifiableLongCollection.of(this.delegate.values());
    }

    public LazyIterable<K> keysView()
    {
        return this.delegate.keysView();
    }

    public RichIterable<ObjectLongPair<K>> keyValuesView()
    {
        return this.delegate.keyValuesView();
    }

    @Override
    public boolean equals(Object obj)
    {
        return this.delegate.equals(obj);
    }

    @Override
    public int hashCode()
    {
        return this.delegate.hashCode();
    }

    @Override
    public String toString()
    {
        return this.delegate.toString();
    }

    public String makeString()
    {
        return this.delegate.makeString();
    }

    public String makeString(String separator)
    {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end)
    {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable)
    {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        this.delegate.appendString(appendable, start, separator, end);
    }

    private Object writeReplace()
    {
        return new ImmutableObjectLongMapSerializationProxy<K>(this);
    }
}
