/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs;

import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.remote.core.IRemoteFileService;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.ISessionInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.SessionInfo;
import org.eclipse.tracecompass.internal.lttng2.control.ui.Activator;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.ICreateSessionDialog;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.messages.Messages;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TargetNodeComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceSessionGroup;
import org.eclipse.tracecompass.tmf.remote.core.proxy.RemoteSystemProxy;

public class CreateSessionDialog
extends TitleAreaDialog
implements ICreateSessionDialog {
    public static final String CREATE_SESSION_ICON_FILE = "icons/elcl16/add_button.gif";
    private static final String DEFAULT_TEXT = "<" + Messages.EnableChannelDialog_DefaultMessage + ">";
    private static final int COMMON_URL_LAST_INDEX = 1;
    private static final int DEFAULT_URL_INDEX = 0;
    private Composite fDialogComposite = null;
    private Text fSessionNameText = null;
    private Label fSessionPathLabel = null;
    private Text fSessionPathText = null;
    private Button fNormalModeButton = null;
    private Button fSnapshotButton = null;
    private Group fModeButtonGroup = null;
    private Button fLiveButton = null;
    private Text fLiveDelayText = null;
    private Group fAdvancedGroup = null;
    private Button fAdvancedButton = null;
    private Composite fStreamingComposite = null;
    private Text fTracePathText = null;
    private Button fLinkDataWithControlButton = null;
    private CCombo fControlProtocolCombo = null;
    private ControlProtocolSelectionListener fCopyProtocolSelectionListener;
    private ProtocolComboSelectionListener fControlProtocolSelectionListener;
    private ProtocolComboSelectionListener fDataProtocolSelectionListener;
    private Text fControlHostAddressText = null;
    private CopyModifyListener fControlUrlKeyListener;
    private UpdateEnablementModifyListener fUpdateEnablementModifyListener;
    private Text fControlPortText = null;
    private CCombo fDataProtocolCombo = null;
    private Text fDataHostAddressText = null;
    private Text fDataPortText = null;
    private TraceSessionGroup fParent = null;
    private String fSessionName = "";
    private String fSessionPath = null;
    private boolean fIsSnapshot = false;
    private boolean fIsLive = false;
    private Text fLiveHostAddressText = null;
    private Text fLivePortText = null;
    private Long fLiveDelay = 0L;
    private String fLiveUrl = null;
    private Integer fLivePort = 0;
    private boolean fIsDefaultPath = true;
    private boolean fIsAdvancedEnabled = false;
    private String fNetworkUrl = null;
    private String fControlUrl = null;
    private String fDataUrl = null;
    private String fTracePath = null;
    private Group fLiveGroup = null;

    public CreateSessionDialog(Shell shell) {
        super(shell);
        this.setShellStyle(0x10 | this.getShellStyle());
    }

    @Override
    public void initialize(TraceSessionGroup group) {
        this.fParent = group;
        this.fStreamingComposite = null;
        this.fLiveGroup = null;
        this.fLiveButton = null;
        this.fIsLive = false;
        this.fSnapshotButton = null;
        this.fSessionName = "";
        this.fSessionPath = null;
        this.fIsSnapshot = false;
        this.fIsDefaultPath = true;
        this.fIsAdvancedEnabled = false;
        this.fNetworkUrl = null;
        this.fControlUrl = null;
        this.fDataUrl = null;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.TraceControl_CreateSessionDialogTitle);
        newShell.setImage(Activator.getDefault().loadIcon(CREATE_SESSION_ICON_FILE));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogAreaa = (Composite)super.createDialogArea(parent);
        this.setTitle(Messages.TraceControl_CreateSessionDialogTitle);
        this.setMessage(Messages.TraceControl_CreateSessionDialogMessage);
        this.fDialogComposite = new Composite(dialogAreaa, 0);
        GridLayout layout = new GridLayout(1, true);
        this.fDialogComposite.setLayout((Layout)layout);
        this.fDialogComposite.setLayoutData((Object)new GridData(1808));
        Group sessionGroup = new Group(this.fDialogComposite, 32);
        sessionGroup.setLayoutData((Object)new GridData(768));
        sessionGroup.setLayout((Layout)new GridLayout(4, true));
        this.fUpdateEnablementModifyListener = new UpdateEnablementModifyListener();
        Label sessionNameLabel = new Label((Composite)sessionGroup, 131072);
        sessionNameLabel.setText(Messages.TraceControl_CreateSessionNameLabel);
        this.fSessionNameText = new Text((Composite)sessionGroup, 0);
        this.fSessionNameText.setToolTipText(Messages.TraceControl_CreateSessionNameTooltip);
        this.fSessionNameText.addModifyListener((ModifyListener)this.fUpdateEnablementModifyListener);
        GridData data = new GridData(768);
        data.horizontalSpan = 3;
        this.fSessionNameText.setLayoutData((Object)data);
        this.fSessionPathLabel = new Label((Composite)sessionGroup, 131072);
        this.fSessionPathLabel.setText(Messages.TraceControl_CreateSessionPathLabel);
        this.fSessionPathText = new Text((Composite)sessionGroup, 0);
        this.fSessionPathText.setToolTipText(Messages.TraceControl_CreateSessionPathTooltip);
        data = new GridData(768);
        data.horizontalSpan = 3;
        this.fSessionPathText.setLayoutData((Object)data);
        this.fSessionPathText.addModifyListener((ModifyListener)this.fUpdateEnablementModifyListener);
        if (this.fParent.isSnapshotSupported() || this.fParent.isLiveSupported()) {
            this.fModeButtonGroup = new Group((Composite)sessionGroup, 0);
            data = new GridData(768);
            data.horizontalSpan = 4;
            this.fModeButtonGroup.setLayoutData((Object)data);
            this.fModeButtonGroup.setLayout((Layout)new GridLayout(3, true));
            SelectionAdapter modeChangedListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (CreateSessionDialog.this.fLiveButton != null) {
                        if (CreateSessionDialog.this.fLiveButton.getSelection()) {
                            CreateSessionDialog.this.createAdvancedLiveGroup();
                            CreateSessionDialog.this.updateSessionPathEnablement();
                            CreateSessionDialog.this.updateProtocolComboItems();
                        } else {
                            CreateSessionDialog.this.disposeLiveGroup();
                            CreateSessionDialog.this.updateSessionPathEnablement();
                            CreateSessionDialog.this.updateProtocolComboItems();
                        }
                    }
                    CreateSessionDialog.this.updateEnablement();
                }
            };
            this.fNormalModeButton = new Button((Composite)this.fModeButtonGroup, 16);
            this.fNormalModeButton.setText(Messages.TraceControl_CreateSessionNormalLabel);
            this.fNormalModeButton.setToolTipText(Messages.TraceControl_CreateSessionNormalTooltip);
            this.fNormalModeButton.setSelection(true);
            this.fNormalModeButton.addSelectionListener((SelectionListener)modeChangedListener);
            if (this.fParent.isSnapshotSupported()) {
                this.fSnapshotButton = new Button((Composite)this.fModeButtonGroup, 16);
                this.fSnapshotButton.setText(Messages.TraceControl_CreateSessionSnapshotLabel);
                this.fSnapshotButton.setToolTipText(Messages.TraceControl_CreateSessionSnapshotTooltip);
                this.fSnapshotButton.addSelectionListener((SelectionListener)modeChangedListener);
            }
            if (this.fParent.isLiveSupported()) {
                this.fLiveButton = new Button((Composite)this.fModeButtonGroup, 16);
                this.fLiveButton.setText(Messages.TraceControl_CreateSessionLiveLabel);
                this.fLiveButton.setToolTipText(Messages.TraceControl_CreateSessionLiveTooltip);
                this.fLiveButton.addSelectionListener((SelectionListener)modeChangedListener);
            }
        }
        if (this.fParent.isNetworkStreamingSupported() || this.fParent.isLiveSupported()) {
            this.createAdvancedOptionsComposite();
        }
        return this.fDialogComposite;
    }

    private void createAdvancedOptionsComposite() {
        this.fAdvancedGroup = new Group(this.fDialogComposite, 32);
        this.fAdvancedGroup.setLayoutData((Object)new GridData(1808));
        this.fAdvancedGroup.setLayout((Layout)new GridLayout(1, true));
        this.fAdvancedButton = new Button((Composite)this.fAdvancedGroup, 8);
        this.fAdvancedButton.setText(String.valueOf(Messages.TraceControl_CreateSessionConfigureStreamingButtonText) + " >>>");
        this.fAdvancedButton.setToolTipText(Messages.TraceControl_CreateSessionConfigureStreamingButtonTooltip);
        this.fAdvancedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CreateSessionDialog.this.fIsAdvancedEnabled) {
                    CreateSessionDialog.this.fIsAdvancedEnabled = false;
                    CreateSessionDialog.this.fAdvancedButton.setText(String.valueOf(Messages.TraceControl_CreateSessionConfigureStreamingButtonText) + " >>>");
                    CreateSessionDialog.this.fAdvancedButton.setToolTipText(Messages.TraceControl_CreateSessionConfigureStreamingButtonTooltip);
                    if (CreateSessionDialog.this.fParent.isNetworkStreamingSupported()) {
                        CreateSessionDialog.this.updateSessionPathEnablement();
                        CreateSessionDialog.this.disposeConfigureStreamingComposite();
                    }
                    if (CreateSessionDialog.this.fParent.isLiveSupported()) {
                        CreateSessionDialog.this.disposeLiveGroup();
                    }
                } else {
                    CreateSessionDialog.this.fIsAdvancedEnabled = true;
                    CreateSessionDialog.this.fAdvancedButton.setText("<<< " + Messages.TraceControl_CreateSessionNoStreamingButtonText);
                    CreateSessionDialog.this.fAdvancedButton.setToolTipText(Messages.TraceControl_CreateSessionNoStreamingButtonTooltip);
                    if (CreateSessionDialog.this.fParent.isNetworkStreamingSupported()) {
                        CreateSessionDialog.this.updateSessionPathEnablement();
                        CreateSessionDialog.this.createConfigureStreamingComposite();
                    }
                    if (CreateSessionDialog.this.fLiveButton != null && CreateSessionDialog.this.fLiveButton.getSelection()) {
                        CreateSessionDialog.this.createAdvancedLiveGroup();
                    }
                }
                CreateSessionDialog.this.updateEnablement();
                CreateSessionDialog.this.getShell().pack();
            }
        });
    }

    private void updateSessionPathEnablement() {
        if (this.fIsAdvancedEnabled || this.fIsLive) {
            this.fSessionPathText.setEnabled(false);
            this.fSessionPathText.setText("");
            this.fSessionPathLabel.setText("");
        } else {
            this.fSessionPathText.setEnabled(true);
            this.fSessionPathLabel.setText(Messages.TraceControl_CreateSessionPathLabel);
        }
    }

    private void updateProtocolComboItems() {
        if (this.fControlProtocolCombo == null || this.fControlProtocolCombo.isDisposed()) {
            return;
        }
        int currentSelection = this.fControlProtocolCombo.getSelectionIndex() <= 1 ? this.fControlProtocolCombo.getSelectionIndex() : 0;
        this.fControlProtocolCombo.removeAll();
        Enum[] values = this.fIsLive ? LiveProtocol.values() : (this.fLinkDataWithControlButton.getSelection() ? StreamingProtocol.values() : StreamingProtocol2.values());
        String[] controlItems = new String[values.length];
        int i = 0;
        while (i < controlItems.length) {
            controlItems[i] = values[i].name();
            ++i;
        }
        this.fControlProtocolCombo.setItems(controlItems);
        this.fDataProtocolCombo.setItems(controlItems);
        if (currentSelection != -1) {
            this.fControlProtocolCombo.select(currentSelection);
            this.fDataProtocolCombo.select(currentSelection);
        }
    }

    private void createConfigureStreamingComposite() {
        if (this.fStreamingComposite == null) {
            this.fStreamingComposite = new Group((Composite)this.fAdvancedGroup, 32);
            GridLayout layout = new GridLayout(1, true);
            this.fStreamingComposite.setLayout((Layout)layout);
            this.fStreamingComposite.setLayoutData((Object)new GridData(1808));
            layout = new GridLayout(7, true);
            this.fStreamingComposite.setLayout((Layout)layout);
            this.fStreamingComposite.setLayoutData((Object)new GridData(1808));
            Label tracePathLabel = new Label(this.fStreamingComposite, 131072);
            tracePathLabel.setText(Messages.TraceControl_CreateSessionTracePathText);
            this.fTracePathText = new Text(this.fStreamingComposite, 0);
            this.fTracePathText.setToolTipText(Messages.TraceControl_CreateSessionTracePathTooltip);
            GridData data = new GridData(768);
            data.horizontalSpan = 6;
            this.fTracePathText.setLayoutData((Object)data);
            this.fTracePathText.addModifyListener((ModifyListener)this.fUpdateEnablementModifyListener);
            this.fLinkDataWithControlButton = new Button(this.fStreamingComposite, 32);
            this.fLinkDataWithControlButton.setText(Messages.TraceControl_CreateSessionLinkButtonText);
            this.fLinkDataWithControlButton.setToolTipText(Messages.TraceControl_CreateSessionLinkButtonTooltip);
            data = new GridData(768);
            data.horizontalSpan = 7;
            this.fLinkDataWithControlButton.setLayoutData((Object)data);
            this.fLinkDataWithControlButton.setSelection(true);
            Label label = new Label(this.fStreamingComposite, 0);
            data = new GridData(768);
            data.horizontalSpan = 1;
            label.setLayoutData((Object)data);
            label = new Label(this.fStreamingComposite, 0);
            label.setText(Messages.TraceControl_CreateSessionProtocolLabelText);
            data = new GridData(768);
            data.horizontalSpan = 1;
            label.setLayoutData((Object)data);
            label = new Label(this.fStreamingComposite, 0);
            label.setText(Messages.TraceControl_CreateSessionAddressLabelText);
            data = new GridData(768);
            data.horizontalSpan = 4;
            label.setLayoutData((Object)data);
            label = new Label(this.fStreamingComposite, 0);
            label.setText(Messages.TraceControl_CreateSessionPortLabelText);
            data = new GridData(768);
            data.horizontalSpan = 1;
            label.setLayoutData((Object)data);
            label = new Label(this.fStreamingComposite, 131072);
            label.setText(Messages.TraceControl_CreateSessionControlUrlLabel);
            data = new GridData(768);
            data.horizontalSpan = 1;
            label.setLayoutData((Object)data);
            this.fControlProtocolCombo = new CCombo(this.fStreamingComposite, 8);
            this.fControlProtocolCombo.setToolTipText(Messages.TraceControl_CreateSessionCommonProtocolTooltip);
            data = new GridData(768);
            data.horizontalSpan = 1;
            this.fControlProtocolCombo.setLayoutData((Object)data);
            this.fControlProtocolCombo.addModifyListener((ModifyListener)this.fUpdateEnablementModifyListener);
            this.fControlHostAddressText = new Text(this.fStreamingComposite, 0);
            this.fControlHostAddressText.setToolTipText(Messages.TraceControl_CreateSessionControlAddressTooltip);
            data = new GridData(768);
            data.horizontalSpan = 4;
            this.fControlHostAddressText.setLayoutData((Object)data);
            this.fControlHostAddressText.addModifyListener((ModifyListener)this.fUpdateEnablementModifyListener);
            this.fControlPortText = new Text(this.fStreamingComposite, 0);
            this.fControlPortText.setToolTipText(Messages.TraceControl_CreateSessionControlPortTooltip);
            data = new GridData(768);
            data.horizontalSpan = 1;
            this.fControlPortText.setLayoutData((Object)data);
            this.fControlPortText.addModifyListener((ModifyListener)this.fUpdateEnablementModifyListener);
            label = new Label(this.fStreamingComposite, 131072);
            label.setText(Messages.TraceControl_CreateSessionDataUrlLabel);
            data = new GridData(768);
            data.horizontalSpan = 1;
            label.setLayoutData((Object)data);
            this.fDataProtocolCombo = new CCombo(this.fStreamingComposite, 8);
            this.fDataProtocolCombo.setEnabled(false);
            this.fDataProtocolCombo.setToolTipText(Messages.TraceControl_CreateSessionProtocolTooltip);
            data = new GridData(768);
            data.horizontalSpan = 1;
            this.fDataProtocolCombo.setLayoutData((Object)data);
            this.fDataProtocolCombo.addModifyListener((ModifyListener)this.fUpdateEnablementModifyListener);
            this.updateProtocolComboItems();
            this.fDataHostAddressText = new Text(this.fStreamingComposite, 0);
            this.fDataHostAddressText.setEnabled(false);
            this.fDataHostAddressText.setToolTipText(Messages.TraceControl_CreateSessionDataAddressTooltip);
            data = new GridData(768);
            data.horizontalSpan = 4;
            this.fDataHostAddressText.setLayoutData((Object)data);
            this.fDataHostAddressText.addModifyListener((ModifyListener)this.fUpdateEnablementModifyListener);
            this.fDataPortText = new Text(this.fStreamingComposite, 0);
            this.fDataPortText.setEnabled(true);
            this.fDataPortText.setToolTipText(Messages.TraceControl_CreateSessionDataPortTooltip);
            data = new GridData(768);
            data.horizontalSpan = 1;
            this.fDataPortText.setLayoutData((Object)data);
            this.fDataPortText.addModifyListener((ModifyListener)this.fUpdateEnablementModifyListener);
            this.fCopyProtocolSelectionListener = new ControlProtocolSelectionListener();
            this.fControlProtocolSelectionListener = new ProtocolComboSelectionListener(this.fControlProtocolCombo, this.fControlPortText);
            this.fDataProtocolSelectionListener = new ProtocolComboSelectionListener(this.fDataProtocolCombo, this.fDataPortText);
            this.fControlProtocolCombo.addSelectionListener((SelectionListener)this.fCopyProtocolSelectionListener);
            this.fControlUrlKeyListener = new CopyModifyListener(this.fControlHostAddressText, this.fDataHostAddressText);
            this.fControlHostAddressText.addModifyListener((ModifyListener)this.fControlUrlKeyListener);
            this.fControlProtocolCombo.select(0);
            this.fDataProtocolCombo.select(0);
            this.fLinkDataWithControlButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (CreateSessionDialog.this.fLinkDataWithControlButton.getSelection()) {
                        CreateSessionDialog.this.fDataProtocolCombo.setEnabled(false);
                        CreateSessionDialog.this.fDataHostAddressText.setEnabled(false);
                        CreateSessionDialog.this.fControlPortText.setEnabled(true);
                        CreateSessionDialog.this.fDataPortText.setEnabled(true);
                        CreateSessionDialog.this.fControlProtocolCombo.removeSelectionListener((SelectionListener)CreateSessionDialog.this.fControlProtocolSelectionListener);
                        CreateSessionDialog.this.fDataProtocolCombo.removeSelectionListener((SelectionListener)CreateSessionDialog.this.fDataProtocolSelectionListener);
                        CreateSessionDialog.this.fControlProtocolCombo.addSelectionListener((SelectionListener)CreateSessionDialog.this.fCopyProtocolSelectionListener);
                        CreateSessionDialog.this.fControlHostAddressText.addModifyListener((ModifyListener)CreateSessionDialog.this.fControlUrlKeyListener);
                        CreateSessionDialog.this.updateProtocolComboItems();
                        CreateSessionDialog.this.fDataHostAddressText.setText(CreateSessionDialog.this.fControlHostAddressText.getText());
                        CreateSessionDialog.this.fControlProtocolCombo.setToolTipText(Messages.TraceControl_CreateSessionCommonProtocolTooltip);
                    } else {
                        CreateSessionDialog.this.fDataProtocolCombo.setEnabled(true);
                        CreateSessionDialog.this.fDataHostAddressText.setEnabled(true);
                        CreateSessionDialog.this.fControlProtocolCombo.removeSelectionListener((SelectionListener)CreateSessionDialog.this.fCopyProtocolSelectionListener);
                        CreateSessionDialog.this.fControlProtocolCombo.addSelectionListener((SelectionListener)CreateSessionDialog.this.fControlProtocolSelectionListener);
                        CreateSessionDialog.this.fDataProtocolCombo.addSelectionListener((SelectionListener)CreateSessionDialog.this.fDataProtocolSelectionListener);
                        CreateSessionDialog.this.fControlHostAddressText.removeModifyListener((ModifyListener)CreateSessionDialog.this.fControlUrlKeyListener);
                        CreateSessionDialog.this.updateProtocolComboItems();
                        CreateSessionDialog.this.fDataProtocolCombo.setToolTipText(Messages.TraceControl_CreateSessionProtocolTooltip);
                        CreateSessionDialog.this.fControlProtocolCombo.setToolTipText(Messages.TraceControl_CreateSessionProtocolTooltip);
                        if (CreateSessionDialog.this.fControlProtocolCombo.getItem(CreateSessionDialog.this.fControlProtocolCombo.getSelectionIndex()).equals(StreamingProtocol.net.name()) || CreateSessionDialog.this.fControlProtocolCombo.getItem(CreateSessionDialog.this.fControlProtocolCombo.getSelectionIndex()).equals(StreamingProtocol.net6.name())) {
                            CreateSessionDialog.this.fControlPortText.setText("");
                            CreateSessionDialog.this.fControlPortText.setEnabled(false);
                        } else {
                            CreateSessionDialog.this.fControlPortText.setEnabled(true);
                        }
                        if (CreateSessionDialog.this.fDataProtocolCombo.getItem(CreateSessionDialog.this.fDataProtocolCombo.getSelectionIndex()).equals(StreamingProtocol.net.name()) || CreateSessionDialog.this.fDataProtocolCombo.getItem(CreateSessionDialog.this.fDataProtocolCombo.getSelectionIndex()).equals(StreamingProtocol.net6.name())) {
                            CreateSessionDialog.this.fDataPortText.setText("");
                            CreateSessionDialog.this.fDataPortText.setEnabled(false);
                        } else {
                            CreateSessionDialog.this.fDataPortText.setEnabled(true);
                        }
                    }
                }
            });
        }
    }

    private void createAdvancedLiveGroup() {
        if (this.fLiveGroup == null && this.fIsAdvancedEnabled) {
            GridLayout layout = new GridLayout(7, true);
            this.fLiveGroup = new Group((Composite)this.fAdvancedGroup, 0);
            this.fLiveGroup.setLayout((Layout)layout);
            GridData layoutData = new GridData(1808);
            this.fLiveGroup.setLayoutData((Object)layoutData);
            Label label = new Label((Composite)this.fLiveGroup, 0);
            label.setText(Messages.TraceControl_CreateSessionLiveConnectionLabel);
            layoutData = new GridData(768);
            layoutData.horizontalSpan = 2;
            label.setLayoutData((Object)layoutData);
            this.fLiveHostAddressText = new Text((Composite)this.fLiveGroup, 0);
            this.fLiveHostAddressText.setText("net://127.0.0.1");
            this.fLiveHostAddressText.setEnabled(false);
            this.fLiveHostAddressText.setToolTipText(Messages.TraceControl_CreateSessionLiveConnectionUrlTooltip);
            layoutData = new GridData(768);
            layoutData.horizontalSpan = 4;
            this.fLiveHostAddressText.setLayoutData((Object)layoutData);
            this.fLivePortText = new Text((Composite)this.fLiveGroup, 0);
            this.fLivePortText.setText(Integer.toString(5344));
            this.fLivePortText.setToolTipText(Messages.TraceControl_CreateSessionLiveConnectionPortTooltip);
            layoutData = new GridData(768);
            this.fLivePortText.setLayoutData((Object)layoutData);
            Label liveDelayLabel = new Label((Composite)this.fLiveGroup, 0);
            layoutData = new GridData(768);
            liveDelayLabel.setText(Messages.TraceControl_CreateSessionLiveDelayLabel);
            liveDelayLabel.setLayoutData((Object)layoutData);
            this.fLiveDelayText = new Text((Composite)this.fLiveGroup, 0);
            this.fLiveDelayText.setText(DEFAULT_TEXT);
            this.fLiveDelayText.setForeground(this.getShell().getDisplay().getSystemColor(15));
            this.fLiveDelayText.setToolTipText(Messages.TraceControl_CreateSessionLiveDelayTooltip);
            this.fLiveDelayText.addVerifyListener(e -> {
                e.doit = e.text.matches("[0-9]*") || e.text.matches(DEFAULT_TEXT);
                this.updateEnablement();
            });
            this.fLiveDelayText.addModifyListener(event -> this.updateEnablement());
            this.fLiveDelayText.addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent e) {
                    Text focusLostWidget = (Text)e.widget;
                    if (focusLostWidget.getText().isEmpty()) {
                        focusLostWidget.setText(DEFAULT_TEXT);
                        focusLostWidget.setForeground(CreateSessionDialog.this.getShell().getDisplay().getSystemColor(15));
                    }
                }

                public void focusGained(FocusEvent e) {
                    Text focusGainedWidget = (Text)e.widget;
                    if (focusGainedWidget.getText().equals(DEFAULT_TEXT)) {
                        focusGainedWidget.setText("");
                        focusGainedWidget.setForeground(CreateSessionDialog.this.getShell().getDisplay().getSystemColor(2));
                    }
                }
            });
            layoutData = new GridData(768);
            layoutData.grabExcessHorizontalSpace = true;
            layoutData.horizontalSpan = 6;
            this.fLiveDelayText.setLayoutData((Object)layoutData);
            this.getShell().pack();
        }
    }

    private void disposeLiveGroup() {
        if (this.fLiveGroup != null) {
            this.fLiveGroup.dispose();
            this.fLiveGroup = null;
            this.getShell().pack();
        }
    }

    private void disposeConfigureStreamingComposite() {
        if (this.fStreamingComposite != null) {
            this.fStreamingComposite.dispose();
            this.fStreamingComposite = null;
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, "&Cancel", true);
        this.createButton(parent, 0, "&Ok", true);
    }

    private void updateEnablement() {
        this.validate();
        this.getButton(0).setEnabled(this.getErrorMessage() == null);
    }

    private void validate() {
        this.fSessionName = this.fSessionNameText.getText();
        this.fSessionPath = this.fSessionPathText.getText();
        this.setErrorMessage(null);
        if (this.fParent.isLiveSupported() && this.fLiveButton != null) {
            this.fIsLive = this.fLiveButton.getSelection();
            this.fLiveDelay = -1L;
            this.fLiveUrl = "net://127.0.0.1";
            this.fLivePort = 5344;
        }
        if (!"".equals(this.fSessionPath)) {
            TargetNodeComponent node;
            RemoteSystemProxy proxy;
            IRemoteFileService fsss;
            if (!this.fIsAdvancedEnabled && !this.fIsLive && (fsss = (IRemoteFileService)(proxy = (node = (TargetNodeComponent)this.fParent.getParent()).getRemoteSystemProxy()).getRemoteConnection().getService(IRemoteFileService.class)) != null) {
                IFileStore remoteFolder = fsss.getResource(this.fSessionPath);
                if (remoteFolder == null) {
                    this.setErrorMessage(String.valueOf(Messages.TraceControl_InvalidSessionPathError) + " (" + this.fSessionPath + ") \n");
                    return;
                }
                IFileInfo fileInfo = remoteFolder.fetchInfo();
                if (fileInfo.exists()) {
                    this.setErrorMessage(String.valueOf(Messages.TraceControl_SessionPathAlreadyExistsError) + " (" + this.fSessionPath + ") \n");
                    return;
                }
            }
            this.fIsDefaultPath = false;
        }
        if (this.fParent.isSnapshotSupported()) {
            this.fIsSnapshot = this.fSnapshotButton.getSelection();
        }
        this.fNetworkUrl = null;
        this.fControlUrl = null;
        this.fDataUrl = null;
        if (this.fIsAdvancedEnabled && this.fStreamingComposite != null) {
            if (this.fIsLive && this.fLiveGroup != null) {
                String liveDelayText = this.fLiveDelayText.getText();
                try {
                    this.fLiveDelay = liveDelayText.equals(DEFAULT_TEXT) ? -1L : Long.valueOf(liveDelayText);
                    this.fLivePort = Integer.valueOf(this.fLivePortText.getText());
                    this.fLiveUrl = this.fLiveHostAddressText.getText();
                }
                catch (NumberFormatException e) {
                    this.setErrorMessage(Messages.TraceControl_InvalidLiveDelayError);
                    return;
                }
            }
            this.fTracePath = this.fTracePathText.getText();
            if (this.fControlProtocolCombo.getSelectionIndex() < 0) {
                this.setErrorMessage("Control Protocol Text is empty\n");
                return;
            }
            if ("".equals(this.fControlHostAddressText.getText())) {
                this.setErrorMessage("Control Address Text is empty\n");
                return;
            }
            if (!this.fLinkDataWithControlButton.getSelection()) {
                if (this.fDataProtocolCombo.getSelectionIndex() < 0) {
                    this.setErrorMessage("Data Protocol Text is empty\n");
                    return;
                }
                if ("".equals(this.fDataHostAddressText.getText())) {
                    this.setErrorMessage("Data Address Text is empty\n");
                    return;
                }
                this.fControlUrl = CreateSessionDialog.getUrlString(this.fControlProtocolCombo.getItem(this.fControlProtocolCombo.getSelectionIndex()), this.fControlHostAddressText.getText(), this.fControlPortText.getText(), null, this.fTracePath);
                this.fDataUrl = CreateSessionDialog.getUrlString(this.fDataProtocolCombo.getItem(this.fDataProtocolCombo.getSelectionIndex()), this.fDataHostAddressText.getText(), null, this.fDataPortText.getText(), this.fTracePath);
            } else {
                this.fNetworkUrl = CreateSessionDialog.getUrlString(this.fControlProtocolCombo.getItem(this.fControlProtocolCombo.getSelectionIndex()), this.fControlHostAddressText.getText(), this.fControlPortText.getText(), this.fDataPortText.getText(), this.fTracePath);
            }
        }
        if (this.fIsLive && this.fNetworkUrl == null && this.fControlUrl == null && this.fDataUrl == null) {
            this.fNetworkUrl = "net://127.0.0.1";
        }
        if (!"".equals(this.fSessionName) && !this.fSessionName.matches("^[a-zA-Z0-9\\-\\_]{1,}$")) {
            this.setErrorMessage(String.valueOf(Messages.TraceControl_InvalidSessionNameError) + " (" + this.fSessionName + ") \n");
            return;
        }
        if (this.fParent.containsChild(this.fSessionName)) {
            this.setErrorMessage(String.valueOf(Messages.TraceControl_SessionAlreadyExistsError) + " (" + this.fSessionName + ")");
            return;
        }
    }

    private static String getUrlString(String proto, String host, String ctrlPort, String dataPort, String sessionPath) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(proto);
        stringBuilder.append("://");
        stringBuilder.append(host);
        if (ctrlPort != null && !"".equals(ctrlPort)) {
            stringBuilder.append(":");
            stringBuilder.append(ctrlPort);
        }
        if (dataPort != null && !"".equals(dataPort)) {
            stringBuilder.append(":");
            stringBuilder.append(dataPort);
        }
        if (sessionPath != null && !"".equals(sessionPath)) {
            stringBuilder.append("/");
            stringBuilder.append(sessionPath);
        }
        return stringBuilder.toString();
    }

    @Override
    public ISessionInfo getParameters() {
        boolean isStreaming;
        SessionInfo sessionInfo = new SessionInfo(this.fSessionName);
        boolean bl = isStreaming = this.fIsAdvancedEnabled && this.fStreamingComposite != null || this.fIsLive;
        if (isStreaming) {
            sessionInfo.setNetworkUrl(this.fNetworkUrl);
            sessionInfo.setControlUrl(this.fControlUrl);
            sessionInfo.setDataUrl(this.fDataUrl);
            sessionInfo.setStreamedTrace(true);
        } else if (!this.fIsDefaultPath) {
            sessionInfo.setSessionPath(this.fSessionPath);
        }
        sessionInfo.setLive(this.fIsLive);
        sessionInfo.setLiveUrl(this.fLiveUrl);
        sessionInfo.setLivePort(this.fLivePort);
        sessionInfo.setLiveDelay(this.fLiveDelay.longValue());
        sessionInfo.setSnapshot(this.fIsSnapshot);
        return sessionInfo;
    }

    private class ControlProtocolSelectionListener
    extends SelectionAdapter {
        private ControlProtocolSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            CreateSessionDialog.this.fDataProtocolCombo.select(CreateSessionDialog.this.fControlProtocolCombo.getSelectionIndex());
            if (CreateSessionDialog.this.fControlProtocolCombo.getItem(CreateSessionDialog.this.fControlProtocolCombo.getSelectionIndex()).equals(StreamingProtocol.file.name())) {
                CreateSessionDialog.this.fControlPortText.setText("");
                CreateSessionDialog.this.fDataPortText.setText("");
                CreateSessionDialog.this.fControlPortText.setEnabled(false);
                CreateSessionDialog.this.fDataPortText.setEnabled(false);
            } else {
                CreateSessionDialog.this.fControlPortText.setEnabled(true);
                CreateSessionDialog.this.fDataPortText.setEnabled(true);
            }
        }
    }

    private static class CopyModifyListener
    implements ModifyListener {
        private Text fSource;
        private Text fDestination;

        public CopyModifyListener(Text source, Text destination) {
            this.fSource = source;
            this.fDestination = destination;
        }

        public void modifyText(ModifyEvent e) {
            this.fDestination.setText(this.fSource.getText());
        }
    }

    private static enum LiveProtocol {
        net,
        net6;

    }

    private class ProtocolComboSelectionListener
    extends SelectionAdapter {
        private CCombo fCombo;
        private Text fPortText;

        public ProtocolComboSelectionListener(CCombo combo, Text portText) {
            this.fCombo = combo;
            this.fPortText = portText;
        }

        public void widgetSelected(SelectionEvent e) {
            if (this.fCombo.getItem(this.fCombo.getSelectionIndex()).equals(StreamingProtocol.net.name()) || this.fCombo.getItem(this.fCombo.getSelectionIndex()).equals(StreamingProtocol.net6.name())) {
                this.fPortText.setText("");
                this.fPortText.setEnabled(false);
            } else {
                this.fPortText.setEnabled(true);
            }
        }
    }

    private static enum StreamingProtocol {
        net,
        net6,
        file;

    }

    private static enum StreamingProtocol2 {
        net,
        net6,
        tcp,
        tcp6;

    }

    private final class UpdateEnablementModifyListener
    implements ModifyListener {
        private UpdateEnablementModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            CreateSessionDialog.this.updateEnablement();
        }
    }
}

