/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared;

import java.util.Collection;
import java.util.List;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.eclipse.ui.IViewReference;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public abstract class AbstractPerspectiveChecker {
    private static SWTWorkbenchBot fBot;
    protected String fPerspectiveId;
    protected Collection<String> fViewIds;

    @BeforeClass
    public static void beforeInit() {
        SWTBotUtils.initialize();
        SWTBotPreferences.TIMEOUT = 50000L;
        fBot = new SWTWorkbenchBot();
        SWTBotUtils.closeView("welcome", fBot);
    }

    @Test
    public void testPerspectiveForViews() {
        SWTBotUtils.switchToPerspective(this.fPerspectiveId);
        WaitUtils.waitForJobs();
        for (final String viewID : this.fViewIds) {
            List view = fBot.views((Matcher)new BaseMatcher<String>(){

                public boolean matches(Object item) {
                    if (!(item instanceof IViewReference)) {
                        return false;
                    }
                    IViewReference reference = (IViewReference)item;
                    return reference.getId().equals(viewID);
                }

                public void describeTo(Description description) {
                }
            });
            Assert.assertEquals((String)("view " + viewID + " is present"), (long)1L, (long)view.size());
        }
    }

    @Test
    public void testPerspectiveComplete() {
        SWTBotUtils.switchToPerspective(this.fPerspectiveId);
        WaitUtils.waitForJobs();
        for (SWTBotView view : fBot.views()) {
            Assert.assertTrue((String)("view " + view.getViewReference().getId() + " is present"), (boolean)this.fViewIds.contains(view.getViewReference().getId()));
        }
    }
}

