/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.event;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestampFormat;
import org.junit.Assert;
import org.junit.Test;

public class TmfTimestampTest {
    private final ITmfTimestamp ts0 = TmfTimestamp.create((long)0L, (int)0);
    private final ITmfTimestamp ts1 = TmfTimestamp.create((long)12345L, (int)0);
    private final ITmfTimestamp ts2 = TmfTimestamp.create((long)12345L, (int)-1);
    private final ITmfTimestamp ts3 = TmfTimestamp.create((long)12345L, (int)2);
    private final ITmfTimestamp ts4 = TmfTimestamp.create((long)12345L, (int)-3);
    private final ITmfTimestamp ts5 = TmfTimestamp.create((long)12345L, (int)-6);
    private final ITmfTimestamp ts6 = TmfTimestamp.create((long)12345L, (int)-9);
    private final ITmfTimestamp ts7 = TmfTimestamp.create((long)-12345L, (int)-3);
    private final ITmfTimestamp ts8 = TmfTimestamp.create((long)-12345L, (int)-6);
    private final ITmfTimestamp ts9 = TmfTimestamp.create((long)-12345L, (int)-9);
    private final ITmfTimestamp ts10 = TmfTimestamp.create((long)92233720368547758L, (int)-6);
    private final ITmfTimestamp ts11 = TmfTimestamp.create((long)-92233720368547758L, (int)-6);

    @Test
    public void testDefaultConstructor() {
        Assert.assertEquals((String)"getValue", (long)0L, (long)this.ts0.getValue());
        Assert.assertEquals((String)"getscale", (long)0L, (long)this.ts0.getScale());
    }

    @Test
    public void testValueConstructor() {
        Assert.assertEquals((String)"getValue", (long)12345L, (long)this.ts1.getValue());
        Assert.assertEquals((String)"getscale", (long)0L, (long)this.ts1.getScale());
    }

    @Test
    public void testValueScaleConstructor() {
        Assert.assertEquals((String)"getValue", (long)12345L, (long)this.ts2.getValue());
        Assert.assertEquals((String)"getscale", (long)-1L, (long)this.ts2.getScale());
    }

    @Test
    public void testFullConstructor() {
        Assert.assertEquals((String)"getValue", (long)12345L, (long)this.ts3.getValue());
        Assert.assertEquals((String)"getscale", (long)2L, (long)this.ts3.getScale());
    }

    @Test
    public void testCopyConstructor() {
        ITmfTimestamp ts = TmfTimestamp.create((long)12345L, (int)2);
        ITmfTimestamp copy = TmfTimestamp.create((long)ts.getValue(), (int)ts.getScale());
        Assert.assertEquals((String)"getValue", (long)ts.getValue(), (long)copy.getValue());
        Assert.assertEquals((String)"getscale", (long)ts.getScale(), (long)copy.getScale());
        Assert.assertEquals((String)"getValue", (long)12345L, (long)copy.getValue());
        Assert.assertEquals((String)"getscale", (long)2L, (long)copy.getScale());
    }

    @Test
    public void testCopyConstructorBigBang() {
        ITmfTimestamp ts = TmfTimestamp.create((long)TmfTimestamp.BIG_BANG.getValue(), (int)TmfTimestamp.BIG_BANG.getScale());
        Assert.assertEquals((String)"getValue", (long)TmfTimestamp.BIG_BANG.getValue(), (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)TmfTimestamp.BIG_BANG.getScale(), (long)ts.getScale());
    }

    @Test
    public void testCopyConstructorBigCrunch() {
        ITmfTimestamp ts = TmfTimestamp.create((long)TmfTimestamp.BIG_CRUNCH.getValue(), (int)TmfTimestamp.BIG_CRUNCH.getScale());
        Assert.assertEquals((String)"getValue", (long)TmfTimestamp.BIG_CRUNCH.getValue(), (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)TmfTimestamp.BIG_CRUNCH.getScale(), (long)ts.getScale());
    }

    @Test
    public void testCopyConstructorZero() {
        ITmfTimestamp ts = TmfTimestamp.create((long)TmfTimestamp.ZERO.getValue(), (int)TmfTimestamp.ZERO.getScale());
        Assert.assertEquals((String)"getValue", (long)TmfTimestamp.ZERO.getValue(), (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)TmfTimestamp.ZERO.getScale(), (long)ts.getScale());
    }

    @Test
    public void testHashCode() {
        ITmfTimestamp ts0copy = TmfTimestamp.create((long)this.ts0.getValue(), (int)this.ts0.getScale());
        ITmfTimestamp ts1copy = TmfTimestamp.create((long)this.ts1.getValue(), (int)this.ts1.getScale());
        ITmfTimestamp ts2copy = TmfTimestamp.create((long)this.ts2.getValue(), (int)this.ts2.getScale());
        Assert.assertEquals((String)"hashCode", (long)this.ts0.hashCode(), (long)ts0copy.hashCode());
        Assert.assertEquals((String)"hashCode", (long)this.ts1.hashCode(), (long)ts1copy.hashCode());
        Assert.assertEquals((String)"hashCode", (long)this.ts2.hashCode(), (long)ts2copy.hashCode());
        Assert.assertTrue((String)"hashCode", (this.ts0.hashCode() != this.ts1.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsReflexivity() {
        Assert.assertEquals((String)"equals", (Object)this.ts0, (Object)this.ts0);
        Assert.assertEquals((String)"equals", (Object)this.ts1, (Object)this.ts1);
        Assert.assertFalse((String)"Different", (boolean)this.ts0.equals(this.ts1));
        Assert.assertFalse((String)"Different", (boolean)this.ts1.equals(this.ts0));
    }

    @Test
    public void testEqualsSymmetry() {
        ITmfTimestamp ts0copy = TmfTimestamp.create((long)this.ts0.getValue(), (int)this.ts0.getScale());
        Assert.assertEquals((String)"equals", (Object)this.ts0, (Object)ts0copy);
        Assert.assertEquals((String)"equals", (Object)ts0copy, (Object)this.ts0);
        ITmfTimestamp ts1copy = TmfTimestamp.create((long)this.ts1.getValue(), (int)this.ts1.getScale());
        Assert.assertEquals((String)"equals", (Object)this.ts1, (Object)ts1copy);
        Assert.assertEquals((String)"equals", (Object)ts1copy, (Object)this.ts1);
        ITmfTimestamp ts2copy = TmfTimestamp.create((long)this.ts2.getValue(), (int)this.ts2.getScale());
        Assert.assertEquals((String)"equals", (Object)this.ts2, (Object)ts2copy);
        Assert.assertEquals((String)"equals", (Object)ts2copy, (Object)this.ts2);
    }

    @Test
    public void testEqualsTransivity() {
        ITmfTimestamp ts0copy1 = TmfTimestamp.create((long)this.ts0.getValue(), (int)this.ts0.getScale());
        ITmfTimestamp ts0copy2 = TmfTimestamp.create((long)ts0copy1.getValue(), (int)ts0copy1.getScale());
        Assert.assertTrue((String)"equals", (boolean)this.ts0.equals(ts0copy1));
        Assert.assertTrue((String)"equals", (boolean)ts0copy1.equals(ts0copy2));
        Assert.assertTrue((String)"equals", (boolean)this.ts0.equals(ts0copy2));
        ITmfTimestamp ts1copy1 = TmfTimestamp.create((long)this.ts1.getValue(), (int)this.ts1.getScale());
        ITmfTimestamp ts1copy2 = TmfTimestamp.create((long)ts1copy1.getValue(), (int)ts1copy1.getScale());
        Assert.assertTrue((String)"equals", (boolean)this.ts1.equals(ts1copy1));
        Assert.assertTrue((String)"equals", (boolean)ts1copy1.equals(ts1copy2));
        Assert.assertTrue((String)"equals", (boolean)this.ts1.equals(ts1copy2));
        ITmfTimestamp ts2copy1 = TmfTimestamp.create((long)this.ts2.getValue(), (int)this.ts2.getScale());
        ITmfTimestamp ts2copy2 = TmfTimestamp.create((long)ts2copy1.getValue(), (int)ts2copy1.getScale());
        Assert.assertTrue((String)"equals", (boolean)this.ts2.equals(ts2copy1));
        Assert.assertTrue((String)"equals", (boolean)ts2copy1.equals(ts2copy2));
        Assert.assertTrue((String)"equals", (boolean)this.ts2.equals(ts2copy2));
    }

    @Test
    public void testEqualsNull() {
        Assert.assertTrue((String)"equals", (!this.ts0.equals(null) ? 1 : 0) != 0);
        Assert.assertTrue((String)"equals", (!this.ts1.equals(null) ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsNonTimestamp() {
        Assert.assertFalse((String)"equals", (boolean)this.ts0.equals(this.ts0.toString()));
    }

    @Test
    public void testToStringDefault() {
        SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss.SSS");
        Date d0 = new Date((long)((double)this.ts0.getValue() * Math.pow(10.0, this.ts0.getScale() + 3)));
        Date d1 = new Date((long)((double)this.ts1.getValue() * Math.pow(10.0, this.ts1.getScale() + 3)));
        Date d2 = new Date((long)((double)this.ts2.getValue() * Math.pow(10.0, this.ts2.getScale() + 3)));
        Date d3 = new Date((long)((double)this.ts3.getValue() * Math.pow(10.0, this.ts3.getScale() + 3)));
        Date d4 = new Date((long)((double)this.ts4.getValue() * Math.pow(10.0, this.ts4.getScale() + 3)));
        Date d5 = new Date((long)((double)this.ts5.getValue() * Math.pow(10.0, this.ts5.getScale() + 3)));
        Date d6 = new Date((long)((double)this.ts6.getValue() * Math.pow(10.0, this.ts6.getScale() + 3)));
        Date d7 = new Date((long)((double)this.ts7.getValue() * Math.pow(10.0, this.ts7.getScale() + 3)));
        Date d8 = new Date((long)((double)this.ts8.getValue() * Math.pow(10.0, this.ts8.getScale() + 3)) - 1L);
        Date d9 = new Date((long)((double)this.ts9.getValue() * Math.pow(10.0, this.ts9.getScale() + 3)) - 1L);
        Assert.assertEquals((String)"toString", (Object)(df.format(d0) + " 000 000"), (Object)this.ts0.toString());
        Assert.assertEquals((String)"toString", (Object)(df.format(d1) + " 000 000"), (Object)this.ts1.toString());
        Assert.assertEquals((String)"toString", (Object)(df.format(d2) + " 000 000"), (Object)this.ts2.toString());
        Assert.assertEquals((String)"toString", (Object)(df.format(d3) + " 000 000"), (Object)this.ts3.toString());
        Assert.assertEquals((String)"toString", (Object)(df.format(d4) + " 000 000"), (Object)this.ts4.toString());
        Assert.assertEquals((String)"toString", (Object)(df.format(d5) + " 345 000"), (Object)this.ts5.toString());
        Assert.assertEquals((String)"toString", (Object)(df.format(d6) + " 012 345"), (Object)this.ts6.toString());
        Assert.assertEquals((String)"toString", (Object)(df.format(d7) + " 000 000"), (Object)this.ts7.toString());
        Assert.assertEquals((String)"toString", (Object)(df.format(d8) + " 655 000"), (Object)this.ts8.toString());
        Assert.assertEquals((String)"toString", (Object)(df.format(d9) + " 987 655"), (Object)this.ts9.toString());
    }

    @Test
    public void testToStringInterval() {
        Assert.assertEquals((String)"toString", (Object)"000.000 000 000", (Object)this.ts0.toString(TmfTimestampFormat.getDefaulIntervalFormat()));
        Assert.assertEquals((String)"toString", (Object)"12345.000 000 000", (Object)this.ts1.toString(TmfTimestampFormat.getDefaulIntervalFormat()));
        Assert.assertEquals((String)"toString", (Object)"1234.500 000 000", (Object)this.ts2.toString(TmfTimestampFormat.getDefaulIntervalFormat()));
        Assert.assertEquals((String)"toString", (Object)"1234500.000 000 000", (Object)this.ts3.toString(TmfTimestampFormat.getDefaulIntervalFormat()));
        Assert.assertEquals((String)"toString", (Object)"012.345 000 000", (Object)this.ts4.toString(TmfTimestampFormat.getDefaulIntervalFormat()));
        Assert.assertEquals((String)"toString", (Object)"000.012 345 000", (Object)this.ts5.toString(TmfTimestampFormat.getDefaulIntervalFormat()));
        Assert.assertEquals((String)"toString", (Object)"000.000 012 345", (Object)this.ts6.toString(TmfTimestampFormat.getDefaulIntervalFormat()));
        Assert.assertEquals((String)"toString", (Object)"-012.345 000 000", (Object)this.ts7.toString(TmfTimestampFormat.getDefaulIntervalFormat()));
        Assert.assertEquals((String)"toString", (Object)"-000.012 345 000", (Object)this.ts8.toString(TmfTimestampFormat.getDefaulIntervalFormat()));
        Assert.assertEquals((String)"toString", (Object)"-000.000 012 345", (Object)this.ts9.toString(TmfTimestampFormat.getDefaulIntervalFormat()));
    }

    @Test
    public void testToStringBigBangBigCrunch() {
        ITmfTimestamp bang = TmfTimestamp.BIG_BANG;
        ITmfTimestamp crunch = TmfTimestamp.BIG_CRUNCH;
        Assert.assertEquals((String)"toString", (Object)"-9223372036.854 775 808", (Object)bang.toString(TmfTimestampFormat.getDefaulIntervalFormat()));
        Assert.assertEquals((String)"toString", (Object)"9223372036.854 775 807", (Object)crunch.toString(TmfTimestampFormat.getDefaulIntervalFormat()));
    }

    @Test
    public void testNormalizeOffset() {
        ITmfTimestamp ts = this.ts0.normalize(0L, 0);
        Assert.assertEquals((String)"getValue", (long)0L, (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)0L, (long)ts.getScale());
        ts = this.ts0.normalize(12345L, 0);
        Assert.assertEquals((String)"getValue", (long)12345L, (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)0L, (long)ts.getScale());
        ts = this.ts0.normalize(10L, 0);
        Assert.assertEquals((String)"getValue", (long)10L, (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)0L, (long)ts.getScale());
        ts = this.ts0.normalize(-10L, 0);
        Assert.assertEquals((String)"getValue", (long)-10L, (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)0L, (long)ts.getScale());
    }

    @Test
    public void testNormalizeOffsetLowerLimits() {
        ITmfTimestamp ref = TmfTimestamp.create((long)-9223372036854775803L, (int)0);
        ITmfTimestamp ts = ref.normalize(-4L, 0);
        Assert.assertEquals((String)"getValue", (long)-9223372036854775807L, (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)0L, (long)ts.getScale());
        ts = ref.normalize(-5L, 0);
        Assert.assertEquals((String)"getValue", (long)Long.MIN_VALUE, (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)0L, (long)ts.getScale());
        ts = ref.normalize(-6L, 0);
        Assert.assertEquals((String)"getValue", (long)Long.MIN_VALUE, (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)0L, (long)ts.getScale());
    }

    @Test
    public void testNormalizeOffsetUpperLimits() {
        ITmfTimestamp ref = TmfTimestamp.create((long)0x7FFFFFFFFFFFFFFAL, (int)0);
        ITmfTimestamp ts = ref.normalize(4L, 0);
        Assert.assertEquals((String)"getValue", (long)0x7FFFFFFFFFFFFFFEL, (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)0L, (long)ts.getScale());
        ts = ref.normalize(5L, 0);
        Assert.assertEquals((String)"getValue", (long)Long.MAX_VALUE, (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)0L, (long)ts.getScale());
        ts = ref.normalize(6L, 0);
        Assert.assertEquals((String)"getValue", (long)Long.MAX_VALUE, (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)0L, (long)ts.getScale());
    }

    @Test
    public void testNormalizeScale() {
        ITmfTimestamp ts = this.ts1.normalize(0L, 3);
        Assert.assertEquals((String)"getValue", (long)12L, (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)3L, (long)ts.getScale());
        ts = this.ts1.normalize(0L, -3);
        Assert.assertEquals((String)"getValue", (long)12345000L, (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)-3L, (long)ts.getScale());
    }

    @Test
    public void testNormalizeLargeScale() {
        ITmfTimestamp ts = this.ts1.normalize(0L, 10);
        Assert.assertEquals((String)"getValue", (long)0L, (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)0L, (long)ts.getScale());
        ts = this.ts1.normalize(0L, -10);
        Assert.assertEquals((String)"getValue", (long)123450000000000L, (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)-10L, (long)ts.getScale());
    }

    @Test
    public void testNormalizeZeroScale() {
        ITmfTimestamp ts = this.ts0.normalize(0L, 10);
        Assert.assertEquals((String)"getValue", (long)0L, (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)0L, (long)ts.getScale());
        ts = this.ts0.normalize(0L, -10);
        Assert.assertEquals((String)"getValue", (long)0L, (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)0L, (long)ts.getScale());
    }

    @Test
    public void testNormalizedScaleLimits() {
        int MAX_SCALE_DIFF = 19;
        Assert.assertEquals((long)Long.MAX_VALUE, (long)this.ts1.normalize(0L, -18).getValue());
        Assert.assertEquals((long)0L, (long)this.ts1.normalize(0L, 18).getValue());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)this.ts1.normalize(0L, -19).getValue());
        Assert.assertEquals((long)0L, (long)this.ts1.normalize(0L, 19).getValue());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)this.ts1.normalize(0L, -20).getValue());
        Assert.assertEquals((long)0L, (long)this.ts1.normalize(0L, 18).getValue());
    }

    @Test
    public void testNormalizeOffsetAndScaleTrivial() {
        ITmfTimestamp ts = this.ts0.normalize(0L, 0);
        Assert.assertEquals((String)"getValue", (long)0L, (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)0L, (long)ts.getScale());
    }

    @Test
    public void testNormalizeOffsetAndScale() {
        int SCALE = 12;
        ITmfTimestamp ts = this.ts1.normalize(0L, 12);
        Assert.assertEquals((String)"getValue", (long)0L, (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)0L, (long)ts.getScale());
        ts = this.ts1.normalize(12345L, 12);
        Assert.assertEquals((String)"getValue", (long)12345L, (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)12L, (long)ts.getScale());
        ts = this.ts1.normalize(10L, 12);
        Assert.assertEquals((String)"getValue", (long)10L, (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)12L, (long)ts.getScale());
        ts = this.ts1.normalize(-10L, 12);
        Assert.assertEquals((String)"getValue", (long)-10L, (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)12L, (long)ts.getScale());
    }

    @Test
    public void testNormalizeOffsetAndScale2() {
        int SCALE = 2;
        ITmfTimestamp ts = this.ts1.normalize(0L, SCALE);
        Assert.assertEquals((String)"getValue", (long)123L, (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)SCALE, (long)ts.getScale());
        ts = this.ts1.normalize(12345L, SCALE);
        Assert.assertEquals((String)"getValue", (long)12468L, (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)SCALE, (long)ts.getScale());
        SCALE = -2;
        ts = this.ts1.normalize(0L, SCALE);
        Assert.assertEquals((String)"getValue", (long)1234500L, (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)SCALE, (long)ts.getScale());
        ts = this.ts1.normalize(67L, SCALE);
        Assert.assertEquals((String)"getValue", (long)1234567L, (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)SCALE, (long)ts.getScale());
    }

    @Test
    public void testToNanos() {
        Assert.assertEquals((long)12345000000000L, (long)this.ts1.toNanos());
        Assert.assertEquals((long)-12345L, (long)this.ts9.toNanos());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)this.ts10.toNanos());
        Assert.assertEquals((long)Long.MIN_VALUE, (long)this.ts11.toNanos());
    }

    @Test
    public void testBasicCompareTo() {
        ITmfTimestamp t1 = TmfTimestamp.create((long)900L, (int)0);
        ITmfTimestamp t2 = TmfTimestamp.create((long)1000L, (int)0);
        ITmfTimestamp t3 = TmfTimestamp.create((long)1100L, (int)0);
        ITmfTimestamp t4 = TmfTimestamp.create((long)1000L, (int)0);
        Assert.assertTrue((t1.compareTo(t1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t1.compareTo(t2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t1.compareTo(t3) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t1.compareTo(t4) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t2.compareTo(t1) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t2.compareTo(t3) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t2.compareTo(t4) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t3.compareTo(t1) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t3.compareTo(t2) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t3.compareTo(t4) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompareToCornerCases1() {
        ITmfTimestamp ts0a = TmfTimestamp.create((long)this.ts0.getValue(), (int)this.ts0.getScale());
        ITmfTimestamp ts0b = TmfTimestamp.create((long)this.ts0.getValue(), (int)(this.ts0.getScale() + 1));
        ITmfTimestamp ts0c = TmfTimestamp.create((long)(this.ts0.getValue() + 1L), (int)this.ts0.getScale());
        ITmfTimestamp ts0d = TmfTimestamp.create((long)(this.ts0.getValue() + 1L), (int)(this.ts0.getScale() + 1));
        Assert.assertTrue((String)"compareTo", (this.ts0.compareTo(this.ts0) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"compareTo", (this.ts0.compareTo(ts0a) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"compareTo", (this.ts0.compareTo(ts0b) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"compareTo", (this.ts0.compareTo(ts0c) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"compareTo", (this.ts0.compareTo(ts0d) == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testCompareToCornerCases2() {
        ITmfTimestamp ts0a = TmfTimestamp.create((long)Long.MAX_VALUE, (int)0x7FFFFFFE);
        ITmfTimestamp ts0b = TmfTimestamp.create((long)0L, (int)Integer.MAX_VALUE);
        ITmfTimestamp ts0c = TmfTimestamp.create((long)Long.MAX_VALUE, (int)Integer.MAX_VALUE);
        Assert.assertTrue((String)"compareTo", (ts0a.compareTo(ts0b) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"compareTo", (ts0a.compareTo(ts0c) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"compareTo", (ts0b.compareTo(ts0a) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"compareTo", (ts0b.compareTo(ts0c) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"compareTo", (ts0c.compareTo(ts0a) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"compareTo", (ts0c.compareTo(ts0b) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompareToCornerCases3() {
        ITmfTimestamp ts0a = TmfTimestamp.create((long)Long.MIN_VALUE, (int)0x7FFFFFFE);
        ITmfTimestamp ts0b = TmfTimestamp.create((long)0L, (int)Integer.MAX_VALUE);
        ITmfTimestamp ts0c = TmfTimestamp.create((long)Long.MIN_VALUE, (int)Integer.MAX_VALUE);
        Assert.assertTrue((String)"compareTo", (ts0a.compareTo(ts0b) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"compareTo", (ts0a.compareTo(ts0c) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"compareTo", (ts0b.compareTo(ts0a) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"compareTo", (ts0b.compareTo(ts0c) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"compareTo", (ts0c.compareTo(ts0a) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"compareTo", (ts0c.compareTo(ts0b) < 0 ? 1 : 0) != 0);
    }

    @Test(expected=NullPointerException.class)
    public void testCompareToCornerCases4() {
        Assert.assertTrue((String)"compareTo", (this.ts0.compareTo(null) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompareToSameScale() {
        ITmfTimestamp t1 = TmfTimestamp.create((long)900L, (int)0);
        ITmfTimestamp t2 = TmfTimestamp.create((long)1000L, (int)0);
        ITmfTimestamp t3 = TmfTimestamp.create((long)1100L, (int)0);
        ITmfTimestamp t4 = TmfTimestamp.create((long)1000L, (int)0);
        Assert.assertEquals((long)0L, (long)t1.compareTo(t1));
        Assert.assertTrue((String)"CompareTo", (t1.compareTo(t2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t1.compareTo(t3) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t1.compareTo(t4) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t2.compareTo(t1) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t2.compareTo(t3) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t2.compareTo(t4) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t3.compareTo(t1) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t3.compareTo(t2) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t3.compareTo(t4) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompareToDifferentScale() {
        ITmfTimestamp t1 = TmfTimestamp.create((long)9000L, (int)-1);
        ITmfTimestamp t2 = TmfTimestamp.create((long)1000L, (int)0);
        ITmfTimestamp t3 = TmfTimestamp.create((long)110L, (int)1);
        ITmfTimestamp t4 = TmfTimestamp.create((long)1L, (int)3);
        Assert.assertTrue((String)"CompareTo", (t1.compareTo(t1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t1.compareTo(t2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t1.compareTo(t3) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t1.compareTo(t4) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t2.compareTo(t1) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t2.compareTo(t3) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t2.compareTo(t4) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t3.compareTo(t1) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t3.compareTo(t2) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t3.compareTo(t4) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompareToDifferentScale2() {
        ITmfTimestamp t6;
        ITmfTimestamp t5 = TmfTimestamp.fromSeconds((long)1L);
        Assert.assertTrue((String)"CompareTo", (t5.compareTo(t6 = TmfTimestamp.fromMillis((long)1234L)) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t6.compareTo(t5) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompareToSpecials() {
        ITmfTimestamp ersatzBigBang = TmfTimestamp.create((long)Long.MIN_VALUE, (int)Integer.MAX_VALUE);
        ITmfTimestamp ersatzBigCrunch = TmfTimestamp.create((long)Long.MAX_VALUE, (int)Integer.MAX_VALUE);
        ITmfTimestamp lolo = TmfTimestamp.fromMicros((long)Long.MIN_VALUE);
        ITmfTimestamp lo = TmfTimestamp.fromMillis((long)-100L);
        ITmfTimestamp lohi = TmfTimestamp.fromMicros((long)100L);
        ITmfTimestamp hilo = TmfTimestamp.fromMillis((long)Long.MIN_VALUE);
        ITmfTimestamp hi = TmfTimestamp.fromMillis((long)100L);
        Assert.assertTrue((String)"CompareTo", (TmfTimestamp.BIG_BANG.compareTo(this.ts0) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (TmfTimestamp.BIG_BANG.compareTo(this.ts1) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (TmfTimestamp.BIG_BANG.compareTo(this.ts2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (TmfTimestamp.BIG_BANG.compareTo(this.ts3) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (TmfTimestamp.BIG_BANG.compareTo(this.ts4) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (TmfTimestamp.BIG_BANG.compareTo(TmfTimestamp.fromSeconds((long)Long.MIN_VALUE)) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (TmfTimestamp.BIG_BANG.compareTo(ersatzBigBang) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (TmfTimestamp.BIG_BANG.compareTo(TmfTimestamp.BIG_CRUNCH) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (TmfTimestamp.BIG_BANG.compareTo(TmfTimestamp.BIG_BANG) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (this.ts0.compareTo(TmfTimestamp.BIG_BANG) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (this.ts1.compareTo(TmfTimestamp.BIG_BANG) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (this.ts2.compareTo(TmfTimestamp.BIG_BANG) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (this.ts3.compareTo(TmfTimestamp.BIG_BANG) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (this.ts4.compareTo(TmfTimestamp.BIG_BANG) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (ersatzBigBang.compareTo(TmfTimestamp.BIG_BANG) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (TmfTimestamp.BIG_CRUNCH.compareTo(this.ts0) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (TmfTimestamp.BIG_CRUNCH.compareTo(this.ts1) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (TmfTimestamp.BIG_CRUNCH.compareTo(this.ts2) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (TmfTimestamp.BIG_CRUNCH.compareTo(this.ts3) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (TmfTimestamp.BIG_CRUNCH.compareTo(this.ts4) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (TmfTimestamp.BIG_CRUNCH.compareTo(TmfTimestamp.fromSeconds((long)Long.MIN_VALUE)) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (TmfTimestamp.BIG_CRUNCH.compareTo(ersatzBigCrunch) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (TmfTimestamp.BIG_CRUNCH.compareTo(TmfTimestamp.BIG_BANG) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (TmfTimestamp.BIG_CRUNCH.compareTo(TmfTimestamp.BIG_CRUNCH) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (this.ts0.compareTo(TmfTimestamp.BIG_CRUNCH) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (this.ts1.compareTo(TmfTimestamp.BIG_CRUNCH) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (this.ts2.compareTo(TmfTimestamp.BIG_CRUNCH) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (this.ts3.compareTo(TmfTimestamp.BIG_CRUNCH) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (this.ts4.compareTo(TmfTimestamp.BIG_CRUNCH) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (ersatzBigCrunch.compareTo(TmfTimestamp.BIG_CRUNCH) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (ersatzBigBang.compareTo(ersatzBigCrunch) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (ersatzBigCrunch.compareTo(ersatzBigBang) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (ersatzBigBang.compareTo(ersatzBigBang) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (lolo.compareTo(hi) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (hi.compareTo(lolo) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (lolo.compareTo(lolo) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (lo.compareTo(hi) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (hi.compareTo(lo) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (lo.compareTo(lo) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (hilo.compareTo(lohi) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (lohi.compareTo(hilo) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (hilo.compareTo(hilo) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompareToLargeScale1() {
        ITmfTimestamp t1 = TmfTimestamp.create((long)-1L, (int)100);
        ITmfTimestamp t2 = TmfTimestamp.create((long)-1000L, (int)-100);
        ITmfTimestamp t3 = TmfTimestamp.create((long)1L, (int)100);
        ITmfTimestamp t4 = TmfTimestamp.create((long)1000L, (int)-100);
        Assert.assertTrue((String)"CompareTo", (t1.compareTo(t2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t1.compareTo(t3) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t1.compareTo(t4) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t2.compareTo(t1) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t2.compareTo(t3) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t2.compareTo(t4) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t3.compareTo(t1) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t3.compareTo(t2) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t3.compareTo(t4) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t4.compareTo(t1) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t4.compareTo(t2) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t4.compareTo(t3) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompareToLargeScale2() {
        ITmfTimestamp ts0a = TmfTimestamp.create((long)0L, (int)Integer.MAX_VALUE);
        ITmfTimestamp ts0b = TmfTimestamp.create((long)1L, (int)Integer.MAX_VALUE);
        Assert.assertEquals((String)"CompareTo", (long)0L, (long)ts0a.compareTo(this.ts0));
        Assert.assertEquals((String)"CompareTo", (long)0L, (long)this.ts0.compareTo(ts0a));
        Assert.assertEquals((String)"CompareTo", (long)1L, (long)ts0b.compareTo(this.ts0));
        Assert.assertEquals((String)"CompareTo", (long)-1L, (long)this.ts0.compareTo(ts0b));
    }

    @Test
    public void testCompareToLargeScale3() {
        ITmfTimestamp ts0a = TmfTimestamp.create((long)1L, (int)Integer.MAX_VALUE);
        ITmfTimestamp ts0b = TmfTimestamp.create((long)2L, (int)Integer.MAX_VALUE);
        Assert.assertTrue((String)"CompareTo", (ts0b.compareTo(ts0a) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (ts0a.compareTo(ts0b) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testDelta() {
        ITmfTimestamp t0 = TmfTimestamp.create((long)10L, (int)9);
        ITmfTimestamp t1 = TmfTimestamp.create((long)5L, (int)9);
        ITmfTimestamp exp = TmfTimestamp.create((long)5L, (int)9);
        ITmfTimestamp delta = t0.getDelta(t1);
        Assert.assertEquals((String)"getDelta", (long)0L, (long)delta.compareTo(exp));
        t0 = TmfTimestamp.create((long)5L, (int)9);
        t1 = TmfTimestamp.create((long)10L, (int)9);
        exp = TmfTimestamp.create((long)-5L, (int)9);
        delta = t0.getDelta(t1);
        Assert.assertEquals((String)"getDelta", (long)0L, (long)delta.compareTo(exp));
        t0 = TmfTimestamp.create((long)5L, (int)9);
        t1 = TmfTimestamp.create((long)10L, (int)8);
        exp = TmfTimestamp.create((long)4L, (int)9);
        delta = t0.getDelta(t1);
        Assert.assertEquals((String)"getDelta", (long)0L, (long)delta.compareTo(exp));
        t0 = TmfTimestamp.create((long)5L, (int)9);
        t1 = TmfTimestamp.create((long)10L, (int)7);
        exp = TmfTimestamp.create((long)5L, (int)9);
        delta = t0.getDelta(t1);
        Assert.assertEquals((String)"getDelta", (long)0L, (long)delta.compareTo(exp));
        t0 = TmfTimestamp.create((long)10L, (int)9);
        t1 = TmfTimestamp.create((long)5L, (int)8);
        exp = TmfTimestamp.create((long)10L, (int)9);
        delta = t0.getDelta(t1);
        Assert.assertEquals((String)"getDelta", (long)0L, (long)delta.compareTo(exp));
        t0 = TmfTimestamp.create((long)10L, (int)9);
        t1 = TmfTimestamp.create((long)5L, (int)9);
        exp = TmfTimestamp.create((long)5L, (int)9);
        delta = t0.getDelta(t1);
        Assert.assertEquals((String)"getDelta", (long)0L, (long)delta.compareTo(exp));
        t0 = TmfTimestamp.create((long)5L, (int)9);
        t1 = TmfTimestamp.create((long)10L, (int)8);
        exp = TmfTimestamp.create((long)4L, (int)9);
        delta = t0.getDelta(t1);
        Assert.assertEquals((String)"getDelta", (long)0L, (long)delta.compareTo(exp));
        ITmfTimestamp bang = TmfTimestamp.BIG_BANG;
        ITmfTimestamp crunch = TmfTimestamp.BIG_CRUNCH;
        ITmfTimestamp zero = TmfTimestamp.ZERO;
        ITmfTimestamp anyT = TmfTimestamp.create((long)1L, (int)10);
        ITmfTimestamp anyTN = TmfTimestamp.create((long)-2L, (int)10);
        Assert.assertEquals((Object)bang.getDelta(bang), (Object)zero);
        Assert.assertEquals((Object)crunch.getDelta(crunch), (Object)zero);
        Assert.assertEquals((Object)crunch.getDelta(bang), (Object)crunch);
        Assert.assertEquals((Object)bang.getDelta(crunch), (Object)bang);
        Assert.assertEquals((Object)bang.getDelta(anyT), (Object)bang);
        Assert.assertEquals((Object)crunch.getDelta(anyT), (Object)crunch);
        Assert.assertEquals((Object)bang.getDelta(anyTN), (Object)bang);
        Assert.assertEquals((Object)crunch.getDelta(anyTN), (Object)crunch);
        Assert.assertEquals((Object)anyT.getDelta(bang), (Object)crunch);
        Assert.assertEquals((Object)anyT.getDelta(crunch), (Object)bang);
        Assert.assertEquals((Object)anyTN.getDelta(bang), (Object)crunch);
        Assert.assertEquals((Object)anyTN.getDelta(crunch), (Object)bang);
    }
}

