/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.kernel.core.tests.analysis.kernel.statesystem;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelAnalysisModule;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTraceUtils;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;
import org.junit.Assert;
import org.junit.Test;

public class GenerateTestValues {
    private static final long TARGET_TIMESTAMP = 1331668248014184527L;
    private static final String INDENT = "    ";

    @Test
    public void test() throws IOException, TmfAnalysisException, StateSystemDisposedException {
        File logFile = File.createTempFile("TestValues", ".java");
        Throwable throwable = null;
        Object var3_4 = null;
        try (PrintWriter writer = new PrintWriter((Writer)new FileWriter(logFile), true);){
            CtfTmfTrace trace = CtfTmfTestTraceUtils.getTrace((CtfTestTrace)CtfTestTrace.TRACE2);
            KernelAnalysisModule module = new KernelAnalysisModule(){

                protected String getSsFileName() {
                    return "test-values";
                }
            };
            Assert.assertTrue((boolean)module.setTrace((ITmfTrace)trace));
            module.setId("test-values");
            module.schedule();
            module.waitForCompletion();
            ITmfStateSystem ssq = module.getStateSystem();
            Assert.assertNotNull((Object)ssq);
            List fullState = ssq.queryFullState(1331668248014184527L);
            writer.println("final class TestValues {");
            writer.println();
            writer.println("    static int size = " + fullState.size() + ";");
            writer.println();
            writer.println("    static long[] startTimes = {");
            for (ITmfStateInterval interval : fullState) {
                writer.println("        " + String.valueOf(interval.getStartTime()) + "L,");
            }
            writer.println("    };");
            writer.println();
            writer.println("    static long[] endTimes = {");
            for (ITmfStateInterval interval : fullState) {
                writer.println("        " + String.valueOf(interval.getEndTime()) + "L,");
            }
            writer.println("    };");
            writer.println();
            writer.println("    static ITmfStateValue[] values = {");
            for (ITmfStateInterval interval : fullState) {
                ITmfStateValue val = interval.getStateValue();
                writer.print("        ");
                switch (val.getType()) {
                    case NULL: {
                        writer.println("TmfStateValue.nullValue(),");
                        break;
                    }
                    case INTEGER: {
                        writer.println("TmfStateValue.newValueInt(" + val.unboxInt() + "),");
                        break;
                    }
                    case LONG: {
                        writer.println("TmfStateValue.newValueLong(" + val.unboxLong() + "),");
                        break;
                    }
                    case DOUBLE: {
                        writer.println("TmfStateValue.newValueDouble(" + val.unboxDouble() + "),");
                        break;
                    }
                    case STRING: {
                        writer.println("TmfStateValue.newValueString(\"" + val.unboxStr() + "\"),");
                        break;
                    }
                    default: {
                        writer.println(val.toString());
                    }
                }
            }
            writer.println("    };");
            writer.println("}");
            writer.println();
            module.dispose();
            trace.dispose();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        System.out.println("wrote to: " + logFile.getAbsolutePath());
    }
}

